/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.document.DocumentVersionHolder;
import com.jetbrains.rd.ide.document.DocumentVersionsKt;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentVersionHolderImpl;", "Lcom/jetbrains/rd/ide/document/DocumentVersionHolder;", "initialVersion", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "(Lcom/jetbrains/rd/ide/model/RdDocumentVersion;Lcom/jetbrains/rd/ide/model/RdDocumentId;)V", "lastIdeaModificationStamp", "", "<set-?>", "previousVersion", "getPreviousVersion", "()Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "version", "getVersion", "incrementVersion", "", "newIdeaModificationStamp", "resetVersion", "", "v", "ideaModificationStamp", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nDocumentVersionHolderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentVersionHolderImpl.kt\ncom/jetbrains/rd/ide/document/DocumentVersionHolderImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,35:1\n65#2,4:36\n65#2,4:40\n13#2:44\n*S KotlinDebug\n*F\n+ 1 DocumentVersionHolderImpl.kt\ncom/jetbrains/rd/ide/document/DocumentVersionHolderImpl\n*L\n25#1:36,4\n33#1:40,4\n11#1:44\n*E\n"})
public final class DocumentVersionHolderImpl
implements DocumentVersionHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RdDocumentId documentId;
    private long lastIdeaModificationStamp;
    @NotNull
    private RdDocumentVersion previousVersion;
    @NotNull
    private RdDocumentVersion version;
    @NotNull
    private static final Logger logger;

    public DocumentVersionHolderImpl(@NotNull RdDocumentVersion initialVersion, @NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)initialVersion, (String)"initialVersion");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        this.documentId = documentId;
        this.lastIdeaModificationStamp = -1L;
        this.previousVersion = initialVersion;
        this.version = initialVersion;
    }

    @Override
    @NotNull
    public RdDocumentVersion getPreviousVersion() {
        return this.previousVersion;
    }

    @Override
    @NotNull
    public RdDocumentVersion getVersion() {
        return this.version;
    }

    @Override
    public boolean incrementVersion(long newIdeaModificationStamp) {
        this.previousVersion = this.getVersion();
        this.version = DocumentVersionsKt.nextVersion(this.getVersion());
        this.lastIdeaModificationStamp = newIdeaModificationStamp;
        Logger logger = DocumentVersionHolderImpl.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Increment document version '" + this.documentId + "', version: " + this.getVersion() + " previousVersion: " + this.getPreviousVersion() + " stamp: " + this.lastIdeaModificationStamp);
        }
        return true;
    }

    @Override
    public void resetVersion(@NotNull RdDocumentVersion v, long ideaModificationStamp) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.version = v;
        this.previousVersion = Intrinsics.areEqual((Object)v, (Object)DocumentVersionsKt.getInitialDocVersion()) ? v : DocumentVersionsKt.previousVersion(v);
        this.lastIdeaModificationStamp = ideaModificationStamp;
        Logger logger = DocumentVersionHolderImpl.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Reset document version '" + this.documentId + "', version: " + this.getVersion() + " previousVersion: " + this.getPreviousVersion() + " stamp: " + this.lastIdeaModificationStamp);
        }
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(DocumentVersionHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DocumentVersionHolderImpl.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentVersionHolderImpl$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

