/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.ide.document.DocumentLog;
import com.jetbrains.rd.ide.document.DocumentLogRangeShifterKt;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdResetDocumentChange;
import com.jetbrains.rd.ide.model.RdTextModificationKind;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J2\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentLogRangeShifter;", "Lcom/jetbrains/rd/platform/util/IDocumentRangeShifter;", "documentLog", "Lcom/jetbrains/rd/ide/document/DocumentLog;", "(Lcom/jetbrains/rd/ide/document/DocumentLog;)V", "j", "", "version", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "shiftOnePoint", "", "v", "Lcom/jetbrains/rd/ide/model/AbstractDocumentVersion;", "offset", "isStickingToRight", "shiftRange", "Lcom/intellij/openapi/util/TextRange;", "range", "isVerifiable", "isGreedyToLeft", "isGreedyToRight", "shrinkHistory", "", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nDocumentLogRangeShifter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentLogRangeShifter.kt\ncom/jetbrains/rd/ide/document/DocumentLogRangeShifter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,135:1\n1#2:136\n13#3:137\n*S KotlinDebug\n*F\n+ 1 DocumentLogRangeShifter.kt\ncom/jetbrains/rd/ide/document/DocumentLogRangeShifter\n*L\n132#1:137\n*E\n"})
public final class DocumentLogRangeShifter
implements IDocumentRangeShifter {
    @NotNull
    private final DocumentLog documentLog;

    public DocumentLogRangeShifter(@NotNull DocumentLog documentLog) {
        Intrinsics.checkNotNullParameter((Object)documentLog, (String)"documentLog");
        this.documentLog = documentLog;
    }

    @Override
    public void shrinkHistory() {
    }

    @Override
    @Nullable
    public TextRange shiftRange(@NotNull AbstractDocumentVersion v, @NotNull TextRange range2, boolean isVerifiable, boolean isGreedyToLeft, boolean isGreedyToRight) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        boolean bl2 = bl = range2.getStartOffset() <= range2.getEndOffset();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Range: " + range2 + " is not normalized";
            throw new AssertionError((Object)string);
        }
        RdDocumentVersion rdDocumentVersion = (RdDocumentVersion)v;
        if (!this.j(rdDocumentVersion)) {
            return null;
        }
        int n = range2.getStartOffset();
        int n2 = range2.getEndOffset();
        for (Map.Entry<RdDocumentVersion, RdDocumentChangeBase> entry : this.documentLog) {
            int n3;
            RdDocumentVersion rdDocumentVersion2 = entry.getKey();
            RdDocumentChangeBase rdDocumentChangeBase = entry.getValue();
            if (rdDocumentVersion2.getValue() <= rdDocumentVersion.getValue()) continue;
            if (rdDocumentChangeBase instanceof RdResetDocumentChange) {
                return null;
            }
            if (!(rdDocumentChangeBase instanceof RdDocumentChange)) {
                n3 = 0;
                String string = "Unknown document change type: " + rdDocumentChangeBase;
                throw new IllegalStateException(string.toString());
            }
            int n4 = ((RdDocumentChange)rdDocumentChangeBase).getOldText().length();
            n3 = ((RdDocumentChange)rdDocumentChangeBase).getNewText().length();
            int n5 = ((RdDocumentChange)rdDocumentChangeBase).getOffset();
            int n6 = n5 + n4;
            int n7 = n3 - n4;
            if (n4 == 0 && ((RdDocumentChange)rdDocumentChangeBase).getMoveOffset() != n5) {
                int n8 = ((RdDocumentChange)rdDocumentChangeBase).getMoveOffset();
                boolean bl4 = false;
                int n9 = n8 > n5 ? n8 - n3 : n8;
                if (n9 <= n && n2 <= n9 + n3) {
                    int n10 = n5 - n9;
                    n += n10;
                    n2 += n10;
                    continue;
                }
            }
            if (n2 == n5 && (((RdDocumentChange)rdDocumentChangeBase).getModificationKind() == RdTextModificationKind.RightSide || isGreedyToRight)) {
                n2 += n7;
                continue;
            }
            if (n2 <= n5) continue;
            if (n == n6 && (((RdDocumentChange)rdDocumentChangeBase).getModificationKind() == RdTextModificationKind.LeftSide || isGreedyToLeft)) {
                n2 += n7;
                continue;
            }
            if (n >= n6) {
                n += n7;
                n2 += n7;
                continue;
            }
            if (n <= n5 && n6 <= n2 && !isVerifiable) {
                n2 += n7;
                continue;
            }
            return null;
        }
        return new TextRange(n, n2);
    }

    @Override
    public int shiftOnePoint(@NotNull AbstractDocumentVersion v, int offset, boolean isStickingToRight) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        RdDocumentVersion rdDocumentVersion = (RdDocumentVersion)v;
        if (!this.j(rdDocumentVersion)) {
            return -1;
        }
        List list2 = new ArrayList();
        for (Map.Entry<RdDocumentVersion, RdDocumentChangeBase> entry : this.documentLog) {
            RdDocumentVersion rdDocumentVersion2 = entry.getKey();
            RdDocumentChangeBase rdDocumentChangeBase = entry.getValue();
            if (rdDocumentVersion2.getValue() <= rdDocumentVersion.getValue()) continue;
            list2.add(rdDocumentChangeBase);
        }
        return DocumentLogRangeShifterKt.shiftOnePoint(list2, offset, isStickingToRight);
    }

    private final boolean j(RdDocumentVersion rdDocumentVersion) {
        if (this.documentLog.contains(rdDocumentVersion)) {
            return true;
        }
        boolean bl = false;
        Logger logger = Logger.getInstance(DocumentLogRangeShifter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Version " + rdDocumentVersion + " is not found in document log");
        return false;
    }
}

