/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css3.CssListStyleType;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssContent
extends org.w3c.css.properties.css.CssContent {
    private static CssIdent normal = CssIdent.getIdent("normal");
    private static CssIdent contents = CssIdent.getIdent("contents");
    protected static CssIdent[] allowed_quote_values;
    protected static CssIdent[] allowed_target_text_values;
    protected static CssIdent[] allowed_leader_values;

    public static CssIdent getMatchingQuoteIdent(CssIdent ident) {
        for (CssIdent id : allowed_quote_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getTargetTextIdent(CssIdent ident) {
        for (CssIdent id : allowed_target_text_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getLeaderIdent(CssIdent ident) {
        for (CssIdent id : allowed_leader_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssContent() {
        this.value = initial;
    }

    public CssContent(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        char op;
        CssValue val;
        this.setByUser();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean gotSlash = false;
        while (!gotSlash && !expression.end()) {
            val = expression.getValue();
            op = expression.getOperator();
            switch (val.getType()) {
                case 14: {
                    gotSlash = true;
                    values.add(val);
                    break;
                }
                case 1: 
                case 2: 
                case 16: {
                    values.add(val);
                    break;
                }
                case 11: {
                    CssFunction f = val.getFunction();
                    switch (f.getName()) {
                        case "counter": {
                            CssContent.checkCounterFunction(ac, f, this);
                            break;
                        }
                        case "counters": {
                            CssContent.checkCountersFunction(ac, f, this);
                            break;
                        }
                        case "target-counter": {
                            CssContent.checkTargetCounterFunction(ac, f, this);
                            break;
                        }
                        case "target-counters": {
                            CssContent.checkTargetCountersFunction(ac, f, this);
                            break;
                        }
                        case "target-text": {
                            CssContent.checkTargetTextFunction(ac, f, this);
                            break;
                        }
                        case "leader": {
                            CssContent.checkLeaderFunction(ac, f, this);
                            break;
                        }
                        default: {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                    }
                    values.add(val);
                    break;
                }
                case 0: {
                    CssIdent id = val.getIdent();
                    if (CssIdent.isCssWide(id)) {
                        values.add(val);
                        if (expression.getCount() <= 1) break;
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    if (normal.equals(id)) {
                        values.add(val);
                        if (expression.getCount() <= 1) break;
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    if (none.equals(id)) {
                        values.add(val);
                        if (expression.getCount() <= 1) break;
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    if (CssContent.getMatchingQuoteIdent(id) != null) {
                        values.add(val);
                        break;
                    }
                    if (contents.equals(id)) {
                        values.add(val);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        if (gotSlash) {
            boolean gotOne = false;
            while (!expression.end()) {
                val = expression.getValue();
                op = expression.getOperator();
                switch (val.getType()) {
                    case 11: {
                        CssFunction f = val.getFunction();
                        switch (f.getName()) {
                            case "counter": {
                                CssContent.checkCounterFunction(ac, f, this);
                                break;
                            }
                            case "counters": {
                                CssContent.checkCountersFunction(ac, f, this);
                                break;
                            }
                            default: {
                                throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                            }
                        }
                        values.add(val);
                        break;
                    }
                    case 1: {
                        values.add(val);
                    }
                }
                gotOne = true;
                if (op != ' ') {
                    throw new InvalidParamException("operator", Character.toString(op), ac);
                }
                expression.next();
            }
            if (!gotOne) {
                throw new InvalidParamException("unrecognize", ac);
            }
        }
        this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    protected static void checkCounterFunction(ApplContext ac, CssFunction function, CssProperty property) throws InvalidParamException {
        if (!function.getName().equals("counter")) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssExpression exp = function.getParameters();
        if (exp.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue v = exp.getValue();
        char op = exp.getOperator();
        if (v.getType() != 0) {
            throw new InvalidParamException("value", v, property.getPropertyName(), ac);
        }
        exp.next();
        if (!exp.end()) {
            if (op != ',') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            v = exp.getValue();
            if (v.getType() == 0 && null == CssListStyleType.getAllowedIdent(v.getIdent())) {
                throw new InvalidParamException("value", v, property.getPropertyName(), ac);
            }
        }
    }

    protected static void checkCountersFunction(ApplContext ac, CssFunction function, CssProperty property) throws InvalidParamException {
        if (!function.getName().equals("counters")) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssExpression exp = function.getParameters();
        if (exp.getCount() < 2 || exp.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue v = exp.getValue();
        char op = exp.getOperator();
        if (v.getType() != 0) {
            throw new InvalidParamException("value", v, property.getPropertyName(), ac);
        }
        exp.next();
        if (op != ',') {
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        v = exp.getValue();
        op = exp.getOperator();
        if (v.getType() != 1) {
            throw new InvalidParamException("value", v, property.getPropertyName(), ac);
        }
        exp.next();
        if (!exp.end()) {
            if (op != ',') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            v = exp.getValue();
            if (v.getType() == 0 && null == CssListStyleType.getAllowedIdent(v.getIdent())) {
                throw new InvalidParamException("value", v, property.getPropertyName(), ac);
            }
        }
    }

    protected static void checkTargetCounterFunction(ApplContext ac, CssFunction function, CssProperty property) throws InvalidParamException {
        if (!function.getName().equals("target-counter")) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssExpression exp = function.getParameters();
        if (exp.getCount() < 2 || exp.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue v = exp.getValue();
        char op = exp.getOperator();
        switch (v.getType()) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new InvalidParamException("value", v, property.getPropertyName(), ac);
            }
        }
        if (op != ',') {
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        exp.next();
        v = exp.getValue();
        op = exp.getOperator();
        if (v.getType() != 0) {
            throw new InvalidParamException("value", v, property.getPropertyName(), ac);
        }
        if (CssIdent.isCssWide(v.getIdent())) {
            throw new InvalidParamException("value", v, property.getPropertyName(), ac);
        }
        exp.next();
        if (!exp.end()) {
            if (op != ',') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            v = exp.getValue();
            CssExpression e = new CssExpression();
            e.addValue(v);
            try {
                CssListStyleType cssListStyleType = new CssListStyleType(ac, e, false);
            }
            catch (Exception ex) {
                throw new InvalidParamException("value", v, property.getPropertyName(), ac);
            }
        }
    }

    protected static void checkTargetCountersFunction(ApplContext ac, CssFunction function, CssProperty property) throws InvalidParamException {
        if (!function.getName().equals("target-counters")) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssExpression exp = function.getParameters();
        if (exp.getCount() < 3 || exp.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue v = exp.getValue();
        char op = exp.getOperator();
        switch (v.getType()) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new InvalidParamException("value", v, property.getPropertyName(), ac);
            }
        }
        if (op != ',') {
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        exp.next();
        v = exp.getValue();
        op = exp.getOperator();
        if (v.getType() != 0) {
            throw new InvalidParamException("value", v, property.getPropertyName(), ac);
        }
        if (CssIdent.isCssWide(v.getIdent())) {
            throw new InvalidParamException("value", v, property.getPropertyName(), ac);
        }
        if (op != ',') {
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        exp.next();
        v = exp.getValue();
        op = exp.getOperator();
        if (v.getType() != 1) {
            throw new InvalidParamException("value", v, property.getPropertyName(), ac);
        }
        exp.next();
        if (!exp.end()) {
            if (op != ',') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            v = exp.getValue();
            CssExpression e = new CssExpression();
            e.addValue(v);
            try {
                CssListStyleType cssListStyleType = new CssListStyleType(ac, e, false);
            }
            catch (Exception ex) {
                throw new InvalidParamException("value", v, property.getPropertyName(), ac);
            }
        }
    }

    protected static void checkTargetTextFunction(ApplContext ac, CssFunction function, CssProperty property) throws InvalidParamException {
        if (!function.getName().equals("target-text")) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssExpression exp = function.getParameters();
        if (exp.getCount() < 1 || exp.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue v = exp.getValue();
        char op = exp.getOperator();
        switch (v.getType()) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new InvalidParamException("value", v, property.getPropertyName(), ac);
            }
        }
        exp.next();
        if (!exp.end()) {
            if (op != ',') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            v = exp.getValue();
            if (v.getType() != 0) {
                throw new InvalidParamException("value", v, property.getPropertyName(), ac);
            }
            if (CssContent.getTargetTextIdent(v.getIdent()) == null) {
                throw new InvalidParamException("value", v, property.getPropertyName(), ac);
            }
        }
    }

    protected static void checkLeaderFunction(ApplContext ac, CssFunction function, CssProperty property) throws InvalidParamException {
        if (!function.getName().equals("leader")) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssExpression exp = function.getParameters();
        if (exp.getCount() != 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue v = exp.getValue();
        char op = exp.getOperator();
        switch (v.getType()) {
            case 1: {
                break;
            }
            case 0: {
                if (CssContent.getLeaderIdent(v.getIdent()) != null) break;
            }
            default: {
                throw new InvalidParamException("value", v, property.getPropertyName(), ac);
            }
        }
        exp.next();
    }

    public CssContent(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] _allowed_values = new String[]{"open-quote", "close-quote", "no-open-quote", "no-close-quote"};
        int i = 0;
        allowed_quote_values = new CssIdent[_allowed_values.length];
        for (String s : _allowed_values) {
            CssContent.allowed_quote_values[i++] = CssIdent.getIdent(s);
        }
        String[] _target_text = new String[]{"content", "before", "after", "first-letter"};
        i = 0;
        allowed_target_text_values = new CssIdent[_target_text.length];
        for (String s : _target_text) {
            CssContent.allowed_target_text_values[i++] = CssIdent.getIdent(s);
        }
        String[] _leader = new String[]{"dotted", "solid", "space"};
        i = 0;
        allowed_leader_values = new CssIdent[_leader.length];
        for (String s : _leader) {
            CssContent.allowed_leader_values[i++] = CssIdent.getIdent(s);
        }
    }
}

