/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh;

import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.config.unified.SshConfig;
import com.jetbrains.gateway.ssh.HighLevelHostAccessor;
import com.jetbrains.gateway.ssh.deploy.DeployTargetInfo;
import com.jetbrains.gateway.ssh.deploy.LoggingHostCommandExecutorWrapper;
import com.jetbrains.gateway.ssh.deploy.impl.SshCommandExecutor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0001\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/gateway/ssh/HostDeployInputs;", "", "()V", "FullySpecified", "WithDeployedWorker", "WithHostInfo", "Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithHostInfo;", "intellij.gateway.core"})
public abstract class HostDeployInputs {
    private HostDeployInputs() {
    }

    public /* synthetic */ HostDeployInputs(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/gateway/ssh/HostDeployInputs$FullySpecified;", "Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithDeployedWorker;", "remoteProjectPath", "", "deployTarget", "Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo;", "remoteInfo", "(Ljava/lang/String;Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo;Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithDeployedWorker;)V", "getDeployTarget", "()Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo;", "getRemoteProjectPath", "()Ljava/lang/String;", "toString", "intellij.gateway.core"})
    public static final class FullySpecified
    extends WithDeployedWorker {
        @NotNull
        private final String remoteProjectPath;
        @NotNull
        private final DeployTargetInfo deployTarget;

        public FullySpecified(@NotNull String remoteProjectPath, @NotNull DeployTargetInfo deployTarget, @NotNull WithDeployedWorker remoteInfo) {
            Intrinsics.checkNotNullParameter((Object)remoteProjectPath, (String)"remoteProjectPath");
            Intrinsics.checkNotNullParameter((Object)deployTarget, (String)"deployTarget");
            Intrinsics.checkNotNullParameter((Object)remoteInfo, (String)"remoteInfo");
            super(remoteInfo.getHostAccessor(), remoteInfo);
            this.remoteProjectPath = remoteProjectPath;
            this.deployTarget = deployTarget;
        }

        @NotNull
        public final String getRemoteProjectPath() {
            return this.remoteProjectPath;
        }

        @NotNull
        public final DeployTargetInfo getDeployTarget() {
            return this.deployTarget;
        }

        @Override
        @NotNull
        public String toString() {
            return "FullySpecified(remoteProjectPath='" + this.remoteProjectPath + "', deployTarget=" + this.deployTarget + ", base=" + super.toString() + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithDeployedWorker;", "Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithHostInfo;", "hostAccessor", "Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;", "hostInfo", "(Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithHostInfo;)V", "getHostAccessor", "()Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;", "toString", "", "upgrade", "Lcom/jetbrains/gateway/ssh/HostDeployInputs$FullySpecified;", "remoteProjectPath", "deployTarget", "Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo;", "intellij.gateway.core"})
    public static class WithDeployedWorker
    extends WithHostInfo {
        @NotNull
        private final HighLevelHostAccessor hostAccessor;

        public WithDeployedWorker(@NotNull HighLevelHostAccessor hostAccessor, @NotNull WithHostInfo hostInfo) {
            Intrinsics.checkNotNullParameter((Object)hostAccessor, (String)"hostAccessor");
            Intrinsics.checkNotNullParameter((Object)hostInfo, (String)"hostInfo");
            super(hostInfo.getLoggingCommandExecutor());
            this.hostAccessor = hostAccessor;
        }

        @NotNull
        public final HighLevelHostAccessor getHostAccessor() {
            return this.hostAccessor;
        }

        @NotNull
        public final FullySpecified upgrade(@NotNull String remoteProjectPath, @NotNull DeployTargetInfo deployTarget) {
            Intrinsics.checkNotNullParameter((Object)remoteProjectPath, (String)"remoteProjectPath");
            Intrinsics.checkNotNullParameter((Object)deployTarget, (String)"deployTarget");
            return new FullySpecified(remoteProjectPath, deployTarget, this);
        }

        @Override
        @NotNull
        public String toString() {
            return "WithDeployedWorker(hostAccessor=" + this.hostAccessor + ", base=" + super.toString() + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithHostInfo;", "Lcom/jetbrains/gateway/ssh/HostDeployInputs;", "sshConfig", "Lcom/intellij/ssh/config/unified/SshConfig;", "(Lcom/intellij/ssh/config/unified/SshConfig;)V", "remoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "(Lcom/intellij/remote/RemoteCredentials;)V", "loggingCommandExecutor", "Lcom/jetbrains/gateway/ssh/deploy/LoggingHostCommandExecutorWrapper;", "(Lcom/jetbrains/gateway/ssh/deploy/LoggingHostCommandExecutorWrapper;)V", "getLoggingCommandExecutor", "()Lcom/jetbrains/gateway/ssh/deploy/LoggingHostCommandExecutorWrapper;", "toString", "", "upgrade", "Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithDeployedWorker;", "executor", "Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;", "intellij.gateway.core"})
    public static class WithHostInfo
    extends HostDeployInputs {
        @NotNull
        private final LoggingHostCommandExecutorWrapper loggingCommandExecutor;

        public WithHostInfo(@NotNull LoggingHostCommandExecutorWrapper loggingCommandExecutor) {
            Intrinsics.checkNotNullParameter((Object)loggingCommandExecutor, (String)"loggingCommandExecutor");
            super(null);
            this.loggingCommandExecutor = loggingCommandExecutor;
        }

        @NotNull
        public final LoggingHostCommandExecutorWrapper getLoggingCommandExecutor() {
            return this.loggingCommandExecutor;
        }

        public WithHostInfo(@NotNull SshConfig sshConfig) {
            Intrinsics.checkNotNullParameter((Object)sshConfig, (String)"sshConfig");
            RemoteCredentials remoteCredentials = sshConfig.copyToCredentials();
            Intrinsics.checkNotNullExpressionValue((Object)remoteCredentials, (String)"copyToCredentials(...)");
            this(remoteCredentials);
        }

        public WithHostInfo(@NotNull RemoteCredentials remoteCredentials) {
            Intrinsics.checkNotNullParameter((Object)remoteCredentials, (String)"remoteCredentials");
            this(new LoggingHostCommandExecutorWrapper(new SshCommandExecutor(remoteCredentials, false, 2, null)));
        }

        @NotNull
        public final WithDeployedWorker upgrade(@NotNull HighLevelHostAccessor executor2) {
            Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
            return new WithDeployedWorker(executor2, this);
        }

        @NotNull
        public String toString() {
            return "WithHostInfo(loggingCommandExecutor=" + this.loggingCommandExecutor + ")";
        }
    }
}

