/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.EditorConfigLanguage;
import org.editorconfig.language.formatting.EditorConfigFormattingBlock;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\n \f*\u0004\u0018\u00010\b0\b*\u00060\rR\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/editorconfig/language/formatting/EditorConfigFormattingModelBuilder;", "Lcom/intellij/formatting/FormattingModelBuilder;", "()V", "createModel", "Lcom/intellij/formatting/FormattingModel;", "formattingContext", "Lcom/intellij/formatting/FormattingContext;", "createSpacingBuilder", "Lcom/intellij/formatting/SpacingBuilder;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "strictSpaces", "kotlin.jvm.PlatformType", "Lcom/intellij/formatting/SpacingBuilder$RuleBuilder;", "needSpace", "", "toInt", "", "intellij.editorconfig"})
public final class EditorConfigFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        Intrinsics.checkNotNullParameter((Object)formattingContext, (String)"formattingContext");
        CodeStyleSettings codeStyleSettings = formattingContext.getCodeStyleSettings();
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getCodeStyleSettings(...)");
        CodeStyleSettings settings = codeStyleSettings;
        SpacingBuilder spacingBuilder = this.createSpacingBuilder(settings);
        CommonCodeStyleSettings commonCodeStyleSettings = settings.getCommonSettings((Language)EditorConfigLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
        CommonCodeStyleSettings commonSettings = commonCodeStyleSettings;
        boolean shouldAlignSeparators = commonSettings.ALIGN_GROUP_FIELD_DECLARATIONS;
        ASTNode aSTNode = formattingContext.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        EditorConfigFormattingBlock root = new EditorConfigFormattingBlock(aSTNode, spacingBuilder, shouldAlignSeparators, null, 8, null);
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)formattingContext.getContainingFile(), (Block)((Block)root), (CodeStyleSettings)settings);
        Intrinsics.checkNotNullExpressionValue((Object)formattingModel, (String)"createFormattingModelForPsiFile(...)");
        return formattingModel;
    }

    private final SpacingBuilder createSpacingBuilder(CodeStyleSettings settings) {
        CommonCodeStyleSettings commonCodeStyleSettings = settings.getCommonSettings((Language)EditorConfigLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
        CommonCodeStyleSettings commonSettings = commonCodeStyleSettings;
        boolean beforeComma = commonSettings.SPACE_BEFORE_COMMA;
        boolean afterComma = commonSettings.SPACE_AFTER_COMMA;
        boolean beforeColon = commonSettings.SPACE_BEFORE_COLON;
        boolean afterColon = commonSettings.SPACE_AFTER_COLON;
        boolean aroundSeparator = commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS;
        SpacingBuilder.RuleBuilder ruleBuilder = new SpacingBuilder(settings, (Language)EditorConfigLanguage.INSTANCE).around(EditorConfigElementTypes.SEPARATOR);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder, (String)"around(...)");
        SpacingBuilder.RuleBuilder ruleBuilder2 = this.strictSpaces(ruleBuilder, aroundSeparator).before(EditorConfigElementTypes.COMMA);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder2, (String)"before(...)");
        SpacingBuilder.RuleBuilder ruleBuilder3 = this.strictSpaces(ruleBuilder2, beforeComma).after(EditorConfigElementTypes.COMMA);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder3, (String)"after(...)");
        SpacingBuilder.RuleBuilder ruleBuilder4 = this.strictSpaces(ruleBuilder3, afterComma).around(EditorConfigElementTypes.DOT);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder4, (String)"around(...)");
        SpacingBuilder.RuleBuilder ruleBuilder5 = this.strictSpaces(ruleBuilder4, false).before(EditorConfigElementTypes.COLON);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder5, (String)"before(...)");
        SpacingBuilder.RuleBuilder ruleBuilder6 = this.strictSpaces(ruleBuilder5, beforeColon).after(EditorConfigElementTypes.COLON);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder6, (String)"after(...)");
        SpacingBuilder spacingBuilder = this.strictSpaces(ruleBuilder6, afterColon).around(EditorConfigElementTypes.LINE_COMMENT).spaces(1).around(EditorConfigElementTypes.OPTION).lineBreakInCode().around(EditorConfigElementTypes.ROOT_DECLARATION).blankLines(1).around(EditorConfigElementTypes.SECTION).blankLines(1);
        Intrinsics.checkNotNullExpressionValue((Object)spacingBuilder, (String)"blankLines(...)");
        return spacingBuilder;
    }

    private final SpacingBuilder strictSpaces(SpacingBuilder.RuleBuilder $this$strictSpaces, boolean needSpace) {
        return $this$strictSpaces.spacing(this.toInt(needSpace), this.toInt(needSpace), 0, false, 0);
    }

    private final int toInt(boolean $this$toInt) {
        return $this$toInt ? 1 : 0;
    }
}

