/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigOptionValueIdentifier;
import org.editorconfig.language.psi.EditorConfigOptionValueList;
import org.editorconfig.language.services.EditorConfigElementFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\r\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveUnexpectedValuesQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "findClosestListElement", "Lorg/editorconfig/language/psi/EditorConfigOptionValueIdentifier;", "list", "Lorg/editorconfig/language/psi/EditorConfigOptionValueList;", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigRemoveUnexpectedValuesQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigRemoveUnexpectedValuesQuickFix.kt\norg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveUnexpectedValuesQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n2333#2,14:37\n*S KotlinDebug\n*F\n+ 1 EditorConfigRemoveUnexpectedValuesQuickFix.kt\norg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveUnexpectedValuesQuickFix\n*L\n30#1:37,14\n*E\n"})
public final class EditorConfigRemoveUnexpectedValuesQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.value.list.remove.others");
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.editorconfig.language.psi.EditorConfigOptionValueList");
        EditorConfigOptionValueList list = (EditorConfigOptionValueList)psiElement;
        EditorConfigOptionValueIdentifier editorConfigOptionValueIdentifier = this.findClosestListElement(list);
        if (editorConfigOptionValueIdentifier == null) {
            return;
        }
        EditorConfigOptionValueIdentifier identifier = editorConfigOptionValueIdentifier;
        EditorConfigElementFactory factory = EditorConfigElementFactory.Companion.getInstance(project);
        String string = identifier.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        EditorConfigOptionValueIdentifier replacement = factory.createValueIdentifier(string);
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> EditorConfigRemoveUnexpectedValuesQuickFix.applyFix$lambda$0(list, replacement));
    }

    private final EditorConfigOptionValueIdentifier findClosestListElement(EditorConfigOptionValueList list) {
        Object v2;
        Editor editor = FileEditorManager.getInstance((Project)list.getProject()).getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        List<EditorConfigOptionValueIdentifier> list2 = list.getOptionValueIdentifierList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getOptionValueIdentifierList(...)");
        Iterable $this$minByOrNull$iv = list2;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = minElem$iv;
            } else {
                PsiElement element = (PsiElement)minElem$iv;
                boolean bl = false;
                int minValue$iv = Math.min(Math.abs(element.getTextRange().getStartOffset() - editor2.getCaretModel().getOffset()), Math.abs(element.getTextRange().getEndOffset() - editor2.getCaretModel().getOffset()));
                do {
                    Object e$iv = iterator$iv.next();
                    PsiElement element2 = (PsiElement)e$iv;
                    $i$a$-minByOrNull-EditorConfigRemoveUnexpectedValuesQuickFix$findClosestListElement$1 = false;
                    int v$iv = Math.min(Math.abs(element2.getTextRange().getStartOffset() - editor2.getCaretModel().getOffset()), Math.abs(element2.getTextRange().getEndOffset() - editor2.getCaretModel().getOffset()));
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = minElem$iv;
            }
        }
        return v2;
    }

    private static final void applyFix$lambda$0(EditorConfigOptionValueList $list, EditorConfigOptionValueIdentifier $replacement) {
        Intrinsics.checkNotNullParameter((Object)$list, (String)"$list");
        Intrinsics.checkNotNullParameter((Object)$replacement, (String)"$replacement");
        $list.replace($replacement);
    }
}

