/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbNamedTypeElement;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbSymbolOwner;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResolveFilters {
    private static final Condition<PbSymbol> anySymbol = element -> true;
    private static final Condition<PbSymbol> packageOrMessage = element -> PbPsiUtil.isPackageElement(element) || PbPsiUtil.isMessageElement(element);
    private static final Condition<PbSymbol> packageOrMessageWithExtension = element -> PbPsiUtil.isPackageElement(element) || PbPsiUtil.isMessageElement(element) && ResolveFilters.messageHasExtension((PbMessageType)element);
    private static final Condition<PbSymbol> packageOrType = element -> PbPsiUtil.isPackageElement(element) || PbPsiUtil.isTypeElement(element);
    private static final Condition<PbSymbol> symbolOwner = PbSymbolOwner.class::isInstance;
    private static final Condition<PbSymbol> unsuggestableFilter = PbPsiUtil::isGeneratedMapEntry;

    private static boolean messageHasExtension(PbMessageType message) {
        return message.getStatements().stream().anyMatch(statement -> PbPsiUtil.isExtendElement(statement) || statement instanceof PbMessageType && ResolveFilters.messageHasExtension((PbMessageType)statement));
    }

    @NotNull
    public static Condition<PbSymbol> anySymbol() {
        Condition<PbSymbol> condition = anySymbol;
        if (condition == null) {
            ResolveFilters.$$$reportNull$$$0(0);
        }
        return condition;
    }

    @NotNull
    public static Condition<PbSymbol> packageOrMessage() {
        Condition<PbSymbol> condition = packageOrMessage;
        if (condition == null) {
            ResolveFilters.$$$reportNull$$$0(1);
        }
        return condition;
    }

    @NotNull
    public static Condition<PbSymbol> packageOrMessageWithExtension() {
        Condition<PbSymbol> condition = packageOrMessageWithExtension;
        if (condition == null) {
            ResolveFilters.$$$reportNull$$$0(2);
        }
        return condition;
    }

    @NotNull
    public static Condition<PbSymbol> packageOrType() {
        Condition<PbSymbol> condition = packageOrType;
        if (condition == null) {
            ResolveFilters.$$$reportNull$$$0(3);
        }
        return condition;
    }

    @NotNull
    public static Condition<PbSymbol> symbolOwner() {
        Condition<PbSymbol> condition = symbolOwner;
        if (condition == null) {
            ResolveFilters.$$$reportNull$$$0(4);
        }
        return condition;
    }

    @NotNull
    public static Condition<PbSymbol> extendedFromType(PbNamedTypeElement typeElement) {
        Condition condition = element -> element instanceof PbField && PbPsiUtil.fieldIsExtension((PbField)element, typeElement);
        if (condition == null) {
            ResolveFilters.$$$reportNull$$$0(5);
        }
        return condition;
    }

    @NotNull
    public static Condition<PbSymbol> extendedFromTypeOrMember(PbNamedTypeElement typeElement) {
        Condition condition = element -> element instanceof PbField && PbPsiUtil.fieldIsExtensionOrMember((PbField)element, typeElement);
        if (condition == null) {
            ResolveFilters.$$$reportNull$$$0(6);
        }
        return condition;
    }

    @Nullable
    public static Condition<PbSymbol> withUnsuggestableFilter(@Nullable Condition<PbSymbol> base) {
        if (base == null) {
            return null;
        }
        return Conditions.and(base, (Condition)Conditions.not(ResolveFilters.unsuggestableFilter()));
    }

    private static Condition<PbSymbol> unsuggestableFilter() {
        return unsuggestableFilter;
    }

    private ResolveFilters() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/protobuf/lang/resolve/ResolveFilters";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "anySymbol";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "packageOrMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "packageOrMessageWithExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "packageOrType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "symbolOwner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extendedFromType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "extendedFromTypeOrMember";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

