/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.protobuf.ide.settings.PbImportPathsConfiguration;
import com.intellij.protobuf.ide.settings.PbProjectSettings;
import com.intellij.protobuf.lang.resolve.FileResolveProvider;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/protobuf/lang/resolve/PbIndexBasedFileResolveProvider;", "Lcom/intellij/protobuf/lang/resolve/FileResolveProvider;", "()V", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getChildEntries", "", "Lcom/intellij/protobuf/lang/resolve/FileResolveProvider$ChildEntry;", "getDescriptorFile", "getSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "isEnabled", "", "intellij.protoeditor.core"})
@SourceDebugExtension(value={"SMAP\nPbIndexBasedFileResolveProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PbIndexBasedFileResolveProvider.kt\ncom/intellij/protobuf/lang/resolve/PbIndexBasedFileResolveProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
public final class PbIndexBasedFileResolveProvider
implements FileResolveProvider {
    @Override
    @Nullable
    public VirtualFile findFile(@NotNull String path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!this.isEnabled(project) || !StringsKt.endsWith$default((String)path, (String)".proto", (boolean)false, (int)2, null)) {
            return null;
        }
        String p0 = StringsKt.substringAfterLast$default((String)path, (char)'/', null, (int)2, null);
        boolean bl = false;
        String string = FileUtilRt.getNameWithoutExtension((String)p0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"let(...)");
        String searchedFileName = string;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        return PbImportPathsConfiguration.findFileByImportPath(searchedFileName, searchScope, path);
    }

    @Override
    @Nullable
    public VirtualFile findFile(@NotNull String path, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!this.isEnabled(project) || !StringsKt.endsWith$default((String)path, (String)".proto", (boolean)false, (int)2, null)) {
            return null;
        }
        String p0 = StringsKt.substringAfterLast$default((String)path, (char)'/', null, (int)2, null);
        boolean bl = false;
        String string = FileUtilRt.getNameWithoutExtension((String)p0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"let(...)");
        String searchedFileName = string;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module).uniteWith(module.getModuleContentWithDependenciesScope());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"uniteWith(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        return PbImportPathsConfiguration.findFileByImportPath(searchedFileName, searchScope, path);
    }

    private final boolean isEnabled(Project project) {
        return PbProjectSettings.getInstance(project).isIndexBasedResolveEnabled();
    }

    @Override
    @NotNull
    public Collection<FileResolveProvider.ChildEntry> getChildEntries(@NotNull String path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public VirtualFile getDescriptorFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    @Override
    @NotNull
    public GlobalSearchScope getSearchScope(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        return globalSearchScope;
    }
}

