/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.intentions;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.intentions.PbAddImportStatementIntention;
import com.intellij.protobuf.lang.intentions.PbImportIntentionVariant;
import com.intellij.protobuf.lang.intentions.util.ImportPathData;
import com.intellij.protobuf.lang.intentions.util.PbImportPathResolver;
import com.intellij.protobuf.lang.intentions.util.PbUiUtilsKt;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbImportName;
import com.intellij.protobuf.lang.psi.PbImportStatement;
import com.intellij.protobuf.lang.psi.PbNamedElement;
import com.intellij.protobuf.lang.psi.PbStringValue;
import com.intellij.protobuf.lang.psi.PbSymbolPath;
import com.intellij.protobuf.lang.resolve.ProtoSymbolPathReference;
import com.intellij.protobuf.lang.stub.index.QualifiedNameIndex;
import com.intellij.protobuf.lang.stub.index.ShortNameIndex;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.QualifiedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00042\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0015H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0015H\u0016J\b\u0010!\u001a\u00020\u0007H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015H\u0016J\b\u0010%\u001a\u00020\u0007H\u0016J\u001e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00172\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0002J!\u0010)\u001a\u00020*2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u0015H\u0096\u0002J \u0010,\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0015H\u0016J&\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u0005H\u0002J\b\u0010.\u001a\u00020'H\u0016\u00a8\u0006/"}, d2={"Lcom/intellij/protobuf/lang/intentions/PbAddImportStatementIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "()V", "allProtoFilesWithFqnFromIndex", "", "Lcom/intellij/protobuf/lang/psi/PbFile;", "unresolvedMessageFqn", "", "key", "Lcom/intellij/psi/stubs/StubIndexKey;", "Lcom/intellij/protobuf/lang/psi/PbNamedElement;", "project", "Lcom/intellij/openapi/project/Project;", "allProtoFilesWithGivenFqn", "constructUnresolvedSymbolPath", "file", "editor", "Lcom/intellij/openapi/editor/Editor;", "createPossibleImportIssueFixes", "Lcom/intellij/protobuf/lang/intentions/PbImportIntentionVariant;", "protoFileCandidates", "Lcom/intellij/psi/PsiFile;", "suitableImportStatements", "Lcom/intellij/protobuf/lang/psi/PbImportStatement;", "editedProtoFile", "findSymbolPathReference", "Lcom/intellij/psi/PsiReference;", "findTheOnlySuitableProtoFileToImport", "Lcom/intellij/protobuf/lang/intentions/util/ImportPathData;", "unresolvedImportStatement", "getElementToMakeWritable", "Lcom/intellij/psi/PsiElement;", "currentFile", "getFamilyName", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "getText", "importCorrespondsToFile", "", "currentImportStatement", "invoke", "", "editedFile", "isAvailable", "prepareQuickFixes", "startInWriteAction", "intellij.protoeditor.core"})
@SourceDebugExtension(value={"SMAP\nPbAddImportStatementIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PbAddImportStatementIntention.kt\ncom/intellij/protobuf/lang/intentions/PbAddImportStatementIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,168:1\n1#2:169\n1549#3:170\n1620#3,3:171\n766#3:174\n857#3,2:175\n1549#3:177\n1620#3,3:178\n1549#3:181\n1620#3,3:182\n1549#3:187\n1620#3,3:188\n800#3,11:191\n1747#3,3:202\n14#4:185\n80#5:186\n23#6:205\n23#6:206\n*S KotlinDebug\n*F\n+ 1 PbAddImportStatementIntention.kt\ncom/intellij/protobuf/lang/intentions/PbAddImportStatementIntention\n*L\n82#1:170\n82#1:171,3\n85#1:174\n85#1:175,2\n95#1:177\n95#1:178,3\n102#1:181\n102#1:182,3\n143#1:187\n143#1:188,3\n144#1:191,11\n152#1:202,3\n116#1:185\n121#1:186\n158#1:205\n164#1:206\n*E\n"})
public final class PbAddImportStatementIntention
implements IntentionAction {
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return (FileModifier)this;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        return (PsiElement)currentFile;
    }

    @NotNull
    public String getText() {
        String string = PbLangBundle.message("intention.add.import.statement.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PbLangBundle.message("intention.fix.import.problems.familyName", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof PbFile)) return false;
        PsiReference psiReference = this.findSymbolPathReference(editor, file);
        if ((psiReference != null ? psiReference.resolve() : null) != null) return false;
        String string = this.constructUnresolvedSymbolPath((PbFile)file, editor);
        Object object = string;
        if (string == null) return false;
        String it = object;
        boolean bl = false;
        List<PbFile> list = this.allProtoFilesWithGivenFqn(it, project);
        object = list;
        if (list == null) return false;
        if (((Collection)object).isEmpty()) return false;
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile editedFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)editedFile, (String)"editedFile");
        if (!(editedFile instanceof PbFile)) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || IntentionPreviewUtils.isPreviewElement((PsiElement)((PsiElement)editedFile))) {
            PbUiUtilsKt.selectItemAndApply(this.prepareQuickFixes(project, editor, (PbFile)editedFile), editor, project);
            return;
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> PbAddImportStatementIntention.invoke$lambda$1(editor, project, this, editedFile), PbLangBundle.message("background.task.title.add.import.prepare.variants", new Object[0]), true, project);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PbImportIntentionVariant> prepareQuickFixes(Project project, Editor editor, PbFile editedFile) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        String string = this.constructUnresolvedSymbolPath(editedFile, editor);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String unresolvedMessageFqn = string;
        List<PbFile> importCandidates = this.allProtoFilesWithGivenFqn(unresolvedMessageFqn, project);
        Iterable $this$map$iv = importCandidates;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PbFile pbFile = (PbFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FileUtil.toSystemIndependentName((String)it.getVirtualFile().getPath()));
        }
        List importCandidatesPaths = (List)destination$iv$iv;
        List<PbImportStatement> list = editedFile.getImportStatements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getImportStatements(...)");
        Iterable $i$f$map22 = list;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PbImportStatement it = (PbImportStatement)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!this.importCorrespondsToFile(it, importCandidatesPaths)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List suitableExistingInCurrentFileImportStatements = (List)destination$iv$iv2;
        return this.createPossibleImportIssueFixes(importCandidates, suitableExistingInCurrentFileImportStatements, editedFile);
    }

    private final List<PbImportIntentionVariant> createPossibleImportIssueFixes(List<? extends PsiFile> protoFileCandidates, List<? extends PbImportStatement> suitableImportStatements, PbFile editedProtoFile) {
        if (suitableImportStatements.isEmpty()) {
            ImportPathData it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = protoFileCandidates;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                VirtualFile originalProtoFile;
                Project project;
                PsiFile psiFile = (PsiFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)editedProtoFile.getViewProvider().getVirtualFile(), (String)"getVirtualFile(...)");
                VirtualFile importedProtoFile = it.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)editedProtoFile.getProject(), (String)"getProject(...)");
                Intrinsics.checkNotNull((Object)importedProtoFile);
                String presentablePath = ImportPathData.Companion.shortenPath(importedProtoFile, project);
                String string = importedProtoFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = importedProtoFile.getParent().getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
                collection.add(new ImportPathData(originalProtoFile, importedProtoFile, string, string2, presentablePath));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ImportPathData)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new PbImportIntentionVariant.AddImportStatementAndPathToSettings(it));
            }
            return (List)destination$iv$iv;
        }
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)suitableImportStatements), (Function1)((Function1)new Function1<PbImportStatement, ImportPathData>(this, editedProtoFile){
            final /* synthetic */ PbAddImportStatementIntention this$0;
            final /* synthetic */ PbFile $editedProtoFile;
            {
                this.this$0 = $receiver;
                this.$editedProtoFile = $editedProtoFile;
                super(1);
            }

            @Nullable
            public final ImportPathData invoke(@NotNull PbImportStatement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return PbAddImportStatementIntention.access$findTheOnlySuitableProtoFileToImport(this.this$0, it, this.$editedProtoFile);
            }
        })), (Function1)createPossibleImportIssueFixes.4.INSTANCE));
    }

    private final PsiReference findSymbolPathReference(Editor editor, PsiFile file) {
        PsiReference $this$asSafely$iv = file.findReferenceAt(editor.getCaretModel().getOffset());
        boolean $i$f$asSafely = false;
        PsiReference psiReference = $this$asSafely$iv;
        if (!(psiReference instanceof ProtoSymbolPathReference)) {
            psiReference = null;
        }
        return (PsiReference)((ProtoSymbolPathReference)psiReference);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String constructUnresolvedSymbolPath(PbFile file, Editor editor) {
        void $this$parentsOfType$iv;
        PsiElement psiElement = file.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement == null) return null;
        PsiElement psiElement2 = psiElement;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        Sequence sequence = PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, PbSymbolPath.class, (boolean)withSelf$iv);
        if (sequence == null) return null;
        psiElement2 = (PbSymbolPath)SequencesKt.lastOrNull((Sequence)sequence);
        if (psiElement2 == null) return null;
        QualifiedName qualifiedName = psiElement2.getQualifiedName();
        if (qualifiedName == null) return null;
        String string = qualifiedName.join("/");
        return string;
    }

    private final List<PbFile> allProtoFilesWithGivenFqn(String unresolvedMessageFqn, Project project) {
        List<PbFile> list;
        StubIndexKey<String, PbNamedElement> stubIndexKey = QualifiedNameIndex.KEY;
        Intrinsics.checkNotNullExpressionValue(stubIndexKey, (String)"KEY");
        List<PbFile> it = list = this.allProtoFilesWithFqnFromIndex(unresolvedMessageFqn, stubIndexKey, project);
        boolean bl = false;
        List<PbFile> list2 = !((Collection)it).isEmpty() ? list : null;
        if (list2 == null) {
            StubIndexKey<String, PbNamedElement> stubIndexKey2 = ShortNameIndex.KEY;
            Intrinsics.checkNotNullExpressionValue(stubIndexKey2, (String)"KEY");
            list2 = this.allProtoFilesWithFqnFromIndex(unresolvedMessageFqn, stubIndexKey2, project);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PbFile> allProtoFilesWithFqnFromIndex(String unresolvedMessageFqn, StubIndexKey<String, PbNamedElement> key, Project project) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Collection collection = StubIndex.getElements(key, (Object)unresolvedMessageFqn, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project), PbNamedElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getElements(...)");
        Iterable iterable = collection;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(p0.getContainingFile());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PbFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean importCorrespondsToFile(PbImportStatement currentImportStatement, List<String> protoFileCandidates) {
        String it;
        String string;
        PbImportName pbImportName = currentImportStatement.getImportName();
        if (pbImportName == null) return false;
        PbStringValue pbStringValue = pbImportName.getStringValue();
        if (pbStringValue == null) return false;
        String string2 = (String)pbStringValue.getValue();
        if (string2 == null) return false;
        String p0 = string = string2;
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)p0)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        String string3 = string;
        String string4 = string3;
        if (string4 == null) return false;
        String existingImport = string = string4;
        boolean bl3 = false;
        Iterable $this$any$iv = protoFileCandidates;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl4 = false;
        } while (!StringsKt.endsWith$default((String)it, (String)existingImport, (boolean)false, (int)2, null));
        boolean bl5 = true;
        if (!bl5) return false;
        String string5 = string;
        if (string5 == null) return false;
        return true;
    }

    private final ImportPathData findTheOnlySuitableProtoFileToImport(PbImportStatement unresolvedImportStatement, PbFile editedProtoFile) {
        Object object = unresolvedImportStatement.getImportName();
        if (object == null || (object = object.getStringValue()) == null || (object = (String)object.getValue()) == null) {
            PbAddImportStatementIntention $this$findTheOnlySuitableProtoFileToImport_u24lambda_u2410 = this;
            boolean bl = false;
            PbAddImportStatementIntention $this$thisLogger$iv = $this$findTheOnlySuitableProtoFileToImport_u24lambda_u2410;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PbAddImportStatementIntention.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Empty import statement selected as suitable for import paths configuration");
            return null;
        }
        Object relativeProtoPath = object;
        VirtualFile virtualFile = editedProtoFile.getViewProvider().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Project project = editedProtoFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ImportPathData importPathData = (ImportPathData)SequencesKt.firstOrNull(PbImportPathResolver.INSTANCE.findSuitableImportPaths((String)relativeProtoPath, virtualFile, project));
        if (importPathData == null) {
            PbAddImportStatementIntention $this$findTheOnlySuitableProtoFileToImport_u24lambda_u2411 = this;
            boolean bl = false;
            PbAddImportStatementIntention $this$thisLogger$iv = $this$findTheOnlySuitableProtoFileToImport_u24lambda_u2411;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PbAddImportStatementIntention.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to find suitable PROTO file for specified import statement");
            importPathData = null;
        }
        return importPathData;
    }

    private static final void invoke$lambda$1(Editor $editor, Project $project, PbAddImportStatementIntention this$0, PsiFile $editedFile) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$editedFile, (String)"$editedFile");
        List fixes2 = (List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends PbImportIntentionVariant>>(this$0, $project, $editor, $editedFile){
            final /* synthetic */ PbAddImportStatementIntention this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ PsiFile $editedFile;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$editor = $editor;
                this.$editedFile = $editedFile;
                super(0);
            }

            @NotNull
            public final List<PbImportIntentionVariant> invoke() {
                return PbAddImportStatementIntention.access$prepareQuickFixes(this.this$0, this.$project, this.$editor, (PbFile)this.$editedFile);
            }
        }));
        PbUiUtilsKt.selectItemAndApply(fixes2, $editor, $project);
    }

    public static final /* synthetic */ ImportPathData access$findTheOnlySuitableProtoFileToImport(PbAddImportStatementIntention $this, PbImportStatement unresolvedImportStatement, PbFile editedProtoFile) {
        return $this.findTheOnlySuitableProtoFileToImport(unresolvedImportStatement, editedProtoFile);
    }

    public static final /* synthetic */ List access$prepareQuickFixes(PbAddImportStatementIntention $this, Project project, Editor editor, PbFile editedFile) {
        return $this.prepareQuickFixes(project, editor, editedFile);
    }
}

