/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.intentions.PbAddImportPathIntention;
import com.intellij.protobuf.lang.intentions.PbImportIntentionVariant;
import com.intellij.protobuf.lang.intentions.util.PbImportPathResolver;
import com.intellij.protobuf.lang.intentions.util.PbUiUtilsKt;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbImportStatement;
import com.intellij.protobuf.lang.psi.PbStringValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J!\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/protobuf/lang/intentions/PbAddImportPathIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "()V", "findEditedImportStatement", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "getFamilyName", "getText", "invoke", "", "isAvailable", "", "prepareQuickFixes", "", "Lcom/intellij/protobuf/lang/intentions/PbImportIntentionVariant;", "startInWriteAction", "intellij.protoeditor.core"})
@SourceDebugExtension(value={"SMAP\nPbAddImportPathIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PbAddImportPathIntention.kt\ncom/intellij/protobuf/lang/intentions/PbAddImportPathIntention\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,81:1\n67#2:82\n*S KotlinDebug\n*F\n+ 1 PbAddImportPathIntention.kt\ncom/intellij/protobuf/lang/intentions/PbAddImportPathIntention\n*L\n78#1:82\n*E\n"})
public final class PbAddImportPathIntention
implements IntentionAction {
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @NotNull
    public String getText() {
        String string = PbLangBundle.message("intention.add.import.path.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PbLangBundle.message("intention.fix.import.problems.familyName", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(project, file, this, editor){
            final /* synthetic */ Project $project;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ PbAddImportPathIntention this$0;
            final /* synthetic */ Editor $editor;
            {
                this.$project = $project;
                this.$file = $file;
                this.this$0 = $receiver;
                this.$editor = $editor;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                if (DumbService.Companion.isDumb(this.$project) || !(this.$file instanceof PbFile)) {
                    bl = false;
                } else {
                    String string = PbAddImportPathIntention.access$findEditedImportStatement(this.this$0, this.$editor, this.$file);
                    bl = string != null ? StringsKt.endsWith$default((String)string, (String)".proto", (boolean)false, (int)2, null) : false;
                }
                return bl;
            }
        }));
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PbUiUtilsKt.selectItemAndApply(this.prepareQuickFixes(project, editor, file), editor, project);
            return;
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> PbAddImportPathIntention.invoke$lambda$0(editor, project, this, file), PbLangBundle.message("background.task.title.add.import.prepare.variants", new Object[0]), true, project);
    }

    private final List<PbImportIntentionVariant> prepareQuickFixes(Project project, Editor editor, PsiFile file) {
        String string = this.findEditedImportStatement(editor, file);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String importStatement = string;
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)SequencesKt.map(PbImportPathResolver.INSTANCE.findSuitableImportPaths(importStatement, virtualFile, project), (Function1)prepareQuickFixes.1.INSTANCE), (Object)PbImportIntentionVariant.ManuallyConfigureImportPathsSettings.INSTANCE));
    }

    public boolean startInWriteAction() {
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String findEditedImportStatement(Editor editor, PsiFile file) {
        void $this$parentOfType$iv;
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null) return null;
        PsiElement psiElement2 = psiElement;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        PbImportStatement pbImportStatement = (PbImportStatement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PbImportStatement.class, (boolean)false);
        if (pbImportStatement == null) return null;
        psiElement2 = pbImportStatement.getImportName();
        if (psiElement2 == null) return null;
        PbStringValue pbStringValue = psiElement2.getStringValue();
        if (pbStringValue == null) return null;
        String string = (String)pbStringValue.getValue();
        return string;
    }

    private static final void invoke$lambda$0(Editor $editor, Project $project, PbAddImportPathIntention this$0, PsiFile $file) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        List fixes2 = (List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends PbImportIntentionVariant>>(this$0, $project, $editor, $file){
            final /* synthetic */ PbAddImportPathIntention this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ PsiFile $file;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$editor = $editor;
                this.$file = $file;
                super(0);
            }

            @NotNull
            public final List<PbImportIntentionVariant> invoke() {
                return PbAddImportPathIntention.access$prepareQuickFixes(this.this$0, this.$project, this.$editor, this.$file);
            }
        }));
        PbUiUtilsKt.selectItemAndApply(fixes2, $editor, $project);
    }

    public static final /* synthetic */ String access$findEditedImportStatement(PbAddImportPathIntention $this, Editor editor, PsiFile file) {
        return $this.findEditedImportStatement(editor, file);
    }

    public static final /* synthetic */ List access$prepareQuickFixes(PbAddImportPathIntention $this, Project project, Editor editor, PsiFile file) {
        return $this.prepareQuickFixes(project, editor, file);
    }
}

