/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.jvm.gutter;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.protobuf.ide.gutter.PbCodeImplementationSearcher;
import com.intellij.protobuf.ide.gutter.PbGeneratedCodeConverter;
import com.intellij.protobuf.jvm.PbJavaFindUsagesHandlerFactory;
import com.intellij.protobuf.jvm.PbJavaGotoDeclarationHandler;
import com.intellij.protobuf.jvm.gutter.PbJavaImplementationSearcher;
import com.intellij.protobuf.jvm.gutter.PbJavaImplementationSearcher$handleMessageImplementations$;
import com.intellij.protobuf.jvm.gutter.PbJavaImplementationSearcher$handleModel$;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbMessageDefinition;
import com.intellij.protobuf.lang.psi.PbOptionExpression;
import com.intellij.protobuf.lang.psi.PbServiceDefinition;
import com.intellij.protobuf.lang.psi.PbServiceMethod;
import com.intellij.protobuf.lang.psi.PbStringValue;
import com.intellij.protobuf.lang.stub.PbSearchParameters;
import com.intellij.protobuf.lang.stub.ProtoFileAccessor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J \u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001e\u0010\"\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J$\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u0013\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J,\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a8\u0006'"}, d2={"Lcom/intellij/protobuf/jvm/gutter/PbJavaImplementationSearcher;", "Lcom/intellij/protobuf/ide/gutter/PbCodeImplementationSearcher;", "()V", "classWithSuitableSuperSearcher", "Lcom/intellij/util/CommonProcessors$FindFirstProcessor;", "Lcom/intellij/psi/PsiClass;", "converters", "", "Lcom/intellij/protobuf/ide/gutter/PbGeneratedCodeConverter;", "effectiveServiceFqn", "", "serviceDefinition", "Lcom/intellij/protobuf/lang/psi/PbServiceDefinition;", "findDeclarationsForCodeElement", "Lkotlin/sequences/Sequence;", "Lcom/intellij/protobuf/lang/psi/PbElement;", "psiElement", "Lcom/intellij/psi/PsiElement;", "findGeneratedServiceSuperclass", "psiClass", "findImplementationsForProtoElement", "pbElement", "handleMessageImplementations", "messageDefinition", "Lcom/intellij/protobuf/lang/psi/PbMessageDefinition;", "handleMethod", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "handleMethodImplementations", "methodDefinition", "Lcom/intellij/protobuf/lang/psi/PbServiceMethod;", "handleModel", "handleService", "handleServiceImplementations", "hasServiceSuperclass", "", "protoNamesForClass", "protoNamesForMethod", "generatedBaseClass", "intellij.protoeditor.jvm"})
@SourceDebugExtension(value={"SMAP\nPbJavaImplementationSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PbJavaImplementationSearcher.kt\ncom/intellij/protobuf/jvm/gutter/PbJavaImplementationSearcher\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n66#2,2:148\n66#2,2:150\n473#3:152\n473#3:153\n31#4,2:154\n31#4,2:156\n14#5:158\n288#6,2:159\n1549#6:161\n1620#6,3:162\n1747#6,3:165\n*S KotlinDebug\n*F\n+ 1 PbJavaImplementationSearcher.kt\ncom/intellij/protobuf/jvm/gutter/PbJavaImplementationSearcher\n*L\n57#1:148,2\n65#1:150,2\n68#1:152\n75#1:153\n80#1:154,2\n89#1:156,2\n94#1:158\n96#1:159,2\n141#1:161\n141#1:162,3\n143#1:165,3\n*E\n"})
public final class PbJavaImplementationSearcher
implements PbCodeImplementationSearcher {
    @Override
    @NotNull
    public Sequence<PsiElement> findImplementationsForProtoElement(@NotNull PbElement pbElement, @NotNull Collection<? extends PbGeneratedCodeConverter> converters) {
        Intrinsics.checkNotNullParameter((Object)pbElement, (String)"pbElement");
        Intrinsics.checkNotNullParameter(converters, (String)"converters");
        PbElement pbElement2 = pbElement;
        return pbElement2 instanceof PbServiceDefinition ? this.handleServiceImplementations((PbServiceDefinition)pbElement, converters) : (pbElement2 instanceof PbServiceMethod ? this.handleMethodImplementations((PbServiceMethod)pbElement, converters) : (pbElement2 instanceof PbMessageDefinition ? this.handleMessageImplementations((PbMessageDefinition)pbElement) : SequencesKt.emptySequence()));
    }

    @Override
    @NotNull
    public Sequence<PbElement> findDeclarationsForCodeElement(@NotNull PsiElement psiElement, @NotNull Collection<? extends PbGeneratedCodeConverter> converters) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter(converters, (String)"converters");
        return psiElement instanceof PsiClass && this.hasServiceSuperclass((PsiClass)psiElement, converters) ? this.handleService((PsiClass)psiElement, converters) : (psiElement instanceof PsiClass ? this.handleModel(psiElement) : (psiElement instanceof PsiMethod ? this.handleMethod((PsiMethod)psiElement, converters) : SequencesKt.emptySequence()));
    }

    private final Sequence<PsiClass> handleServiceImplementations(PbServiceDefinition serviceDefinition, Collection<? extends PbGeneratedCodeConverter> converters) {
        String string = this.effectiveServiceFqn(serviceDefinition);
        if (string == null) {
            return SequencesKt.emptySequence();
        }
        String serviceFqn = string;
        Project project = serviceDefinition.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        return SequencesKt.flatMapIterable((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)converters), (Function1)((Function1)new Function1<PbGeneratedCodeConverter, String>(serviceFqn){
            final /* synthetic */ String $serviceFqn;
            {
                this.$serviceFqn = $serviceFqn;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull PbGeneratedCodeConverter converter) {
                Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
                return converter.protoToCodeEntityName(this.$serviceFqn);
            }
        })), (Function1)((Function1)new Function1<String, PsiClass>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            @Nullable
            public final PsiClass invoke(@NotNull String maybeExistingCodeEntity) {
                Intrinsics.checkNotNullParameter((Object)maybeExistingCodeEntity, (String)"maybeExistingCodeEntity");
                return JavaPsiFacade.getInstance((Project)this.$project).findClass(maybeExistingCodeEntity, GlobalSearchScope.projectScope((Project)this.$project));
            }
        })), (Function1)handleServiceImplementations.3.INSTANCE);
    }

    private final Sequence<PsiMethod> handleMethodImplementations(PbServiceMethod methodDefinition, Collection<? extends PbGeneratedCodeConverter> converters) {
        PsiElement $this$parentOfType_u24default$iv = methodDefinition;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PbServiceDefinition pbServiceDefinition = (PbServiceDefinition)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PbServiceDefinition.class, (boolean)true);
        if (pbServiceDefinition == null) {
            return SequencesKt.emptySequence();
        }
        PbServiceDefinition serviceDefinition = pbServiceDefinition;
        String string = methodDefinition.getName();
        if (string == null) {
            return SequencesKt.emptySequence();
        }
        String methodName = string;
        return SequencesKt.filter((Sequence)SequencesKt.flatMap(this.handleServiceImplementations(serviceDefinition, converters), (Function1)handleMethodImplementations.1.INSTANCE), (Function1)((Function1)new Function1<PsiMethod, Boolean>(methodName){
            final /* synthetic */ String $methodName;
            {
                this.$methodName = $methodName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(PsiMethod it) {
                return Intrinsics.areEqual((Object)it.getName(), (Object)this.$methodName);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<PsiClass> handleMessageImplementations(PbMessageDefinition messageDefinition) {
        void $this$filterIsInstance$iv;
        PsiElement $this$parentOfType_u24default$iv = messageDefinition;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PbFile pbFile = (PbFile)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PbFile.class, (boolean)true);
        if (pbFile == null) {
            return SequencesKt.emptySequence();
        }
        PbFile pbFile2 = pbFile;
        PbJavaFindUsagesHandlerFactory.ProtoToJavaConverter dispatcher = new PbJavaFindUsagesHandlerFactory.ProtoToJavaConverter(pbFile2);
        messageDefinition.accept(dispatcher);
        Object[] objectArray = dispatcher.getResults();
        Object object = objectArray != null ? ArraysKt.asSequence((Object[])objectArray) : null;
        if (object == null) {
            object = SequencesKt.emptySequence();
        }
        $this$parentOfType_u24default$iv = object;
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)handleMessageImplementations$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return sequence;
    }

    private final Sequence<PbElement> handleModel(PsiElement psiElement) {
        Object[] objectArray = PbJavaGotoDeclarationHandler.findProtoDeclarationForResolvedJavaElement(psiElement);
        Sequence sequence = objectArray != null ? ArraysKt.asSequence((Object[])objectArray) : null;
        if (sequence == null) {
            sequence = SequencesKt.emptySequence();
        }
        Sequence $this$filterIsInstance$iv = sequence;
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)handleModel$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return sequence2;
    }

    private final Sequence<PbElement> handleService(PsiClass psiClass, Collection<? extends PbGeneratedCodeConverter> converters) {
        PsiClass psiClass2 = this.findGeneratedServiceSuperclass(psiClass, converters);
        if (psiClass2 == null) {
            return SequencesKt.emptySequence();
        }
        PsiClass generatedBaseClass = psiClass2;
        Project project = psiClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ProtoFileAccessor> serviceClass$iv = ProtoFileAccessor.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ProtoFileAccessor protoFileAccessor = (ProtoFileAccessor)object;
        return SequencesKt.flatMap(this.protoNamesForClass(generatedBaseClass, converters), (Function1)((Function1)new Function1<String, Sequence<? extends PbServiceDefinition>>(protoFileAccessor){
            final /* synthetic */ ProtoFileAccessor $protoFileAccessor;
            {
                this.$protoFileAccessor = $protoFileAccessor;
                super(1);
            }

            @NotNull
            public final Sequence<PbServiceDefinition> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$protoFileAccessor.findServicesByFqn(it, PbSearchParameters.CONTAINS);
            }
        }));
    }

    private final Sequence<PbElement> handleMethod(PsiMethod psiMethod, Collection<? extends PbGeneratedCodeConverter> converters) {
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return SequencesKt.emptySequence();
        }
        PsiClass containingClass = psiClass;
        PsiClass psiClass2 = this.findGeneratedServiceSuperclass(containingClass, converters);
        if (psiClass2 == null) {
            return SequencesKt.emptySequence();
        }
        PsiClass generatedBaseClass = psiClass2;
        Sequence<String> protoNamesForMethod2 = this.protoNamesForMethod(psiMethod, generatedBaseClass, converters);
        Project project = psiMethod.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ProtoFileAccessor> serviceClass$iv = ProtoFileAccessor.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ProtoFileAccessor protoFileAccessor = (ProtoFileAccessor)object;
        return SequencesKt.flatMap(protoNamesForMethod2, (Function1)((Function1)new Function1<String, Sequence<? extends PbServiceMethod>>(protoFileAccessor){
            final /* synthetic */ ProtoFileAccessor $protoFileAccessor;
            {
                this.$protoFileAccessor = $protoFileAccessor;
                super(1);
            }

            @NotNull
            public final Sequence<PbServiceMethod> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$protoFileAccessor.findAllMethodsWithFqnPrefix(it);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final String effectiveServiceFqn(PbServiceDefinition serviceDefinition) {
        Object object;
        PbStringValue pbStringValue;
        String javaPackageOrNull;
        Object v3;
        block6: {
            void $this$firstOrNull$iv;
            PsiFile $this$asSafely$iv = serviceDefinition.getContainingFile();
            boolean $i$f$asSafely22 = false;
            PsiFile psiFile = $this$asSafely$iv;
            if (!(psiFile instanceof PbFile)) {
                psiFile = null;
            }
            PbFile pbFile = (PbFile)psiFile;
            if (pbFile == null) {
                return null;
            }
            PbFile pbFile2 = pbFile;
            List list = pbFile2.getOptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOptions(...)");
            Iterable $i$f$asSafely22 = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PbOptionExpression it = (PbOptionExpression)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOptionName().getText(), (Object)"java_package")) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        PbOptionExpression pbOptionExpression = v3;
        String string = javaPackageOrNull = pbOptionExpression != null && (pbStringValue = pbOptionExpression.getStringValue()) != null ? pbStringValue.getAsString() : null;
        if (javaPackageOrNull == null) {
            QualifiedName qualifiedName = serviceDefinition.getQualifiedName();
            object = qualifiedName != null ? qualifiedName.toString() : null;
        } else {
            String string2 = serviceDefinition.getName();
            if (string2 == null) {
                string2 = "";
            }
            object = javaPackageOrNull + "." + string2;
        }
        return object;
    }

    private final Sequence<String> protoNamesForClass(PsiClass psiClass, Collection<? extends PbGeneratedCodeConverter> converters) {
        String string = psiClass.getQualifiedName();
        if (string == null) {
            return SequencesKt.emptySequence();
        }
        String qualifiedName = string;
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)converters), (Function1)((Function1)new Function1<PbGeneratedCodeConverter, String>(qualifiedName){
            final /* synthetic */ String $qualifiedName;
            {
                this.$qualifiedName = $qualifiedName;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull PbGeneratedCodeConverter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.codeEntityNameToProtoName(this.$qualifiedName);
            }
        }));
    }

    private final Sequence<String> protoNamesForMethod(PsiMethod psiMethod, PsiClass generatedBaseClass, Collection<? extends PbGeneratedCodeConverter> converters) {
        String string = psiMethod.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String methodName = string;
        return SequencesKt.map(this.protoNamesForClass(generatedBaseClass, converters), (Function1)((Function1)new Function1<String, String>(methodName){
            final /* synthetic */ String $methodName;
            {
                this.$methodName = $methodName;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it + "." + this.$methodName;
            }
        }));
    }

    private final PsiClass findGeneratedServiceSuperclass(PsiClass psiClass, Collection<? extends PbGeneratedCodeConverter> converters) {
        CommonProcessors.FindFirstProcessor<PsiClass> searchProcessor = this.classWithSuitableSuperSearcher(converters);
        InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)true, (Processor)((Processor)searchProcessor));
        return (PsiClass)searchProcessor.getFoundValue();
    }

    private final CommonProcessors.FindFirstProcessor<PsiClass> classWithSuitableSuperSearcher(Collection<? extends PbGeneratedCodeConverter> converters) {
        return (CommonProcessors.FindFirstProcessor)new CommonProcessors.FindFirstProcessor<PsiClass>(converters){
            final /* synthetic */ Collection<PbGeneratedCodeConverter> $converters;
            {
                this.$converters = $converters;
            }

            protected boolean accept(@NotNull PsiClass psiClass) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
                    Iterable $this$any$iv = this.$converters;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            PbGeneratedCodeConverter it = (PbGeneratedCodeConverter)element$iv;
                            boolean bl2 = false;
                            if (!this.checkJavaClassHierarchy(psiClass, it)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private final boolean checkJavaClassHierarchy(PsiClass psiClass, PbGeneratedCodeConverter converter) {
                PsiClass bindableServiceClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(converter.generatedFileNameHint(), psiClass.getResolveScope());
                return InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)bindableServiceClass, (boolean)false);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasServiceSuperclass(PsiClass psiClass, Collection<? extends PbGeneratedCodeConverter> converters) {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = converters;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                PbGeneratedCodeConverter pbGeneratedCodeConverter = (PbGeneratedCodeConverter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(p0.generatedFileNameHint());
            }
            Iterable $this$any$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

