/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.settings;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.protobuf.lang.PbFileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="ProtobufLanguageSettings", storages={@Storage(value="protoeditor.xml")})
public final class PbProjectSettings
implements PersistentStateComponent<State>,
Disposable {
    private State state;
    private final Project project;

    public PbProjectSettings(@NotNull Project project) {
        if (project == null) {
            PbProjectSettings.$$$reportNull$$$0(0);
        }
        this(project, new State());
    }

    @NonInjectable
    private PbProjectSettings(@NotNull Project project, State state) {
        if (project == null) {
            PbProjectSettings.$$$reportNull$$$0(1);
        }
        this.state = state;
        this.project = project;
    }

    public void dispose() {
    }

    public static PbProjectSettings getInstance(Project project) {
        return (PbProjectSettings)project.getService(PbProjectSettings.class);
    }

    public static void notifyUpdated(Project project) {
        PbProjectSettings serviceInstance = PbProjectSettings.getInstance(project);
        serviceInstance.state.incModificationCount();
        BackgroundTaskUtil.executeOnPooledThread((Disposable)serviceInstance, () -> ReadAction.run(() -> {
            for (VirtualFile file : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
                PsiFile psiFile;
                if (file.getFileType() != PbFileType.INSTANCE || (psiFile = PsiManager.getInstance((Project)project).findFile(file)) == null) continue;
                DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
            }
        }));
    }

    public static ModificationTracker getModificationTracker(Project project) {
        return PbProjectSettings.getInstance((Project)project).state;
    }

    @NotNull
    public State getState() {
        State state = this.state;
        if (state == null) {
            PbProjectSettings.$$$reportNull$$$0(2);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PbProjectSettings.$$$reportNull$$$0(3);
        }
        this.state = state;
    }

    public List<ImportPathEntry> getImportPathEntries() {
        return this.state.importPathEntries;
    }

    public void setImportPathEntries(List<ImportPathEntry> importPathEntries) {
        this.state.importPathEntries = importPathEntries == null ? Collections.emptyList() : importPathEntries;
    }

    @NlsSafe
    public String getDescriptorPath() {
        return this.state.descriptorPath;
    }

    public void setDescriptorPath(String descriptorPath) {
        this.state.descriptorPath = StringUtil.defaultIfEmpty((String)descriptorPath, (String)"");
    }

    public boolean isThirdPartyConfigurationEnabled() {
        return this.state.thirdPartyConfiguration;
    }

    public void setThirdPartyConfigurationEnabled(boolean autoConfigEnabled) {
        this.state.thirdPartyConfiguration = autoConfigEnabled;
    }

    public boolean isIncludeProtoDirectories() {
        return this.state.includeProtoDirectories;
    }

    public void setIncludeProtoDirectories(boolean includeProtoDirectories) {
        this.state.includeProtoDirectories = includeProtoDirectories;
    }

    public boolean isIndexBasedResolveEnabled() {
        return this.state.indexBasedResolveEnabled;
    }

    public void setIndexBasedResolveEnabled(boolean indexBasedResolveEnabled) {
        this.state.indexBasedResolveEnabled = indexBasedResolveEnabled;
    }

    public boolean isIncludeContentRoots() {
        return this.state.includeContentRoots;
    }

    public void setIncludeContentRoots(boolean includeSourceRoots) {
        this.state.includeContentRoots = includeSourceRoots;
    }

    public PbProjectSettings copy() {
        return new PbProjectSettings(this.project, (State)((Object)XmlSerializer.deserialize((Element)XmlSerializer.serialize((Object)((Object)this.state)), State.class)));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        PbProjectSettings other = (PbProjectSettings)obj;
        return Objects.equals(this.getDescriptorPath(), other.getDescriptorPath()) && Objects.equals(this.getImportPathEntries(), other.getImportPathEntries());
    }

    public int hashCode() {
        return Objects.hash(this.getDescriptorPath(), this.getImportPathEntries());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/ide/settings/PbProjectSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/ide/settings/PbProjectSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class State
    extends SimpleModificationTracker {
        public boolean thirdPartyConfiguration = true;
        public boolean includeContentRoots = true;
        public boolean includeProtoDirectories = true;
        public boolean indexBasedResolveEnabled = false;
        public List<ImportPathEntry> importPathEntries = new SmartList();
        @NlsSafe
        public String descriptorPath = "";
    }

    public static final class ImportPathEntry {
        @NlsSafe
        private String location;
        @NlsSafe
        private String prefix;

        public ImportPathEntry(String location, String prefix) {
            this.location = StringUtil.defaultIfEmpty((String)location, (String)"");
            this.prefix = StringUtil.defaultIfEmpty((String)prefix, (String)"");
        }

        public ImportPathEntry() {
            this(null, null);
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImportPathEntry other = (ImportPathEntry)obj;
            return Objects.equals(this.location, other.location) && Objects.equals(this.prefix, other.prefix);
        }

        public int hashCode() {
            return Objects.hash(this.location, this.prefix);
        }
    }
}

