/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.settings;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.protobuf.ide.PbIdeBundle;
import com.intellij.protobuf.ide.actions.PbExportSettingsAsCliCommandAction;
import com.intellij.protobuf.ide.settings.PbImportPathsConfiguration;
import com.intellij.protobuf.ide.settings.PbProjectSettings;
import com.intellij.protobuf.ide.settings.PbSettingsUiUtilsKt;
import com.intellij.protobuf.ide.settings.SettingsFileResolveProvider;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.TableView;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.table.IconTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PbLanguageSettingsForm
implements ConfigurableUi<PbProjectSettings> {
    private static final Pattern LEADING_TRAILING_SLASHES = Pattern.compile("(^/+)|(/+$)");
    private final Project project;
    private JPanel panel;
    private ListTableModel<ImportPath> importPathModel;
    private ComboBox<String> descriptorPathField;
    private JCheckBox isIncludeStandardProtoDirectoriesCheckbox;
    private JCheckBox isIncludeContentRootsCheckbox;
    private JCheckBox autoConfigCheckbox;
    private JCheckBox isIndexBasedResolveEnabledCheckbox;
    private static final ImportPathGroup autoConfiguredGroup = ImportPathGroup.create(count -> PbIdeBundle.message("settings.virtual.group.contributed.name", count), 0);
    private static final ImportPathGroup protoDirectoriesGroup = ImportPathGroup.create(count -> PbIdeBundle.message("settings.virtual.group.proto.directory.name", count), 1);
    private static final ImportPathGroup contentRootsGroup = ImportPathGroup.create(count -> PbIdeBundle.message("settings.virtual.group.content.root.name", count), 2);
    private static final ImportPathGroup bundledGoogleStdLibGroup = ImportPathGroup.create(count -> PbIdeBundle.message("settings.virtual.group.std.google.proto.name", new Object[0]), 3);
    private static final ImportPathGroup filesFromIndexesGroup = ImportPathGroup.create(count -> PbIdeBundle.message("settings.virtual.group.from.indexes", count), 4);
    private static final ImportPathGroup loadingStateGroup = ImportPathGroup.create(count -> PbIdeBundle.message("settings.virtual.group.loading", new Object[0]), 100);

    PbLanguageSettingsForm(Project project) {
        this.project = project;
        this.initComponent();
    }

    public void reset(@NotNull PbProjectSettings settings) {
        if (settings == null) {
            PbLanguageSettingsForm.$$$reportNull$$$0(0);
        }
        this.loadSettings(settings);
    }

    public boolean isModified(@NotNull PbProjectSettings settings) {
        if (settings == null) {
            PbLanguageSettingsForm.$$$reportNull$$$0(1);
        }
        return !this.getDescriptorPath().equals(settings.getDescriptorPath()) || this.isAutoConfigEnabled() != settings.isThirdPartyConfigurationEnabled() || this.isIncludeStandardProtoDirectories() != settings.isIncludeProtoDirectories() || this.isIncludeProjectContentRoots() != settings.isIncludeContentRoots() || this.isIndexBasedResolveEnabled() != settings.isIndexBasedResolveEnabled() || !this.getImportPathEntries().equals(settings.getImportPathEntries());
    }

    public void apply(@NotNull PbProjectSettings settings) {
        if (settings == null) {
            PbLanguageSettingsForm.$$$reportNull$$$0(2);
        }
        this.applyNoNotify(settings);
        PbProjectSettings.notifyUpdated(this.project);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            PbLanguageSettingsForm.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void loadSettings(@NotNull PbProjectSettings settings) {
        if (settings == null) {
            PbLanguageSettingsForm.$$$reportNull$$$0(4);
        }
        this.autoConfigCheckbox.setSelected(settings.isThirdPartyConfigurationEnabled());
        this.isIncludeStandardProtoDirectoriesCheckbox.setSelected(settings.isIncludeProtoDirectories());
        this.isIncludeContentRootsCheckbox.setSelected(settings.isIncludeContentRoots());
        this.isIndexBasedResolveEnabledCheckbox.setSelected(settings.isIndexBasedResolveEnabled());
        this.descriptorPathField.setSelectedItem((Object)settings.getDescriptorPath());
        this.importPathModel.setItems(new CopyOnWriteArrayList());
        this.importPathModel.addRows((Collection)ContainerUtil.map(settings.getImportPathEntries(), ImportPath::new));
    }

    private void applyNoNotify(@NotNull PbProjectSettings settings) {
        if (settings == null) {
            PbLanguageSettingsForm.$$$reportNull$$$0(5);
        }
        settings.setThirdPartyConfigurationEnabled(this.isAutoConfigEnabled());
        settings.setIncludeContentRoots(this.isIncludeProjectContentRoots());
        settings.setIncludeProtoDirectories(this.isIncludeStandardProtoDirectories());
        settings.setIndexBasedResolveEnabled(this.isIndexBasedResolveEnabled());
        settings.setDescriptorPath(this.getDescriptorPath());
        settings.setImportPathEntries(this.getImportPathEntries());
    }

    private void initComponent() {
        JPanel pathsPanel = this.buildImportPathsPanel();
        JPanel descriptorPanel = this.buildDescriptorPathPanel();
        BorderLayoutPanel manualConfigurationPanel = new BorderLayoutPanel();
        manualConfigurationPanel.add((Component)pathsPanel, "Center");
        manualConfigurationPanel.add((Component)descriptorPanel, "South");
        this.autoConfigCheckbox = new JBCheckBox(PbIdeBundle.message("settings.language.autoconfig", new Object[0]));
        this.isIncludeStandardProtoDirectoriesCheckbox = new JBCheckBox(PbIdeBundle.message("settings.language.include.std.proto.dirs", new Object[0]));
        this.isIncludeContentRootsCheckbox = new JBCheckBox(PbIdeBundle.message("settings.language.include.project.content.roots", new Object[0]));
        this.isIndexBasedResolveEnabledCheckbox = new JBCheckBox(PbIdeBundle.message("settings.language.index.based.resolve.enabled", new Object[0]));
        JPanel autoDetectionPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        UIUtil.addBorder((JComponent)autoDetectionPanel, (Border)IdeBorderFactory.createTitledBorder((String)PbIdeBundle.message("settings.language.autoconfiguration.section.title", new Object[0]), (boolean)false));
        autoDetectionPanel.add((Component)this.autoConfigCheckbox, "CENTER");
        autoDetectionPanel.add((Component)this.isIncludeStandardProtoDirectoriesCheckbox, "CENTER");
        autoDetectionPanel.add((Component)this.isIncludeContentRootsCheckbox, "CENTER");
        autoDetectionPanel.add((Component)this.isIndexBasedResolveEnabledCheckbox, "CENTER");
        this.panel = new BorderLayoutPanel();
        this.panel.add((Component)autoDetectionPanel, "North");
        this.panel.add((Component)manualConfigurationPanel, "Center");
        this.autoConfigCheckbox.addActionListener(this.groupItemPresentationUpdater(autoConfiguredGroup, PbImportPathsConfiguration::thirdPartyImportPaths));
        this.isIncludeStandardProtoDirectoriesCheckbox.addActionListener(this.groupItemPresentationUpdater(protoDirectoriesGroup, PbImportPathsConfiguration::standardProtoDirectories));
        this.isIncludeContentRootsCheckbox.addActionListener(this.groupItemPresentationUpdater(contentRootsGroup, PbImportPathsConfiguration::projectContentRoots));
        this.isIndexBasedResolveEnabledCheckbox.addActionListener(this.groupItemPresentationUpdater(filesFromIndexesGroup, PbImportPathsConfiguration::computeImportPathsForAllImportStatements));
        this.computePreciseAutoConfiguredEntriesCount();
    }

    @NotNull
    private ActionListener groupItemPresentationUpdater(final ImportPathGroup group, final Function<Project, Collection<?>> heavyImportsFetcher) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object changeSource = event.getSource();
                if (changeSource instanceof JCheckBox) {
                    PbLanguageSettingsForm.this.computePresentationAndUpdateModel((JCheckBox)changeSource, group, heavyImportsFetcher);
                }
            }
        };
    }

    private void computePresentationAndUpdateModel(JCheckBox checkBox, ImportPathGroup group, Function<Project, Collection<?>> heavyImportsFetcher) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            int importsCount = heavyImportsFetcher == null ? 0 : (Integer)ReadAction.compute(() -> ((Collection)heavyImportsFetcher.apply(this.project)).size());
            SwingUtilities.invokeLater(() -> this.processVirtualGroupItemPresentation(checkBox, group.copyWithPreciseCount(importsCount)));
        }, PbIdeBundle.message("settings.compute.import.paths.modal.progress.title", new Object[0]), true, this.project);
    }

    private void computePreciseAutoConfiguredEntriesCount() {
        SwingUtilities.invokeLater(() -> this.addVirtualGroup(loadingStateGroup));
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(this.project, PbIdeBundle.message("settings.compute.import.paths.bg.progress.title", new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                ReadAction.run(() -> {
                    int contentRootsSize = PbImportPathsConfiguration.projectContentRoots(PbLanguageSettingsForm.this.project).size();
                    int protoDirsSize = PbImportPathsConfiguration.standardProtoDirectories(PbLanguageSettingsForm.this.project).size();
                    int contributedPathsSize = PbImportPathsConfiguration.thirdPartyImportPaths(PbLanguageSettingsForm.this.project).size();
                    int protoDirectoriesFromIndexSize = PbImportPathsConfiguration.computeImportPathsForAllImportStatements(PbLanguageSettingsForm.this.project).size();
                    SwingUtilities.invokeLater(() -> {
                        PbLanguageSettingsForm.this.removeVirtualGroup(loadingStateGroup);
                        PbLanguageSettingsForm.this.processVirtualGroupItemPresentation(PbLanguageSettingsForm.this.autoConfigCheckbox, autoConfiguredGroup.copyWithPreciseCount(contributedPathsSize));
                        PbLanguageSettingsForm.this.processVirtualGroupItemPresentation(PbLanguageSettingsForm.this.isIncludeStandardProtoDirectoriesCheckbox, protoDirectoriesGroup.copyWithPreciseCount(protoDirsSize));
                        PbLanguageSettingsForm.this.processVirtualGroupItemPresentation(PbLanguageSettingsForm.this.isIncludeContentRootsCheckbox, contentRootsGroup.copyWithPreciseCount(contentRootsSize));
                        PbLanguageSettingsForm.this.processVirtualGroupItemPresentation(PbLanguageSettingsForm.this.isIndexBasedResolveEnabledCheckbox, filesFromIndexesGroup.copyWithPreciseCount(protoDirectoriesFromIndexSize));
                        PbLanguageSettingsForm.this.addVirtualGroup(bundledGoogleStdLibGroup);
                    });
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/protobuf/ide/settings/PbLanguageSettingsForm$2", "run"));
            }
        }, EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressIndicatorProvider.getGlobalProgressIndicator()));
    }

    private void processVirtualGroupItemPresentation(JCheckBox checkBox, ImportPathGroup group) {
        boolean isGroupPresent;
        boolean bl = isGroupPresent = this.importPathModel.indexOf((Object)group) != -1;
        if (checkBox.isSelected()) {
            if (!isGroupPresent) {
                this.addVirtualGroup(group);
            } else {
                this.removeVirtualGroup(group);
                this.addVirtualGroup(group);
            }
        } else if (isGroupPresent) {
            this.removeVirtualGroup(group);
        }
    }

    private void addVirtualGroup(ImportPathGroup group) {
        this.importPathModel.insertRow(PbSettingsUiUtilsKt.findIndexToInsertGroup(this.importPathModel, group), (Object)group);
    }

    private void removeVirtualGroup(ImportPathGroup group) {
        int index = this.importPathModel.indexOf((Object)group);
        if (index == -1) {
            return;
        }
        this.importPathModel.removeRow(index);
    }

    private JPanel buildDescriptorPathPanel() {
        ArrayList<String> descriptorOptions = new ArrayList<String>(PbImportPathsConfiguration.getDescriptorPathSuggestions(this.project));
        this.descriptorPathField = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(descriptorOptions));
        this.descriptorPathField.setEditable(true);
        JTextField editorComponent = (JTextField)this.descriptorPathField.getEditor().getEditorComponent();
        editorComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                PbLanguageSettingsForm.this.scheduleDescriptorValidation();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/protobuf/ide/settings/PbLanguageSettingsForm$3", "textChanged"));
            }
        });
        this.importPathModel.addTableModelListener(event -> this.scheduleDescriptorValidation());
        return LabeledComponent.create(this.descriptorPathField, (String)PbIdeBundle.message("settings.language.descriptor.path", new Object[0]), (String)"West");
    }

    private JPanel buildImportPathsPanel() {
        BorderLayoutPanel panel = new BorderLayoutPanel();
        UIUtil.addBorder((JComponent)panel, (Border)IdeBorderFactory.createTitledBorder((String)PbIdeBundle.message("settings.language.import.paths", new Object[0]), (boolean)false));
        this.importPathModel = new ListTableModel(new ColumnInfo[]{new LocationColumn(PbIdeBundle.message("location", new Object[0])), new PrefixColumn(PbIdeBundle.message("prefix", new Object[0]))}, new CopyOnWriteArrayList());
        TableView importPathTable = new TableView(this.importPathModel);
        importPathTable.setStriped(true);
        importPathTable.setMinRowHeight(25);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((TableView)importPathTable, null);
        decorator.setRemoveActionUpdater(PbLanguageSettingsForm.allowOnlyEffectivePathEditing((TableView<ImportPath>)importPathTable));
        decorator.setEditActionUpdater(PbLanguageSettingsForm.allowOnlyEffectivePathEditing((TableView<ImportPath>)importPathTable));
        decorator.setMoveDownActionUpdater(PbLanguageSettingsForm.allowOnlyEffectivePathEditing((TableView<ImportPath>)importPathTable));
        decorator.setMoveUpActionUpdater(PbLanguageSettingsForm.allowOnlyEffectivePathEditing((TableView<ImportPath>)importPathTable));
        decorator.setAddAction(button -> {
            VirtualFile selectedFile = FileChooser.chooseFile((FileChooserDescriptor)PbLanguageSettingsForm.getFileChooserDescriptor(null), (Project)this.project, null);
            if (selectedFile != null) {
                this.importPathModel.insertRow(0, (Object)new ImportPath(selectedFile.getUrl()));
            }
        });
        decorator.setEditAction(button -> importPathTable.editCellAt(importPathTable.getSelectedRow(), importPathTable.getSelectedColumn()));
        decorator.addExtraAction((AnAction)new PbExportSettingsAsCliCommandAction());
        panel.add((Component)decorator.createPanel(), "Center");
        return panel;
    }

    @NotNull
    private static AnActionButtonUpdater allowOnlyEffectivePathEditing(TableView<ImportPath> importPathTable) {
        AnActionButtonUpdater anActionButtonUpdater = e -> {
            int selectedRow = importPathTable.getSelectedRow();
            if (selectedRow == -1) {
                return false;
            }
            return !(importPathTable.getListTableModel().getItem(selectedRow) instanceof ImportPathGroup);
        };
        if (anActionButtonUpdater == null) {
            PbLanguageSettingsForm.$$$reportNull$$$0(6);
        }
        return anActionButtonUpdater;
    }

    private List<PbProjectSettings.ImportPathEntry> getImportPathEntries() {
        return this.importPathModel.getItems().stream().filter(PbLanguageSettingsForm::isEffectivePath).map(ImportPath::toEntry).toList();
    }

    private String getDescriptorPath() {
        return (String)this.descriptorPathField.getEditor().getItem();
    }

    private boolean isAutoConfigEnabled() {
        return this.autoConfigCheckbox.isSelected();
    }

    private boolean isIncludeStandardProtoDirectories() {
        return this.isIncludeStandardProtoDirectoriesCheckbox.isSelected();
    }

    private boolean isIncludeProjectContentRoots() {
        return this.isIncludeContentRootsCheckbox.isSelected();
    }

    private boolean isIndexBasedResolveEnabled() {
        return this.isIndexBasedResolveEnabledCheckbox.isSelected();
    }

    private boolean isDescriptorPathValid() {
        PbProjectSettings tempSettings = new PbProjectSettings(this.project);
        this.applyNoNotify(tempSettings);
        return (Boolean)ReadAction.compute(() -> SettingsFileResolveProvider.findFileWithSettings(tempSettings.getDescriptorPath(), this.project, tempSettings) != null);
    }

    private void scheduleDescriptorValidation() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (this.isDescriptorPathValid()) {
                SwingUtilities.invokeLater(() -> this.descriptorPathField.getEditor().getEditorComponent().setForeground(UIUtil.getTextFieldForeground()));
            } else {
                SwingUtilities.invokeLater(() -> this.descriptorPathField.getEditor().getEditorComponent().setForeground((Color)JBColor.RED));
            }
        });
    }

    private static FileChooserDescriptor getFileChooserDescriptor(@NlsContexts.DialogTitle String title) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, true, false, true, false).withShowFileSystemRoots(true).withShowHiddenFiles(true);
        if (title != null) {
            descriptor.setTitle(title);
        }
        return descriptor;
    }

    private static boolean isEffectivePath(ImportPath item) {
        return !(item instanceof ImportPathGroup);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/ide/settings/PbLanguageSettingsForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/ide/settings/PbLanguageSettingsForm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "allowOnlyEffectivePathEditing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyNoNotify";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }

    static class ImportPathGroup
    extends ImportPath {
        private final int myOrder;
        private final Function<Integer, String> lazyMessage;

        ImportPathGroup(Function<Integer, String> lazyMessage, String emptyMessage, int order) {
            super(emptyMessage);
            this.lazyMessage = lazyMessage;
            this.myOrder = order;
        }

        ImportPathGroup copyWithPreciseCount(int groupItemsCount) {
            String effectiveMessage = this.lazyMessage.apply(groupItemsCount);
            return new ImportPathGroup(this.lazyMessage, effectiveMessage, this.myOrder);
        }

        static ImportPathGroup create(Function<Integer, String> lazyMessage, int order) {
            return new ImportPathGroup(lazyMessage, lazyMessage.apply(0), order);
        }

        int getOrder() {
            return this.myOrder;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImportPathGroup)) {
                return false;
            }
            ImportPathGroup group = (ImportPathGroup)o;
            return this.myOrder == group.myOrder;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.myOrder);
        }
    }

    private class LocationColumn
    extends ColumnInfo<ImportPath, String> {
        LocationColumn(String name) {
            super(name);
        }

        @Nullable
        public String valueOf(ImportPath o) {
            return o.location;
        }

        public void setValue(ImportPath o, String value) {
            o.location = value;
        }

        public boolean isCellEditable(ImportPath item) {
            return PbLanguageSettingsForm.isEffectivePath(item);
        }

        public TableCellRenderer getRenderer(final ImportPath path) {
            return new IconTableCellRenderer<String>(){

                @NotNull
                protected Icon getIcon(@NotNull String value, JTable table, int row) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (path instanceof ImportPathGroup) {
                        Icon icon = AllIcons.General.ShowInfos;
                        if (icon == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return icon;
                    }
                    VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(value);
                    if (file != null && file.isDirectory()) {
                        Icon icon = PlatformIcons.FOLDER_ICON;
                        if (icon == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return icon;
                    }
                    Icon icon = AllIcons.General.Error;
                    if (icon == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return icon;
                }

                protected void setValue(Object value) {
                    String url = (String)value;
                    VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                    if (!(path instanceof ImportPathGroup || file != null && file.isDirectory())) {
                        this.setForeground((Color)JBColor.RED);
                    }
                    this.setText(file != null ? file.getPresentableUrl() : url);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2, 3 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "value";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/protobuf/ide/settings/PbLanguageSettingsForm$LocationColumn$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/protobuf/ide/settings/PbLanguageSettingsForm$LocationColumn$1";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getIcon";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getIcon";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2, 3 -> new IllegalStateException(string);
                    };
                }
            };
        }

        public TableCellEditor getEditor(ImportPath path) {
            return new LocationCellEditor(PbLanguageSettingsForm.this.project);
        }
    }

    private static class PrefixColumn
    extends ColumnInfo<ImportPath, String> {
        PrefixColumn(@NlsContexts.ColumnName String name) {
            super(name);
        }

        @Nullable
        public String valueOf(ImportPath o) {
            return o.prefix;
        }

        public void setValue(ImportPath o, String value) {
            o.prefix = LEADING_TRAILING_SLASHES.matcher(value.trim()).replaceAll("");
        }

        public boolean isCellEditable(ImportPath item) {
            return PbLanguageSettingsForm.isEffectivePath(item);
        }

        public TableCellEditor getEditor(ImportPath path) {
            DefaultCellEditor editor = new DefaultCellEditor((JTextField)new JBTextField(path.prefix));
            editor.setClickCountToStart(2);
            return editor;
        }

        public int getWidth(JTable table) {
            return JBUIScale.scale((int)200);
        }
    }

    static class ImportPath {
        @NlsSafe
        String location;
        @NlsSafe
        String prefix;

        ImportPath(PbProjectSettings.ImportPathEntry entry) {
            this.location = entry.getLocation();
            this.prefix = entry.getPrefix();
        }

        ImportPath(String location) {
            this.location = location;
            this.prefix = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImportPath)) {
                return false;
            }
            ImportPath path = (ImportPath)o;
            return Objects.equals(this.location, path.location) && Objects.equals(this.prefix, path.prefix);
        }

        public int hashCode() {
            return Objects.hash(this.location, this.prefix);
        }

        PbProjectSettings.ImportPathEntry toEntry() {
            return new PbProjectSettings.ImportPathEntry(this.location, this.prefix);
        }
    }

    private static class LocationCellEditor
    extends AbstractTableCellEditor {
        @NlsContexts.DialogTitle
        private final String title;
        private final Project project;
        private CellEditorComponentWithBrowseButton<JTextField> component = null;

        LocationCellEditor(@Nullable @NlsContexts.DialogTitle String title, @Nullable Project project) {
            this.title = title;
            this.project = project;
        }

        LocationCellEditor(@Nullable Project project) {
            this(null, project);
        }

        public Object getCellEditorValue() {
            return this.component != null ? ((JTextField)this.component.getChildComponent()).getText() : "";
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.component = new CellEditorComponentWithBrowseButton((ComponentWithBrowseButton)new TextFieldWithBrowseButton(this.createActionListener(table)), (TableCellEditor)((Object)this));
            ((JTextField)this.component.getChildComponent()).setText((String)value);
            this.component.setFocusable(false);
            return this.component;
        }

        public boolean isCellEditable(EventObject e) {
            return !(e instanceof MouseEvent) || ((MouseEvent)e).getClickCount() >= 2;
        }

        private ActionListener createActionListener(JTable table) {
            return e -> {
                String initialValue = (String)this.getCellEditorValue();
                VirtualFile initialFile = !StringUtil.isEmpty((String)initialValue) ? VirtualFileManager.getInstance().findFileByUrl(initialValue) : null;
                FileChooser.chooseFile((FileChooserDescriptor)PbLanguageSettingsForm.getFileChooserDescriptor(this.title), (Project)this.project, (Component)table, (VirtualFile)initialFile, file -> ((JTextField)this.component.getChildComponent()).setText(file.getUrl()));
            };
        }
    }
}

