/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.protobuf.lang.psi.PbTextFile;
import com.intellij.protobuf.lang.psi.ProtoBlockBody;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PbTextBlock
extends AbstractBlock {
    private static final TokenSet UNINDENTED_SYMBOLS = TokenSet.create((IElementType[])new IElementType[]{ProtoTokenTypes.SEMI, ProtoTokenTypes.COMMA});
    private final SpacingBuilder spacingBuilder;

    public PbTextBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, SpacingBuilder spacingBuilder) {
        if (node == null) {
            PbTextBlock.$$$reportNull$$$0(0);
        }
        super(node, wrap, alignment);
        this.spacingBuilder = spacingBuilder;
    }

    protected List<Block> buildChildren() {
        if (this.isLeaf()) {
            return Collections.emptyList();
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (ASTNode child : this.myNode.getChildren(null)) {
            if (PbTextBlock.isEmpty(child)) continue;
            blocks.add((Block)new PbTextBlock(child, this.myWrap, this.myAlignment, this.spacingBuilder));
        }
        return blocks;
    }

    public Indent getIndent() {
        if (PbTextBlock.isEmpty(this.myNode)) {
            return null;
        }
        PsiElement psi = this.myNode.getPsi();
        PsiElement parent = psi.getParent();
        if (parent instanceof ProtoBlockBody) {
            ProtoBlockBody block = (ProtoBlockBody)parent;
            if (psi.equals(block.getStart()) || psi.equals(block.getEnd())) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (psi instanceof ProtoBlockBody) {
            return Indent.getNoneIndent();
        }
        if (parent instanceof PbTextFile) {
            return Indent.getNoneIndent();
        }
        if (UNINDENTED_SYMBOLS.contains(this.myNode.getElementType())) {
            return Indent.getNoneIndent();
        }
        return Indent.getContinuationWithoutFirstIndent();
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            PbTextBlock.$$$reportNull$$$0(1);
        }
        return this.spacingBuilder.getSpacing((Block)this, child1, child2);
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    public Indent getChildIndent() {
        PsiElement psi = this.myNode.getPsi();
        if (psi instanceof PbTextFile) {
            return Indent.getNoneIndent();
        }
        if (psi instanceof ProtoBlockBody) {
            return Indent.getNormalIndent();
        }
        return Indent.getContinuationWithoutFirstIndent();
    }

    private static boolean isEmpty(ASTNode node) {
        return node.getElementType() == TokenType.WHITE_SPACE || node.getTextLength() == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/protobuf/ide/formatter/PbTextBlock";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

