/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sqlite;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.sqlite.BusyHandler;
import org.jetbrains.sqlite.SafeStatementPointer;
import org.jetbrains.sqlite.SqliteDbKt;
import org.jetbrains.sqlite.SqliteException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001:\u0001@B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H$J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H&J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0012H&J \u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH&J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH&J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH&J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J \u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0018H&J\u0012\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH&J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u000bH&J\b\u0010\u001e\u001a\u00020\rH&J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u0006\u0010 \u001a\u00020\u0007J\u001a\u0010!\u001a\u0004\u0018\u00010\u00102\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u000bH&J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u0018\u0010%\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u000bH&J\u0018\u0010&\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u000bH&J\u0018\u0010'\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u000bH&J\u001a\u0010(\u001a\u0004\u0018\u00010\u00182\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u000bH&J\u0018\u0010)\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u000bH&J\n\u0010+\u001a\u0004\u0018\u00010\u0018H&J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u0016\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\rJ\u0018\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000bH&J\u001a\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000b2\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u0010J\u0018\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u000bH$J\u0018\u00105\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u00182\u0006\u00107\u001a\u00020\u000bH&J\u0010\u00109\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020<H&J\u0010\u0010=\u001a\u00020\u00072\u0006\u0010;\u001a\u00020<H&J\u0006\u0010>\u001a\u00020\u0007J\u000e\u0010>\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u000bJ\b\u0010?\u001a\u00020\rH&R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/jetbrains/sqlite/SqliteDb;", "", "()V", "statements", "", "Lorg/jetbrains/sqlite/SafeStatementPointer;", "_close", "", "addStatement", "pointer", "bind_blob", "", "stmt", "", "oneBasedColumnIndex", "v", "", "bind_double", "", "bind_int", "bind_long", "bind_null", "bind_parameter_count", "bind_text", "", "busy_handler", "busyHandler", "Lorg/jetbrains/sqlite/BusyHandler;", "busy_timeout", "ms", "changes", "clear_bindings", "close", "column_blob", "statementPointer", "zeroBasedColumnIndex", "column_count", "column_double", "column_int", "column_long", "column_text", "column_type", "col", "errmsg", "finalize", "safeStatementPointer", "limit", "id", "value", "newException", "Lorg/jetbrains/sqlite/SqliteException;", "errorCode", "sql", "open", "filename", "openFlags", "file", "reset", "set_commit_listener", "enabled", "", "set_update_listener", "throwex", "total_changes", "ProgressObserver", "intellij.platform.sqlite"})
@SourceDebugExtension(value={"SMAP\nSqliteDb.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteDb.kt\norg/jetbrains/sqlite/SqliteDb\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,271:1\n13#2:272\n1#3:273\n*S KotlinDebug\n*F\n+ 1 SqliteDb.kt\norg/jetbrains/sqlite/SqliteDb\n*L\n94#1:272\n*E\n"})
public abstract class SqliteDb {
    @NotNull
    private final Set<SafeStatementPointer> statements;

    public SqliteDb() {
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        this.statements = set;
    }

    public abstract void busy_timeout(int var1);

    public abstract void busy_handler(@Nullable BusyHandler var1);

    @Nullable
    public abstract String errmsg();

    public abstract long changes();

    public abstract long total_changes();

    public abstract int open(@NotNull String var1, int var2);

    public final synchronized void close() {
        Throwable error = null;
        for (SafeStatementPointer element : CollectionsKt.toList((Iterable)this.statements)) {
            try {
                element.close$intellij_platform_sqlite(this);
            }
            catch (Throwable e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                ExceptionsKt.addSuppressed((Throwable)error, (Throwable)e);
            }
        }
        if (error != null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SqliteDb.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(error);
        }
        this._close();
    }

    @NotNull
    public final synchronized SafeStatementPointer addStatement(@NotNull SafeStatementPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        if (!this.statements.add(pointer)) {
            boolean bl = false;
            String string2 = "Already added pointer to statements set";
            throw new IllegalStateException(string2.toString());
        }
        return pointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized int finalize(@NotNull SafeStatementPointer safeStatementPointer, long pointer) {
        Intrinsics.checkNotNullParameter((Object)safeStatementPointer, (String)"safeStatementPointer");
        try {
            int n = this.finalize(pointer);
            return n;
        }
        finally {
            this.statements.remove(safeStatementPointer);
        }
    }

    protected abstract int open(@NotNull byte[] var1, int var2);

    protected abstract void _close();

    public abstract int finalize(long var1);

    public abstract int reset(long var1);

    public abstract int clear_bindings(long var1);

    public abstract int bind_parameter_count(long var1);

    public abstract int column_count(long var1);

    public abstract int column_type(long var1, int var3);

    @Nullable
    public abstract String column_text(long var1, int var3);

    @Nullable
    public abstract byte[] column_blob(long var1, int var3);

    public abstract double column_double(long var1, int var3);

    public abstract long column_long(long var1, int var3);

    public abstract int column_int(long var1, int var3);

    public abstract int bind_null(long var1, int var3);

    public abstract int bind_int(long var1, int var3, int var4);

    public abstract int bind_long(long var1, int var3, long var4);

    public abstract int bind_double(long var1, int var3, double var4);

    public abstract int bind_text(long var1, int var3, @NotNull String var4);

    public abstract int bind_blob(long var1, int var3, @Nullable byte[] var4);

    public abstract int limit(int var1, int var2);

    public abstract void set_commit_listener(boolean var1);

    public abstract void set_update_listener(boolean var1);

    public final void throwex() throws IOException {
        throw new IOException(this.errmsg());
    }

    public final void throwex(int errorCode) {
        String string2 = this.errmsg();
        Intrinsics.checkNotNull((Object)string2);
        throw SqliteDbKt.newException$default(errorCode, string2, null, 4, null);
    }

    @NotNull
    public final SqliteException newException(int errorCode, @Nullable byte[] sql2) {
        String string2 = this.errmsg();
        Intrinsics.checkNotNull((Object)string2);
        return SqliteDbKt.newException(errorCode, string2, sql2);
    }

    public static /* synthetic */ SqliteException newException$default(SqliteDb sqliteDb, int n, byte[] byArray, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newException");
        }
        if ((n2 & 2) != 0) {
            byArray = null;
        }
        return sqliteDb.newException(n, byArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/sqlite/SqliteDb$ProgressObserver;", "", "progress", "", "remaining", "", "pageCount", "intellij.platform.sqlite"})
    public static interface ProgressObserver {
        public void progress(int var1, int var2);
    }
}

