/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryNonCapturingGroupInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnnecessaryNonCapturingGroupInspection.$$$reportNull$$$0(0);
        }
        return new UnnecessaryNonCapturingGroupVisitor(holder);
    }

    private static RegExpAtom getSingleAtom(RegExpPattern pattern2) {
        if (pattern2 == null) {
            return null;
        }
        RegExpBranch[] branches = pattern2.getBranches();
        if (branches.length != 1) {
            return null;
        }
        RegExpAtom[] atoms = branches[0].getAtoms();
        return atoms.length != 1 ? null : atoms[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/UnnecessaryNonCapturingGroupInspection", "buildVisitor"));
    }

    private static class UnnecessaryNonCapturingGroupVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        private UnnecessaryNonCapturingGroupVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpGroup(RegExpGroup group) {
            super.visitRegExpGroup(group);
            if (group.getType() != RegExpGroup.Type.NON_CAPTURING) {
                return;
            }
            PsiElement parent = group.getParent();
            RegExpPattern pattern2 = group.getPattern();
            RegExpAtom atom = UnnecessaryNonCapturingGroupInspection.getSingleAtom(pattern2);
            if (atom != null) {
                if (!(parent instanceof RegExpClosure) || !(atom instanceof RegExpClosure)) {
                    this.registerProblem(group);
                }
            } else if (parent instanceof RegExpBranch) {
                RegExpBranch[] branches = pattern2.getBranches();
                if (branches.length == 1) {
                    if (branches[0].getAtoms().length == 0) {
                        return;
                    }
                    this.registerProblem(group);
                } else {
                    PsiElement grandParent = parent.getParent();
                    if (grandParent instanceof RegExpPattern && UnnecessaryNonCapturingGroupInspection.getSingleAtom((RegExpPattern)grandParent) != null) {
                        this.registerProblem(group);
                    }
                }
            }
        }

        void registerProblem(RegExpGroup group) {
            this.myHolder.registerProblem(group.getFirstChild(), RegExpBundle.message("inspection.warning.unnecessary.non.capturing.group", group.getText()), new LocalQuickFix[]{new UnnecessaryNonCapturingGroupFix()});
        }
    }

    private static class UnnecessaryNonCapturingGroupFix
    extends PsiUpdateModCommandQuickFix {
        private UnnecessaryNonCapturingGroupFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string2 = RegExpBundle.message("inspection.quick.fix.remove.unnecessary.non.capturing.group", new Object[0]);
            if (string2 == null) {
                UnnecessaryNonCapturingGroupFix.$$$reportNull$$$0(0);
            }
            return string2;
        }

        protected void applyFix(@NotNull Project project2, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project2 == null) {
                UnnecessaryNonCapturingGroupFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                UnnecessaryNonCapturingGroupFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessaryNonCapturingGroupFix.$$$reportNull$$$0(3);
            }
            if (!((element = element.getParent()) instanceof RegExpGroup)) {
                return;
            }
            RegExpGroup group = (RegExpGroup)element;
            RegExpReplacementUtil.replaceInContext(group, group.getPattern().getUnescapedText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/UnnecessaryNonCapturingGroupInspection$UnnecessaryNonCapturingGroupFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/UnnecessaryNonCapturingGroupInspection$UnnecessaryNonCapturingGroupFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2, 3 -> new IllegalArgumentException(string2);
            };
        }
    }
}

