/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EmptyAlternationBranchInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            EmptyAlternationBranchInspection.$$$reportNull$$$0(0);
        }
        return new EmptyAlternationBranchVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/EmptyAlternationBranchInspection", "buildVisitor"));
    }

    private static class EmptyAlternationBranchVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        EmptyAlternationBranchVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern2) {
            RegExpBranch[] branches = pattern2.getBranches();
            if (branches.length < 2) {
                return;
            }
            boolean emptyBranchSeen = false;
            for (int i = 0; i < branches.length; ++i) {
                RegExpBranch branch = branches[i];
                if (branch.getAtoms().length > 0) continue;
                if (i == 0) {
                    emptyBranchSeen = true;
                    continue;
                }
                if (!emptyBranchSeen && i == branches.length - 1) continue;
                this.myHolder.registerProblem(branch.getPrevSibling(), RegExpBundle.message("inspection.warning.empty.branch.in.alternation", new Object[0]), new LocalQuickFix[]{new EmptyAlternationBranchFix()});
            }
        }
    }

    private static class EmptyAlternationBranchFix
    extends PsiUpdateModCommandQuickFix {
        private EmptyAlternationBranchFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string2 = RegExpBundle.message("inspection.quick.fix.remove.empty.branch", new Object[0]);
            if (string2 == null) {
                EmptyAlternationBranchFix.$$$reportNull$$$0(0);
            }
            return string2;
        }

        protected void applyFix(@NotNull Project project2, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project2 == null) {
                EmptyAlternationBranchFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                EmptyAlternationBranchFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                EmptyAlternationBranchFix.$$$reportNull$$$0(3);
            }
            if (!(element.getParent() instanceof RegExpPattern)) {
                return;
            }
            element.getNextSibling().delete();
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/EmptyAlternationBranchInspection$EmptyAlternationBranchFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/EmptyAlternationBranchInspection$EmptyAlternationBranchFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2, 3 -> new IllegalArgumentException(string2);
            };
        }
    }
}

