/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AbstractPatternFunction;
import com.thaiopensource.relaxng.impl.AfterPattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataDerivTypeFunction;
import com.thaiopensource.relaxng.impl.EndAttributesFunction;
import com.thaiopensource.relaxng.impl.EndTagDerivFunction;
import com.thaiopensource.relaxng.impl.IgnoreMissingAttributesFunction;
import com.thaiopensource.relaxng.impl.MixedTextDerivFunction;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternBuilder;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.RecoverAfterFunction;
import com.thaiopensource.relaxng.impl.TextOnlyFunction;
import java.util.Hashtable;

public class ValidatorPatternBuilder
extends PatternBuilder {
    private final Hashtable patternMemoMap = new Hashtable();
    private final PatternFunction endAttributesFunction;
    private final PatternFunction ignoreMissingAttributesFunction;
    private final PatternFunction endTagDerivFunction;
    private final PatternFunction mixedTextDerivFunction;
    private final PatternFunction textOnlyFunction;
    private final PatternFunction recoverAfterFunction;
    private final PatternFunction dataDerivTypeFunction;
    private final Hashtable choiceMap = new Hashtable();
    private final PatternFunction removeChoicesFunction = new RemoveChoicesFunction();
    private final PatternFunction noteChoicesFunction = new NoteChoicesFunction();

    public ValidatorPatternBuilder(PatternBuilder patternBuilder) {
        super(patternBuilder);
        this.endAttributesFunction = new EndAttributesFunction(this);
        this.ignoreMissingAttributesFunction = new IgnoreMissingAttributesFunction(this);
        this.endTagDerivFunction = new EndTagDerivFunction(this);
        this.mixedTextDerivFunction = new MixedTextDerivFunction(this);
        this.textOnlyFunction = new TextOnlyFunction(this);
        this.recoverAfterFunction = new RecoverAfterFunction(this);
        this.dataDerivTypeFunction = new DataDerivTypeFunction(this);
    }

    PatternMemo getPatternMemo(Pattern pattern2) {
        PatternMemo patternMemo = (PatternMemo)this.patternMemoMap.get(pattern2);
        if (patternMemo == null) {
            patternMemo = new PatternMemo(pattern2, this);
            this.patternMemoMap.put(pattern2, patternMemo);
        }
        return patternMemo;
    }

    PatternFunction getEndAttributesFunction() {
        return this.endAttributesFunction;
    }

    PatternFunction getIgnoreMissingAttributesFunction() {
        return this.ignoreMissingAttributesFunction;
    }

    PatternFunction getEndTagDerivFunction() {
        return this.endTagDerivFunction;
    }

    PatternFunction getMixedTextDerivFunction() {
        return this.mixedTextDerivFunction;
    }

    PatternFunction getTextOnlyFunction() {
        return this.textOnlyFunction;
    }

    PatternFunction getRecoverAfterFunction() {
        return this.recoverAfterFunction;
    }

    PatternFunction getDataDerivTypeFunction() {
        return this.dataDerivTypeFunction;
    }

    Pattern makeAfter(Pattern pattern2, Pattern pattern3) {
        AfterPattern afterPattern = new AfterPattern(pattern2, pattern3);
        return this.interner.intern(afterPattern);
    }

    Pattern makeChoice(Pattern pattern2, Pattern pattern3) {
        if (pattern2 == pattern3) {
            return pattern2;
        }
        if (pattern2 == this.notAllowed) {
            return pattern3;
        }
        if (pattern3 == this.notAllowed) {
            return pattern2;
        }
        if (!(pattern2 instanceof ChoicePattern)) {
            if (pattern3.containsChoice(pattern2)) {
                return pattern3;
            }
        } else if (!(pattern3 instanceof ChoicePattern)) {
            if (pattern2.containsChoice(pattern3)) {
                return pattern2;
            }
        } else {
            pattern2.apply(this.noteChoicesFunction);
            pattern3 = pattern3.applyForPattern(this.removeChoicesFunction);
            if (this.choiceMap.size() > 0) {
                this.choiceMap.clear();
            }
        }
        if (pattern2 instanceof AfterPattern && pattern3 instanceof AfterPattern) {
            AfterPattern afterPattern = (AfterPattern)pattern2;
            AfterPattern afterPattern2 = (AfterPattern)pattern3;
            if (afterPattern.getOperand1() == afterPattern2.getOperand1()) {
                return this.makeAfter(afterPattern.getOperand1(), this.makeChoice(afterPattern.getOperand2(), afterPattern2.getOperand2()));
            }
            if (afterPattern.getOperand1() == this.notAllowed) {
                return afterPattern2;
            }
            if (afterPattern2.getOperand1() == this.notAllowed) {
                return afterPattern;
            }
            if (afterPattern.getOperand2() == afterPattern2.getOperand2()) {
                return this.makeAfter(this.makeChoice(afterPattern.getOperand1(), afterPattern2.getOperand1()), afterPattern.getOperand2());
            }
        }
        return super.makeChoice(pattern2, pattern3);
    }

    private class RemoveChoicesFunction
    extends AbstractPatternFunction {
        private RemoveChoicesFunction() {
        }

        public Object caseOther(Pattern pattern2) {
            if (ValidatorPatternBuilder.this.choiceMap.get(pattern2) != null) {
                return ValidatorPatternBuilder.this.notAllowed;
            }
            return pattern2;
        }

        public Object caseChoice(ChoicePattern choicePattern) {
            Pattern pattern2 = choicePattern.getOperand1().applyForPattern(this);
            Pattern pattern3 = choicePattern.getOperand2().applyForPattern(this);
            if (pattern2 == choicePattern.getOperand1() && pattern3 == choicePattern.getOperand2()) {
                return choicePattern;
            }
            if (pattern2 == ValidatorPatternBuilder.this.notAllowed) {
                return pattern3;
            }
            if (pattern3 == ValidatorPatternBuilder.this.notAllowed) {
                return pattern2;
            }
            ChoicePattern choicePattern2 = new ChoicePattern(pattern2, pattern3);
            return ValidatorPatternBuilder.this.interner.intern(choicePattern2);
        }
    }

    private class NoteChoicesFunction
    extends AbstractPatternFunction {
        private NoteChoicesFunction() {
        }

        public Object caseOther(Pattern pattern2) {
            ValidatorPatternBuilder.this.choiceMap.put(pattern2, pattern2);
            return null;
        }

        public Object caseChoice(ChoicePattern choicePattern) {
            choicePattern.getOperand1().apply(this);
            choicePattern.getOperand2().apply(this);
            return null;
        }
    }
}

