/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Alphabet;
import com.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import org.xml.sax.SAXException;

abstract class BinaryPattern
extends Pattern {
    final Pattern p1;
    final Pattern p2;

    BinaryPattern(boolean bl, int n, Pattern pattern2, Pattern pattern3) {
        super(bl, Math.max(pattern2.getContentType(), pattern3.getContentType()), n);
        this.p1 = pattern2;
        this.p2 = pattern3;
    }

    void checkRecursion(int n) throws SAXException {
        this.p1.checkRecursion(n);
        this.p2.checkRecursion(n);
    }

    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        this.p1.checkRestrictions(n, duplicateAttributeDetector, alphabet);
        this.p2.checkRestrictions(n, duplicateAttributeDetector, alphabet);
    }

    boolean samePattern(Pattern pattern2) {
        if (this.getClass() != pattern2.getClass()) {
            return false;
        }
        BinaryPattern binaryPattern = (BinaryPattern)pattern2;
        return this.p1 == binaryPattern.p1 && this.p2 == binaryPattern.p2;
    }

    Pattern getOperand1() {
        return this.p1;
    }

    Pattern getOperand2() {
        return this.p2;
    }
}

