/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectValidation
implements JsonSchemaValidation {
    public static final ObjectValidation INSTANCE = new ObjectValidation();

    @Override
    public void validate(@NotNull JsonValueAdapter propValue, @NotNull JsonSchemaObject schema, @Nullable JsonSchemaType schemaType, @NotNull JsonValidationHost consumer, @NotNull JsonComplianceCheckerOptions options) {
        if (propValue == null) {
            ObjectValidation.$$$reportNull$$$0(0);
        }
        if (schema == null) {
            ObjectValidation.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            ObjectValidation.$$$reportNull$$$0(2);
        }
        if (options == null) {
            ObjectValidation.$$$reportNull$$$0(3);
        }
        ObjectValidation.checkObject(propValue, schema, consumer, options);
    }

    private static void checkObject(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema, JsonValidationHost consumer, JsonComplianceCheckerOptions options) {
        JsonObjectValueAdapter object;
        if (value == null) {
            ObjectValidation.$$$reportNull$$$0(4);
        }
        if (schema == null) {
            ObjectValidation.$$$reportNull$$$0(5);
        }
        if ((object = value.getAsObject()) == null) {
            return;
        }
        List<JsonPropertyAdapter> propertyList = object.getPropertyList();
        HashSet<String> set = new HashSet<String>();
        for (JsonPropertyAdapter property : propertyList) {
            JsonPointerPosition step2;
            Pair<ThreeState, JsonSchemaObject> pair;
            JsonValidationHost checker;
            JsonValueAdapter nameValueAdapter;
            String name2 = StringUtil.notNullize((String)property.getName());
            JsonSchemaObject jsonSchemaObject = schema.getPropertyNamesSchema();
            if (jsonSchemaObject != null && (nameValueAdapter = property.getNameValueAdapter()) != null && (checker = consumer.checkByMatchResult(nameValueAdapter, consumer.resolve(jsonSchemaObject, nameValueAdapter), options)) != null) {
                consumer.addErrorsFrom(checker);
            }
            if (ThreeState.NO.equals((pair = JsonSchemaVariantsTreeBuilder.doSingleStep(step2 = JsonPointerPosition.createSingleProperty(name2), schema)).getFirst()) && !set.contains(name2)) {
                consumer.error(JsonBundle.message("json.schema.annotation.not.allowed.property", name2), property.getDelegate(), JsonValidationError.FixableIssueKind.ProhibitedProperty, new JsonValidationError.ProhibitedPropertyIssueData(name2), JsonErrorPriority.LOW_PRIORITY);
            } else if (ThreeState.UNSURE.equals(pair.getFirst()) && ((JsonSchemaObject)pair.second).getConstantSchema() == null) {
                for (JsonValueAdapter propertyValue : property.getValues()) {
                    consumer.checkObjectBySchemaRecordErrors((JsonSchemaObject)pair.getSecond(), propertyValue);
                }
            }
            set.add(name2);
        }
        ObjectValidation.reportMissingOptionalProperties(value, schema, consumer, options);
        if (object.shouldCheckIntegralRequirements() || options.isForceStrict()) {
            Map<String, List<String>> dependencies;
            Set<String> required2 = schema.getRequired();
            if (required2 != null) {
                LinkedHashSet<String> requiredNames = new LinkedHashSet<String>(required2);
                requiredNames.removeAll(set);
                if (!requiredNames.isEmpty()) {
                    JsonValidationError.MissingMultiplePropsIssueData data2 = ObjectValidation.createMissingPropertiesData(schema, requiredNames, consumer, value);
                    consumer.error(JsonBundle.message("schema.validation.missing.required.property.or.properties", data2.getMessage(false)), value.getDelegate(), JsonValidationError.FixableIssueKind.MissingProperty, data2, JsonErrorPriority.MISSING_PROPS);
                }
            }
            if (schema.getMinProperties() != null && propertyList.size() < schema.getMinProperties()) {
                consumer.error(JsonBundle.message("schema.validation.number.of.props.less.than", schema.getMinProperties()), value.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
            }
            if (schema.getMaxProperties() != null && propertyList.size() > schema.getMaxProperties()) {
                consumer.error(JsonBundle.message("schema.validation.number.of.props.greater.than", schema.getMaxProperties()), value.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
            }
            if ((dependencies = schema.getPropertyDependencies()) != null) {
                for (Map.Entry entry2 : dependencies.entrySet()) {
                    if (!set.contains(entry2.getKey())) continue;
                    List list2 = (List)entry2.getValue();
                    HashSet<String> deps = new HashSet<String>(list2);
                    deps.removeAll(set);
                    if (deps.isEmpty()) continue;
                    JsonValidationError.MissingMultiplePropsIssueData data3 = ObjectValidation.createMissingPropertiesData(schema, deps, consumer, value);
                    consumer.error(JsonBundle.message("schema.validation.violated.dependency", data3.getMessage(false), entry2.getKey()), value.getDelegate(), JsonValidationError.FixableIssueKind.MissingProperty, data3, JsonErrorPriority.MISSING_PROPS);
                }
            }
            Iterator<String> schemaDependencies = schema.getSchemaDependencyNames();
            StreamEx.of(schemaDependencies).forEach(name -> {
                JsonSchemaObject dependency = schema.getSchemaDependencyByName((String)name);
                if (set.contains(name) && dependency != null) {
                    consumer.checkObjectBySchemaRecordErrors(dependency, value);
                }
            });
            ObjectValidation.reportUnevaluatedPropertiesSchemaViolation(consumer, schema, object);
        }
    }

    private static void reportUnevaluatedPropertiesSchemaViolation(@NotNull JsonValidationHost consumer, @NotNull JsonSchemaObject schemaNode, @NotNull JsonObjectValueAdapter inspectedObject) {
        JsonSchemaObject unevaluatedPropertiesSchema;
        if (consumer == null) {
            ObjectValidation.$$$reportNull$$$0(6);
        }
        if (schemaNode == null) {
            ObjectValidation.$$$reportNull$$$0(7);
        }
        if (inspectedObject == null) {
            ObjectValidation.$$$reportNull$$$0(8);
        }
        if ((unevaluatedPropertiesSchema = schemaNode.getUnevaluatedPropertiesSchema()) == null) {
            return;
        }
        Boolean constantSchemaValue = unevaluatedPropertiesSchema.getConstantSchema();
        if (Boolean.TRUE.equals(constantSchemaValue)) {
            return;
        }
        for (JsonPropertyAdapter childPropertyAdapter : inspectedObject.getPropertyList()) {
            JsonValueAdapter childPropertyNameAdapter;
            if (ObjectValidation.isCoveredByAdjacentSchemas(consumer, childPropertyAdapter, schemaNode) || (childPropertyNameAdapter = childPropertyAdapter.getNameValueAdapter()) == null) continue;
            consumer.checkObjectBySchemaRecordErrors(unevaluatedPropertiesSchema, childPropertyNameAdapter);
        }
    }

    private static boolean isCoveredByAdjacentSchemas(@NotNull JsonValidationHost validationHost, @NotNull JsonPropertyAdapter propertyAdapter, @NotNull JsonSchemaObject schemaNode) {
        String instancePropertyName;
        if (validationHost == null) {
            ObjectValidation.$$$reportNull$$$0(9);
        }
        if (propertyAdapter == null) {
            ObjectValidation.$$$reportNull$$$0(10);
        }
        if (schemaNode == null) {
            ObjectValidation.$$$reportNull$$$0(11);
        }
        if ((instancePropertyName = propertyAdapter.getName()) != null && schemaNode.getPropertyByName(instancePropertyName) != null) {
            return true;
        }
        if (instancePropertyName != null && schemaNode.getMatchingPatternPropertySchema(instancePropertyName) != null) {
            return true;
        }
        if (Boolean.FALSE.equals(schemaNode.getAdditionalPropertiesAllowed())) {
            return true;
        }
        JsonSchemaObject additionalPropertiesSchema = schemaNode.getAdditionalPropertiesSchema();
        if (additionalPropertiesSchema != null && Boolean.TRUE.equals(additionalPropertiesSchema.getConstantSchema())) {
            return true;
        }
        JsonValueAdapter propertyNameAdapter = propertyAdapter.getNameValueAdapter();
        return propertyNameAdapter != null && validationHost.hasRecordedErrorsFor(propertyNameAdapter);
    }

    public static JsonValidationError.MissingMultiplePropsIssueData createMissingPropertiesData(@NotNull JsonSchemaObject schema, Set<String> requiredNames, JsonValidationHost consumer, @NotNull JsonValueAdapter inspectedElementAdapter) {
        if (schema == null) {
            ObjectValidation.$$$reportNull$$$0(12);
        }
        if (inspectedElementAdapter == null) {
            ObjectValidation.$$$reportNull$$$0(13);
        }
        ArrayList<JsonValidationError.MissingPropertyIssueData> allProps = new ArrayList<JsonValidationError.MissingPropertyIssueData>();
        for (String req : requiredNames) {
            Object defaultValue2;
            JsonSchemaObject propertySchema = ObjectValidation.resolvePropertySchema(schema, req);
            Object object = defaultValue2 = propertySchema == null ? null : propertySchema.getDefault();
            if (defaultValue2 == null) {
                Map<String, Object> example;
                defaultValue2 = Registry.is((String)"json.schema.object.v2") ? schema.getExampleByName(req) : ((example = schema.getExample()) == null ? null : example.get(req));
            }
            Ref enumCount = Ref.create((Object)0);
            JsonSchemaType type2 = null;
            if (propertySchema != null) {
                MatchResult result2 = null;
                Object valueFromEnum = ObjectValidation.getDefaultValueFromEnum(propertySchema, (Ref<Integer>)enumCount);
                if (valueFromEnum != null) {
                    defaultValue2 = valueFromEnum;
                } else {
                    result2 = consumer.resolve(propertySchema, inspectedElementAdapter);
                    if (result2.mySchemas.size() == 1 && (valueFromEnum = ObjectValidation.getDefaultValueFromEnum(result2.mySchemas.get(0), (Ref<Integer>)enumCount)) != null) {
                        defaultValue2 = valueFromEnum;
                    }
                }
                type2 = propertySchema.getType();
                if (type2 == null) {
                    if (result2 == null) {
                        result2 = consumer.resolve(propertySchema, inspectedElementAdapter);
                    }
                    if (result2.mySchemas.size() == 1) {
                        type2 = result2.mySchemas.get(0).getType();
                    }
                }
            }
            allProps.add(new JsonValidationError.MissingPropertyIssueData(req, type2, defaultValue2, (Integer)enumCount.get()));
        }
        return new JsonValidationError.MissingMultiplePropsIssueData(allProps);
    }

    private static JsonSchemaObject resolvePropertySchema(@NotNull JsonSchemaObject schema, String req) {
        JsonSchemaObject propOrNull;
        if (schema == null) {
            ObjectValidation.$$$reportNull$$$0(14);
        }
        if ((propOrNull = schema.getPropertyByName(req)) != null) {
            return propOrNull;
        }
        JsonSchemaObject propertySchema = schema.getMatchingPatternPropertySchema(req);
        if (propertySchema != null) {
            return propertySchema;
        }
        JsonSchemaObject additionalPropertiesSchema = schema.getAdditionalPropertiesSchema();
        if (additionalPropertiesSchema != null) {
            return additionalPropertiesSchema;
        }
        JsonSchemaObject unevaluatedPropertiesSchema = schema.getUnevaluatedPropertiesSchema();
        if (unevaluatedPropertiesSchema != null && unevaluatedPropertiesSchema.getConstantSchema() == null) {
            return unevaluatedPropertiesSchema;
        }
        return null;
    }

    @Nullable
    private static Object getDefaultValueFromEnum(@NotNull JsonSchemaObject propertySchema, @NotNull Ref<Integer> enumCount) {
        List<Object> enumValues;
        if (propertySchema == null) {
            ObjectValidation.$$$reportNull$$$0(15);
        }
        if (enumCount == null) {
            ObjectValidation.$$$reportNull$$$0(16);
        }
        if ((enumValues = propertySchema.getEnum()) != null) {
            enumCount.set((Object)enumValues.size());
            if (!enumValues.isEmpty()) {
                Object defaultObject = enumValues.get(0);
                return defaultObject instanceof String ? StringUtil.unquoteString((String)((String)defaultObject)) : defaultObject;
            }
        }
        return null;
    }

    private static void reportMissingOptionalProperties(JsonValueAdapter inspectedValue, JsonSchemaObject schema, JsonValidationHost validationHost, JsonComplianceCheckerOptions options) {
        JsonObjectValueAdapter objectValueAdapter = inspectedValue.getAsObject();
        if (!options.isReportMissingOptionalProperties() || objectValueAdapter == null) {
            return;
        }
        List existingProperties = ContainerUtil.map(objectValueAdapter.getPropertyList(), JsonPropertyAdapter::getName);
        Iterable iter = () -> schema.getPropertyNames();
        Set<String> missingProperties = StreamSupport.stream(iter.spliterator(), false).filter(it -> !existingProperties.contains(it)).collect(Collectors.toSet());
        JsonValidationError.MissingMultiplePropsIssueData missingPropertiesData = ObjectValidation.createMissingPropertiesData(schema, missingProperties, validationHost, objectValueAdapter);
        validationHost.error(JsonBundle.message("schema.validation.missing.not.required.property.or.properties", missingPropertiesData.getMessage(false)), inspectedValue.getDelegate(), JsonValidationError.FixableIssueKind.MissingOptionalProperty, missingPropertiesData, JsonErrorPriority.MISSING_PROPS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propValue";
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectedObject";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validationHost";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyAdapter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectedElementAdapter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySchema";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumCount";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/validations/ObjectValidation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkObject";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "reportUnevaluatedPropertiesSchemaViolation";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isCoveredByAdjacentSchemas";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createMissingPropertiesData";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "resolvePropertySchema";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultValueFromEnum";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

