/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.light.versions.v202012;

import com.intellij.json.JsonBundle;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.validations.ArrayValidation;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J;\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u000b\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0002J&\u0010\u0018\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/jsonSchema/impl/light/versions/v202012/Array2020Validator;", "Lcom/jetbrains/jsonSchema/impl/validations/ArrayValidation;", "()V", "validate", "", "valueAdapter", "Lcom/jetbrains/jsonSchema/extension/adapters/JsonValueAdapter;", "schema", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "schemaType", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaType;", "consumer", "Lcom/jetbrains/jsonSchema/extension/JsonValidationHost;", "options", "Lcom/jetbrains/jsonSchema/impl/JsonComplianceCheckerOptions;", "validateAgainstNonPositionalSchema", "nonPositionalItemsSchema", "instanceArrayItems", "", "firstRegularItemIndex", "", "errorMessage", "", "Lorg/jetbrains/annotations/Nls;", "validateIndividualItems", "intellij.json"})
public final class Array2020Validator
extends ArrayValidation {
    @NotNull
    public static final Array2020Validator INSTANCE = new Array2020Validator();

    private Array2020Validator() {
    }

    @Override
    public void validate(@NotNull JsonValueAdapter valueAdapter, @NotNull JsonSchemaObject schema, @Nullable JsonSchemaType schemaType, @NotNull JsonValidationHost consumer, @NotNull JsonComplianceCheckerOptions options) {
        Intrinsics.checkNotNullParameter((Object)valueAdapter, (String)"valueAdapter");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Object object = valueAdapter.getAsArray();
        if (object == null || (object = object.getElements()) == null) {
            return;
        }
        Object arrayItems = object;
        ArrayValidation.validateUniqueItems(valueAdapter, (List<JsonValueAdapter>)arrayItems, schema, consumer);
        ArrayValidation.validateAgainstContainsSchema(valueAdapter, (List<JsonValueAdapter>)arrayItems, schema, consumer, options);
        this.validateIndividualItems((List<? extends JsonValueAdapter>)arrayItems, schema, consumer);
        ArrayValidation.validateArrayLength(valueAdapter, (List<JsonValueAdapter>)arrayItems, schema, consumer);
        ArrayValidation.validateArrayLengthHeuristically(valueAdapter, (List<JsonValueAdapter>)arrayItems, schema, consumer);
    }

    private final void validateIndividualItems(List<? extends JsonValueAdapter> instanceArrayItems, JsonSchemaObject schema, JsonValidationHost consumer) {
        JsonSchemaObject additionalItemsSchema;
        List<? extends JsonSchemaObject> additionalItemsSchemaList = schema.getItemsSchemaList();
        Collection collection = additionalItemsSchemaList;
        int firstRegularItemIndex = collection == null || collection.isEmpty() ? 0 : additionalItemsSchemaList.size();
        for (int index = 0; index < firstRegularItemIndex; ++index) {
            JsonValueAdapter inspectedInstanceItem;
            JsonSchemaObject positionalSchema;
            List<? extends JsonSchemaObject> list2 = additionalItemsSchemaList;
            if ((list2 != null ? list2.get(index) : null) == null) break;
            positionalSchema = positionalSchema;
            if ((JsonValueAdapter)CollectionsKt.getOrNull(instanceArrayItems, (int)index) == null) break;
            consumer.checkObjectBySchemaRecordErrors(positionalSchema, inspectedInstanceItem);
        }
        if ((additionalItemsSchema = schema.getAdditionalItemsSchema()) != null) {
            String string2 = JsonBundle.message("schema.validation.array.no.extra", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.validateAgainstNonPositionalSchema(additionalItemsSchema, instanceArrayItems, firstRegularItemIndex, consumer, string2);
            return;
        }
        JsonSchemaObject unevaluatedItemsSchema = schema.getUnevaluatedItemsSchema();
        if (unevaluatedItemsSchema != null) {
            String string3 = JsonBundle.message("schema.validation.array.no.unevaluated", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            this.validateAgainstNonPositionalSchema(unevaluatedItemsSchema, instanceArrayItems, firstRegularItemIndex, consumer, string3);
        }
    }

    private final void validateAgainstNonPositionalSchema(JsonSchemaObject nonPositionalItemsSchema, List<? extends JsonValueAdapter> instanceArrayItems, int firstRegularItemIndex, JsonValidationHost consumer, String errorMessage) {
        if (Intrinsics.areEqual((Object)nonPositionalItemsSchema.getConstantSchema(), (Object)true)) {
            return;
        }
        if (Intrinsics.areEqual((Object)nonPositionalItemsSchema.getConstantSchema(), (Object)false) && CollectionsKt.getOrNull(instanceArrayItems, (int)firstRegularItemIndex) != null) {
            consumer.error(errorMessage, instanceArrayItems.get(firstRegularItemIndex).getDelegate(), JsonErrorPriority.LOW_PRIORITY);
            return;
        }
        int n = instanceArrayItems.size();
        for (int index = firstRegularItemIndex; index < n && (JsonValueAdapter)CollectionsKt.getOrNull(instanceArrayItems, (int)index) != null; ++index) {
            JsonValueAdapter instanceArrayItem;
            consumer.checkObjectBySchemaRecordErrors(nonPositionalItemsSchema, instanceArrayItem);
        }
    }
}

