/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.presentation;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.structures.TextFragment;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreviewPanel
extends JPanel {
    private final Project myProject;
    private final DiffRequestPanel myDiffPanel;
    private TextClone myTextClone;

    public PreviewPanel(@NotNull Project project2, @NotNull Disposable parent) {
        if (project2 == null) {
            PreviewPanel.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            PreviewPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myProject = project2;
        this.myDiffPanel = DiffManager.getInstance().createRequestPanel(project2, parent, null);
        this.myDiffPanel.putContextHints(DiffUserDataKeys.PLACE, (Object)"DuplicateInspectionPresentation");
        this.myDiffPanel.putContextHints(DiffUserDataKeys.FORCE_READ_ONLY, (Object)true);
        this.add((Component)this.myDiffPanel.getComponent(), "Center");
    }

    public void setTextClone(TextClone textClone) {
        this.myTextClone = textClone;
    }

    public void selectDuplicate(@NotNull TextFragment duplicate) {
        if (duplicate == null) {
            PreviewPanel.$$$reportNull$$$0(2);
        }
        SimpleDiffRequest request = this.createDiffRequest(this.myTextClone.getMain(), duplicate);
        this.myDiffPanel.setRequest((DiffRequest)request);
    }

    @Nullable
    private SimpleDiffRequest createDiffRequest(@NotNull TextFragment main2, @NotNull TextFragment duplicate) {
        if (main2 == null) {
            PreviewPanel.$$$reportNull$$$0(3);
        }
        if (duplicate == null) {
            PreviewPanel.$$$reportNull$$$0(4);
        }
        DocumentContent mainContent = PreviewPanel.createContent(this.myProject, main2);
        DocumentContent duplicateContent = PreviewPanel.createContent(this.myProject, duplicate);
        if (mainContent == null || duplicateContent == null) {
            return null;
        }
        return new SimpleDiffRequest(null, (DiffContent)mainContent, (DiffContent)duplicateContent, PreviewPanel.getFragmentTitle(main2), PreviewPanel.getFragmentTitle(duplicate));
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    @NlsSafe
    static String getFragmentTitle(@Nullable TextFragment fragment) {
        if (fragment == null) {
            return null;
        }
        IntRange lines = fragment.getLines();
        return fragment.getFile().getPresentableName() + " " + lines.getStart() + "-" + lines.getEndInclusive();
    }

    @Nullable
    public static DocumentContent createContent(@NotNull Project project2, @NotNull TextFragment fragment) {
        Document document2;
        PsiFile file;
        if (project2 == null) {
            PreviewPanel.$$$reportNull$$$0(5);
        }
        if (fragment == null) {
            PreviewPanel.$$$reportNull$$$0(6);
        }
        if ((file = PsiManager.getInstance((Project)project2).findFile(fragment.getFile())) != null && (document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(file)) != null) {
            TextRange range = PreviewPanel.extendRangeToWholeLines(document2, fragment.getRange());
            return DiffContentFactory.getInstance().createFragment(project2, document2, range);
        }
        return null;
    }

    @NotNull
    private static TextRange extendRangeToWholeLines(@NotNull Document document2, @NotNull TextRange range) {
        if (document2 == null) {
            PreviewPanel.$$$reportNull$$$0(7);
        }
        if (range == null) {
            PreviewPanel.$$$reportNull$$$0(8);
        }
        int startOffset = document2.getLineStartOffset(document2.getLineNumber(range.getStartOffset()));
        int endOffset = document2.getLineEndOffset(document2.getLineNumber(range.getEndOffset()));
        return new TextRange(startOffset, endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "main";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/clones/presentation/PreviewPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "selectDuplicate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createDiffRequest";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createContent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "extendRangeToWholeLines";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

