/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.presentation;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.clones.DuplicateProblemDescriptor;
import com.jetbrains.clones.presentation.PreviewPanel;
import com.jetbrains.clones.structures.TextFragment;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ActionsPanel
extends JPanel {
    private TextFragment mySelectedFragment;

    ActionsPanel(@NotNull DuplicateProblemDescriptor descriptor, @NotNull PreviewPanel previewPanel) {
        if (descriptor == null) {
            ActionsPanel.$$$reportNull$$$0(0);
        }
        if (previewPanel == null) {
            ActionsPanel.$$$reportNull$$$0(1);
        }
        @NlsSafe List<TextFragment> duplicates = descriptor.getTextClone().getDuplicates();
        if (!duplicates.isEmpty()) {
            this.mySelectedFragment = duplicates.get(0);
        }
        AnAction action = this.createAction(previewPanel, duplicates);
        ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("DuplicateInspectionPresentation", (ActionGroup)new DefaultActionGroup(new AnAction[]{action}), true);
        this.setLayout(new GridBagLayout());
        this.add((Component)toolbar2.getComponent(), new GridBagConstraints());
    }

    @NotNull
    private AnAction createAction(final @NotNull PreviewPanel previewPanel, final List<TextFragment> duplicates) {
        if (previewPanel == null) {
            ActionsPanel.$$$reportNull$$$0(2);
        }
        return new ComboBoxAction(){

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button, @NotNull DataContext context) {
                if (button == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                DefaultActionGroup group = new DefaultActionGroup();
                for (final TextFragment duplicate : duplicates) {
                    group.add(new AnAction(PreviewPanel.getFragmentTitle(duplicate), null, this.getIcon(duplicate)){

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            ActionsPanel.this.selectDuplicate(previewPanel, duplicate);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/clones/presentation/ActionsPanel$1$1", "actionPerformed"));
                        }
                    });
                }
                DefaultActionGroup defaultActionGroup = group;
                if (defaultActionGroup == null) {
                    1.$$$reportNull$$$0(2);
                }
                return defaultActionGroup;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(3);
                }
                Presentation presentation = e.getPresentation();
                presentation.setText(PreviewPanel.getFragmentTitle(ActionsPanel.this.mySelectedFragment), false);
                presentation.setIcon(this.getIcon(ActionsPanel.this.mySelectedFragment));
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(4);
                }
                return actionUpdateThread;
            }

            @Contract(value="null -> null; !null -> !null")
            @Nullable
            private Icon getIcon(@Nullable TextFragment fragment) {
                return fragment != null ? fragment.getFile().getFileType().getIcon() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "button";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/clones/presentation/ActionsPanel$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/clones/presentation/ActionsPanel$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPopupActionGroup";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createPopupActionGroup";
                        break;
                    }
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2, 4 -> new IllegalStateException(string2);
                };
            }
        };
    }

    public void selectDuplicate(@NotNull PreviewPanel previewPanel, @NotNull TextFragment duplicate) {
        if (previewPanel == null) {
            ActionsPanel.$$$reportNull$$$0(3);
        }
        if (duplicate == null) {
            ActionsPanel.$$$reportNull$$$0(4);
        }
        this.mySelectedFragment = duplicate;
        previewPanel.selectDuplicate(duplicate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicate";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/clones/presentation/ActionsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "selectDuplicate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

