/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.core.postprocessing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.clones.configuration.RestrictedDuplicateScope;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.structures.TextFragment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/clones/core/postprocessing/DuplicatesScopeFilter;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "findModule", "Lcom/intellij/openapi/module/Module;", "fragment", "Lcom/jetbrains/clones/structures/TextFragment;", "isTestSource", "", "textFragment", "restrict", "Lcom/jetbrains/clones/structures/TextClone;", "clone", "scope", "Lcom/jetbrains/clones/configuration/RestrictedDuplicateScope;", "restrictToDependedModules", "restrictToSameFile", "restrictToSameModule", "intellij.platform.duplicatesDetector"})
@SourceDebugExtension(value={"SMAP\nDuplicatesScopeFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicatesScopeFilter.kt\ncom/jetbrains/clones/core/postprocessing/DuplicatesScopeFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n766#2:56\n857#2,2:57\n766#2:59\n857#2,2:60\n766#2:62\n857#2,2:63\n*S KotlinDebug\n*F\n+ 1 DuplicatesScopeFilter.kt\ncom/jetbrains/clones/core/postprocessing/DuplicatesScopeFilter\n*L\n39#1:56\n39#1:57,2\n45#1:59\n45#1:60,2\n51#1:62\n51#1:63,2\n*E\n"})
public final class DuplicatesScopeFilter {
    @NotNull
    private final Project project;

    public DuplicatesScopeFilter(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final Module findModule(TextFragment fragment) {
        return ModuleUtil.findModuleForFile((VirtualFile)fragment.getFile(), (Project)this.project);
    }

    private final boolean isTestSource(TextFragment textFragment) {
        return ProjectFileIndex.getInstance((Project)this.project).isInTestSourceContent(textFragment.getFile());
    }

    @Nullable
    public final TextClone restrict(@NotNull TextClone clone, @NotNull RestrictedDuplicateScope scope) {
        Intrinsics.checkNotNullParameter((Object)clone, (String)"clone");
        Intrinsics.checkNotNullParameter((Object)((Object)scope), (String)"scope");
        return switch (WhenMappings.$EnumSwitchMapping$0[scope.ordinal()]) {
            case 1 -> this.restrictToDependedModules(clone);
            case 2 -> this.restrictToSameModule(clone);
            case 3 -> this.restrictToSameFile(clone);
            case 4 -> clone;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final TextClone restrictToDependedModules(TextClone clone) {
        void $this$filterTo$iv$iv;
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(this.project);
        Module module = this.findModule(clone.getMain());
        if (module == null) {
            return null;
        }
        Module mainModule = module;
        Iterable $this$filter$iv = clone.getDuplicates();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextFragment it = (TextFragment)element$iv$iv;
            boolean bl = false;
            if (!DuplicatesScopeFilter.restrictToDependedModules$areModulesDepended(moduleManager, mainModule, this.findModule(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List duplicates = (List)destination$iv$iv;
        return !((Collection)duplicates).isEmpty() ? new TextClone(clone.getMain(), duplicates) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final TextClone restrictToSameModule(TextClone clone) {
        void $this$filterTo$iv$iv;
        Module module = this.findModule(clone.getMain());
        if (module == null) {
            return null;
        }
        Module mainModule = module;
        Iterable $this$filter$iv = clone.getDuplicates();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextFragment it = (TextFragment)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)mainModule, (Object)this.findModule(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List duplicates = (List)destination$iv$iv;
        return !((Collection)duplicates).isEmpty() ? new TextClone(clone.getMain(), duplicates) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final TextClone restrictToSameFile(TextClone clone) {
        void $this$filterTo$iv$iv;
        TextFragment main2 = clone.getMain();
        Iterable $this$filter$iv = clone.getDuplicates();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextFragment it = (TextFragment)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFile(), (Object)main2.getFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List duplicates = (List)destination$iv$iv;
        return !((Collection)duplicates).isEmpty() ? new TextClone(main2, duplicates) : null;
    }

    private static final boolean restrictToDependedModules$areModulesDepended(ModuleManager moduleManager, Module first, Module second) {
        if (first == null || second == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)first, (Object)second) || moduleManager.isModuleDependent(first, second) || moduleManager.isModuleDependent(second, first);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RestrictedDuplicateScope.values().length];
            try {
                nArray[RestrictedDuplicateScope.DEPENDED_MODULES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestrictedDuplicateScope.SAME_MODULE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestrictedDuplicateScope.SAME_FILE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestrictedDuplicateScope.EVERYWHERE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

