/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones;

import com.intellij.CommonBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PlatformUtils;
import com.jetbrains.clones.DuplicateInspection;
import com.jetbrains.clones.DuplicateInspectionUtilKt;
import com.jetbrains.clones.DuplicateProblemDescriptor;
import com.jetbrains.clones.configuration.DuplicateInspectionConfiguration;
import com.jetbrains.clones.configuration.DuplicateInspectionState;
import com.jetbrains.clones.configuration.DuplicatesBundle;
import com.jetbrains.clones.configuration.GlobalSettings;
import com.jetbrains.clones.configuration.RestrictedDuplicateScope;
import com.jetbrains.clones.core.DuplicateAnalyzer;
import com.jetbrains.clones.core.postprocessing.DuplicatesScopeFilter;
import com.jetbrains.clones.index.HashIndexFileFilterKt;
import com.jetbrains.clones.languagescope.DuplicateScope;
import com.jetbrains.clones.languagescope.DuplicateScopeExtension;
import com.jetbrains.clones.structures.TextClone;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0017J*\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006)"}, d2={"Lcom/jetbrains/clones/DuplicateInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "fullHighlighting", "", "getFullHighlighting", "()Z", "setFullHighlighting", "(Z)V", "state", "Lcom/jetbrains/clones/configuration/DuplicateInspectionState;", "getState", "()Lcom/jetbrains/clones/configuration/DuplicateInspectionState;", "setState", "(Lcom/jetbrains/clones/configuration/DuplicateInspectionState;)V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "createProblemDescriptor", "manger", "textClone", "Lcom/jetbrains/clones/structures/TextClone;", "scope", "Lcom/jetbrains/clones/languagescope/DuplicateScope;", "getOptionController", "Lcom/intellij/codeInspection/options/OptionController;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "getStaticDescription", "", "readSettings", "", "node", "Lorg/jdom/Element;", "writeSettings", "intellij.platform.duplicatesDetector"})
@SourceDebugExtension(value={"SMAP\nDuplicateInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicateInspection.kt\ncom/jetbrains/clones/DuplicateInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1549#2:133\n1620#2,3:134\n1819#2,8:139\n1603#2,9:152\n1855#2:161\n1856#2:163\n1612#2:164\n1603#2,9:165\n1855#2:174\n1856#2:176\n1612#2:177\n37#3,2:137\n37#3,2:178\n37#3,2:180\n26#4:147\n26#4:148\n26#4:149\n26#4:150\n26#4:151\n26#4:182\n1#5:162\n1#5:175\n*S KotlinDebug\n*F\n+ 1 DuplicateInspection.kt\ncom/jetbrains/clones/DuplicateInspection\n*L\n63#1:133\n63#1:134,3\n77#1:139,8\n94#1:152,9\n94#1:161\n94#1:163\n94#1:164\n95#1:165,9\n95#1:174\n95#1:176\n95#1:177\n69#1:137,2\n97#1:178,2\n107#1:180,2\n87#1:147\n88#1:148\n89#1:149\n90#1:150\n91#1:151\n107#1:182\n94#1:162\n95#1:175\n*E\n"})
public final class DuplicateInspection
extends LocalInspectionTool {
    @NotNull
    private DuplicateInspectionState state = new DuplicateInspectionState();
    private boolean fullHighlighting = ApplicationManager.getApplication().isUnitTestMode();

    @NotNull
    public final DuplicateInspectionState getState() {
        return this.state;
    }

    public final void setState(@NotNull DuplicateInspectionState duplicateInspectionState) {
        Intrinsics.checkNotNullParameter((Object)duplicateInspectionState, (String)"<set-?>");
        this.state = duplicateInspectionState;
    }

    public final boolean getFullHighlighting() {
        return this.fullHighlighting;
    }

    public final void setFullHighlighting(boolean bl) {
        this.fullHighlighting = bl;
    }

    public void readSettings(@NotNull Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.state.read(node);
    }

    public void writeSettings(@NotNull Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.state.write(node);
    }

    @NotNull
    public String getStaticDescription() {
        String settingsPath = CommonBundle.settingsActionPath();
        int isNonIntelliJ = !PlatformUtils.isIntelliJ() ? 1 : 0;
        int isHeadless = ApplicationManager.getApplication().isHeadlessEnvironment() ? 1 : 0;
        Object[] objectArray = new Object[3];
        objectArray[0] = isNonIntelliJ;
        objectArray[1] = isHeadless;
        Intrinsics.checkNotNull((Object)settingsPath);
        objectArray[2] = settingsPath;
        return DuplicatesBundle.INSTANCE.message("duplicates.inspection.description", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public OptPane getOptionsPane() {
        void $this$mapTo$iv$iv;
        List scopes2 = SequencesKt.toList((Sequence)SequencesKt.filter(DuplicateScopeExtension.Companion.findAllUniqueDuplicateScopes(), (Function1)getOptionsPane.scopes.1.INSTANCE));
        OptCheckbox[] $this$map$iv = (OptCheckbox[])scopes2;
        boolean $i$f$map = false;
        OptCheckbox[] optCheckboxArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void scope;
            DuplicateScope duplicateScope = (DuplicateScope)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(scope.createOptions().asCheckbox("enabled", scope.getLanguageName()).prefix(scope.getClass().getCanonicalName()));
        }
        List languageOptions = (List)destination$iv$iv;
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[2];
        optRegularComponentArray[0] = OptPane.dropdown((String)"restrictedDuplicateScope", (String)DuplicatesBundle.INSTANCE.getMessage("duplicate.settings.inspection.scope", new Object[0]), (Collection)RestrictedDuplicateScope.Companion.getOptions(), arg_0 -> DuplicateInspection.getOptionsPane$lambda$1((Function1)getOptionsPane.1.INSTANCE, arg_0), arg_0 -> DuplicateInspection.getOptionsPane$lambda$2(getOptionsPane.2.INSTANCE, arg_0));
        Collection $this$toTypedArray$iv = languageOptions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        optCheckboxArray = thisCollection$iv.toArray(new OptCheckbox[0]);
        optRegularComponentArray[1] = OptPane.checkboxPanel((OptCheckbox[])Arrays.copyOf(optCheckboxArray, optCheckboxArray.length));
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public OptionController getOptionController() {
        List scopes2;
        OptionController optionController = OptionController.empty().onValue("restrictedDuplicateScope", (KMutableProperty0)new MutablePropertyReference0Impl(this.state.getGlobalSettings()){

            @Nullable
            public Object get() {
                return ((GlobalSettings)this.receiver).getRestrictedDuplicateScope();
            }

            public void set(@Nullable Object value) {
                ((GlobalSettings)this.receiver).setRestrictedDuplicateScope((RestrictedDuplicateScope)((Object)value));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)optionController, (String)"onValue(...)");
        OptionController globalOptionsController2 = optionController;
        List $this$foldRight$iv = scopes2 = SequencesKt.toList(DuplicateScopeExtension.Companion.findAllUniqueDuplicateScopes());
        boolean $i$f$foldRight = false;
        OptionController accumulator$iv = globalOptionsController2;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                DuplicateInspectionConfiguration config;
                void controller;
                OptionController optionController2 = accumulator$iv;
                DuplicateScope scope = (DuplicateScope)iterator$iv.previous();
                boolean bl = false;
                if (this.state.findConfiguration(scope) == null) {
                    throw new IllegalStateException("No such configuration: " + scope.getClass());
                }
                Intrinsics.checkNotNullExpressionValue((Object)controller.onPrefix(scope.getClass().getCanonicalName(), scope.createOptionController(config).onValue("enabled", (KMutableProperty0)new MutablePropertyReference0Impl(config){

                    @Nullable
                    public Object get() {
                        return ((DuplicateInspectionConfiguration)this.receiver).isEnabled();
                    }

                    public void set(@Nullable Object value) {
                        ((DuplicateInspectionConfiguration)this.receiver).setEnabled((Boolean)value);
                    }
                })), (String)"onPrefix(...)");
            }
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)file));
        if (virtualFile == null) {
            boolean $i$f$emptyArray = false;
            return new ProblemDescriptor[0];
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project2 = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (!HashIndexFileFilterKt.isIndexed(project2, virtualFile2)) {
            boolean $i$f$emptyArray = false;
            return new ProblemDescriptor[0];
        }
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        DuplicateScope duplicateScope = DuplicateScopeExtension.Companion.findDuplicateScope(fileType);
        if (duplicateScope == null) {
            boolean $i$f$emptyArray = false;
            return new ProblemDescriptor[0];
        }
        DuplicateScope scope = duplicateScope;
        DuplicateInspectionConfiguration duplicateInspectionConfiguration = this.state.findConfiguration(scope);
        if (duplicateInspectionConfiguration == null) {
            boolean $i$f$emptyArray = false;
            return new ProblemDescriptor[0];
        }
        DuplicateInspectionConfiguration inspectionSettings = duplicateInspectionConfiguration;
        if (!inspectionSettings.isEnabled()) {
            boolean $i$f$emptyArray = false;
            return new ProblemDescriptor[0];
        }
        List<TextClone> clones = new DuplicateAnalyzer(scope).searchDuplicates(file, inspectionSettings.getMinSize());
        Project project3 = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        DuplicatesScopeFilter duplicatesScopeFilter = new DuplicatesScopeFilter(project3);
        Iterable $this$mapNotNull$iv = clones;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<TextClone> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TextClone it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TextClone it = (TextClone)element$iv$iv;
            boolean bl2 = false;
            if (duplicatesScopeFilter.restrict(it, this.state.getGlobalSettings().getRestrictedDuplicateScope()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List restrictedClones = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv2 = restrictedClones;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            ProblemDescriptor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            TextClone textClone = (TextClone)element$iv$iv;
            boolean bl4 = false;
            if (this.createProblemDescriptor(manager, textClone, scope, isOnTheFly) == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List problems = (List)destination$iv$iv2;
        Collection $this$toTypedArray$iv = problems;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ProblemDescriptor[0]);
    }

    private final ProblemDescriptor createProblemDescriptor(InspectionManager manger, TextClone textClone, DuplicateScope scope, boolean isOnTheFly) {
        String string2;
        TextRange textRange;
        LocalQuickFix[] fixes;
        Project project2 = manger.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        PsiFile psiFile = PsiManager.getInstance((Project)project3).findFile(textClone.getMain().getFile());
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file = psiFile;
        if (isOnTheFly) {
            Collection $this$toTypedArray$iv = scope.createQuickFixes(project3, textClone);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            v2 = thisCollection$iv.toArray(new LocalQuickFix[0]);
        } else {
            boolean $i$f$emptyArray = false;
            v2 = fixes = new LocalQuickFix[]{};
        }
        if (this.fullHighlighting) {
            textRange = textClone.getMain().getRange();
        } else {
            VirtualFile virtualFile = file.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            textRange = DuplicateInspectionUtilKt.cropToOneLine(virtualFile, textClone.getMain().getRange());
        }
        TextRange range = textRange;
        PsiElement psiElement = DuplicateInspectionUtilKt.findCommonParent(file, range);
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        TextRange textRange2 = element.getTextRange();
        if (textRange2 == null) {
            return null;
        }
        int elementOffset = textRange2.getStartOffset();
        IntRange lines = textClone.getMain().getLines();
        if (isOnTheFly) {
            var13_15 = new Object[]{lines.getLast() - lines.getFirst() + 1};
            string2 = DuplicatesBundle.INSTANCE.getMessage("duplicate.inspection.problem", var13_15);
        } else {
            var13_15 = new Object[]{lines.getFirst(), lines.getLast()};
            string2 = DuplicatesBundle.INSTANCE.getMessage("duplicate.inspection.problem.details", var13_15);
        }
        String message2 = string2;
        return (ProblemDescriptor)new DuplicateProblemDescriptor(element, range.shiftLeft(elementOffset), message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, textClone, isOnTheFly, Arrays.copyOf(fixes, fixes.length));
    }

    private static final String getOptionsPane$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String getOptionsPane$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }
}

