/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.template.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.text.TextRangeUtil;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.intellij.xml.template.formatter.FragmentedTemplateException;
import com.intellij.xml.template.formatter.IndentInheritingBlock;
import com.intellij.xml.template.formatter.TemplateLanguageBlock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TemplateFormatUtil {
    private static final List<PsiElement> EMPTY_PSI_ELEMENT_LIST = new ArrayList<PsiElement>();
    private static final String[] IGNORABLE_ERROR_MESSAGES = new String[]{XmlPsiBundle.message("xml.parsing.closing.tag.matches.nothing", new Object[0]), XmlPsiBundle.message("xml.parsing.closing.tag.name.missing", new Object[0])};

    private TemplateFormatUtil() {
    }

    @NotNull
    static List<PsiElement> findAllMarkupLanguageElementsInside(PsiElement outerLangElement) {
        FileViewProvider fileViewProvider;
        PsiFile file = outerLangElement.getContainingFile();
        if (file != null && (fileViewProvider = file.getViewProvider()) instanceof TemplateLanguageFileViewProvider) {
            TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)fileViewProvider;
            return TemplateFormatUtil.findAllElementsInside(outerLangElement.getTextRange(), viewProvider, false);
        }
        List<PsiElement> list2 = EMPTY_PSI_ELEMENT_LIST;
        if (list2 == null) {
            TemplateFormatUtil.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    static List<PsiElement> findAllTemplateLanguageElementsInside(@NotNull PsiElement outerLangElement, @NotNull TemplateLanguageFileViewProvider viewProvider) {
        if (outerLangElement == null) {
            TemplateFormatUtil.$$$reportNull$$$0(1);
        }
        if (viewProvider == null) {
            TemplateFormatUtil.$$$reportNull$$$0(2);
        }
        return TemplateFormatUtil.findAllElementsInside(outerLangElement.getTextRange(), viewProvider, true);
    }

    @NotNull
    static List<PsiElement> findAllElementsInside(@NotNull TextRange range, @NotNull TemplateLanguageFileViewProvider viewProvider, boolean fromTemplate) {
        if (range == null) {
            TemplateFormatUtil.$$$reportNull$$$0(3);
        }
        if (viewProvider == null) {
            TemplateFormatUtil.$$$reportNull$$$0(4);
        }
        return TemplateFormatUtil.findAllElementsInside(range, viewProvider, fromTemplate ? viewProvider.getBaseLanguage() : viewProvider.getTemplateDataLanguage());
    }

    @NotNull
    public static List<PsiElement> findAllElementsInside(TextRange range, TemplateLanguageFileViewProvider viewProvider, Language language) {
        ArrayList<PsiElement> matchingElements = new ArrayList<PsiElement>();
        PsiElement currElement = viewProvider.findElementAt(range.getStartOffset(), language);
        while (currElement instanceof OuterLanguageElement) {
            currElement = currElement.getNextSibling();
        }
        if (currElement != null) {
            currElement = TemplateFormatUtil.findTopmostElementInRange(currElement, range);
            Pair<Integer, PsiElement> result2 = TemplateFormatUtil.addElementSequence(currElement, range, matchingElements);
            int lastOffset = (Integer)result2.first;
            assert (lastOffset >= 0) : "Failed to process elements in range: " + range;
            if (lastOffset < range.getEndOffset()) {
                matchingElements.addAll(TemplateFormatUtil.findAllElementsInside(new TextRange(lastOffset, range.getEndOffset()), viewProvider, language));
            }
        }
        ArrayList<PsiElement> arrayList = matchingElements;
        if (arrayList == null) {
            TemplateFormatUtil.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static Pair<Integer, PsiElement> addElementSequence(PsiElement startElement, TextRange range, List<? super PsiElement> targetList) {
        PsiElement child;
        PsiElement currElement;
        int lastOffset = -1;
        for (currElement = startElement; currElement != null && (lastOffset = currElement.getTextRange().getEndOffset()) <= range.getEndOffset(); currElement = currElement.getNextSibling()) {
            if (currElement instanceof OuterLanguageElement) continue;
            targetList.add((PsiElement)currElement);
        }
        if (currElement != null && currElement.getTextRange().intersects(range) && (child = currElement.getFirstChild()) != null) {
            TemplateFormatUtil.addElementSequence(child, range, targetList);
        }
        return new Pair((Object)lastOffset, (Object)currElement);
    }

    @NotNull
    public static PsiElement findTopmostElementInRange(@NotNull PsiElement original, TextRange fitToRange) {
        if (original == null) {
            TemplateFormatUtil.$$$reportNull$$$0(6);
        }
        PsiElement prevElement = original;
        for (PsiElement currElement = original; currElement != null; currElement = currElement.getParent()) {
            if (currElement instanceof PsiFile || !fitToRange.contains(currElement.getTextRange())) {
                if (!fitToRange.contains(prevElement.getTextRange())) {
                    PsiElement psiElement = original;
                    if (psiElement == null) {
                        TemplateFormatUtil.$$$reportNull$$$0(7);
                    }
                    return psiElement;
                }
                PsiElement psiElement = prevElement;
                if (psiElement == null) {
                    TemplateFormatUtil.$$$reportNull$$$0(8);
                }
                return psiElement;
            }
            prevElement = currElement;
        }
        PsiElement psiElement = original;
        if (psiElement == null) {
            TemplateFormatUtil.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    static List<Block> mergeBlocks(List<Block> originalBlocks, List<? extends Block> blocksToMerge, TextRange range) throws FragmentedTemplateException {
        int n;
        int n2;
        if (blocksToMerge.isEmpty()) {
            return originalBlocks;
        }
        ArrayList<Block> result2 = new ArrayList<Block>();
        if (originalBlocks.isEmpty()) {
            for (Block block : blocksToMerge) {
                if (!range.contains(block.getTextRange())) continue;
                result2.add(block);
            }
            return result2;
        }
        ArrayList<TextRange> originalRanges = new ArrayList<TextRange>();
        for (Block originalBlock : originalBlocks) {
            originalRanges.add(originalBlock.getTextRange());
        }
        int n3 = range.getStartOffset();
        Iterator<Block> originalBlockIterator = originalBlocks.iterator();
        while (originalBlockIterator.hasNext()) {
            Block mergeableBlock;
            Block originalBlock = originalBlockIterator.next();
            int startOffset = originalBlock.getTextRange().getStartOffset();
            if (n2 < startOffset && (n2 = TemplateFormatUtil.fillGap(originalRanges, blocksToMerge, result2, n2, startOffset)) < startOffset) {
                n2 = TemplateFormatUtil.fillGap(originalRanges, originalBlocks, result2, n2, startOffset);
            }
            if ((mergeableBlock = TemplateFormatUtil.getBlockContaining(blocksToMerge, originalRanges, originalBlock.getTextRange())) != null) {
                if (mergeableBlock.getTextRange().getStartOffset() < n2) continue;
                result2.add(mergeableBlock);
                n2 = mergeableBlock.getTextRange().getEndOffset();
                continue;
            }
            if (startOffset < n2) continue;
            result2.add(originalBlock);
            originalBlockIterator.remove();
            n2 = originalBlock.getTextRange().getEndOffset();
        }
        if (n2 < range.getEndOffset() && (n = TemplateFormatUtil.fillGap(originalRanges, blocksToMerge, result2, n2, range.getEndOffset())) < range.getEndOffset()) {
            TemplateFormatUtil.fillGap(originalRanges, originalBlocks, result2, n, range.getEndOffset());
        }
        return result2;
    }

    private static int fillGap(List<? extends TextRange> originalRanges, List<? extends Block> blocks, List<? super Block> result2, int startOffset, int endOffset) throws FragmentedTemplateException {
        return TemplateFormatUtil.fillGap(null, originalRanges, blocks, result2, startOffset, endOffset, 0);
    }

    private static int fillGap(@Nullable Block parent, List<? extends TextRange> originalRanges, List<? extends Block> blocks, List<? super Block> result2, int startOffset, int endOffset, int depth) throws FragmentedTemplateException {
        int lastOffset = startOffset;
        TextRange currRange = new TextRange(lastOffset, endOffset);
        for (Block block : blocks) {
            if (lastOffset == endOffset || block.getTextRange().getStartOffset() > endOffset) {
                return lastOffset;
            }
            if (currRange.contains(block.getTextRange())) {
                result2.add((Block)block);
                if (parent != null && block instanceof IndentInheritingBlock) {
                    ((IndentInheritingBlock)block).setIndent(parent.getIndent());
                }
                lastOffset = block.getTextRange().getEndOffset();
                currRange = new TextRange(lastOffset, endOffset);
                continue;
            }
            if (!currRange.intersects(block.getTextRange()) || !TextRangeUtil.intersectsOneOf((TextRange)block.getTextRange(), originalRanges)) continue;
            List subBlocks = block.getSubBlocks();
            if (block instanceof TemplateLanguageBlock && ((TemplateLanguageBlock)block).containsErrorElements()) {
                throw new FragmentedTemplateException();
            }
            lastOffset = TemplateFormatUtil.fillGap(block, originalRanges, subBlocks, result2, lastOffset, endOffset, depth + 1);
            currRange = new TextRange(lastOffset, endOffset);
        }
        return lastOffset;
    }

    private static Block getBlockContaining(List<? extends Block> blockList, List<? extends TextRange> originalRanges, TextRange range) {
        return TemplateFormatUtil.getBlockContaining(blockList, originalRanges, range, 0);
    }

    @Nullable
    private static Block getBlockContaining(List<? extends Block> blockList, List<? extends TextRange> originalRanges, TextRange range, int depth) {
        for (Block block : blockList) {
            Block containingBlock;
            if (!block.getTextRange().contains(range)) continue;
            if (TextRangeUtil.intersectsOneOf((TextRange)block.getTextRange(), originalRanges) && (containingBlock = TemplateFormatUtil.getBlockContaining(block.getSubBlocks(), originalRanges, range, depth + 1)) != null) {
                return containingBlock;
            }
            return block;
        }
        return null;
    }

    @Nullable
    public static Block buildTemplateLanguageBlock(@NotNull OuterLanguageElement outerElement, @NotNull CodeStyleSettings settings, @Nullable Indent indent) {
        if (outerElement == null) {
            TemplateFormatUtil.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            TemplateFormatUtil.$$$reportNull$$$0(11);
        }
        try {
            FormattingModel model;
            Language language;
            FormattingModelBuilder builder2;
            PsiFile file = outerElement.getContainingFile();
            FileViewProvider viewProvider = outerElement.getContainingFile().getViewProvider();
            if (viewProvider instanceof TemplateLanguageFileViewProvider && (builder2 = LanguageFormatting.INSTANCE.forContext(language = outerElement.getLanguage(), (PsiElement)outerElement)) instanceof AbstractXmlTemplateFormattingModelBuilder && (model = ((AbstractXmlTemplateFormattingModelBuilder)builder2).createTemplateFormattingModel(file, (TemplateLanguageFileViewProvider)viewProvider, outerElement, settings, indent)) != null) {
                return model.getRootBlock();
            }
        }
        catch (FragmentedTemplateException fragmentedTemplateException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isErrorElement(@NotNull PsiElement element) {
        if (element == null) {
            TemplateFormatUtil.$$$reportNull$$$0(12);
        }
        if (element instanceof PsiErrorElement) {
            String description2 = ((PsiErrorElement)element).getErrorDescription();
            for (String ignorableMessage : IGNORABLE_ERROR_MESSAGES) {
                if (!ignorableMessage.equals(description2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/template/formatter/TemplateFormatUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerLangElement";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllMarkupLanguageElementsInside";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/template/formatter/TemplateFormatUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllElementsInside";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopmostElementInRange";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findAllTemplateLanguageElementsInside";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAllElementsInside";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTopmostElementInRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplateLanguageBlock";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isErrorElement";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 6, 10, 11, 12 -> new IllegalArgumentException(string2);
        };
    }
}

