/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.impl;

import com.intellij.model.Pointer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.WebSymbolApiStatus;
import com.intellij.webSymbols.WebSymbolNameSegment;
import com.intellij.webSymbols.WebSymbolQualifiedKind;
import com.intellij.webSymbols.impl.WebSymbolNameSegmentImpl;
import com.intellij.webSymbols.utils.WebSymbolUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0001@Bt\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\r\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0016J\r\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b0JE\u00101\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\b\u0010!\u001a\u0004\u0018\u00010\u00142\b\u0010&\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0004\b2\u00103J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\u000105H\u0016J\u0015\u00106\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u0006\u00107\u001a\u00020\u0007H\u0016J\b\u00108\u001a\u00020\u000bH\u0016J\u0017\u00109\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u00a2\u0006\u0002\b:J\u0015\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b=J\u001d\u0010>\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b?R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u0016\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u0016\u0010!\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0016\u0010&\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001dR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006A"}, d2={"Lcom/intellij/webSymbols/impl/WebSymbolNameSegmentImpl;", "Lcom/intellij/webSymbols/WebSymbolNameSegment;", "start", "", "end", "symbols", "", "Lcom/intellij/webSymbols/WebSymbol;", "problem", "Lcom/intellij/webSymbols/WebSymbolNameSegment$MatchProblem;", "displayName", "", "Lcom/intellij/openapi/util/NlsSafe;", "matchScore", "symbolKinds", "", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "explicitApiStatus", "Lcom/intellij/webSymbols/WebSymbolApiStatus;", "explicitPriority", "Lcom/intellij/webSymbols/WebSymbol$Priority;", "explicitProximity", "(IILjava/util/List;Lcom/intellij/webSymbols/WebSymbolNameSegment$MatchProblem;Ljava/lang/String;ILjava/util/Set;Lcom/intellij/webSymbols/WebSymbolApiStatus;Lcom/intellij/webSymbols/WebSymbol$Priority;Ljava/lang/Integer;)V", "apiStatus", "getApiStatus", "()Lcom/intellij/webSymbols/WebSymbolApiStatus;", "getDisplayName", "()Ljava/lang/String;", "getEnd", "()I", "Ljava/lang/Integer;", "forcedSymbolKinds", "getMatchScore", "priority", "getPriority", "()Lcom/intellij/webSymbols/WebSymbol$Priority;", "getProblem", "()Lcom/intellij/webSymbols/WebSymbolNameSegment$MatchProblem;", "proximity", "getProximity", "()Ljava/lang/Integer;", "getStart", "getSymbolKinds", "()Ljava/util/Set;", "getSymbols", "()Ljava/util/List;", "canUnwrapSymbols", "", "canUnwrapSymbols$intellij_platform_webSymbols", "copy", "copy$intellij_platform_webSymbols", "(Lcom/intellij/webSymbols/WebSymbolApiStatus;Lcom/intellij/webSymbols/WebSymbol$Priority;Ljava/lang/Integer;Lcom/intellij/webSymbols/WebSymbolNameSegment$MatchProblem;Ljava/util/List;)Lcom/intellij/webSymbols/impl/WebSymbolNameSegmentImpl;", "createPointer", "Lcom/intellij/model/Pointer;", "getName", "symbol", "toString", "withDisplayName", "withDisplayName$intellij_platform_webSymbols", "withOffset", "offset", "withOffset$intellij_platform_webSymbols", "withRange", "withRange$intellij_platform_webSymbols", "NameSegmentPointer", "intellij.platform.webSymbols"})
public final class WebSymbolNameSegmentImpl
implements WebSymbolNameSegment {
    private final int start;
    private final int end;
    @NotNull
    private final List<WebSymbol> symbols;
    @Nullable
    private final WebSymbolNameSegment.MatchProblem problem;
    @Nullable
    private final String displayName;
    private final int matchScore;
    @Nullable
    private final WebSymbolApiStatus explicitApiStatus;
    @Nullable
    private final WebSymbol.Priority explicitPriority;
    @Nullable
    private final Integer explicitProximity;
    @Nullable
    private final Set<WebSymbolQualifiedKind> forcedSymbolKinds;

    public WebSymbolNameSegmentImpl(int start2, int end, @NotNull List<? extends WebSymbol> symbols, @Nullable WebSymbolNameSegment.MatchProblem problem, @Nullable String displayName, int matchScore, @Nullable Set<WebSymbolQualifiedKind> symbolKinds2, @Nullable WebSymbolApiStatus explicitApiStatus, @Nullable WebSymbol.Priority explicitPriority, @Nullable Integer explicitProximity) {
        boolean bl;
        Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
        this.start = start2;
        this.end = end;
        this.symbols = symbols;
        this.problem = problem;
        this.displayName = displayName;
        this.matchScore = matchScore;
        this.explicitApiStatus = explicitApiStatus;
        this.explicitPriority = explicitPriority;
        this.explicitProximity = explicitProximity;
        boolean bl2 = bl = this.getStart() <= this.getEnd();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.forcedSymbolKinds = symbolKinds2;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    @NotNull
    public List<WebSymbol> getSymbols() {
        return this.symbols;
    }

    @Override
    @Nullable
    public WebSymbolNameSegment.MatchProblem getProblem() {
        return this.problem;
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public int getMatchScore() {
        return this.matchScore;
    }

    @Override
    @Nullable
    public WebSymbolApiStatus getApiStatus() {
        return this.explicitApiStatus;
    }

    @Override
    @Nullable
    public WebSymbol.Priority getPriority() {
        WebSymbol.Priority priority2 = this.explicitPriority;
        if (priority2 == null) {
            priority2 = (WebSymbol.Priority)((Object)SequencesKt.maxOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.getSymbols()), (Function1)priority.1.INSTANCE)));
        }
        return priority2;
    }

    @Override
    @Nullable
    public Integer getProximity() {
        Integer n = this.explicitProximity;
        if (n == null) {
            n = (Integer)SequencesKt.maxOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.getSymbols()), (Function1)proximity.1.INSTANCE));
        }
        return n;
    }

    @Override
    @NotNull
    public Set<WebSymbolQualifiedKind> getSymbolKinds() {
        Set set = this.forcedSymbolKinds;
        if (set == null) {
            set = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.getSymbols()), (Function1)symbolKinds.1.INSTANCE));
        }
        return set;
    }

    @Override
    @NotNull
    public String getName(@NotNull WebSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        String string2 = WebSymbolUtils.getMatchedNameOrName(symbol).substring(this.getStart(), this.getEnd());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    @NotNull
    public final WebSymbolNameSegmentImpl withOffset$intellij_platform_webSymbols(int offset) {
        return new WebSymbolNameSegmentImpl(this.getStart() + offset, this.getEnd() + offset, this.getSymbols(), this.getProblem(), this.getDisplayName(), this.getMatchScore(), this.forcedSymbolKinds, this.explicitApiStatus, this.explicitPriority, this.explicitProximity);
    }

    @NotNull
    public final WebSymbolNameSegmentImpl withDisplayName$intellij_platform_webSymbols(@Nullable String displayName) {
        int n = this.getStart();
        int n2 = this.getEnd();
        List<WebSymbol> list2 = this.getSymbols();
        WebSymbolNameSegment.MatchProblem matchProblem2 = this.getProblem();
        String string2 = this.getDisplayName();
        if (string2 == null) {
            string2 = displayName;
        }
        return new WebSymbolNameSegmentImpl(n, n2, list2, matchProblem2, string2, this.getMatchScore(), this.forcedSymbolKinds, this.explicitApiStatus, this.explicitPriority, this.explicitProximity);
    }

    @NotNull
    public final WebSymbolNameSegmentImpl withRange$intellij_platform_webSymbols(int start2, int end) {
        return new WebSymbolNameSegmentImpl(start2, end, this.getSymbols(), this.getProblem(), this.getDisplayName(), this.getMatchScore(), this.forcedSymbolKinds, this.explicitApiStatus, this.explicitPriority, this.explicitProximity);
    }

    @NotNull
    public final WebSymbolNameSegmentImpl copy$intellij_platform_webSymbols(@Nullable WebSymbolApiStatus apiStatus2, @Nullable WebSymbol.Priority priority2, @Nullable Integer proximity2, @Nullable WebSymbolNameSegment.MatchProblem problem, @NotNull List<? extends WebSymbol> symbols) {
        Integer n;
        WebSymbol.Priority priority3;
        Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
        int n2 = this.getStart();
        int n3 = this.getEnd();
        List list2 = CollectionsKt.plus((Collection)this.getSymbols(), (Iterable)symbols);
        WebSymbolNameSegment.MatchProblem matchProblem2 = problem;
        if (matchProblem2 == null) {
            matchProblem2 = this.getProblem();
        }
        String string2 = this.getDisplayName();
        int n4 = this.getMatchScore();
        WebSymbolApiStatus webSymbolApiStatus = apiStatus2;
        if (webSymbolApiStatus == null) {
            webSymbolApiStatus = this.explicitApiStatus;
        }
        if ((priority3 = priority2) == null) {
            priority3 = this.explicitPriority;
        }
        if ((n = proximity2) == null) {
            n = this.explicitProximity;
        }
        return new WebSymbolNameSegmentImpl(n2, n3, list2, matchProblem2, string2, n4, this.forcedSymbolKinds, webSymbolApiStatus, priority3, n);
    }

    public final boolean canUnwrapSymbols$intellij_platform_webSymbols() {
        return this.explicitApiStatus == null && this.getProblem() == null && this.getDisplayName() == null && this.getMatchScore() == this.getEnd() - this.getStart() && this.explicitPriority == null && this.explicitProximity == null && !((Collection)this.getSymbols()).isEmpty();
    }

    @Override
    @NotNull
    public Pointer<WebSymbolNameSegment> createPointer() {
        return new NameSegmentPointer(this);
    }

    @NotNull
    public String toString() {
        return "<" + this.getStart() + ":" + this.getEnd() + (String)(this.getProblem() != null ? ":" + this.getProblem() : "") + "-" + this.getSymbols().size() + "cs>";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0016R\u0017\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/webSymbols/impl/WebSymbolNameSegmentImpl$NameSegmentPointer;", "Lcom/intellij/model/Pointer;", "Lcom/intellij/webSymbols/WebSymbolNameSegment;", "nameSegment", "Lcom/intellij/webSymbols/impl/WebSymbolNameSegmentImpl;", "(Lcom/intellij/webSymbols/impl/WebSymbolNameSegmentImpl;)V", "displayName", "", "Lcom/intellij/openapi/util/NlsSafe;", "end", "", "explicitApiStatus", "Lcom/intellij/webSymbols/WebSymbolApiStatus;", "explicitPriority", "Lcom/intellij/webSymbols/WebSymbol$Priority;", "explicitProximity", "Ljava/lang/Integer;", "matchScore", "problem", "Lcom/intellij/webSymbols/WebSymbolNameSegment$MatchProblem;", "start", "symbols", "", "Lcom/intellij/webSymbols/WebSymbol;", "types", "", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "dereference", "intellij.platform.webSymbols"})
    @SourceDebugExtension(value={"SMAP\nWebSymbolNameSegmentImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolNameSegmentImpl.kt\ncom/intellij/webSymbols/impl/WebSymbolNameSegmentImpl$NameSegmentPointer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1549#2:115\n1620#2,3:116\n1549#2:119\n1620#2,3:120\n1726#2,3:124\n1#3:123\n*S KotlinDebug\n*F\n+ 1 WebSymbolNameSegmentImpl.kt\ncom/intellij/webSymbols/impl/WebSymbolNameSegmentImpl$NameSegmentPointer\n*L\n92#1:115\n92#1:116,3\n105#1:119\n105#1:120,3\n106#1:124,3\n*E\n"})
    private static final class NameSegmentPointer
    implements Pointer<WebSymbolNameSegment> {
        private final int start;
        private final int end;
        @NotNull
        private final List<Pointer<? extends WebSymbol>> symbols;
        @Nullable
        private final WebSymbolNameSegment.MatchProblem problem;
        @NlsSafe
        @Nullable
        private final String displayName;
        private final int matchScore;
        @NotNull
        private final Set<WebSymbolQualifiedKind> types;
        @Nullable
        private final WebSymbolApiStatus explicitApiStatus;
        @Nullable
        private final WebSymbol.Priority explicitPriority;
        @Nullable
        private final Integer explicitProximity;

        /*
         * WARNING - void declaration
         */
        public NameSegmentPointer(@NotNull WebSymbolNameSegmentImpl nameSegment) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)nameSegment, (String)"nameSegment");
            this.start = nameSegment.getStart();
            this.end = nameSegment.getEnd();
            Iterable iterable = nameSegment.getSymbols();
            NameSegmentPointer nameSegmentPointer = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                WebSymbol webSymbol = (WebSymbol)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.createPointer());
            }
            nameSegmentPointer.symbols = (List)destination$iv$iv;
            this.problem = nameSegment.getProblem();
            this.displayName = nameSegment.getDisplayName();
            this.matchScore = nameSegment.getMatchScore();
            this.types = nameSegment.getSymbolKinds();
            this.explicitApiStatus = nameSegment.explicitApiStatus;
            this.explicitPriority = nameSegment.explicitPriority;
            this.explicitProximity = nameSegment.explicitProximity;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public WebSymbolNameSegmentImpl dereference() {
            WebSymbolNameSegmentImpl webSymbolNameSegmentImpl;
            List list2;
            boolean bl;
            List it;
            List list3;
            block6: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.symbols;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    Pointer pointer = (Pointer)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add((WebSymbol)it2.dereference());
                }
                it = list3 = (List)destination$iv$iv;
                boolean bl3 = false;
                Iterable $this$all$iv = it;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        WebSymbol symbol = (WebSymbol)element$iv;
                        boolean bl4 = false;
                        if (symbol != null) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            List list4 = list2 = bl ? list3 : null;
            if (list2 != null) {
                it = list2;
                boolean bl5 = false;
                webSymbolNameSegmentImpl = new WebSymbolNameSegmentImpl(this.start, this.end, it, this.problem, this.displayName, this.matchScore, this.types, this.explicitApiStatus, this.explicitPriority, this.explicitProximity);
            } else {
                webSymbolNameSegmentImpl = null;
            }
            return webSymbolNameSegmentImpl;
        }
    }
}

