/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.DomSupportEnabled;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.ModelMergerImpl;
import com.intellij.util.xml.StableElement;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomCreator;
import com.intellij.util.xml.impl.DomDisposable;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.MockDomFileDescription;
import com.intellij.util.xml.impl.StableInvocationHandler;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import net.sf.cglib.proxy.AdvancedProxy;
import net.sf.cglib.proxy.InvocationHandler;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DomManagerImpl
extends DomManager
implements Disposable {
    private static final Key<Object> MOCK = Key.create((String)"MockElement");
    static final Key<WeakReference<DomFileElementImpl<?>>> CACHED_FILE_ELEMENT = Key.create((String)"CACHED_FILE_ELEMENT");
    static final Key<DomFileDescription<?>> MOCK_DESCRIPTION = Key.create((String)"MockDescription");
    private static final Key<CachedValue<DomFileElementImpl<?>>> FILE_ELEMENT_KEY = Key.create((String)"DomFileElement");
    private static final Key<CachedValue<DomFileElementImpl<?>>> FILE_ELEMENT_KEY_FOR_INDEX = Key.create((String)"DomFileElementForIndex");
    private static final Key<CachedValue<DomInvocationHandler>> HANDLER_KEY = Key.create((String)"DomInvocationHandler");
    private static final Key<CachedValue<DomInvocationHandler>> HANDLER_KEY_FOR_INDEX = Key.create((String)"DomInvocationHandlerForIndex");
    private final EventDispatcher<DomEventListener> listeners = EventDispatcher.create(DomEventListener.class);
    private final Project project;
    private final DomApplicationComponent applicationComponent;
    private boolean isChanging;
    private boolean isBulkChange;

    public DomManagerImpl(Project project2) {
        super(project2);
        this.project = project2;
        this.applicationComponent = DomApplicationComponent.getInstance();
        Disposable parent = (Disposable)project2.getService(DomDisposable.class);
        final PomModel pomModel = PomManager.getModel((Project)project2);
        pomModel.addModelListener(new PomModelListener(){

            public void modelChanged(@NotNull PomModelEvent event) {
                DomFileElementImpl element;
                PsiFile file;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DomManagerImpl.this.isChanging) {
                    return;
                }
                TreeChangeEvent changeSet = (TreeChangeEvent)event.getChangeSet(pomModel.getModelAspect(TreeAspect.class));
                if (changeSet != null && (file = changeSet.getRootElement().getPsi().getContainingFile()) instanceof XmlFile && (element = DomManagerImpl.getCachedFileElement((XmlFile)file)) != null) {
                    DomManagerImpl.this.fireEvent(new DomEvent(element, false));
                }
            }

            public boolean isAspectChangeInteresting(@NotNull PomModelAspect aspect) {
                if (aspect == null) {
                    1.$$$reportNull$$$0(1);
                }
                return aspect instanceof TreeAspect;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aspect";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/util/xml/impl/DomManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modelChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isAspectChangeInteresting";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, parent);
        VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){

            @Nullable
            public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                final ArrayList<DomEvent> domEvents = new ArrayList<DomEvent>();
                for (VFileEvent vFileEvent : events) {
                    if (!2.shouldFireDomEvents(vFileEvent)) continue;
                    ProgressManager.checkCanceled();
                    domEvents.addAll(DomManagerImpl.this.calcDomChangeEvents(vFileEvent.getFile()));
                }
                return domEvents.isEmpty() ? null : new AsyncFileListener.ChangeApplier(){

                    public void afterVfsChange() {
                        DomManagerImpl.this.fireEvents(domEvents);
                    }
                };
            }

            private static boolean shouldFireDomEvents(VFileEvent event) {
                if (event instanceof VFileContentChangeEvent) {
                    return !event.isFromSave();
                }
                if (event instanceof VFilePropertyChangeEvent) {
                    return "name".equals(((VFilePropertyChangeEvent)event).getPropertyName()) && !((VFilePropertyChangeEvent)event).getFile().isDirectory();
                }
                return event instanceof VFileMoveEvent || event instanceof VFileDeleteEvent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/util/xml/impl/DomManagerImpl$2", "prepareChange"));
            }
        }, parent);
        project2.getMessageBus().connect(parent).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                DomUtil.clearCaches();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/util/xml/impl/DomManagerImpl$3", "beforePluginUnload"));
            }
        });
    }

    public void dispose() {
    }

    public long getPsiModificationCount() {
        return PsiManager.getInstance((Project)this.getProject()).getModificationTracker().getModificationCount();
    }

    private List<DomEvent> calcDomChangeEvents(VirtualFile file) {
        if (!(file instanceof NewVirtualFile) || this.project.isDisposed()) {
            return Collections.emptyList();
        }
        final FileManager fileManager = PsiManagerEx.getInstanceEx((Project)this.project).getFileManager();
        final ArrayList<DomEvent> events = new ArrayList<DomEvent>();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!file.isDirectory() && FileTypeRegistry.getInstance().isFileOfType(file, (FileType)XmlFileType.INSTANCE)) {
                    DomFileElementImpl domElement;
                    PsiFile psiFile = fileManager.getCachedPsiFile(file);
                    DomFileElementImpl domFileElementImpl = domElement = psiFile instanceof XmlFile ? DomManagerImpl.getCachedFileElement((XmlFile)psiFile) : null;
                    if (domElement != null) {
                        events.add(new DomEvent(domElement, false));
                    }
                }
                return true;
            }

            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                if (file == null) {
                    4.$$$reportNull$$$0(1);
                }
                return ((NewVirtualFile)file).getCachedChildren();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/util/xml/impl/DomManagerImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildrenIterable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return events;
    }

    boolean isInsideAtomicChange() {
        return this.isBulkChange;
    }

    public static DomManagerImpl getDomManager(Project project2) {
        return (DomManagerImpl)DomManager.getDomManager(project2);
    }

    @Override
    public void addDomEventListener(DomEventListener listener2, Disposable parentDisposable) {
        this.listeners.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    public ConverterManager getConverterManager() {
        return (ConverterManager)ApplicationManager.getApplication().getService(ConverterManager.class);
    }

    @Override
    public ModelMerger createModelMerger() {
        return new ModelMergerImpl();
    }

    void fireEvent(@NotNull DomEvent event) {
        if (event == null) {
            DomManagerImpl.$$$reportNull$$$0(0);
        }
        if (this.isInsideAtomicChange()) {
            return;
        }
        this.clearCache();
        ((DomEventListener)this.listeners.getMulticaster()).eventOccured(event);
    }

    private void fireEvents(@NotNull Collection<? extends DomEvent> events) {
        if (events == null) {
            DomManagerImpl.$$$reportNull$$$0(1);
        }
        for (DomEvent domEvent : events) {
            this.fireEvent(domEvent);
        }
    }

    @Override
    public DomGenericInfo getGenericInfo(Type type2) {
        return this.applicationComponent.getStaticGenericInfo(type2);
    }

    @Nullable
    public static DomInvocationHandler getDomInvocationHandler(DomElement proxy) {
        if (proxy instanceof DomFileElement) {
            return null;
        }
        if (proxy instanceof DomInvocationHandler) {
            DomInvocationHandler h = (DomInvocationHandler)proxy;
            return h;
        }
        InvocationHandler handler2 = AdvancedProxy.getInvocationHandler(proxy);
        if (handler2 instanceof StableInvocationHandler) {
            DomElement element = (DomElement)((StableInvocationHandler)handler2).getWrappedElement();
            return element == null ? null : DomManagerImpl.getDomInvocationHandler(element);
        }
        if (handler2 instanceof DomInvocationHandler) {
            return (DomInvocationHandler)((Object)handler2);
        }
        if (handler2 instanceof DomInvocationHandler.MyInvocationHandler) {
            DomInvocationHandler.MyInvocationHandler h = (DomInvocationHandler.MyInvocationHandler)handler2;
            return h.getDomInvocationHandler();
        }
        return null;
    }

    @NotNull
    public static DomInvocationHandler getNotNullHandler(DomElement proxy) {
        DomInvocationHandler handler2 = DomManagerImpl.getDomInvocationHandler(proxy);
        if (handler2 == null) {
            throw new AssertionError((Object)("null handler for " + proxy));
        }
        DomInvocationHandler domInvocationHandler = handler2;
        if (domInvocationHandler == null) {
            DomManagerImpl.$$$reportNull$$$0(2);
        }
        return domInvocationHandler;
    }

    static StableInvocationHandler<?> getStableInvocationHandler(Object proxy) {
        return (StableInvocationHandler)AdvancedProxy.getInvocationHandler(proxy);
    }

    public DomApplicationComponent getApplicationComponent() {
        return this.applicationComponent;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public <T extends DomElement> DomFileElementImpl<T> getFileElement(XmlFile file, Class<T> aClass, String rootTagName) {
        if (file.getUserData(MOCK_DESCRIPTION) == null) {
            file.putUserData(MOCK_DESCRIPTION, new MockDomFileDescription<T>(aClass, rootTagName, file.getViewProvider().getVirtualFile()));
            this.clearCache();
        }
        DomFileElement fileElement = this.getFileElement(file);
        assert (fileElement != null);
        DomFileElement domFileElement = fileElement;
        if (domFileElement == null) {
            DomManagerImpl.$$$reportNull$$$0(3);
        }
        return domFileElement;
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        String string2 = ((Object)((Object)this)).getClass().getName();
        if (string2 == null) {
            DomManagerImpl.$$$reportNull$$$0(4);
        }
        return string2;
    }

    void runChange(Runnable change) {
        boolean b = this.setChanging(true);
        try {
            change.run();
        }
        finally {
            this.setChanging(b);
        }
    }

    boolean setChanging(boolean changing) {
        boolean oldChanging = this.isChanging;
        if (changing) assert (!oldChanging);
        this.isChanging = changing;
        return oldChanging;
    }

    @Nullable
    public <T extends DomElement> DomFileElementImpl<T> getFileElement(@Nullable XmlFile file) {
        if (file == null || !(file.getFileType() instanceof DomSupportEnabled)) {
            return null;
        }
        return (DomFileElementImpl)CachedValuesManager.getCachedValue((PsiElement)file, DomManagerImpl.chooseKey(FILE_ELEMENT_KEY, FILE_ELEMENT_KEY_FOR_INDEX), () -> CachedValueProvider.Result.create(DomCreator.createFileElement(file), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}));
    }

    private static <T> T chooseKey(T base, T forIndex) {
        return FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() != null ? forIndex : base;
    }

    @Nullable
    static <T extends DomElement> DomFileElementImpl<T> getCachedFileElement(@NotNull XmlFile file) {
        if (file == null) {
            DomManagerImpl.$$$reportNull$$$0(5);
        }
        return (DomFileElementImpl)SoftReference.dereference((Reference)((Reference)file.getUserData(CACHED_FILE_ELEMENT)));
    }

    @Nullable
    public <T extends DomElement> DomFileElementImpl<T> getFileElement(XmlFile file, Class<T> domClass) {
        DomFileDescription<?> description2 = this.getDomFileDescription(file);
        if (description2 != null && this.applicationComponent.assignabilityCache.isAssignable(domClass, description2.getRootElementClass())) {
            return this.getFileElement(file);
        }
        return null;
    }

    @Override
    @Nullable
    public DomElement getDomElement(XmlTag element) {
        if (this.isChanging) {
            return null;
        }
        DomInvocationHandler handler2 = this.getDomHandler(element);
        return handler2 != null ? handler2.getProxy() : null;
    }

    @Override
    @Nullable
    public GenericAttributeValue<?> getDomElement(XmlAttribute attribute) {
        if (this.isChanging) {
            return null;
        }
        DomInvocationHandler handler2 = this.getDomHandler(attribute);
        return handler2 == null ? null : (GenericAttributeValue)handler2.getProxy();
    }

    @Nullable
    public DomInvocationHandler getDomHandler(@Nullable XmlElement xml) {
        if (xml instanceof XmlTag) {
            return (DomInvocationHandler)CachedValuesManager.getCachedValue((PsiElement)xml, DomManagerImpl.chooseKey(HANDLER_KEY, HANDLER_KEY_FOR_INDEX), () -> {
                DomInvocationHandler handler2 = DomCreator.createTagHandler((XmlTag)xml);
                if (handler2 != null && handler2.getXmlTag() != xml) {
                    throw new AssertionError((Object)("Inconsistent dom, stub=" + handler2.getStub()));
                }
                return CachedValueProvider.Result.create((Object)handler2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
            });
        }
        if (xml instanceof XmlAttribute) {
            return (DomInvocationHandler)CachedValuesManager.getCachedValue((PsiElement)xml, DomManagerImpl.chooseKey(HANDLER_KEY, HANDLER_KEY_FOR_INDEX), () -> CachedValueProvider.Result.create((Object)DomCreator.createAttributeHandler((XmlAttribute)xml), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}));
        }
        return null;
    }

    @Override
    @Nullable
    public AbstractDomChildrenDescription findChildrenDescription(@NotNull XmlTag tag, @NotNull DomElement parent) {
        if (tag == null) {
            DomManagerImpl.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            DomManagerImpl.$$$reportNull$$$0(7);
        }
        DomInvocationHandler parentHandler = DomManagerImpl.getDomInvocationHandler(parent);
        assert (parentHandler != null);
        return parentHandler.getGenericInfo().findChildrenDescription(parentHandler, tag);
    }

    public boolean isDomFile(@Nullable PsiFile file) {
        return file instanceof XmlFile && this.getFileElement((XmlFile)file) != null;
    }

    @Nullable
    public DomFileDescription<?> getDomFileDescription(PsiElement element) {
        PsiFile psiFile;
        if (element instanceof XmlElement && (psiFile = element.getContainingFile()) instanceof XmlFile) {
            return this.getDomFileDescription((XmlFile)psiFile);
        }
        return null;
    }

    @Override
    public <T extends DomElement> T createMockElement(Class<T> aClass, Module module, boolean physical) {
        XmlFile file = (XmlFile)PsiFileFactory.getInstance((Project)this.project).createFileFromText("a.xml", (FileType)XmlFileType.INSTANCE, (CharSequence)"", 0L, physical);
        file.putUserData(MOCK_ELEMENT_MODULE, module);
        file.putUserData(MOCK, new Object());
        return ((DomFileElementImpl)this.getFileElement(file, (Class)aClass, "I_sincerely_hope_that_nobody_will_have_such_a_root_tag_name")).getRootElement();
    }

    @Override
    public boolean isMockElement(DomElement element) {
        return DomUtil.getFile(element).getUserData(MOCK) != null;
    }

    @Override
    public <T extends DomElement> T createStableValue(Factory<? extends T> provider) {
        return (T)((DomElement)this.createStableValue(provider, t -> t.isValid()));
    }

    @Override
    public <T> T createStableValue(Factory<? extends T> provider, Condition<? super T> validator) {
        Object initial = provider.create();
        assert (initial != null);
        StableInvocationHandler<? super T> handler2 = new StableInvocationHandler<T>(initial, provider, validator);
        HashSet<Class<StableElement>> intf = new HashSet<Class<StableElement>>();
        ContainerUtil.addAll(intf, (Object[])initial.getClass().getInterfaces());
        intf.add(StableElement.class);
        return (T)AdvancedProxy.createProxy(initial.getClass().getSuperclass(), intf.toArray(ArrayUtil.EMPTY_CLASS_ARRAY), handler2, new Object[0]);
    }

    @TestOnly
    public <T extends DomElement> void registerFileDescription(DomFileDescription<T> description2, Disposable parentDisposable) {
        this.clearCache();
        this.applicationComponent.registerFileDescription(description2);
        Disposer.register((Disposable)parentDisposable, () -> this.applicationComponent.removeDescription(description2));
    }

    @Override
    @NotNull
    public DomElement getResolvingScope(GenericDomValue<?> element) {
        DomFileDescription description2 = DomUtil.getFileElement(element).getFileDescription();
        DomElement domElement = description2.getResolveScope(element);
        if (domElement == null) {
            DomManagerImpl.$$$reportNull$$$0(8);
        }
        return domElement;
    }

    @Override
    @NotNull
    public DomElement getIdentityScope(DomElement element) {
        DomFileDescription description2 = DomUtil.getFileElement(element).getFileDescription();
        DomElement domElement = description2.getIdentityScope(element);
        if (domElement == null) {
            DomManagerImpl.$$$reportNull$$$0(9);
        }
        return domElement;
    }

    @Override
    public TypeChooserManager getTypeChooserManager() {
        return this.applicationComponent.getTypeChooserManager();
    }

    void performAtomicChange(@NotNull Runnable change) {
        if (change == null) {
            DomManagerImpl.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.assertWriteAccess();
        boolean oldValue = this.isBulkChange;
        this.isBulkChange = true;
        try {
            change.run();
        }
        finally {
            this.isBulkChange = oldValue;
            if (!oldValue) {
                this.clearCache();
            }
        }
        if (!this.isInsideAtomicChange()) {
            this.clearCache();
        }
    }

    private void clearCache() {
        this.incModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/DomManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/DomManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvingScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentityScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fireEvents";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCachedFileElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenDescription";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performAtomicChange";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 8, 9 -> new IllegalStateException(string2);
        };
    }
}

