/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@State(name="TaskProjectConfiguration")
public final class TaskProjectConfiguration
implements PersistentStateComponent<TaskProjectConfiguration> {
    @Property(surroundWithTag=false)
    @XCollection(elementName="server")
    public List<SharedServer> servers;
    private final Project myProject;

    @NonInjectable
    public TaskProjectConfiguration() {
        this.servers = new ArrayList<SharedServer>();
        this.myProject = null;
    }

    public TaskProjectConfiguration(@NotNull Project project2) {
        if (project2 == null) {
            TaskProjectConfiguration.$$$reportNull$$$0(0);
        }
        this.servers = new ArrayList<SharedServer>();
        this.myProject = project2;
    }

    public TaskProjectConfiguration getState() {
        LinkedHashSet<SharedServer> set = new LinkedHashSet<SharedServer>(this.servers);
        for (TaskRepository repository : TaskManager.getManager(this.myProject).getAllRepositories()) {
            if (!repository.isShared()) continue;
            SharedServer server = new SharedServer();
            server.type = repository.getRepositoryType().getName();
            server.url = repository.getUrl();
            set.add(server);
        }
        this.servers.clear();
        this.servers.addAll(set);
        return this;
    }

    public void loadState(@NotNull TaskProjectConfiguration state) {
        if (state == null) {
            TaskProjectConfiguration.$$$reportNull$$$0(1);
        }
        this.servers.clear();
        for (SharedServer server : state.servers) {
            if (server.url == null || server.type == null) continue;
            this.servers.add(server);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tasks/impl/TaskProjectConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Tag(value="server")
    public static class SharedServer {
        @Attribute(value="type")
        public String type;
        @Attribute(value="url")
        public String url;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SharedServer server = (SharedServer)o;
            if (this.type != null ? !this.type.equals(server.type) : server.type != null) {
                return false;
            }
            return !(this.url != null ? !this.url.equals(server.url) : server.url != null);
        }

        public int hashCode() {
            int result2 = this.type != null ? this.type.hashCode() : 0;
            result2 = 31 * result2 + (this.url != null ? this.url.hashCode() : 0);
            return result2;
        }
    }
}

