/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MatchContext {
    private final Stack<MatchedElementsListener> myMatchedElementsListenerStack;
    private MatchResultSink sink;
    private final Stack<MatchResultImpl> previousResults;
    private MatchResultImpl result;
    private CompiledPattern pattern;
    private MatchOptions options;
    @NotNull
    private final GlobalMatchingVisitor matcher;
    private boolean shouldRecursivelyMatch;
    private final Stack<List<PsiElement>> mySavedMatchedNodes;
    private List<PsiElement> myMatchedNodes;

    public MatchContext(@NotNull GlobalMatchingVisitor visitor2) {
        if (visitor2 == null) {
            MatchContext.$$$reportNull$$$0(0);
        }
        this.myMatchedElementsListenerStack = new Stack(2);
        this.previousResults = new Stack();
        this.shouldRecursivelyMatch = true;
        this.mySavedMatchedNodes = new Stack();
        this.myMatchedNodes = new SmartList();
        this.matcher = visitor2;
    }

    public void addMatchedNode(PsiElement node) {
        this.myMatchedNodes.add(node);
    }

    public void removeMatchedNode(PsiElement node) {
        this.myMatchedNodes.remove(node);
    }

    public void saveMatchedNodes() {
        this.mySavedMatchedNodes.push(this.myMatchedNodes);
        this.myMatchedNodes = new SmartList();
    }

    public void restoreMatchedNodes() {
        this.myMatchedNodes = (List)this.mySavedMatchedNodes.tryPop();
    }

    public void clearMatchedNodes() {
        this.myMatchedNodes.clear();
    }

    @NotNull
    public GlobalMatchingVisitor getMatcher() {
        GlobalMatchingVisitor globalMatchingVisitor = this.matcher;
        if (globalMatchingVisitor == null) {
            MatchContext.$$$reportNull$$$0(1);
        }
        return globalMatchingVisitor;
    }

    public MatchOptions getOptions() {
        return this.options;
    }

    public void setOptions(@NotNull MatchOptions options) {
        if (options == null) {
            MatchContext.$$$reportNull$$$0(2);
        }
        this.options = options;
    }

    public MatchResultImpl getPreviousResult() {
        if (this.previousResults.isEmpty()) {
            return null;
        }
        int index = this.previousResults.size() - 1;
        MatchResultImpl result2 = (MatchResultImpl)this.previousResults.get(index);
        while (result2 == null && index > 0) {
            result2 = (MatchResultImpl)this.previousResults.get(--index);
        }
        return result2;
    }

    @NotNull
    public MatchResultImpl getResult() {
        if (this.result == null) {
            this.result = new MatchResultImpl();
        }
        MatchResultImpl matchResultImpl = this.result;
        if (matchResultImpl == null) {
            MatchContext.$$$reportNull$$$0(3);
        }
        return matchResultImpl;
    }

    public void pushResult() {
        this.previousResults.push((Object)this.result);
        this.result = null;
    }

    public void popResult() {
        this.result = (MatchResultImpl)this.previousResults.pop();
    }

    public void setResult(MatchResultImpl result2) {
        this.result = result2;
        if (result2 == null) {
            this.pattern.clearHandlersState();
        }
    }

    public boolean hasResult() {
        return this.result != null;
    }

    public CompiledPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(@NotNull CompiledPattern pattern2) {
        if (pattern2 == null) {
            MatchContext.$$$reportNull$$$0(4);
        }
        this.pattern = pattern2;
    }

    public MatchResultSink getSink() {
        return this.sink;
    }

    public void setSink(@NotNull MatchResultSink sink) {
        if (sink == null) {
            MatchContext.$$$reportNull$$$0(5);
        }
        this.sink = sink;
    }

    public void clear() {
        this.result = null;
    }

    public boolean shouldRecursivelyMatch() {
        return this.shouldRecursivelyMatch;
    }

    public void setShouldRecursivelyMatch(boolean shouldRecursivelyMatch) {
        this.shouldRecursivelyMatch = shouldRecursivelyMatch;
    }

    public void pushMatchedElementsListener(@NotNull MatchedElementsListener matchedElementsListener) {
        if (matchedElementsListener == null) {
            MatchContext.$$$reportNull$$$0(6);
        }
        this.myMatchedElementsListenerStack.push((Object)matchedElementsListener);
    }

    public void popMatchedElementsListener() {
        this.myMatchedElementsListenerStack.pop();
    }

    public void notifyMatchedElements(@NotNull Collection<? extends PsiElement> matchedElements) {
        if (matchedElements == null) {
            MatchContext.$$$reportNull$$$0(7);
        }
        if (!this.myMatchedElementsListenerStack.isEmpty()) {
            ((MatchedElementsListener)this.myMatchedElementsListenerStack.peek()).matchedElements(matchedElements);
        }
    }

    public void dispatchMatched() {
        if (!this.myMatchedNodes.isEmpty() && !this.dispatchTargetMatch(this.getResult())) {
            this.dispatchCompleteMatch();
        }
    }

    private boolean dispatchTargetMatch(@NotNull MatchResult result2) {
        if (result2 == null) {
            MatchContext.$$$reportNull$$$0(8);
        }
        boolean dispatched = false;
        for (MatchResult r : result2.getChildren()) {
            if (r.isScopeMatch() && !r.isTarget() || r.isMultipleMatch()) {
                dispatched |= this.dispatchTargetMatch(r);
                continue;
            }
            if (!r.isTarget()) continue;
            this.getSink().newMatch(r);
            dispatched = true;
        }
        return dispatched;
    }

    private void dispatchCompleteMatch() {
        MatchResultImpl result2 = this.getResult();
        boolean complexMatch = this.myMatchedNodes.size() > 1;
        PsiElement match2 = this.myMatchedNodes.get(0);
        if (!complexMatch) {
            result2.setMatch(match2);
            result2.setMatchImage(match2.getText());
        } else {
            for (PsiElement matchStatement : this.myMatchedNodes) {
                result2.addChild(new MatchResultImpl("__line__", matchStatement.getText(), matchStatement, 0, -1, false));
            }
            result2.setMatch(match2);
            result2.setMatchImage(match2.getText());
            result2.setName("__multi_line__");
        }
        this.getSink().newMatch(result2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/MatchContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedElementsListener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedElements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/MatchContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setOptions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setPattern";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSink";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pushMatchedElementsListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notifyMatchedElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dispatchTargetMatch";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 3 -> new IllegalStateException(string2);
        };
    }

    @FunctionalInterface
    public static interface MatchedElementsListener {
        public void matchedElements(@NotNull Collection<? extends PsiElement> var1);
    }
}

