/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.XmlStubBasedElement;
import com.intellij.psi.impl.source.xml.XmlTagDelegate;
import com.intellij.psi.impl.source.xml.XmlTagValueImpl;
import com.intellij.psi.impl.source.xml.stub.XmlTagStub;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class XmlStubBasedTagBase<StubT extends XmlTagStub<?>>
extends XmlStubBasedElement<StubT>
implements XmlTag,
HintedReferenceHost,
StubBasedPsiElement<StubT> {
    @Nullable
    private volatile XmlTagDelegate myImpl;
    private volatile XmlTagValue myValue;
    private volatile XmlAttribute[] myAttributes;

    XmlStubBasedTagBase(@NotNull StubT stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(1);
        }
        super(stub, nodeType);
    }

    XmlStubBasedTagBase(@NotNull ASTNode node) {
        if (node == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(2);
        }
        super(node);
    }

    @NotNull
    private XmlTagDelegate getImpl() {
        XmlTagDelegate impl = this.myImpl;
        if (impl != null) {
            XmlTagDelegate xmlTagDelegate = impl;
            if (xmlTagDelegate == null) {
                XmlStubBasedTagBase.$$$reportNull$$$0(3);
            }
            return xmlTagDelegate;
        }
        this.myImpl = impl = this.createDelegate();
        XmlTagDelegate xmlTagDelegate = impl;
        if (xmlTagDelegate == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(4);
        }
        return xmlTagDelegate;
    }

    protected XmlTagDelegate createDelegate() {
        return new XmlStubBasedTagDelegate();
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myImpl = null;
        this.myValue = null;
        this.myAttributes = null;
    }

    @Override
    public PsiElement getContext() {
        XmlTagStub stub = (XmlTagStub)this.getStub();
        if (stub != null && !(stub instanceof PsiFileStub)) {
            return stub.getParentStub().getPsi();
        }
        return super.getParent();
    }

    @Deprecated
    public final PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = this.getReferences(PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    public boolean shouldAskParentForReferences(@NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(6);
        }
        return false;
    }

    public PsiReference @NotNull [] getReferences(@NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(7);
        }
        PsiReference[] psiReferenceArray = this.getImpl().getDefaultReferences(hints);
        if (psiReferenceArray == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(8);
        }
        return psiReferenceArray;
    }

    @Override
    public XmlNSDescriptor getNSDescriptor(String namespace, boolean strict) {
        return this.getImpl().getNSDescriptor(namespace, strict);
    }

    @Override
    public boolean isEmpty() {
        return XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this.getNode()) == null;
    }

    @Override
    public void collapseIfEmpty() {
        this.getImpl().collapseIfEmpty();
    }

    @Override
    @Nullable
    @NonNls
    public String getSubTagText(@NonNls String qname) {
        XmlTag tag = this.findFirstSubTag(qname);
        if (tag == null) {
            return null;
        }
        return tag.getValue().getText();
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences(PsiReferenceService.Hints.NO_HINTS));
    }

    @Override
    public XmlElementDescriptor getDescriptor() {
        return this.getImpl().getDescriptor();
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.getImpl().getName();
        if (string2 == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(9);
        }
        return string2;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(10);
        }
        return this.getImpl().setName(name);
    }

    @Override
    public XmlAttribute @NotNull [] getAttributes() {
        XmlAttribute[] attributes = this.myAttributes;
        if (attributes == null) {
            this.myAttributes = attributes = this.getImpl().calculateAttributes();
        }
        XmlAttribute[] xmlAttributeArray = (XmlAttribute[])attributes.clone();
        if (xmlAttributeArray == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(11);
        }
        return xmlAttributeArray;
    }

    @Override
    public String getAttributeValue(String qname) {
        return this.getImpl().getAttributeValue(qname);
    }

    @Override
    public String getAttributeValue(String _name, String namespace) {
        return this.getImpl().getAttributeValue(_name, namespace);
    }

    @Override
    public XmlTag @NotNull [] getSubTags() {
        XmlTag[] xmlTagArray = this.getSubTags(XmlStubBasedTagBase.shouldProcessIncludesNow());
        if (xmlTagArray == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(12);
        }
        return xmlTagArray;
    }

    private XmlTag[] getSubTags(boolean processIncludes) {
        return this.getImpl().getSubTags(processIncludes);
    }

    public static boolean shouldProcessIncludesNow() {
        return FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() == null && !XmlUtil.isStubBuilding();
    }

    @Override
    public XmlTag @NotNull [] findSubTags(@NotNull String name) {
        if (name == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(13);
        }
        XmlTag[] xmlTagArray = this.findSubTags(name, null);
        if (xmlTagArray == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(14);
        }
        return xmlTagArray;
    }

    @Override
    public XmlTag @NotNull [] findSubTags(@NotNull String name, @Nullable String namespace) {
        if (name == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(15);
        }
        XmlTag[] xmlTagArray = this.getImpl().findSubTags(name, namespace);
        if (xmlTagArray == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(16);
        }
        return xmlTagArray;
    }

    @Override
    public XmlTag findFirstSubTag(String name) {
        return this.getImpl().findFirstSubTag(name);
    }

    @Override
    public XmlAttribute getAttribute(String name, String namespace) {
        return this.getImpl().getAttribute(name, namespace);
    }

    @Override
    @Nullable
    public XmlAttribute getAttribute(String qname) {
        return this.getImpl().getAttribute(qname);
    }

    @Override
    @NotNull
    public String getNamespace() {
        String string2 = (String)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.getNamespaceByPrefix(this.getNamespacePrefix()), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (string2 == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(17);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getNamespacePrefix() {
        String string2 = this.getImpl().getNamespacePrefix(this.getName());
        if (string2 == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getNamespaceByPrefix(String prefix) {
        String string2 = this.getImpl().getNamespaceByPrefix(prefix);
        if (string2 == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(19);
        }
        return string2;
    }

    @Override
    public String getPrefixByNamespace(String namespace) {
        return this.getImpl().getPrefixByNamespace(namespace);
    }

    @Override
    public String[] knownNamespaces() {
        return this.getImpl().knownNamespaces();
    }

    @Override
    @NotNull
    public String getLocalName() {
        String string2 = this.getImpl().getLocalName();
        if (string2 == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(20);
        }
        return string2;
    }

    @Override
    public boolean hasNamespaceDeclarations() {
        return this.getImpl().hasNamespaceDeclarations();
    }

    @Override
    @NotNull
    public Map<String, String> getLocalNamespaceDeclarations() {
        Map<String, String> map = this.getImpl().getLocalNamespaceDeclarations();
        if (map == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(21);
        }
        return map;
    }

    @Override
    public XmlAttribute setAttribute(String qname, String value) throws IncorrectOperationException {
        return this.getImpl().setAttribute(qname, value);
    }

    @Override
    public XmlAttribute setAttribute(String name, String namespace, String value) throws IncorrectOperationException {
        return this.getImpl().setAttribute(name, namespace, value);
    }

    @Override
    public XmlTag createChildTag(String localName, String namespace, String bodyText, boolean enforceNamespacesDeep) {
        return XmlUtil.createChildTag(this, localName, namespace, bodyText, enforceNamespacesDeep, this.getImpl()::createTagFromText);
    }

    protected XmlTagValue createXmlTagValue() {
        return XmlTagValueImpl.createXmlTagValue(this);
    }

    @Override
    public XmlTag addSubTag(XmlTag subTag, boolean first) {
        return this.getImpl().addSubTag(subTag, first);
    }

    @Override
    @NotNull
    public XmlTagValue getValue() {
        XmlTagValue tagValue = this.myValue;
        if (tagValue == null) {
            this.myValue = tagValue = this.createXmlTagValue();
        }
        XmlTagValue xmlTagValue = tagValue;
        if (xmlTagValue == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(22);
        }
        return xmlTagValue;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(23);
        }
        if (visitor2 instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor2).visitXmlTag(this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "XmlTag:" + this.getName();
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMeta((PsiElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean beforeB) {
        if (!(first instanceof TreeElement)) {
            return null;
        }
        TreeElement firstAppended = null;
        boolean before2 = beforeB == null || beforeB != false;
        try {
            TreeElement next;
            do {
                next = ((TreeElement)first).getTreeNext();
                if (firstAppended == null) {
                    firstAppended = this.getImpl().addInternal((TreeElement)first, anchor, before2);
                    anchor = firstAppended;
                    continue;
                }
                anchor = this.getImpl().addInternal((TreeElement)first, anchor, false);
            } while (first != last && (first = next) != null);
        }
        finally {
            this.subtreeChanged();
        }
        return firstAppended;
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(24);
        }
        this.getImpl().deleteChildInternal(child);
    }

    protected void deleteChildInternalSuper(@NotNull ASTNode child) {
        if (child == null) {
            XmlStubBasedTagBase.$$$reportNull$$$0(25);
        }
        super.deleteChildInternal(child);
    }

    protected TreeElement addInternalSuper(TreeElement first, ASTNode last, @Nullable ASTNode anchor, @Nullable Boolean before2) {
        return (TreeElement)super.addInternal((ASTNode)first, last, anchor, before2);
    }

    @Override
    public XmlTag getParentTag() {
        PsiElement parent = this.getParentByStub();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    @Override
    public XmlTagChild getNextSiblingInTag() {
        PsiElement nextSibling = this.getNextSibling();
        if (nextSibling instanceof XmlTagChild) {
            return (XmlTagChild)nextSibling;
        }
        return null;
    }

    @Override
    public XmlTagChild getPrevSiblingInTag() {
        PsiElement prevSibling = this.getPrevSibling();
        return prevSibling instanceof XmlTagChild ? (XmlTagChild)prevSibling : null;
    }

    public Icon getElementIcon(int flags) {
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.Tag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 8, 9, 11, 12, 14, 16, 17, 18, 19, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlStubBasedTagBase";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlStubBasedTagBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImpl";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubTags";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findSubTags";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacePrefix";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceByPrefix";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalNamespaceDeclarations";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldAskParentForReferences";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findSubTags";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternalSuper";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 5, 8, 9, 11, 12, 14, 16, 17, 18, 19, 20, 21, 22 -> new IllegalStateException(string2);
        };
    }

    protected class XmlStubBasedTagDelegate
    extends XmlTagDelegate {
        public XmlStubBasedTagDelegate() {
            super(XmlStubBasedTagBase.this);
        }

        @Override
        protected void deleteChildInternalSuper(@NotNull ASTNode child) {
            if (child == null) {
                XmlStubBasedTagDelegate.$$$reportNull$$$0(0);
            }
            XmlStubBasedTagBase.this.deleteChildInternalSuper(child);
        }

        @Override
        protected TreeElement addInternalSuper(TreeElement first, ASTNode last, @Nullable ASTNode anchor, @Nullable Boolean before2) {
            return XmlStubBasedTagBase.this.addInternalSuper(first, last, anchor, before2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/xml/XmlStubBasedTagBase$XmlStubBasedTagDelegate", "deleteChildInternalSuper"));
        }
    }
}

