/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.ProcessingContext;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspxIncludePathReferenceProvider
extends PsiReferenceProvider
implements CustomizableReferenceProvider {
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            JspxIncludePathReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JspxIncludePathReferenceProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof XmlAttributeValue) {
            XmlAttributeValue attributeValue2 = (XmlAttributeValue)element;
            String valueString = attributeValue2.getValue();
            if (valueString.indexOf(63) >= 0) {
                return this.getReferencesByString(valueString.substring(0, valueString.indexOf(63)), attributeValue2, 1);
            }
            return this.getReferencesByString(valueString, attributeValue2, 1);
        }
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            XmlTagValue value = tag.getValue();
            String text2 = value.getText();
            String trimmedText = text2.trim();
            return this.getReferencesByString(trimmedText, tag, value.getTextRange().getStartOffset() + text2.indexOf(trimmedText) - element.getTextOffset());
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            JspxIncludePathReferenceProvider.$$$reportNull$$$0(2);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private PsiReference @NotNull [] getReferencesByString(String str, @NotNull PsiElement position, int offsetInPosition) {
        if (position == null) {
            JspxIncludePathReferenceProvider.$$$reportNull$$$0(3);
        }
        PsiReference[] psiReferenceArray = JspxIncludePathReferenceProvider.getFileReferencesFromString(str, position, offsetInPosition, this);
        if (psiReferenceArray == null) {
            JspxIncludePathReferenceProvider.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    public static PsiReference[] getFileReferencesFromString(String str, @NotNull PsiElement position, int offsetInPosition, PsiReferenceProvider provider) {
        if (position == null) {
            JspxIncludePathReferenceProvider.$$$reportNull$$$0(5);
        }
        return JspxIncludePathReferenceProvider.getFileReferenceSet(str, position, offsetInPosition, provider).getAllReferences();
    }

    public static FileReferenceSet getFileReferenceSet(String str, @NotNull PsiElement position, int offsetInPosition, PsiReferenceProvider provider) {
        if (position == null) {
            JspxIncludePathReferenceProvider.$$$reportNull$$$0(6);
        }
        return new FileReferenceSet(str, position, offsetInPosition, provider, true){

            protected boolean useIncludingFileAsContext() {
                return false;
            }
        };
    }

    @Nullable
    public Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspxIncludePathReferenceProvider";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspxIncludePathReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileReferencesFromString";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileReferenceSet";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 4 -> new IllegalStateException(string2);
        };
    }
}

