/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeManipulator
extends AbstractElementManipulator<XmlAttribute> {
    private static final Logger LOG = Logger.getInstance(XmlAttributeManipulator.class);

    public XmlAttribute handleContentChange(@NotNull XmlAttribute attribute, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (attribute == null) {
            XmlAttributeManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            XmlAttributeManipulator.$$$reportNull$$$0(1);
        }
        String attr = attribute.getText();
        ASTNode astNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attribute.getNode());
        assert (astNode != null);
        PsiElement namePsi = astNode.getPsi();
        int startOffsetInParent = namePsi.getStartOffsetInParent();
        TextRange nameRange = new TextRange(startOffsetInParent, startOffsetInParent + namePsi.getTextLength());
        if (nameRange.contains(range)) {
            String content2 = attr.substring(0, range.getStartOffset()) + newContent + attr.substring(range.getEndOffset(), nameRange.getEndOffset());
            attribute.setName(content2);
        } else {
            XmlAttributeValue value = attribute.getValueElement();
            if (value == null) {
                assert (range.getStartOffset() == 0 && range.getEndOffset() == 0);
                attribute.setValue(newContent);
                return attribute;
            }
            StringBuilder replacement = new StringBuilder(value.getText());
            int offset = value.getTextRange().getStartOffset() - attribute.getTextRange().getStartOffset();
            replacement.replace(range.getStartOffset() - offset, range.getEndOffset() - offset, newContent);
            attribute.setValue(replacement.toString());
        }
        return attribute;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull XmlAttribute attribute) {
        XmlAttributeValue value;
        if (attribute == null) {
            XmlAttributeManipulator.$$$reportNull$$$0(2);
        }
        if ((value = attribute.getValueElement()) == null) {
            TextRange textRange = TextRange.from((int)0, (int)0);
            if (textRange == null) {
                XmlAttributeManipulator.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        TextRange range = attribute.getValueTextRange();
        TextRange textRange = range.shiftRight(value.getStartOffsetInParent());
        if (textRange == null) {
            XmlAttributeManipulator.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeManipulator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4 -> new IllegalStateException(string2);
        };
    }
}

