/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.whatsNew;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.HTMLEditorProvider;
import com.intellij.platform.whatsNew.WhatsNewAction;
import com.intellij.platform.whatsNew.WhatsNewContent;
import com.intellij.platform.whatsNew.WhatsNewContentKt;
import com.intellij.util.Urls;
import com.intellij.util.ui.StartupUiUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/whatsNew/WhatsNewUrlContent;", "Lcom/intellij/platform/whatsNew/WhatsNewContent;", "url", "", "(Ljava/lang/String;)V", "linkRegEx", "Lkotlin/text/Regex;", "getUrl", "()Ljava/lang/String;", "checkConnectionAvailable", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getActionWhiteList", "", "getRequest", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$Request;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getVersion", "Lcom/intellij/platform/whatsNew/WhatsNewContent$ContentVersion;", "isAvailable", "parseUrl", "link", "Companion", "intellij.platform.whatsNew"})
@SourceDebugExtension(value={"SMAP\nWhatsNewContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhatsNewContent.kt\ncom/intellij/platform/whatsNew/WhatsNewUrlContent\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,304:1\n13#2:305\n*S KotlinDebug\n*F\n+ 1 WhatsNewContent.kt\ncom/intellij/platform/whatsNew/WhatsNewUrlContent\n*L\n133#1:305\n*E\n"})
public final class WhatsNewUrlContent
extends WhatsNewContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final Regex linkRegEx;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Set<String> actionWhiteList;

    public WhatsNewUrlContent(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        super(null);
        this.url = url;
        this.linkRegEx = new Regex("^https://www\\.jetbrains\\.com/[a-zA-Z]+/whatsnew(-eap)?/(\\d+)-(\\d+)-(\\d+)/$");
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    private final WhatsNewContent.ContentVersion parseUrl(String link) {
        WhatsNewContent.ContentVersion contentVersion;
        WhatsNewContent.ContentVersion parseResult;
        MatchResult matchResult = this.linkRegEx.matchEntire((CharSequence)link);
        if (matchResult != null) {
            MatchResult it = matchResult;
            boolean bl = false;
            Object object = it.getGroups().get(it.getGroups().size() - 3);
            if (object == null || (object = object.getValue()) == null) {
                v2 = null;
            } else {
                int year = Integer.parseInt((String)object);
                Object object2 = it.getGroups().get(it.getGroups().size() - 2);
                if (object2 == null || (object2 = object2.getValue()) == null) {
                    v2 = null;
                } else {
                    int release = Integer.parseInt((String)object2);
                    Object object3 = it.getGroups().get(it.getGroups().size() - 1);
                    if (object3 == null || (object3 = object3.getValue()) == null) {
                        v2 = null;
                    } else {
                        int eap = Integer.parseInt((String)object3);
                        v2 = new WhatsNewContent.ContentVersion(year, release, eap, null);
                    }
                }
            }
        } else {
            v2 = parseResult = null;
        }
        if (parseResult == null) {
            LOG.warn("Cannot parse IDE version for What's New content from URL: \"" + link + "\".");
        }
        if ((contentVersion = parseResult) == null) {
            if (ApplicationInfo.getInstance().isEAP()) {
                contentVersion = null;
            } else {
                ApplicationInfo it = ApplicationInfo.getInstance();
                boolean bl = false;
                String string2 = it.getMajorVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMajorVersion(...)");
                int n = Integer.parseInt(string2);
                String string3 = it.getMinorVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMinorVersion(...)");
                contentVersion = new WhatsNewContent.ContentVersion(n, Integer.parseInt(string3), null, null);
            }
        }
        return contentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public HTMLEditorProvider.Request getRequest(@Nullable DataContext dataContext) {
        HashMap parameters = new HashMap();
        ((Map)parameters).put("var", "embed");
        if (StartupUiUtil.INSTANCE.isDarkTheme()) {
            ((Map)parameters).put("theme", "dark");
        }
        ((Map)parameters).put("lang", WhatsNewContentKt.getCurrentLanguageTag());
        String string2 = Urls.newFromEncoded((String)this.url).addParameters((Map)parameters).toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toExternalForm(...)");
        HTMLEditorProvider.Request request = HTMLEditorProvider.Request.Companion.url(string2);
        try {
            Closeable closeable = WhatsNewAction.class.getResourceAsStream("whatsNewTimeoutText.html");
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl = false;
                if (stream != null) {
                    byte[] byArray = stream.readAllBytes();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                    byte[] byArray2 = byArray;
                    Intrinsics.checkNotNullExpressionValue((Object)StandardCharsets.UTF_8, (String)"UTF_8");
                    Object[] objectArray = StandardCharsets.UTF_8;
                    String string3 = StringsKt.replace$default((String)new String(byArray2, (Charset)objectArray), (String)"__THEME__", (String)(StartupUiUtil.INSTANCE.isDarkTheme() ? "theme-dark" : ""), (boolean)false, (int)4, null);
                    String string4 = IdeBundle.message((String)"whats.new.timeout.title", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                    String string5 = StringsKt.replace$default((String)string3, (String)"__TITLE__", (String)string4, (boolean)false, (int)4, null);
                    String string6 = IdeBundle.message((String)"whats.new.timeout.message", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
                    String string7 = StringsKt.replace$default((String)string5, (String)"__MESSAGE__", (String)string6, (boolean)false, (int)4, null);
                    objectArray = new Object[]{this.url};
                    String string8 = IdeBundle.message((String)"whats.new.timeout.action", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
                    request.withTimeoutHtml(StringsKt.replace$default((String)string7, (String)"__ACTION__", (String)string8, (boolean)false, (int)4, null));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        request.withQueryHandler(this.getHandler(dataContext));
        return request;
    }

    @Override
    @NotNull
    public Set<String> getActionWhiteList() {
        return actionWhiteList;
    }

    @Override
    @Nullable
    public WhatsNewContent.ContentVersion getVersion() {
        return this.parseUrl(this.url);
    }

    @Override
    @Nullable
    public Object isAvailable(@NotNull Continuation<? super Boolean> $completion) {
        return this.checkConnectionAvailable($completion);
    }

    private final Object checkConnectionAvailable(Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, null){
            int label;
            final /* synthetic */ WhatsNewUrlContent this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean bl;
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            boolean bl2;
                            URLConnection uRLConnection = new URL(this.this$0.getUrl()).openConnection();
                            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                            connection.setConnectTimeout(5000);
                            connection.setInstanceFollowRedirects(false);
                            connection.connect();
                            if (connection.getResponseCode() != 200) {
                                WhatsNewUrlContent.Companion.getLOG().warn("WhatsNew page '" + this.this$0.getUrl() + "' not available response code: " + connection.getResponseCode());
                                bl2 = false;
                            } else {
                                bl2 = true;
                            }
                            bl = bl2;
                        }
                        catch (Exception e) {
                            WhatsNewUrlContent.Companion.getLOG().warn("WhatsNew page connection error: '" + e);
                            bl = false;
                        }
                        return Boxing.boxBoolean((bl ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final /* synthetic */ Object access$checkConnectionAvailable(WhatsNewUrlContent $this, Continuation $completion) {
        return $this.checkConnectionAvailable((Continuation<? super Boolean>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WhatsNewUrlContent.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new String[]{"SearchEverywhere", "ChangeLaf", "ChangeIdeScale", "SettingsSyncOpenSettingsAction", "BuildWholeSolutionAction", "GitLab.Open.Settings.Page", "AIAssistant.ToolWindow.ShowOrFocus", "ChangeMainToolbarColor", "ShowEapDiagram", "multilaunch.RunMultipleProjects", "EfCore.Shared.OpenQuickEfCoreActionsAction", "OpenNewTerminalEAP", "CollectionsVisualizerEAP", "ShowDebugMonitoringToolEAP", "LearnMoreStickyScrollEAP", "NewRiderProject", "BlazorHotReloadEAP"};
        actionWhiteList = SetsKt.mutableSetOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/whatsNew/WhatsNewUrlContent$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "actionWhiteList", "", "", "intellij.platform.whatsNew"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

