/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.whatsNew;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.whatsNew.WhatsNewContent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/platform/whatsNew/WhatsNewContentVersionChecker;", "", "()V", "Companion", "intellij.platform.whatsNew"})
@SourceDebugExtension(value={"SMAP\nWhatsNewContentVersionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhatsNewContentVersionChecker.kt\ncom/intellij/platform/whatsNew/WhatsNewContentVersionChecker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,43:1\n13#2:44\n*S KotlinDebug\n*F\n+ 1 WhatsNewContentVersionChecker.kt\ncom/intellij/platform/whatsNew/WhatsNewContentVersionChecker\n*L\n9#1:44\n*E\n"})
public final class WhatsNewContentVersionChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String LAST_SHOWN_EAP_VERSION_PROP = "whats.new.last.shown.version";

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WhatsNewContentVersionChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/whatsNew/WhatsNewContentVersionChecker$Companion;", "", "()V", "LAST_SHOWN_EAP_VERSION_PROP", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "isNeedToShowContent", "", "whatsNewContent", "Lcom/intellij/platform/whatsNew/WhatsNewContent;", "saveLastShownContent", "", "content", "intellij.platform.whatsNew"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isNeedToShowContent(@NotNull WhatsNewContent whatsNewContent) {
            Intrinsics.checkNotNullParameter((Object)whatsNewContent, (String)"whatsNewContent");
            String string2 = PropertiesComponent.getInstance().getValue(WhatsNewContentVersionChecker.LAST_SHOWN_EAP_VERSION_PROP);
            if (string2 == null) {
                Companion $this$isNeedToShowContent_u24lambda_u240 = this;
                boolean bl = false;
                LOG.info("whats.new.last.shown.version is not defined. Will show What's New.");
                return true;
            }
            String savedVersionInfo = string2;
            WhatsNewContent.ContentVersion contentVersion = WhatsNewContent.ContentVersion.Companion.parse(savedVersionInfo);
            if (contentVersion == null) {
                Companion $this$isNeedToShowContent_u24lambda_u241 = this;
                boolean bl = false;
                LOG.warn("Cannot parse last shown What's New version: \"" + savedVersionInfo + "\". Will show What's new as fallback.");
                return true;
            }
            WhatsNewContent.ContentVersion savedVersion = contentVersion;
            WhatsNewContent.ContentVersion contentVersion2 = whatsNewContent.getVersion();
            if (contentVersion2 == null) {
                Companion $this$isNeedToShowContent_u24lambda_u242 = this;
                boolean bl = false;
                LOG.warn("What's New content provider returns null version. What's New will be ignored.");
                return false;
            }
            WhatsNewContent.ContentVersion newVersion = contentVersion2;
            boolean result2 = newVersion.compareTo(savedVersion) > 0 || newVersion.releaseInfoEquals(savedVersion) && !Intrinsics.areEqual((Object)newVersion.getHash(), (Object)savedVersion.getHash());
            LOG.info("Comparing versions " + newVersion + " > " + savedVersion + ": " + result2 + ".");
            return result2;
        }

        public final void saveLastShownContent(@NotNull WhatsNewContent content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            LOG.info("EapWhatsNew version saved '" + content2.getVersion() + "'");
            WhatsNewContent.ContentVersion contentVersion = content2.getVersion();
            if (contentVersion == null) {
                Companion $this$saveLastShownContent_u24lambda_u243 = this;
                boolean bl = false;
                LOG.error("What's New content " + content2 + " returned a null version.");
                return;
            }
            WhatsNewContent.ContentVersion version = contentVersion;
            PropertiesComponent.getInstance().setValue(WhatsNewContentVersionChecker.LAST_SHOWN_EAP_VERSION_PROP, version.toString());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

