/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.impl.ngram.model;

import com.intellij.platform.ml.impl.ngram.model.NGramModel;
import com.intellij.platform.ml.impl.ngram.model.NGramModelKt;
import com.intellij.platform.ml.impl.ngram.model.NGramToken;
import com.intellij.platform.ml.impl.ngram.model.counter.NGramCounter;
import com.intellij.platform.ml.impl.ngram.model.counter.NGramHashMapCounter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u0010*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0010B\u001d\b\u0002\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J2\u0010\b\u001a\u00020\t2 \u0010\n\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\f0\u000bj\n\u0012\u0006\b\u0001\u0012\u00028\u0000`\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u001e\u0010\u000f\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/ml/impl/ngram/model/SimpleNGramModel;", "T", "Lcom/intellij/platform/ml/impl/ngram/model/NGramModel;", "ngramCounter", "Lcom/intellij/platform/ml/impl/ngram/model/counter/NGramCounter;", "ngramSize", "", "(Lcom/intellij/platform/ml/impl/ngram/model/counter/NGramCounter;I)V", "scoreNGram", "", "input", "", "Lcom/intellij/platform/ml/impl/ngram/model/NGramToken;", "Lcom/intellij/platform/ml/impl/ngram/model/NGram;", "tokenIndex", "scoreToken", "Companion", "intellij.platform.ml.impl"})
public final class SimpleNGramModel<T>
extends NGramModel<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private SimpleNGramModel(NGramCounter<T> ngramCounter2, int ngramSize) {
        super(ngramCounter2, ngramSize);
    }

    @Override
    public double scoreToken(@NotNull List<? extends T> input, int tokenIndex) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        List ngram = NGramModelKt.toNGram((Collection)input, false);
        int tokenInNGramIndex = tokenIndex + 1;
        return this.scoreNGram(ngram, tokenInNGramIndex);
    }

    private final double scoreNGram(List<? extends NGramToken<? extends T>> input, int tokenIndex) {
        int minIndex = RangesKt.coerceAtLeast((int)(tokenIndex - this.getNgramSize() + 1), (int)0);
        List<? extends NGramToken<? extends T>> inputWithToken = input.subList(minIndex, tokenIndex + 1);
        List<? extends NGramToken<? extends T>> prefix = input.subList(minIndex, tokenIndex);
        int inputFrequency = this.getNGramCounter().getFrequencyOf(inputWithToken);
        int prefixFrequency = this.getNGramCounter().getFrequencyOf(prefix);
        return (double)inputFrequency / (double)prefixFrequency;
    }

    public /* synthetic */ SimpleNGramModel(NGramCounter ngramCounter2, int ngramSize, DefaultConstructorMarker $constructor_marker) {
        this(ngramCounter2, ngramSize);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\b0\u00072\u0006\u0010\t\u001a\u00020\nJ0\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\b0\u000b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/ml/impl/ngram/model/SimpleNGramModel$Companion;", "", "()V", "train", "Lcom/intellij/platform/ml/impl/ngram/model/NGramModel;", "T", "tokens", "", "", "ngramSize", "", "Lkotlin/sequences/Sequence;", "intellij.platform.ml.impl"})
    @SourceDebugExtension(value={"SMAP\nSimpleNGramModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleNGramModel.kt\ncom/intellij/platform/ml/impl/ngram/model/SimpleNGramModel$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1055#2:67\n1#3:68\n*S KotlinDebug\n*F\n+ 1 SimpleNGramModel.kt\ncom/intellij/platform/ml/impl/ngram/model/SimpleNGramModel$Companion\n*L\n59#1:67\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> NGramModel<T> train(@NotNull Collection<? extends List<? extends T>> tokens, int ngramSize) {
            Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
            return this.train(CollectionsKt.asSequence((Iterable)tokens), ngramSize);
        }

        /*
         * WARNING - void declaration
         */
        private final <T> NGramModel<T> train(Sequence<? extends List<? extends T>> tokens, int ngramSize) {
            void $this$groupingBy$iv;
            Sequence sequence = SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.mapNotNull(tokens, (Function1)new Function1<List<? extends T>, List<? extends List<? extends NGramToken<? extends T>>>>(ngramSize){
                final /* synthetic */ int $ngramSize;
                {
                    this.$ngramSize = $ngramSize;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final List<List<NGramToken<? extends T>>> invoke(@NotNull List<? extends T> token) {
                    List list2;
                    List list3;
                    List<T> list4;
                    List<Object> list5;
                    Intrinsics.checkNotNullParameter(token, (String)"token");
                    List<T> it = list5 = token;
                    boolean bl2 = false;
                    List<Object> list6 = list4 = !((Collection)it).isEmpty() ? list5 : null;
                    if (list4 != null && (list5 = NGramModelKt.toNGram((Collection)list4, true)) != null && (list3 = CollectionsKt.windowed$default((Iterable)list5, (int)this.$ngramSize, (int)0, (boolean)true, (int)2, null)) != null) {
                        void $this$filterNotTo$iv$iv;
                        void $this$filterNot$iv;
                        Iterable bl2 = list3;
                        int n = this.$ngramSize;
                        boolean $i$f$filterNot = false;
                        void var8_9 = $this$filterNot$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterNotTo = false;
                        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                            List it2 = (List)element$iv$iv;
                            boolean bl3 = false;
                            if (it2.size() < n && !(CollectionsKt.first((List)it2) instanceof NGramToken.StartOfSentence)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        list2 = (List)destination$iv$iv;
                    } else {
                        list2 = null;
                    }
                    return list2;
                }
            }));
            boolean $i$f$groupingBy = false;
            Map it = GroupingKt.eachCount((Grouping)new Grouping<List<? extends NGramToken<? extends T>>, List<? extends NGramToken<? extends T>>>((Sequence)$this$groupingBy$iv){
                final /* synthetic */ Sequence $this_groupingBy;
                {
                    this.$this_groupingBy = $receiver;
                }

                @NotNull
                public Iterator<List<? extends NGramToken<? extends T>>> sourceIterator() {
                    return this.$this_groupingBy.iterator();
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public Object keyOf(Object element) {
                    void var2_2;
                    List it = (List)element;
                    boolean bl = false;
                    return var2_2;
                }
            });
            boolean bl = false;
            NGramHashMapCounter ngramCounter2 = new NGramHashMapCounter(it, ngramSize);
            return new SimpleNGramModel(ngramCounter2, ngramSize, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

