/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.CurrentRevisionProvider;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContentRevisionCache {
    private final Object myLock = new Object();
    private final Cache<Key, byte[]> myCache = Caffeine.newBuilder().maximumSize(100L).softValues().build();
    private final Map<Key, byte[]> myConstantCache = new HashMap<Key, byte[]>();

    private void put(@NotNull FilePath path2, @NotNull VcsRevisionNumber number, @NotNull VcsKey vcsKey, @NotNull UniqueType type2, byte @Nullable [] bytes) {
        if (path2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(0);
        }
        if (number == null) {
            ContentRevisionCache.$$$reportNull$$$0(1);
        }
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(2);
        }
        if (type2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(3);
        }
        if (bytes != null) {
            this.myCache.put((Object)new Key(path2, number, vcsKey, type2), (Object)bytes);
        }
    }

    @Contract(value="!null, _, _ -> !null")
    @Nullable
    public static String getAsString(byte @Nullable [] bytes, @NotNull FilePath file, @Nullable Charset charset) {
        if (file == null) {
            ContentRevisionCache.$$$reportNull$$$0(4);
        }
        if (bytes == null) {
            return null;
        }
        if (charset == null) {
            return ContentRevisionCache.bytesToString(file, bytes);
        }
        return CharsetToolkit.bytesToString((byte[])bytes, (Charset)charset);
    }

    @NotNull
    private static String bytesToString(FilePath path2, byte @NotNull [] bytes) {
        if (bytes == null) {
            ContentRevisionCache.$$$reportNull$$$0(5);
        }
        Charset charset = null;
        if (path2.getVirtualFile() != null) {
            charset = path2.getVirtualFile().getCharset();
        }
        if (charset != null) {
            int bomLength = CharsetToolkit.getBOMLength((byte[])bytes, (Charset)charset);
            CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(bytes, bomLength, bytes.length - bomLength));
            String string2 = charBuffer.toString();
            if (string2 == null) {
                ContentRevisionCache.$$$reportNull$$$0(6);
            }
            return string2;
        }
        String string3 = CharsetToolkit.bytesToString((byte[])bytes, (Charset)EncodingRegistry.getInstance().getDefaultCharset());
        if (string3 == null) {
            ContentRevisionCache.$$$reportNull$$$0(7);
        }
        return string3;
    }

    public byte @Nullable [] getBytes(FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, @NotNull UniqueType type2) {
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(8);
        }
        if (type2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(9);
        }
        return (byte[])this.myCache.getIfPresent((Object)new Key(path2, number, vcsKey, type2));
    }

    public static byte @NotNull [] loadAsBytes(@NotNull FilePath path2, Throwable2Computable<byte @NotNull [], ? extends VcsException, ? extends IOException> loader) throws VcsException, IOException {
        if (path2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(10);
        }
        ContentRevisionCache.checkLocalFileSize(path2);
        byte[] byArray = (byte[])loader.compute();
        if (byArray == null) {
            ContentRevisionCache.$$$reportNull$$$0(11);
        }
        return byArray;
    }

    public static byte @NotNull [] getOrLoadAsBytes(@NotNull Project project2, @NotNull FilePath path2, @NotNull VcsRevisionNumber number, @NotNull VcsKey vcsKey, @NotNull UniqueType type2, @NotNull @NotNull Throwable2Computable<byte @NotNull [], ? extends VcsException, ? extends IOException> loader) throws VcsException, IOException {
        ContentRevisionCache cache;
        byte[] bytes;
        if (project2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(12);
        }
        if (path2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(13);
        }
        if (number == null) {
            ContentRevisionCache.$$$reportNull$$$0(14);
        }
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(15);
        }
        if (type2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(16);
        }
        if (loader == null) {
            ContentRevisionCache.$$$reportNull$$$0(17);
        }
        if ((bytes = (cache = ProjectLevelVcsManager.getInstance(project2).getContentRevisionCache()).getBytes(path2, number, vcsKey, type2)) != null) {
            if (bytes == null) {
                ContentRevisionCache.$$$reportNull$$$0(18);
            }
            return bytes;
        }
        bytes = cache.getFromConstantCache(path2, number, vcsKey, type2);
        if (bytes != null) {
            if (bytes == null) {
                ContentRevisionCache.$$$reportNull$$$0(19);
            }
            return bytes;
        }
        ContentRevisionCache.checkLocalFileSize(path2);
        bytes = (byte[])loader.compute();
        cache.put(path2, number, vcsKey, type2, bytes);
        if (bytes == null) {
            ContentRevisionCache.$$$reportNull$$$0(20);
        }
        return bytes;
    }

    private static void checkLocalFileSize(@NotNull FilePath path2) throws VcsException {
        File ioFile;
        if (path2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(21);
        }
        if ((ioFile = path2.getIOFile()).exists()) {
            ContentRevisionCache.checkContentsSize(ioFile.getPath(), ioFile.length());
        }
    }

    public static void checkContentsSize(String path2, long size) throws VcsException {
        if (size > (long)VcsUtil.getMaxVcsLoadedFileSize()) {
            throw new VcsException(VcsBundle.message("file.content.too.big.to.load.increase.property.suggestion", path2, StringUtil.formatFileSize((long)VcsUtil.getMaxVcsLoadedFileSize()), "idea.max.vcs.loaded.size.kb"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIntoConstantCache(@NotNull FilePath path2, @NotNull VcsRevisionNumber revisionNumber, @NotNull VcsKey vcsKey, byte[] content2) {
        if (path2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(22);
        }
        if (revisionNumber == null) {
            ContentRevisionCache.$$$reportNull$$$0(23);
        }
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(24);
        }
        Map<Key, byte[]> map = this.myConstantCache;
        synchronized (map) {
            this.myConstantCache.put(new Key(path2, revisionNumber, vcsKey, UniqueType.REPOSITORY_CONTENT), content2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFromConstantCache(@NotNull FilePath path2, @NotNull VcsRevisionNumber revisionNumber, @NotNull VcsKey vcsKey, @NotNull UniqueType type2) {
        if (path2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(25);
        }
        if (revisionNumber == null) {
            ContentRevisionCache.$$$reportNull$$$0(26);
        }
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(27);
        }
        if (type2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(28);
        }
        Map<Key, byte[]> map = this.myConstantCache;
        synchronized (map) {
            return this.myConstantCache.get(new Key(path2, revisionNumber, vcsKey, type2));
        }
    }

    public void clearConstantCache() {
        this.myConstantCache.clear();
    }

    public static Pair<VcsRevisionNumber, byte[]> getOrLoadCurrentAsBytes(@NotNull Project project2, @NotNull FilePath path2, @NotNull VcsKey vcsKey, @NotNull CurrentRevisionProvider loader) throws VcsException, IOException {
        VcsRevisionNumber currentRevision;
        Pair<VcsRevisionNumber, byte[]> loaded;
        if (project2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(29);
        }
        if (path2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(30);
        }
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(31);
        }
        if (loader == null) {
            ContentRevisionCache.$$$reportNull$$$0(32);
        }
        ContentRevisionCache cache = ProjectLevelVcsManager.getInstance(project2).getContentRevisionCache();
        do {
            byte[] cachedCurrent;
            if ((cachedCurrent = cache.getBytes(path2, currentRevision = loader.getCurrentRevision(), vcsKey, UniqueType.REPOSITORY_CONTENT)) != null) {
                return Pair.create((Object)currentRevision, (Object)cachedCurrent);
            }
            ContentRevisionCache.checkLocalFileSize(path2);
        } while (!((VcsRevisionNumber)(loaded = loader.get()).getFirst()).equals(currentRevision));
        cache.put(path2, currentRevision, vcsKey, UniqueType.REPOSITORY_CONTENT, (byte[])loaded.getSecond());
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        this.myCache.invalidateAll();
        Object object = this.myLock;
        synchronized (object) {
            this.myConstantCache.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 11, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 24: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 3: 
            case 9: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/ContentRevisionCache";
                break;
            }
            case 12: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/ContentRevisionCache";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "bytesToString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAsBytes";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrLoadAsBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAsString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bytesToString";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBytes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadAsBytes";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOrLoadAsBytes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkLocalFileSize";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "putIntoConstantCache";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFromConstantCache";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getOrLoadCurrentAsBytes";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7, 11, 18, 19, 20 -> new IllegalStateException(string2);
        };
    }

    private static final class Key
    extends CurrentKey {
        private final VcsRevisionNumber myNumber;
        private final UniqueType myType;

        private Key(FilePath path2, VcsRevisionNumber number, VcsKey vcsKey, UniqueType type2) {
            super(path2, vcsKey);
            this.myNumber = number;
            this.myType = type2;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Key key2 = (Key)o;
            return Objects.equals(this.myNumber, key2.myNumber) && this.myPath.equals(key2.myPath) && this.myType == key2.myType && this.myVcsKey.equals(key2.myVcsKey);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.myPath.hashCode();
            result2 = 31 * result2 + (this.myNumber == null ? 0 : this.myNumber.hashCode());
            result2 = 31 * result2 + this.myVcsKey.hashCode();
            result2 = 31 * result2 + this.myType.hashCode();
            return result2;
        }
    }

    public static enum UniqueType {
        REPOSITORY_CONTENT,
        REMOTE_CONTENT;

    }

    private static class CurrentKey {
        protected final FilePath myPath;
        protected final VcsKey myVcsKey;

        private CurrentKey(FilePath path2, VcsKey vcsKey) {
            this.myPath = path2;
            this.myVcsKey = vcsKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CurrentKey that = (CurrentKey)o;
            return Objects.equals(this.myPath, that.myPath) && Objects.equals(this.myVcsKey, that.myVcsKey);
        }

        public int hashCode() {
            int result2 = this.myPath != null ? this.myPath.hashCode() : 0;
            result2 = 31 * result2 + (this.myVcsKey != null ? this.myVcsKey.hashCode() : 0);
            return result2;
        }
    }
}

