/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.JBIterable;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangesUtil {
    private static final Key<Boolean> INTERNAL_OPERATION_KEY = Key.create((String)"internal vcs operation");
    public static final HashingStrategy<FilePath> CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY = new HashingStrategy<FilePath>(){

        public int hashCode(@Nullable FilePath path2) {
            return path2 != null ? Objects.hash(path2.getPath(), path2.isDirectory()) : 0;
        }

        public boolean equals(@Nullable FilePath path1, @Nullable FilePath path2) {
            if (path1 == path2) {
                return true;
            }
            if (path1 == null || path2 == null) {
                return false;
            }
            return path1.isDirectory() == path2.isDirectory() && path1.getPath().equals(path2.getPath());
        }
    };
    public static final Comparator<LocalChangeList> CHANGELIST_COMPARATOR = Comparator.comparingInt(list2 -> list2.isDefault() ? -1 : 0).thenComparing(list2 -> list2.getName(), String::compareToIgnoreCase);

    private ChangesUtil() {
    }

    @NotNull
    public static FilePath getFilePath(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(0);
        }
        if ((revision = change.getAfterRevision()) == null) {
            revision = change.getBeforeRevision();
            assert (revision != null);
        }
        FilePath filePath = revision.getFile();
        if (filePath == null) {
            ChangesUtil.$$$reportNull$$$0(1);
        }
        return filePath;
    }

    @Nullable
    public static FilePath getBeforePath(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(2);
        }
        return (revision = change.getBeforeRevision()) == null ? null : revision.getFile();
    }

    @Nullable
    public static FilePath getAfterPath(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(3);
        }
        return (revision = change.getAfterRevision()) == null ? null : revision.getFile();
    }

    @Nullable
    public static AbstractVcs getVcsForChange(@NotNull Change change, @NotNull Project project2) {
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(5);
        }
        return ProjectLevelVcsManager.getInstance(project2).getVcsFor(ChangesUtil.getFilePath(change));
    }

    @NotNull
    public static Set<AbstractVcs> getAffectedVcses(@NotNull Collection<? extends Change> changes, @NotNull Project project2) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(7);
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance(project2);
        Set set = ContainerUtil.map2SetNotNull(changes, change -> vcsManager.getVcsFor(ChangesUtil.getFilePath(change)));
        if (set == null) {
            ChangesUtil.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public static Set<AbstractVcs> getAffectedVcsesForFilePaths(@NotNull Collection<? extends FilePath> files, @NotNull Project project2) {
        if (files == null) {
            ChangesUtil.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(10);
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance(project2);
        Set set = ContainerUtil.map2SetNotNull(files, file -> vcsManager.getVcsFor((FilePath)file));
        if (set == null) {
            ChangesUtil.$$$reportNull$$$0(11);
        }
        return set;
    }

    @Nullable
    public static AbstractVcs getVcsForFile(@NotNull VirtualFile file, @NotNull Project project2) {
        if (file == null) {
            ChangesUtil.$$$reportNull$$$0(12);
        }
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(13);
        }
        return ProjectLevelVcsManager.getInstance(project2).getVcsFor(file);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static AbstractVcs getVcsForFile(@NotNull File file, @NotNull Project project2) {
        if (file == null) {
            ChangesUtil.$$$reportNull$$$0(14);
        }
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(15);
        }
        return ProjectLevelVcsManager.getInstance(project2).getVcsFor(VcsUtil.getFilePath(file));
    }

    @NotNull
    public static List<FilePath> getPaths(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(16);
        }
        List list2 = ChangesUtil.iteratePaths(changes).toList();
        if (list2 == null) {
            ChangesUtil.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @NotNull
    public static List<File> getIoFilesFromChanges(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(18);
        }
        List list2 = ChangesUtil.iteratePaths(changes).map(FilePath::getIOFile).unique().toList();
        if (list2 == null) {
            ChangesUtil.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    public static JBIterable<FilePath> iteratePaths(@NotNull Iterable<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(20);
        }
        JBIterable jBIterable = JBIterable.from(changes).flatMap(ChangesUtil::iteratePathsCaseSensitive);
        if (jBIterable == null) {
            ChangesUtil.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    public static boolean equalsCaseSensitive(@Nullable FilePath path1, @Nullable FilePath path2) {
        return CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)path1, (Object)path2);
    }

    @NotNull
    public static JBIterable<FilePath> iteratePathsCaseSensitive(@NotNull Change change) {
        FilePath afterPath;
        FilePath beforePath;
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(22);
        }
        if (ChangesUtil.equalsCaseSensitive(beforePath = ChangesUtil.getBeforePath(change), afterPath = ChangesUtil.getAfterPath(change))) {
            JBIterable jBIterable = JBIterable.of((Object)beforePath);
            if (jBIterable == null) {
                ChangesUtil.$$$reportNull$$$0(23);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object[])new FilePath[]{beforePath, afterPath}).filterNotNull();
        if (jBIterable == null) {
            ChangesUtil.$$$reportNull$$$0(24);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<VirtualFile> iterateFiles(@NotNull Iterable<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(25);
        }
        JBIterable jBIterable = ChangesUtil.iteratePaths(changes).map(FilePath::getVirtualFile).filter(Objects::nonNull);
        if (jBIterable == null) {
            ChangesUtil.$$$reportNull$$$0(26);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<VirtualFile> iterateAfterRevisionFiles(@NotNull Iterable<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(27);
        }
        JBIterable jBIterable = JBIterable.from(changes).map(ChangesUtil::getAfterPath).filter(Objects::nonNull).map(FilePath::getVirtualFile).filter(Objects::nonNull);
        if (jBIterable == null) {
            ChangesUtil.$$$reportNull$$$0(28);
        }
        return jBIterable;
    }

    public static VirtualFile @NotNull [] getFilesFromChanges(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(29);
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])ChangesUtil.iterateFiles(changes).toArray((Object[])VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            ChangesUtil.$$$reportNull$$$0(30);
        }
        return virtualFileArray;
    }

    public static Navigatable @NotNull [] getNavigatableArray(@NotNull Project project2, @NotNull Iterable<? extends VirtualFile> files) {
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(31);
        }
        if (files == null) {
            ChangesUtil.$$$reportNull$$$0(32);
        }
        Navigatable[] navigatableArray = JBIterable.from(files).filter(file -> !file.isDirectory()).map(file -> new OpenFileDescriptor(project2, file)).toList().toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
        if (navigatableArray == null) {
            ChangesUtil.$$$reportNull$$$0(33);
        }
        return navigatableArray;
    }

    @Nullable
    public static LocalChangeList getChangeListIfOnlyOne(@NotNull Project project2, Change @Nullable [] changes) {
        ChangeListManager manager;
        String changeListName;
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(34);
        }
        return (changeListName = (manager = ChangeListManager.getInstance(project2)).getChangeListNameIfOnlyOne(changes)) == null ? null : manager.findChangeList(changeListName);
    }

    public static FilePath getCommittedPath(@NotNull Project project2, FilePath filePath) {
        Change change;
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(35);
        }
        if ((change = ChangeListManager.getInstance(project2).getChange(filePath)) != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && afterRevision.getFile().equals(filePath)) {
                filePath = beforeRevision.getFile();
            }
        }
        return filePath;
    }

    public static FilePath getLocalPath(@NotNull Project project2, FilePath filePath) {
        Change change;
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(36);
        }
        if ((change = (Change)ReadAction.compute(() -> {
            if (project2.isDisposed()) {
                throw new ProcessCanceledException();
            }
            return ChangeListManager.getInstance(project2).getChange(filePath);
        })) != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && beforeRevision.getFile().equals(filePath)) {
                return afterRevision.getFile();
            }
        }
        return filePath;
    }

    @Deprecated
    @Nullable
    public static VirtualFile findValidParentAccurately(@NotNull FilePath filePath) {
        VirtualFile result2;
        if (filePath == null) {
            ChangesUtil.$$$reportNull$$$0(37);
        }
        if ((result2 = filePath.getVirtualFile()) == null && !ApplicationManager.getApplication().isReadAccessAllowed()) {
            result2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath.getPath());
        }
        if (result2 == null) {
            result2 = ChangesUtil.getValidParentUnderReadAction(filePath);
        }
        return result2;
    }

    @Deprecated
    @Nullable
    private static VirtualFile getValidParentUnderReadAction(@NotNull FilePath filePath) {
        if (filePath == null) {
            ChangesUtil.$$$reportNull$$$0(38);
        }
        return (VirtualFile)ReadAction.compute(() -> {
            VirtualFile result2 = null;
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            for (FilePath parent = filePath; result2 == null && parent != null; parent = parent.getParentPath()) {
                result2 = lfs.findFileByPath(parent.getPath());
            }
            return result2;
        });
    }

    @Nullable
    @NlsSafe
    public static String getProjectRelativePath(@NotNull Project project2, @Nullable File fileName) {
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(39);
        }
        if (fileName == null) {
            return null;
        }
        String baseDir = project2.getBasePath();
        if (baseDir == null) {
            return fileName.toString();
        }
        String relativePath = FileUtil.getRelativePath((File)new File(baseDir), (File)fileName);
        return relativePath == null ? fileName.toString() : relativePath;
    }

    public static boolean isTextConflictingChange(@NotNull Change change) {
        FileStatus status;
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(40);
        }
        return FileStatus.MERGED_WITH_CONFLICTS.equals(status = change.getFileStatus()) || FileStatus.MERGED_WITH_BOTH_CONFLICTS.equals(status);
    }

    public static <T> void processItemsByVcs(@NotNull Collection<? extends T> items, @NotNull VcsSeparator<? super T> separator, @NotNull PerVcsProcessor<T> processor) {
        if (items == null) {
            ChangesUtil.$$$reportNull$$$0(41);
        }
        if (separator == null) {
            ChangesUtil.$$$reportNull$$$0(42);
        }
        if (processor == null) {
            ChangesUtil.$$$reportNull$$$0(43);
        }
        HashMap<AbstractVcs, List> changesByVcs = new HashMap<AbstractVcs, List>();
        ReadAction.run(() -> {
            for (Object item : items) {
                AbstractVcs vcs = separator.getVcsFor((Object)item);
                if (vcs == null) continue;
                changesByVcs.computeIfAbsent(vcs, __ -> new ArrayList()).add(item);
            }
        });
        changesByVcs.forEach(processor::process);
    }

    public static void processChangesByVcs(@NotNull Project project2, @NotNull Collection<? extends Change> changes, @NotNull PerVcsProcessor<Change> processor) {
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(44);
        }
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(45);
        }
        if (processor == null) {
            ChangesUtil.$$$reportNull$$$0(46);
        }
        ChangesUtil.processItemsByVcs(changes, change -> ChangesUtil.getVcsForChange(change, project2), processor);
    }

    public static void processVirtualFilesByVcs(@NotNull Project project2, @NotNull Collection<? extends VirtualFile> files, @NotNull PerVcsProcessor<VirtualFile> processor) {
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(47);
        }
        if (files == null) {
            ChangesUtil.$$$reportNull$$$0(48);
        }
        if (processor == null) {
            ChangesUtil.$$$reportNull$$$0(49);
        }
        if (files.isEmpty()) {
            return;
        }
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance(project2);
        ChangesUtil.processItemsByVcs(files, file -> projectLevelVcsManager.getVcsFor((VirtualFile)file), processor);
    }

    public static void processFilePathsByVcs(@NotNull Project project2, @NotNull Collection<? extends FilePath> files, @NotNull PerVcsProcessor<FilePath> processor) {
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(50);
        }
        if (files == null) {
            ChangesUtil.$$$reportNull$$$0(51);
        }
        if (processor == null) {
            ChangesUtil.$$$reportNull$$$0(52);
        }
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance(project2);
        ChangesUtil.processItemsByVcs(files, filePath -> projectLevelVcsManager.getVcsFor((FilePath)filePath), processor);
    }

    @NotNull
    public static List<File> filePathsToFiles(@NotNull Collection<? extends FilePath> filePaths) {
        if (filePaths == null) {
            ChangesUtil.$$$reportNull$$$0(53);
        }
        List list2 = ContainerUtil.map(filePaths, FilePath::getIOFile);
        if (list2 == null) {
            ChangesUtil.$$$reportNull$$$0(54);
        }
        return list2;
    }

    public static boolean hasFileChanges(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(55);
        }
        for (Change change : changes) {
            FilePath path2 = ChangesUtil.getFilePath(change);
            if (path2.isDirectory()) continue;
            return true;
        }
        return false;
    }

    public static void markInternalOperation(@NotNull Iterable<? extends Change> changes, boolean set) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(56);
        }
        for (Change change : changes) {
            VirtualFile file = change.getVirtualFile();
            if (file == null) continue;
            ChangesUtil.markInternalOperation(file, set);
        }
    }

    public static void markInternalOperation(@NotNull VirtualFile file, boolean set) {
        if (file == null) {
            ChangesUtil.$$$reportNull$$$0(57);
        }
        file.putUserData(INTERNAL_OPERATION_KEY, (Object)(set ? Boolean.TRUE : null));
    }

    public static boolean isInternalOperation(@NotNull VirtualFile file) {
        if (file == null) {
            ChangesUtil.$$$reportNull$$$0(58);
        }
        return Boolean.TRUE.equals(file.getUserData(INTERNAL_OPERATION_KEY));
    }

    @Nullable
    public static File findCommonAncestor(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(59);
        }
        File ancestor = null;
        for (Change change : changes) {
            File currentChangeAncestor = ChangesUtil.getCommonBeforeAfterAncestor(change);
            if (currentChangeAncestor == null) {
                return null;
            }
            if (ancestor == null) {
                ancestor = currentChangeAncestor;
                continue;
            }
            if ((ancestor = FileUtil.findAncestor((File)ancestor, (File)currentChangeAncestor)) != null) continue;
            return null;
        }
        return ancestor;
    }

    @Nullable
    private static File getCommonBeforeAfterAncestor(@NotNull Change change) {
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(60);
        }
        FilePath before2 = ChangesUtil.getBeforePath(change);
        FilePath after2 = ChangesUtil.getAfterPath(change);
        return before2 == null ? Objects.requireNonNull(after2).getIOFile() : (after2 == null ? before2.getIOFile() : FileUtil.findAncestor((File)before2.getIOFile(), (File)after2.getIOFile()));
    }

    public static byte @NotNull [] loadContentRevision(@NotNull ContentRevision revision) throws VcsException {
        if (revision == null) {
            ChangesUtil.$$$reportNull$$$0(61);
        }
        if (revision instanceof ByteBackedContentRevision) {
            byte[] bytes = ((ByteBackedContentRevision)revision).getContentAsBytes();
            if (bytes == null) {
                throw new VcsException(VcsBundle.message("vcs.error.failed.to.load.file.content.from.vcs", new Object[0]));
            }
            if (bytes == null) {
                ChangesUtil.$$$reportNull$$$0(62);
            }
            return bytes;
        }
        String content2 = revision.getContent();
        if (content2 == null) {
            throw new VcsException(VcsBundle.message("vcs.error.failed.to.load.file.content.from.vcs", new Object[0]));
        }
        byte[] byArray = content2.getBytes(revision.getFile().getCharset());
        if (byArray == null) {
            ChangesUtil.$$$reportNull$$$0(63);
        }
        return byArray;
    }

    public static boolean hasMeaningfulChangelists(@NotNull Project project2) {
        ChangeListManager changeListManager;
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(64);
        }
        if (!(changeListManager = ChangeListManager.getInstance(project2)).areChangeListsEnabled()) {
            return false;
        }
        if (VcsApplicationSettings.getInstance().CREATE_CHANGELISTS_AUTOMATICALLY) {
            return true;
        }
        List<LocalChangeList> changeLists = changeListManager.getChangeLists();
        return changeLists.size() != 1 || !changeLists.get(0).isBlank();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 11, 17, 19, 21, 23, 24, 26, 28, 30, 33, 54, 62, 63 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 54: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesUtil";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 44: 
            case 47: 
            case 50: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 27: 
            case 29: 
            case 45: 
            case 55: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 9: 
            case 32: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 12: 
            case 14: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 43: 
            case 46: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedVcses";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedVcsesForFilePaths";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getIoFilesFromChanges";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "iteratePaths";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "iteratePathsCaseSensitive";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateFiles";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateAfterRevisionFiles";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesFromChanges";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatableArray";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "filePathsToFiles";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilePath";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 54: 
            case 62: 
            case 63: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBeforePath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAfterPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVcsForChange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedVcses";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedVcsesForFilePaths";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getVcsForFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPaths";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIoFilesFromChanges";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "iteratePaths";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "iteratePathsCaseSensitive";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "iterateFiles";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "iterateAfterRevisionFiles";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFilesFromChanges";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatableArray";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getChangeListIfOnlyOne";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getCommittedPath";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPath";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findValidParentAccurately";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getValidParentUnderReadAction";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRelativePath";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isTextConflictingChange";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processItemsByVcs";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processChangesByVcs";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFilesByVcs";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "processFilePathsByVcs";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "filePathsToFiles";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "hasFileChanges";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "markInternalOperation";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isInternalOperation";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "findCommonAncestor";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getCommonBeforeAfterAncestor";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "loadContentRevision";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "hasMeaningfulChangelists";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 8, 11, 17, 19, 21, 23, 24, 26, 28, 30, 33, 54, 62, 63 -> new IllegalStateException(string2);
        };
    }

    @FunctionalInterface
    public static interface VcsSeparator<T> {
        @Nullable
        public AbstractVcs getVcsFor(@NotNull T var1);
    }

    @FunctionalInterface
    public static interface PerVcsProcessor<T> {
        public void process(@NotNull AbstractVcs var1, @NotNull List<T> var2);
    }
}

