/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml.ngram;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nJ\u001a\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\u00110\u0010H\u0007J\u0006\u0010\u0012\u001a\u00020\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\u0011J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0003H\u0007J\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\nJ\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0003`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/internal/ml/ngram/NGramRecentTokens;", "Ljava/io/Externalizable;", "maxSequenceSize", "", "(I)V", "maxTokenIndex", "nextTokenIndex", "Ljava/util/concurrent/atomic/AtomicInteger;", "recent", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "contains", "", "token", "getRecentTokens", "", "Lkotlin/Pair;", "lastIndex", "readExternal", "", "ins", "Ljava/io/ObjectInput;", "removeEldest", "resetTokenIndex", "setMaxTokenIndex", "newMax", "size", "update", "writeExternal", "out", "Ljava/io/ObjectOutput;", "intellij.platform.ml.impl"})
public final class NGramRecentTokens
implements Externalizable {
    private final int maxSequenceSize;
    private int maxTokenIndex;
    @NotNull
    private final AtomicInteger nextTokenIndex;
    @NotNull
    private final LinkedHashMap<String, Integer> recent;

    public NGramRecentTokens(int maxSequenceSize) {
        this.maxSequenceSize = maxSequenceSize;
        this.maxTokenIndex = 0x7FFFFFFE;
        this.nextTokenIndex = new AtomicInteger(1);
        this.recent = new LinkedHashMap();
    }

    public final synchronized void update(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        if (this.recent.containsKey(token)) {
            this.recent.remove(token);
        }
        ((Map)this.recent).put(token, this.nextTokenIndex.getAndIncrement());
        if (this.nextTokenIndex.get() > this.maxTokenIndex) {
            this.resetTokenIndex();
        }
    }

    private final void resetTokenIndex() {
        int first = this.nextTokenIndex.get() - this.maxSequenceSize;
        int newLast = 0;
        for (Map.Entry entry2 : ((Map)this.recent).entrySet()) {
            String key2 = (String)entry2.getKey();
            int value = ((Number)entry2.getValue()).intValue();
            int newIdx = Math.max(value - first + 1, 0);
            Integer n = newIdx;
            ((Map)this.recent).put(key2, n);
            newLast = Math.max(newLast, newIdx);
        }
        this.nextTokenIndex.set(newLast + 1);
    }

    @NotNull
    public final synchronized Pair<String, Integer> removeEldest() {
        Map.Entry entry2 = ((Map)this.recent).entrySet().iterator().next();
        String token = (String)entry2.getKey();
        int id = ((Number)entry2.getValue()).intValue();
        this.recent.remove(token);
        return TuplesKt.to((Object)token, (Object)id);
    }

    public final synchronized boolean contains(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return ((Map)this.recent).containsKey(token);
    }

    public final synchronized int lastIndex() {
        return this.nextTokenIndex.get() - 1;
    }

    public final synchronized int size() {
        return this.recent.size();
    }

    @Override
    public synchronized void writeExternal(@NotNull ObjectOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInt(this.nextTokenIndex.get());
        out.writeInt(this.recent.size());
        for (Map.Entry entry2 : ((Map)this.recent).entrySet()) {
            out.writeObject(entry2.getKey());
            out.writeInt(((Number)entry2.getValue()).intValue());
        }
    }

    @Override
    public synchronized void readExternal(@NotNull ObjectInput ins) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ins, (String)"ins");
        this.nextTokenIndex.set(ins.readInt());
        int recentSize = ins.readInt();
        for (int i = 0; i < recentSize; ++i) {
            Map map = this.recent;
            Object object = ins.readObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String string2 = (String)object;
            Integer n = ins.readInt();
            map.put(string2, n);
        }
    }

    @TestOnly
    public final void setMaxTokenIndex(int newMax) {
        this.maxTokenIndex = newMax;
    }

    @TestOnly
    @NotNull
    public final List<Pair<String, Integer>> getRecentTokens() {
        ArrayList<Pair> recentTokens = new ArrayList<Pair>();
        for (Map.Entry entry2 : ((Map)this.recent).entrySet()) {
            String key2 = (String)entry2.getKey();
            int value = ((Number)entry2.getValue()).intValue();
            recentTokens.add(TuplesKt.to((Object)key2, (Object)value));
        }
        return recentTokens;
    }
}

