/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeInspection.actions.RunInspectionAction;
import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesIndex;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.ContentPanel;
import com.intellij.dupLocator.resultUI.DuplicatesForm;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.treeHash.DuplocatorHashCallback;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.DeprecationStripePanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class DuplocateManager {
    private static final Logger LOG = Logger.getInstance(DuplocateManager.class);
    private final Project myProject;
    private ContentManager myContentManager;

    public DuplocateManager(@NotNull Project p) {
        if (p == null) {
            DuplocateManager.$$$reportNull$$$0(0);
        }
        this.myProject = p;
        StartupManager.getInstance((Project)p).runWhenProjectIsInitialized(() -> {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
            ToolWindow toolWindow = toolWindowManager.registerToolWindow(RegisterToolWindowTask.closable((String)"Duplicates", (Icon)AllIcons.Toolwindows.ToolWindowDuplicates, (ToolWindowAnchor)ToolWindowAnchor.BOTTOM));
            this.myContentManager = toolWindow.getContentManager();
            ContentManagerWatcher.watchContentManager((ToolWindow)toolWindow, (ContentManager)this.myContentManager);
        });
    }

    public static DuplocateManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            DuplocateManager.$$$reportNull$$$0(1);
        }
        return (DuplocateManager)project2.getService(DuplocateManager.class);
    }

    private static DuplocateVisitor[] createVisitors(DuplicatesProfile[] profiles, FragmentsCollector collector, DuplocatorSettings settings) {
        DuplocatorSettings.getInstance().loadState(settings);
        DuplocateVisitor[] visitors = new DuplocateVisitor[profiles.length];
        for (int i = 0; i < visitors.length; ++i) {
            visitors[i] = profiles[i].createVisitor(collector);
        }
        return visitors;
    }

    public static void hash(DuplocatorHashCallback duplicateCollector, DuplocatorSettings settings, @NotNull AnalysisScope scope) {
        DuplicatesProfile javaProfile;
        Language javaLanguage;
        if (scope == null) {
            DuplocateManager.$$$reportNull$$$0(2);
        }
        if ((javaLanguage = Language.findLanguageByID((String)"JAVA")) != null && (javaProfile = DuplicatesProfile.findProfileForLanguage(javaLanguage)) != null) {
            DuplocateManager.hash(scope, duplicateCollector, Collections.singletonList(javaProfile), settings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hash(@NotNull AnalysisScope scope, FragmentsCollector collector, List<? extends DuplicatesProfile> profiles, DuplocatorSettings settings) {
        if (scope == null) {
            DuplocateManager.$$$reportNull$$$0(3);
        }
        ArrayList<DuplicatesProfile> withIndex = new ArrayList<DuplicatesProfile>();
        ArrayList<DuplicatesProfile> withoutIndex = new ArrayList<DuplicatesProfile>();
        boolean useIndex = scope.getFileCount() > 500;
        for (DuplicatesProfile duplicatesProfile : profiles) {
            if (useIndex && duplicatesProfile.supportIndex()) {
                withIndex.add(duplicatesProfile);
                continue;
            }
            withoutIndex.add(duplicatesProfile);
        }
        Project project2 = scope.getProject();
        if (!withIndex.isEmpty()) {
            DuplicatesIndex index;
            DuplicatesProfile[] duplicatesProfileArray = withIndex.toArray(new DuplicatesProfile[0]);
            try {
                index = new DuplicatesIndex(project2, duplicatesProfileArray);
            }
            catch (IOException e) {
                LOG.warn("Duplicates index cannot be used", (Throwable)e);
                index = null;
            }
            if (index != null) {
                try {
                    index.update(scope);
                    index.processAll(scope, collector);
                }
                finally {
                    Disposer.dispose((Disposable)index);
                }
            } else {
                withoutIndex.addAll(withIndex);
            }
        }
        if (!withoutIndex.isEmpty()) {
            DuplicatesProfile[] duplicatesProfileArray = withoutIndex.toArray(new DuplicatesProfile[0]);
            DuplocateManager.doHash(scope, collector, duplicatesProfileArray, settings);
        }
    }

    private static void doHash(@NotNull AnalysisScope scope, FragmentsCollector collector, DuplicatesProfile[] profiles, DuplocatorSettings settings) {
        DuplocateVisitor[] visitors;
        if (scope == null) {
            DuplocateManager.$$$reportNull$$$0(4);
        }
        for (DuplocateVisitor visitor2 : visitors = DuplocateManager.visitAll(scope, collector, profiles, settings)) {
            visitor2.hashingFinished();
        }
    }

    private static DuplocateVisitor[] visitAll(@NotNull AnalysisScope scope, FragmentsCollector collector, DuplicatesProfile[] profiles, DuplocatorSettings settings) {
        if (scope == null) {
            DuplocateManager.$$$reportNull$$$0(5);
        }
        final int totalFiles = scope.getFileCount();
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setIndeterminate(false);
            indicator.setText(DupLocatorBundle.message("duplicates.searching.progress", new Object[0]));
        }
        final DuplocateVisitor[] visitors = DuplocateManager.createVisitors(profiles, collector, settings);
        final int[] fileCount = new int[]{0};
        scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitFile(@NotNull PsiFile baseFile) {
                if (baseFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                Project project2 = baseFile.getProject();
                fileCount[0] = fileCount[0] + 1;
                if (indicator != null) {
                    VirtualFile virtualFile = baseFile.getVirtualFile();
                    if (virtualFile != null) {
                        indicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project2));
                    }
                    indicator.setFraction((double)fileCount[0] / (double)totalFiles);
                }
                try {
                    for (PsiFile file : baseFile.getViewProvider().getAllFiles()) {
                        for (DuplocateVisitor visitor2 : visitors) {
                            visitor2.visitNode((PsiElement)file);
                        }
                        InjectedLanguageManager.getInstance((Project)project2).dropFileCaches(file);
                    }
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/dupLocator/DuplocateManager$1", "visitFile"));
            }
        });
        return visitors;
    }

    void findAndShow(AnalysisScope scope, DuplocatorSettings settings, List<DuplicatesProfile> profiles) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        DuplocatorHashCallback collector = new DuplocatorHashCallback(-1, -1);
        final Runnable process2 = () -> {
            try {
                DuplocateManager.hash(scope, collector, profiles, settings);
            }
            catch (IndexNotReadyException e) {
                DumbService.getInstance((Project)this.myProject).showDumbModeNotificationForFunctionality(DupLocatorBundle.message("duplication.unavailable.without.indices", new Object[0]), DumbModeBlockedFunctionality.DupLocator);
                throw new ProcessCanceledException();
            }
        };
        final Runnable successRunnable = () -> ApplicationManager.getApplication().invokeLater(() -> {
            DupInfo info = collector.getInfo();
            if (info.getPatterns() > 0) {
                int caretOffset = -1;
                this.showDuplicates(info, scope, settings, -1, null, scope != null ? scope.getDisplayName() : "", profiles, true);
            } else {
                Messages.showInfoMessage((Project)this.myProject, (String)DupLocatorBundle.message("duplication.none.found.message", new Object[0]), (String)DupLocatorBundle.message("duplication.none.found.title", new Object[0]));
            }
        });
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, DupLocatorBundle.message("duplication.progress", new Object[0]), true, (PerformInBackgroundOption)new PerformAnalysisInBackgroundOption(this.myProject)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                process2.run();
            }

            public void onSuccess() {
                successRunnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dupLocator/DuplocateManager$2", "run"));
            }
        });
    }

    public void showDuplicates(DupInfo info, AnalysisScope scope, DuplocatorSettings settings) {
        int caretOffset = -1;
        this.showDuplicates(info, scope, settings, -1, null, scope != null ? scope.getDisplayName() : "", DuplicatesProfile.getAllProfiles(), false);
    }

    public void showDuplicates(DupInfo info, int caretOffset, VirtualFile virtualFile, @NlsContexts.TabTitle String title) {
        this.showDuplicates(info, null, null, caretOffset, virtualFile, title, DuplicatesProfile.getAllProfiles(), false);
    }

    private void showDuplicates(DupInfo duplicates, AnalysisScope scope, DuplocatorSettings settings, int caretOffset, VirtualFile virtualFile, @NlsContexts.TabTitle String title, List<DuplicatesProfile> profiles, boolean showDeprecation) {
        DuplicatesForm form = DuplicatesForm.create(this.myProject, duplicates);
        if (caretOffset != -1 && virtualFile != null) {
            JTree duplicatesTree = form.getDuplicatesTree();
            TreeUtil.treeNodeTraverser((TreeNode)((TreeNode)duplicatesTree.getModel().getRoot())).traverse(TreeTraversal.POST_ORDER_DFS).processEach(node -> {
                if (node instanceof CodeNode) {
                    CodeNode codeNode = (CodeNode)node;
                    try {
                        if (Comparing.equal((Object)codeNode.getVirtualFile(), (Object)virtualFile) && codeNode.getTextRange().contains(caretOffset)) {
                            TreeUtil.selectNode((JTree)duplicatesTree, (TreeNode)codeNode);
                            return false;
                        }
                    }
                    catch (InvalidatedException e) {
                        return true;
                    }
                }
                return true;
            });
        }
        DeprecationStripePanel deprecationPanel = new DeprecationStripePanel(DupLocatorBundle.message("label.locate.duplicates.action.deprecated", new Object[0]), null);
        if (PlatformUtils.isIdeaUltimate()) {
            String duplicateCodeFragmentDisplayText = DupLocatorBundle.message("link.label.duplicated.code.fragment", new Object[0]);
            String linkText = DupLocatorBundle.message("link.label.use.duplicate.coded.fragment.inspection", duplicateCodeFragmentDisplayText);
            deprecationPanel = deprecationPanel.withAlternativeAction(linkText, (AnAction)new RunInspectionAction(duplicateCodeFragmentDisplayText));
        }
        ContentPanel contentPanel = new ContentPanel(form.getComponent());
        if (scope != null && profiles != null) {
            contentPanel.addRerunAction(() -> {
                Content selectedContent = this.myContentManager.getSelectedContent();
                if (selectedContent != null) {
                    this.myContentManager.removeContent(selectedContent, true);
                }
                this.findAndShow(scope, settings, profiles);
            });
        }
        JPanel twPanel = showDeprecation ? deprecationPanel.wrap((JComponent)contentPanel.getComponent()) : contentPanel.getComponent();
        Content content2 = this.myContentManager.getFactory().createContent((JComponent)twPanel, title, true);
        content2.setHelpId("find.locateDuplicates.result");
        content2.setDisposer((Disposable)form);
        this.myContentManager.addContent(content2);
        this.myContentManager.setSelectedContent(content2);
        contentPanel.addCloseAction(this.myContentManager, content2);
        form.addToolbarActionsTo(contentPanel);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Duplicates").activate(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/DuplocateManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hash";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doHash";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

