/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dependencyAnalysis.core.utils;

import com.intellij.dependencyAnalysis.core.model.Dependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u001a\u0018\u0010\b\u001a\u00020\t*\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a8\u0006\u0011"}, d2={"fixCycle", "", "dependencies", "", "Lcom/intellij/dependencyAnalysis/core/model/Dependency;", "treeTraversal", "collection", "", "findCycle", "", "visited", "", "", "getFlatDependencies", "getFlatUniqueDependencies", "getOnlyDirectDependencies", "getOnlyTransitiveDependencies", "intellij.dependencyAnalysis.core"})
@SourceDebugExtension(value={"SMAP\nTreeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeUtils.kt\ncom/intellij/dependencyAnalysis/core/utils/TreeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1360#2:61\n1446#2,5:62\n1045#2:67\n1360#2:68\n1446#2,5:69\n1549#2:74\n1620#2,3:75\n1549#2:78\n1620#2,3:79\n*S KotlinDebug\n*F\n+ 1 TreeUtils.kt\ncom/intellij/dependencyAnalysis/core/utils/TreeUtilsKt\n*L\n30#1:61\n30#1:62,5\n39#1:67\n42#1:68\n42#1:69,5\n44#1:74\n44#1:75,3\n46#1:78\n46#1:79,3\n*E\n"})
public final class TreeUtilsKt {
    public static final void fixCycle(@NotNull List<Dependency> dependencies) {
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        for (Dependency dependency : dependencies) {
            TreeUtilsKt.findCycle(dependency, new LinkedHashSet());
        }
    }

    public static final boolean findCycle(@NotNull Dependency $this$findCycle, @NotNull Set<String> visited) {
        Intrinsics.checkNotNullParameter((Object)$this$findCycle, (String)"<this>");
        Intrinsics.checkNotNullParameter(visited, (String)"visited");
        if (visited.contains($this$findCycle.getIdentifier())) {
            return true;
        }
        visited.add($this$findCycle.getIdentifier());
        List dependencies = CollectionsKt.toMutableList((Collection)$this$findCycle.getDependencies());
        int n = dependencies.size();
        for (int index = 0; index < n; ++index) {
            if (!TreeUtilsKt.findCycle((Dependency)dependencies.get(index), visited)) continue;
            dependencies.set(index, Dependency.copy$default((Dependency)dependencies.get(index), null, null, null, null, null, null, false, null, null, null, null, null, null, CollectionsKt.emptyList(), 8191, null));
        }
        $this$findCycle.setDependencies(dependencies);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Dependency> getFlatUniqueDependencies(@NotNull List<Dependency> $this$getFlatUniqueDependencies) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getFlatUniqueDependencies, (String)"<this>");
        Iterable $this$flatMap$iv = $this$getFlatUniqueDependencies;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Dependency it = (Dependency)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFlatDependency();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allDependencies = (List)destination$iv$iv;
        Map dependencyMap = new LinkedHashMap();
        for (Dependency dependency : allDependencies) {
            String name = dependency.getFullName();
            Dependency oldDependency = dependencyMap.putIfAbsent(name, dependency);
            if (oldDependency == null || oldDependency.getDependencies().size() <= dependency.getDependencies().size()) continue;
            dependencyMap.put(name, oldDependency);
        }
        Iterable $this$sortedBy$iv = CollectionsKt.toList((Iterable)dependencyMap.values());
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Dependency it = (Dependency)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getFullName());
                it = (Dependency)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getFullName())));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Dependency> getFlatDependencies(@NotNull List<Dependency> $this$getFlatDependencies) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getFlatDependencies, (String)"<this>");
        Iterable $this$flatMap$iv = $this$getFlatDependencies;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Dependency it = (Dependency)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFlatDependency();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Dependency> getOnlyTransitiveDependencies(@NotNull List<Dependency> $this$getOnlyTransitiveDependencies) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getOnlyTransitiveDependencies, (String)"<this>");
        Iterable $this$map$iv = $this$getOnlyTransitiveDependencies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Dependency dependency = (Dependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDependencies());
        }
        return TreeUtilsKt.treeTraversal(CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Dependency> getOnlyDirectDependencies(@NotNull List<Dependency> $this$getOnlyDirectDependencies) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getOnlyDirectDependencies, (String)"<this>");
        Iterable $this$map$iv = $this$getOnlyDirectDependencies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Dependency dependency = (Dependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Dependency.copy$default((Dependency)it, null, null, null, null, null, null, false, null, null, null, null, null, null, CollectionsKt.emptyList(), 8191, null));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<Dependency> treeTraversal(@NotNull Collection<Dependency> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        List dependencyQueue = CollectionsKt.toMutableList(collection);
        Set seen = new LinkedHashSet();
        while (!((Collection)dependencyQueue).isEmpty()) {
            Dependency dependency = (Dependency)dependencyQueue.remove(CollectionsKt.getLastIndex((List)dependencyQueue));
            if (seen.contains(dependency)) continue;
            dependencyQueue.addAll((Collection)dependency.getDependencies());
            seen.add(dependency);
        }
        return CollectionsKt.toList((Iterable)seen);
    }
}

