/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dependencyAnalysis.core.utils;

import com.intellij.dependencyAnalysis.core.model.Dependency;
import com.intellij.dependencyAnalysis.core.model.DependencyAnalysis;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0004\u001a\u0012\u0010\b\u001a\u00020\u0002*\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"getDependencyCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/dependencyAnalysis/core/model/Dependency;", "Lcom/intellij/openapi/project/Project;", "getPath", "Ljava/nio/file/Path;", "Lcom/intellij/openapi/module/Module;", "relative", "Lcom/intellij/openapi/vfs/VirtualFile;", "other", "intellij.dependencyAnalysis.core"})
public final class PlatformUtilsKt {
    @NotNull
    public static final Path getPath(@NotNull Module $this$getPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getPath, (String)"<this>");
        Object object = ProjectUtil.guessModuleDir((Module)$this$getPath);
        if (object == null || (object = object.getPath()) == null) {
            object = ((Object)$this$getPath.getModuleNioFile().getParent()).toString();
        }
        Object object2 = object;
        Intrinsics.checkNotNull((Object)object2);
        Path path = Paths.get((String)object2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public static final Path getPath(@NotNull Project $this$getPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getPath, (String)"<this>");
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)$this$getPath);
        String string = virtualFile != null ? virtualFile.getPath() : null;
        Intrinsics.checkNotNull((Object)string);
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public static final String relative(@NotNull VirtualFile $this$relative, @NotNull VirtualFile other) {
        Intrinsics.checkNotNullParameter((Object)$this$relative, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String string = $this$relative.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        String string2 = other.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        Path path2 = Paths.get(string2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return "./" + path.relativize(path2);
    }

    @NotNull
    public static final ConcurrentHashMap<String, Dependency> getDependencyCache(@NotNull Project $this$getDependencyCache) {
        Intrinsics.checkNotNullParameter((Object)$this$getDependencyCache, (String)"<this>");
        return DependencyAnalysis.Companion.getInstance($this$getDependencyCache).getMapCacheDependency();
    }
}

