/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dependencyAnalysis.core.utils;

import com.intellij.dependencyAnalysis.core.model.CacheWrapper;
import com.intellij.dependencyAnalysis.core.model.MetadataKt;
import com.intellij.dependencyAnalysis.core.utils.LicenseUtilsKt;
import com.intellij.dependencyAnalysis.core.utils.PlatformUtilsKt;
import com.intellij.openapi.module.Module;
import com.jetbrains.themis.License;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0010\u0010\u0007\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\n\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u0006*\u00020\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u0006*\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001\u001a\n\u0010\u000f\u001a\u00020\u0006*\u00020\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0010"}, d2={"noneLicense", "", "Lcom/jetbrains/themis/License;", "getNoneLicense", "()Ljava/util/List;", "areNone", "", "getHighestPriorityLicense", "getLicenseFromRootPath", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPriority", "", "isNone", "isNotNone", "isUnknown", "intellij.dependencyAnalysis.core"})
@SourceDebugExtension(value={"SMAP\nLicenseUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicenseUtils.kt\ncom/intellij/dependencyAnalysis/core/utils/LicenseUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1726#2,3:48\n1726#2,3:51\n1194#2,2:54\n1222#2,4:56\n*S KotlinDebug\n*F\n+ 1 LicenseUtils.kt\ncom/intellij/dependencyAnalysis/core/utils/LicenseUtilsKt\n*L\n36#1:48,3\n38#1:51,3\n47#1:54,2\n47#1:56,4\n*E\n"})
public final class LicenseUtilsKt {
    @NotNull
    private static final List<License> noneLicense = CollectionsKt.listOf((Object)new License(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 262143, null).toNone());

    public static final int getPriority(@NotNull License $this$getPriority) {
        String fileName;
        Intrinsics.checkNotNullParameter((Object)$this$getPriority, (String)"<this>");
        String string = $this$getPriority.getPath();
        if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null)) == null || (string = StringsKt.substringBefore$default((String)string, (String)".", null, (int)2, null)) == null) {
            return Integer.MAX_VALUE;
        }
        return switch (fileName = string) {
            case "LICENCE", "LICENSE" -> 0;
            case "COPYING" -> 1;
            case "UNLICENSE" -> 2;
            case "MIT" -> 3;
            case "BSD" -> 4;
            case "GPL" -> 5;
            case "LGPL" -> 6;
            case "APACHE" -> 7;
            case "LEGAL" -> 8;
            case "NOTICE" -> 9;
            case "CONTRIBUTORS" -> 10;
            case "COPYLEFT" -> 11;
            case "COPYRIGHT" -> 12;
            default -> Integer.MAX_VALUE;
        };
    }

    @NotNull
    public static final License getHighestPriorityLicense(@NotNull List<License> $this$getHighestPriorityLicense) {
        Intrinsics.checkNotNullParameter($this$getHighestPriorityLicense, (String)"<this>");
        if ($this$getHighestPriorityLicense.isEmpty()) {
            return new License(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 262143, null).toNone();
        }
        Function1[] function1Array = new Function1[]{getHighestPriorityLicense.1.INSTANCE, getHighestPriorityLicense.2.INSTANCE};
        return (License)CollectionsKt.first((List)CollectionsKt.sortedWith((Iterable)$this$getHighestPriorityLicense, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)));
    }

    public static final boolean areNone(@NotNull List<License> $this$areNone) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$areNone, (String)"<this>");
            Iterable $this$all$iv = $this$areNone;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    License it = (License)element$iv;
                    boolean bl2 = false;
                    if (LicenseUtilsKt.isNone(it) || Intrinsics.areEqual((Object)it.getKey(), (Object)"PROPRIETARY-LICENSE") && Intrinsics.areEqual((Object)it.getText(), (Object)MetadataKt.getProprietaryText())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNotNone(@Nullable List<License> $this$isNotNone) {
        boolean bl;
        Collection collection = $this$isNotNone;
        if (collection == null) return false;
        if (collection.isEmpty()) {
            return false;
        }
        boolean bl2 = false;
        if (bl2) return false;
        Iterable $this$all$iv = $this$isNotNone;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            License it = (License)element$iv;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)it.getKey(), (Object)"NONE")) return false;
            bl = true;
        } while (bl);
        return false;
    }

    public static final boolean isUnknown(@NotNull License $this$isUnknown) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnknown, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isUnknown.getKey(), (Object)"UNKNOWN");
    }

    public static final boolean isNone(@NotNull License $this$isNone) {
        Intrinsics.checkNotNullParameter((Object)$this$isNone, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isNone.getKey(), (Object)"NONE");
    }

    @NotNull
    public static final List<License> getNoneLicense() {
        return noneLicense;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getLicenseFromRootPath(@NotNull Module var0, @NotNull Continuation<? super List<License>> var1_1) {
        if (!(var1_1 instanceof getLicenseFromRootPath.1)) ** GOTO lbl-1000
        var14_2 = var1_1;
        if ((var14_2.label & -2147483648) != 0) {
            var14_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var1_1){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LicenseUtilsKt.getLicenseFromRootPath(null, (Continuation<? super List<License>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = PlatformUtilsKt.getPath($this$getLicenseFromRootPath);
                var2_5 = $this$getLicenseFromRootPath.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)var2_5, (String)"getProject(...)");
                $continuation.label = 1;
                v1 = CacheWrapper.detectLicensesFromFolder$default(CacheWrapper.INSTANCE, v0, PlatformUtilsKt.getPath(var2_5), null, (Continuation)$continuation, 4, null);
                if (v1 == var15_4) {
                    return var15_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl23:
                // 2 sources

                $this$associateBy$iv = (Iterable)v1;
                $i$f$associateBy = false;
                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                var5_8 = $this$associateBy$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    var10_13 = (License)element$iv$iv;
                    var12_15 = destination$iv$iv;
                    $i$a$-associateBy-LicenseUtilsKt$getLicenseFromRootPath$2 = false;
                    var12_15.put(it.getKey(), element$iv$iv);
                }
                return CollectionsKt.toList((Iterable)destination$iv$iv.values());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }
}

