/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dependencyAnalysis.core.utils;

import com.intellij.dependencyAnalysis.core.utils.CommonUtilsKt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\tH\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"CUSTOM_MODULE_NAME", "", "EMPTY", "calculateSha256", "isParentPath", "", "other", "relative", "toHex", "", "transformToHttpsUrl", "intellij.dependencyAnalysis.core"})
@SourceDebugExtension(value={"SMAP\nCommonUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonUtils.kt\ncom/intellij/dependencyAnalysis/core/utils/CommonUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public final class CommonUtilsKt {
    @NotNull
    public static final String CUSTOM_MODULE_NAME = "Custom";
    @NotNull
    public static final String EMPTY = "";

    @NotNull
    public static final String transformToHttpsUrl(@NotNull String $this$transformToHttpsUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$transformToHttpsUrl, (String)"<this>");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)$this$transformToHttpsUrl, (String)"git@", (String)"https://", (boolean)false, (int)4, null), (String)":", (String)"/", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final String calculateSha256(@Nullable String $this$calculateSha256) {
        if ($this$calculateSha256 == null) return null;
        String filePath = $this$calculateSha256;
        boolean bl = false;
        Object object = Paths.get(filePath, new String[0]);
        Path it = object;
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return null;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        Path path = object;
        if (path == null) {
            return null;
        }
        Path path2 = path;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        InputStream inputStream = Files.newInputStream(path2, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        object = inputStream;
        int n = 8192;
        object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
        Throwable throwable = null;
        try {
            BufferedInputStream inputStream2 = (BufferedInputStream)object;
            boolean bl4 = false;
            byte[] buffer = new byte[8192];
            int count = inputStream2.read(buffer);
            while (count != -1) {
                md.update(buffer, 0, count);
                count = inputStream2.read(buffer);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        MessageDigest messageDigest = md;
        if (messageDigest == null) return null;
        byte[] byArray = messageDigest.digest();
        if (byArray == null) return null;
        String string = CommonUtilsKt.toHex(byArray);
        if (string == null) return null;
        return string;
    }

    private static final String toHex(byte[] $this$toHex) {
        return ArraysKt.joinToString$default((byte[])$this$toHex, (CharSequence)EMPTY, null, null, (int)0, null, (Function1)toHex.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String relative(@NotNull String $this$relative, @Nullable String other) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$relative, (String)"<this>");
        if (other == null) {
            object = $this$relative;
        } else if (Intrinsics.areEqual((Object)$this$relative, (Object)EMPTY) || !CommonUtilsKt.isParentPath($this$relative, other)) {
            object = other;
        } else if (Intrinsics.areEqual((Object)$this$relative, (Object)other)) {
            object = "./" + StringsKt.substringAfterLast$default((String)$this$relative, (String)"/", null, (int)2, null);
        } else {
            Path path = Paths.get($this$relative, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path path2 = Paths.get(other, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            object = "./" + path.relativize(path2);
        }
        return object;
    }

    public static final boolean isParentPath(@NotNull String $this$isParentPath, @Nullable String other) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$isParentPath, (String)"<this>");
        String string2 = string = other;
        return ((string2 == null ? true : Intrinsics.areEqual((Object)string2, (Object)EMPTY)) ? true : Intrinsics.areEqual((Object)string, (Object)$this$isParentPath)) ? false : StringsKt.startsWith$default((String)other, (String)$this$isParentPath, (boolean)false, (int)2, null);
    }
}

