/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dependencyAnalysis.core.model;

import com.intellij.dependencyAnalysis.core.inspection.InspectionConfig;
import com.intellij.dependencyAnalysis.core.model.Checksum;
import com.intellij.dependencyAnalysis.core.model.Dependency;
import com.intellij.dependencyAnalysis.core.model.DependencyAnalysis;
import com.intellij.dependencyAnalysis.core.model.MetadataKt;
import com.intellij.dependencyAnalysis.core.model.ModuleMetadata;
import com.intellij.dependencyAnalysis.core.model.ProjectMetadata;
import com.intellij.dependencyAnalysis.core.model.Supplier;
import com.intellij.dependencyAnalysis.core.utils.TreeUtilsKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.themis.Detector;
import com.jetbrains.themis.License;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u0081\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007\u00a2\u0006\u0002\u0010\u0013JZ\u00103\u001a\u000204\"\u0004\b\u0000\u001052\u0006\u00106\u001a\u00020\n2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u0002H50)2\u001a\u00109\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u0001H5\u0012\u0004\u0012\u0002040:2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u0002H5\u0012\u0004\u0012\u00020=0<H\u0002J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010?\u001a\u00020=H\u0002J\t\u0010@\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007H\u00c6\u0003J\t\u0010B\u001a\u00020\u0003H\u00c6\u0003J\t\u0010C\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010D\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000f\u0010E\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u00c6\u0003J\t\u0010F\u001a\u00020\fH\u00c6\u0003J\u000b\u0010G\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010H\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010I\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u0089\u0001\u0010J\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007H\u00c6\u0001J\u0013\u0010K\u001a\u00020=2\b\u0010L\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010?\u001a\u00020=J\t\u0010M\u001a\u00020NH\u00d6\u0001Jl\u0010O\u001a\u000204\"\u0004\b\u0000\u001052\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u0001H50<2\u001a\u00109\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u0001H5\u0012\u0004\u0012\u0002040:2\u0014\u0010;\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H5\u0012\u0004\u0012\u00020=0<2\u0014\b\u0002\u0010Q\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u0002H50)H\u0002J\u0006\u0010R\u001a\u000204J\u0006\u0010S\u001a\u000204J\u0006\u0010T\u001a\u000204J\t\u0010U\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b \u0010\u0019\u001a\u0004\b!\u0010\u001bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001dR#\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001dR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u001d\u00a8\u0006V"}, d2={"Lcom/intellij/dependencyAnalysis/core/model/ProjectMetadata;", "", "version", "", "name", "path", "projectLicenses", "", "Lcom/jetbrains/themis/License;", "modules", "Lcom/intellij/dependencyAnalysis/core/model/ModuleMetadata;", "supplier", "Lcom/intellij/dependencyAnalysis/core/model/Supplier;", "checkSum", "Lcom/intellij/dependencyAnalysis/core/model/Checksum;", "downloadLocation", "licenses", "dependencies", "Lcom/intellij/dependencyAnalysis/core/model/Dependency;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lcom/intellij/dependencyAnalysis/core/model/Supplier;Lcom/intellij/dependencyAnalysis/core/model/Checksum;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getCheckSum", "()Lcom/intellij/dependencyAnalysis/core/model/Checksum;", "setCheckSum", "(Lcom/intellij/dependencyAnalysis/core/model/Checksum;)V", "getDependencies$annotations", "()V", "getDependencies", "()Ljava/util/List;", "getDownloadLocation", "()Ljava/lang/String;", "setDownloadLocation", "(Ljava/lang/String;)V", "getLicenses$annotations", "getLicenses", "getModules", "setModules", "(Ljava/util/List;)V", "modulesLicenses", "getModulesLicenses", "getName", "overridedDependenciesNames", "", "getOverridedDependenciesNames", "()Ljava/util/Map;", "getPath", "getProjectLicenses", "getSupplier", "()Lcom/intellij/dependencyAnalysis/core/model/Supplier;", "uniqueModulesLicense", "getUniqueModulesLicense", "getVersion", "addAttributeFromAncestor", "", "T", "module", "mapModulePathAttribute", "Ljava/nio/file/Path;", "attributeSetter", "Lkotlin/Function2;", "isAttributePresent", "Lkotlin/Function1;", "", "collectDependencies", "isThirdPartySoftwareList", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "shareAttributes", "attributeGetter", "projectValue", "shareModuleLicense", "shareModuleSupplier", "shareModuleVersion", "toString", "intellij.dependencyAnalysis.core"})
@SourceDebugExtension(value={"SMAP\nMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Metadata.kt\ncom/intellij/dependencyAnalysis/core/model/ProjectMetadata\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,578:1\n1655#2,8:579\n1045#2:587\n1360#2:588\n1446#2,5:589\n1360#2:594\n1446#2,5:595\n1360#2:600\n1446#2,5:601\n1045#2:606\n766#2:607\n857#2,2:608\n1045#2:610\n1179#2,2:611\n1253#2,4:613\n1194#2,2:617\n1222#2,4:619\n*S KotlinDebug\n*F\n+ 1 Metadata.kt\ncom/intellij/dependencyAnalysis/core/model/ProjectMetadata\n*L\n80#1:579,8\n80#1:587\n96#1:588\n96#1:589,5\n97#1:594\n97#1:595,5\n101#1:600\n101#1:601,5\n105#1:606\n112#1:607\n112#1:608,2\n115#1:610\n116#1:611,2\n116#1:613,4\n167#1:617,2\n167#1:619,4\n*E\n"})
public final class ProjectMetadata {
    @NotNull
    private final String version;
    @NotNull
    private final String name;
    @NotNull
    private final String path;
    @NotNull
    private final List<License> projectLicenses;
    @NotNull
    private List<ModuleMetadata> modules;
    @NotNull
    private final transient Supplier supplier;
    @Nullable
    private transient Checksum checkSum;
    @Nullable
    private transient String downloadLocation;
    @NotNull
    private final List<License> licenses;
    @NotNull
    private final List<Dependency> dependencies;

    public ProjectMetadata(@NotNull String version, @NotNull String name, @NotNull String path, @NotNull List<License> projectLicenses, @NotNull List<ModuleMetadata> modules, @NotNull Supplier supplier, @Nullable Checksum checkSum, @Nullable String downloadLocation, @NotNull List<License> licenses2, @NotNull List<Dependency> dependencies) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(projectLicenses, (String)"projectLicenses");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter((Object)supplier, (String)"supplier");
        Intrinsics.checkNotNullParameter(licenses2, (String)"licenses");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        this.version = version;
        this.name = name;
        this.path = path;
        this.projectLicenses = projectLicenses;
        this.modules = modules;
        this.supplier = supplier;
        this.checkSum = checkSum;
        this.downloadLocation = downloadLocation;
        this.licenses = licenses2;
        this.dependencies = dependencies;
    }

    public /* synthetic */ ProjectMetadata(String string, String string2, String string3, List list, List list2, Supplier supplier, Checksum checksum, String string4, List list3, List list4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "2.0.0";
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            supplier = new Supplier(null, null, null, null, null, 31, null);
        }
        if ((n & 0x40) != 0) {
            checksum = null;
        }
        if ((n & 0x80) != 0) {
            string4 = null;
        }
        if ((n & 0x100) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x200) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        this(string, string2, string3, list, list2, supplier, checksum, string4, list3, list4);
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final List<License> getProjectLicenses() {
        return this.projectLicenses;
    }

    @NotNull
    public final List<ModuleMetadata> getModules() {
        return this.modules;
    }

    public final void setModules(@NotNull List<ModuleMetadata> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.modules = list;
    }

    @NotNull
    public final Supplier getSupplier() {
        return this.supplier;
    }

    @Nullable
    public final Checksum getCheckSum() {
        return this.checkSum;
    }

    public final void setCheckSum(@Nullable Checksum checksum) {
        this.checkSum = checksum;
    }

    @Nullable
    public final String getDownloadLocation() {
        return this.downloadLocation;
    }

    public final void setDownloadLocation(@Nullable String string) {
        this.downloadLocation = string;
    }

    @NotNull
    public final List<License> getLicenses() {
        return this.licenses;
    }

    @Deprecated(message="Only for compatibility with old UI")
    public static /* synthetic */ void getLicenses$annotations() {
    }

    @NotNull
    public final List<Dependency> getDependencies() {
        return this.dependencies;
    }

    @Deprecated(message="Only for compatibility with old UI")
    public static /* synthetic */ void getDependencies$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Dependency> getDependencies(boolean isThirdPartySoftwareList) {
        void $this$sortedBy$iv;
        Function1 distinctKey2 = (Function1)new Function1<Dependency, String>(isThirdPartySoftwareList){
            final /* synthetic */ boolean $isThirdPartySoftwareList;
            {
                this.$isThirdPartySoftwareList = $isThirdPartySoftwareList;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull Dependency dependency) {
                Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
                return this.$isThirdPartySoftwareList ? dependency.getId() + dependency.getVersion() : dependency.getId() + dependency.getVersion() + dependency.getModule();
            }
        };
        Iterable $this$distinctBy$iv = this.collectDependencies(isThirdPartySoftwareList);
        boolean $i$f$distinctBy = false;
        HashSet<Object> set$iv = new HashSet<Object>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Object key$iv = distinctKey2.invoke(e$iv);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$sortedBy = false;
        List<Dependency> result = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Dependency it = (Dependency)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)(it.getName() + it.getVersion()));
                it = (Dependency)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)(it.getName() + it.getVersion()))));
            }
        });
        return InspectionConfig.DEPENDENCY_TREE_STATUS ? result : TreeUtilsKt.getOnlyDirectDependencies(result);
    }

    @NotNull
    public final Map<String, List<License>> getOverridedDependenciesNames() {
        ModuleMetadata moduleMetadata = (ModuleMetadata)CollectionsKt.getOrNull(this.modules, (int)0);
        if (moduleMetadata == null || (moduleMetadata = moduleMetadata.getModule()) == null || (moduleMetadata = moduleMetadata.getProject()) == null) {
            return MapsKt.emptyMap();
        }
        ModuleMetadata project = moduleMetadata;
        return DependencyAnalysis.Companion.getInstance((Project)project).getOverridedDependencies();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Dependency> collectDependencies(boolean isThirdPartySoftwareList) {
        List list;
        if (isThirdPartySoftwareList) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.modules;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ModuleMetadata it = (ModuleMetadata)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = TreeUtilsKt.getFlatUniqueDependencies(it.getDependencies());
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            Iterable $this$flatMap$iv = this.modules;
            boolean $i$f$flatMap = false;
            Iterable $this$flatMapTo$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ModuleMetadata it = (ModuleMetadata)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getDependencies();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<License> getModulesLicenses() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.modules;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ModuleMetadata it = (ModuleMetadata)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getLicenses();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List licenses2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (CollectionsKt.removeAll((List)licenses2, (Function1)modulesLicenses.1.INSTANCE)) {
            License license = Detector.INSTANCE.getAllLicenses().get("PROPRIETARY-LICENSE");
            Intrinsics.checkNotNull((Object)license);
            licenses2.add(License.copy$default(license, null, null, null, null, null, MetadataKt.getProprietaryText(), null, null, null, null, null, null, null, null, null, null, null, null, 196575, null));
        }
        Iterable $this$sortedBy$iv = licenses2;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                License it = (License)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getKey());
                it = (License)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getKey())));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final <T> void shareAttributes(Function1<? super ModuleMetadata, ? extends T> attributeGetter, Function2<? super ModuleMetadata, ? super T, Unit> attributeSetter, Function1<? super T, Boolean> isAttributePresent, Map<Path, ? extends T> projectValue) {
        void $this$associateTo$iv$iv;
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.modules;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object attribute;
            ModuleMetadata it = (ModuleMetadata)element$iv$iv;
            boolean bl = false;
            if (!(attributeGetter.invoke((Object)it) == null ? true : (Boolean)isAttributePresent.invoke(attribute) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List modulesWithoutAttribute = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModuleMetadata it = (ModuleMetadata)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getPath());
                it = (ModuleMetadata)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPath())));
            }
        });
        Iterable $this$associate$iv = this.modules;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable $i$f$filterTo22 = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            ModuleMetadata it = (ModuleMetadata)element$iv$iv;
            boolean bl = false;
            Path path = Paths.get(it.getPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Pair pair = TuplesKt.to((Object)path, (Object)attributeGetter.invoke((Object)it));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map mapModulePathAttribute = MapsKt.plus((Map)destination$iv$iv2, projectValue);
        for (ModuleMetadata module : modulesWithoutAttribute) {
            this.addAttributeFromAncestor(module, mapModulePathAttribute, attributeSetter, isAttributePresent);
        }
    }

    static /* synthetic */ void shareAttributes$default(ProjectMetadata projectMetadata2, Function1 function1, Function2 function2, Function1 function12, Map map, int n, Object object) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        projectMetadata2.shareAttributes(function1, function2, function12, map);
    }

    private final <T> void addAttributeFromAncestor(ModuleMetadata module, Map<Path, ? extends T> mapModulePathAttribute, Function2<? super ModuleMetadata, ? super T, Unit> attributeSetter, Function1<? super T, Boolean> isAttributePresent) {
        Path path = Paths.get(this.path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path projectPath = path;
        Path path2 = Paths.get(module.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path currentPath = path2;
        while (!Intrinsics.areEqual((Object)currentPath, (Object)projectPath)) {
            T parentPathAttribute = mapModulePathAttribute.get(currentPath.getParent());
            if (parentPathAttribute != null && ((Boolean)isAttributePresent.invoke(parentPathAttribute)).booleanValue()) {
                attributeSetter.invoke((Object)module, parentPathAttribute);
                return;
            }
            if (currentPath.getParent() != null) continue;
            return;
        }
    }

    public final void shareModuleVersion() {
        ProjectMetadata.shareAttributes$default(this, shareModuleVersion.1.INSTANCE, shareModuleVersion.2.INSTANCE, shareModuleVersion.3.INSTANCE, null, 8, null);
    }

    public final void shareModuleLicense() {
        Function1 function1 = shareModuleLicense.1.INSTANCE;
        Function2 function2 = shareModuleLicense.2.INSTANCE;
        Function1 function12 = shareModuleLicense.3.INSTANCE;
        Path path = Paths.get(this.path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.shareAttributes(function1, function2, function12, MapsKt.mapOf((Pair)TuplesKt.to((Object)path, this.projectLicenses)));
    }

    public final void shareModuleSupplier() {
        Function1 function1 = shareModuleSupplier.1.INSTANCE;
        Function2 function2 = shareModuleSupplier.2.INSTANCE;
        Function1 function12 = shareModuleSupplier.3.INSTANCE;
        Path path = Paths.get(this.path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.shareAttributes(function1, function2, function12, MapsKt.mapOf((Pair)TuplesKt.to((Object)path, (Object)this.supplier)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<License> getUniqueModulesLicense() {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this.getModulesLicenses();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            License license = (License)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getKey() + it.getPath(), element$iv$iv);
        }
        return CollectionsKt.toMutableList(destination$iv$iv.values());
    }

    @NotNull
    public final String component1() {
        return this.version;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final String component3() {
        return this.path;
    }

    @NotNull
    public final List<License> component4() {
        return this.projectLicenses;
    }

    @NotNull
    public final List<ModuleMetadata> component5() {
        return this.modules;
    }

    @NotNull
    public final Supplier component6() {
        return this.supplier;
    }

    @Nullable
    public final Checksum component7() {
        return this.checkSum;
    }

    @Nullable
    public final String component8() {
        return this.downloadLocation;
    }

    @NotNull
    public final List<License> component9() {
        return this.licenses;
    }

    @NotNull
    public final List<Dependency> component10() {
        return this.dependencies;
    }

    @NotNull
    public final ProjectMetadata copy(@NotNull String version, @NotNull String name, @NotNull String path, @NotNull List<License> projectLicenses, @NotNull List<ModuleMetadata> modules, @NotNull Supplier supplier, @Nullable Checksum checkSum, @Nullable String downloadLocation, @NotNull List<License> licenses2, @NotNull List<Dependency> dependencies) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(projectLicenses, (String)"projectLicenses");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter((Object)supplier, (String)"supplier");
        Intrinsics.checkNotNullParameter(licenses2, (String)"licenses");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        return new ProjectMetadata(version, name, path, projectLicenses, modules, supplier, checkSum, downloadLocation, licenses2, dependencies);
    }

    public static /* synthetic */ ProjectMetadata copy$default(ProjectMetadata projectMetadata2, String string, String string2, String string3, List list, List list2, Supplier supplier, Checksum checksum, String string4, List list3, List list4, int n, Object object) {
        if ((n & 1) != 0) {
            string = projectMetadata2.version;
        }
        if ((n & 2) != 0) {
            string2 = projectMetadata2.name;
        }
        if ((n & 4) != 0) {
            string3 = projectMetadata2.path;
        }
        if ((n & 8) != 0) {
            list = projectMetadata2.projectLicenses;
        }
        if ((n & 0x10) != 0) {
            list2 = projectMetadata2.modules;
        }
        if ((n & 0x20) != 0) {
            supplier = projectMetadata2.supplier;
        }
        if ((n & 0x40) != 0) {
            checksum = projectMetadata2.checkSum;
        }
        if ((n & 0x80) != 0) {
            string4 = projectMetadata2.downloadLocation;
        }
        if ((n & 0x100) != 0) {
            list3 = projectMetadata2.licenses;
        }
        if ((n & 0x200) != 0) {
            list4 = projectMetadata2.dependencies;
        }
        return projectMetadata2.copy(string, string2, string3, list, list2, supplier, checksum, string4, list3, list4);
    }

    @NotNull
    public String toString() {
        return "ProjectMetadata(version=" + this.version + ", name=" + this.name + ", path=" + this.path + ", projectLicenses=" + this.projectLicenses + ", modules=" + this.modules + ", supplier=" + this.supplier + ", checkSum=" + this.checkSum + ", downloadLocation=" + this.downloadLocation + ", licenses=" + this.licenses + ", dependencies=" + this.dependencies + ")";
    }

    public int hashCode() {
        int result = this.version.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.path.hashCode();
        result = result * 31 + ((Object)this.projectLicenses).hashCode();
        result = result * 31 + ((Object)this.modules).hashCode();
        result = result * 31 + this.supplier.hashCode();
        result = result * 31 + (this.checkSum == null ? 0 : this.checkSum.hashCode());
        result = result * 31 + (this.downloadLocation == null ? 0 : this.downloadLocation.hashCode());
        result = result * 31 + ((Object)this.licenses).hashCode();
        result = result * 31 + ((Object)this.dependencies).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProjectMetadata)) {
            return false;
        }
        ProjectMetadata projectMetadata2 = (ProjectMetadata)other;
        if (!Intrinsics.areEqual((Object)this.version, (Object)projectMetadata2.version)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)projectMetadata2.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)projectMetadata2.path)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.projectLicenses, projectMetadata2.projectLicenses)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.modules, projectMetadata2.modules)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.supplier, (Object)projectMetadata2.supplier)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.checkSum, (Object)projectMetadata2.checkSum)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.downloadLocation, (Object)projectMetadata2.downloadLocation)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.licenses, projectMetadata2.licenses)) {
            return false;
        }
        return Intrinsics.areEqual(this.dependencies, projectMetadata2.dependencies);
    }
}

