/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dependencyAnalysis.core.model;

import com.intellij.dependencyAnalysis.core.model.Dependency;
import com.intellij.dependencyAnalysis.core.model.DependencyDeclaration;
import com.intellij.dependencyAnalysis.core.model.DependencyManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001:\u0001 B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J7\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0013\u0010\u001a\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/intellij/dependencyAnalysis/core/model/DependencyDeclaration;", "", "artifactId", "", "version", "psiDeclaration", "Lcom/intellij/dependencyAnalysis/core/model/DependencyDeclaration$PsiDeclaration;", "psiFile", "Lcom/intellij/psi/PsiFile;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/dependencyAnalysis/core/model/DependencyDeclaration$PsiDeclaration;Lcom/intellij/psi/PsiFile;)V", "getArtifactId", "()Ljava/lang/String;", "getPsiDeclaration", "()Lcom/intellij/dependencyAnalysis/core/model/DependencyDeclaration$PsiDeclaration;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "getVersion", "component1", "component2", "component3", "component4", "copy", "dependencyEquals", "", "other", "Lcom/intellij/dependencyAnalysis/core/model/Dependency;", "equals", "hashCode", "", "suggestLibraryName", "name", "toString", "PsiDeclaration", "intellij.dependencyAnalysis.core"})
public final class DependencyDeclaration {
    @Nullable
    private final String artifactId;
    @Nullable
    private final String version;
    @Nullable
    private final PsiDeclaration psiDeclaration;
    @NotNull
    private final PsiFile psiFile;

    public DependencyDeclaration(@Nullable String artifactId, @Nullable String version, @Nullable PsiDeclaration psiDeclaration, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        this.artifactId = artifactId;
        this.version = version;
        this.psiDeclaration = psiDeclaration;
        this.psiFile = psiFile;
    }

    @Nullable
    public final String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    @Nullable
    public final PsiDeclaration getPsiDeclaration() {
        return this.psiDeclaration;
    }

    @NotNull
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    public final boolean dependencyEquals(@NotNull Dependency other) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String string3 = this.artifactId;
        if (string3 != null) {
            String string4 = string3.toLowerCase(Locale.ROOT);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string2 = null;
        }
        String declarationId = string2;
        String string5 = this.version;
        if (string5 != null) {
            String string6 = string5.toLowerCase(Locale.ROOT);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String declarationVersion = string;
        String string7 = other.getName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
        String dName = string7;
        String string8 = other.getVersion().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
        String dVersion = string8;
        if (declarationId != null) {
            if (Intrinsics.areEqual((Object)dName, (Object)declarationId)) {
                if (declarationVersion == null || Intrinsics.areEqual((Object)dVersion, (Object)declarationVersion)) {
                    return true;
                }
                if (other.getType() == DependencyManager.Composer || other.getType() == DependencyManager.npm || other.getType() == DependencyManager.PyPi) {
                    return true;
                }
            } else {
                String imlNameDependency;
                if (StringsKt.contains$default((CharSequence)dName, (CharSequence)declarationId, (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)dVersion, (Object)declarationVersion)) {
                    return true;
                }
                String string9 = this.psiFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string9, (String)".iml", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)(imlNameDependency = this.suggestLibraryName(other.getId())), (Object)this.artifactId)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final String suggestLibraryName(String name) {
        String string = Stream.of(name).flatMap(arg_0 -> DependencyDeclaration.suggestLibraryName$lambda$0(suggestLibraryName.1.INSTANCE, arg_0)).distinct().filter(arg_0 -> DependencyDeclaration.suggestLibraryName$lambda$1(suggestLibraryName.2.INSTANCE, arg_0)).collect(Collectors.joining("."));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collect(...)");
        return string;
    }

    @Nullable
    public final String component1() {
        return this.artifactId;
    }

    @Nullable
    public final String component2() {
        return this.version;
    }

    @Nullable
    public final PsiDeclaration component3() {
        return this.psiDeclaration;
    }

    @NotNull
    public final PsiFile component4() {
        return this.psiFile;
    }

    @NotNull
    public final DependencyDeclaration copy(@Nullable String artifactId, @Nullable String version, @Nullable PsiDeclaration psiDeclaration, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return new DependencyDeclaration(artifactId, version, psiDeclaration, psiFile);
    }

    public static /* synthetic */ DependencyDeclaration copy$default(DependencyDeclaration dependencyDeclaration2, String string, String string2, PsiDeclaration psiDeclaration, PsiFile psiFile, int n, Object object) {
        if ((n & 1) != 0) {
            string = dependencyDeclaration2.artifactId;
        }
        if ((n & 2) != 0) {
            string2 = dependencyDeclaration2.version;
        }
        if ((n & 4) != 0) {
            psiDeclaration = dependencyDeclaration2.psiDeclaration;
        }
        if ((n & 8) != 0) {
            psiFile = dependencyDeclaration2.psiFile;
        }
        return dependencyDeclaration2.copy(string, string2, psiDeclaration, psiFile);
    }

    @NotNull
    public String toString() {
        return "DependencyDeclaration(artifactId=" + this.artifactId + ", version=" + this.version + ", psiDeclaration=" + this.psiDeclaration + ", psiFile=" + this.psiFile + ")";
    }

    public int hashCode() {
        int result = this.artifactId == null ? 0 : this.artifactId.hashCode();
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.psiDeclaration == null ? 0 : this.psiDeclaration.hashCode());
        result = result * 31 + this.psiFile.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DependencyDeclaration)) {
            return false;
        }
        DependencyDeclaration dependencyDeclaration2 = (DependencyDeclaration)other;
        if (!Intrinsics.areEqual((Object)this.artifactId, (Object)dependencyDeclaration2.artifactId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.version, (Object)dependencyDeclaration2.version)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.psiDeclaration, (Object)dependencyDeclaration2.psiDeclaration)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.psiFile, (Object)dependencyDeclaration2.psiFile);
    }

    private static final Stream suggestLibraryName$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final boolean suggestLibraryName$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/dependencyAnalysis/core/model/DependencyDeclaration$PsiDeclaration;", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "getPsiElement", "()Lcom/intellij/psi/PsiElement;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.dependencyAnalysis.core"})
    public static final class PsiDeclaration {
        @Nullable
        private final PsiElement psiElement;
        @Nullable
        private final TextRange textRange;

        public PsiDeclaration(@Nullable PsiElement psiElement, @Nullable TextRange textRange) {
            this.psiElement = psiElement;
            this.textRange = textRange;
        }

        @Nullable
        public final PsiElement getPsiElement() {
            return this.psiElement;
        }

        @Nullable
        public final TextRange getTextRange() {
            return this.textRange;
        }

        @Nullable
        public final PsiElement component1() {
            return this.psiElement;
        }

        @Nullable
        public final TextRange component2() {
            return this.textRange;
        }

        @NotNull
        public final PsiDeclaration copy(@Nullable PsiElement psiElement, @Nullable TextRange textRange) {
            return new PsiDeclaration(psiElement, textRange);
        }

        public static /* synthetic */ PsiDeclaration copy$default(PsiDeclaration psiDeclaration, PsiElement psiElement, TextRange textRange, int n, Object object) {
            if ((n & 1) != 0) {
                psiElement = psiDeclaration.psiElement;
            }
            if ((n & 2) != 0) {
                textRange = psiDeclaration.textRange;
            }
            return psiDeclaration.copy(psiElement, textRange);
        }

        @NotNull
        public String toString() {
            return "PsiDeclaration(psiElement=" + this.psiElement + ", textRange=" + this.textRange + ")";
        }

        public int hashCode() {
            int result = this.psiElement == null ? 0 : this.psiElement.hashCode();
            result = result * 31 + (this.textRange == null ? 0 : this.textRange.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PsiDeclaration)) {
                return false;
            }
            PsiDeclaration psiDeclaration = (PsiDeclaration)other;
            if (!Intrinsics.areEqual((Object)this.psiElement, (Object)psiDeclaration.psiElement)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.textRange, (Object)psiDeclaration.textRange);
        }
    }
}

