/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dependencyAnalysis.core.inspection.wrapper;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.dependencyAnalysis.core.DependencyAnalysisBundle;
import com.intellij.dependencyAnalysis.core.inspection.InspectionConfig;
import com.intellij.dependencyAnalysis.core.inspection.wrapper.LicenseInspectionWrapper;
import com.intellij.dependencyAnalysis.core.inspection.wrapper.LicenseInspectionWrapperAbstract;
import com.intellij.dependencyAnalysis.core.inspection.wrapper.LicenseInspectionWrapperAbstractKt;
import com.intellij.dependencyAnalysis.core.inspection.wrapper.ProblemType;
import com.intellij.dependencyAnalysis.core.model.Dependency;
import com.intellij.dependencyAnalysis.core.model.DependencyAnalysis;
import com.intellij.dependencyAnalysis.core.model.DependencyDeclaration;
import com.intellij.dependencyAnalysis.core.model.ModuleMetadata;
import com.intellij.dependencyAnalysis.core.model.ProjectMetadata;
import com.intellij.dependencyAnalysis.core.utils.LicenseUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.themis.Compatibility;
import com.jetbrains.themis.License;
import com.jetbrains.themis.LicenseKt;
import com.jetbrains.themis.LicenseTag;
import com.jetbrains.themis.LicenseTagType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.Static_analysis_dispatchersKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u00108\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010\u00142\u0006\u00109\u001a\u00020:H\u0016J\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020?H\u0002J\u001a\u0010@\u001a\u00020<2\u0006\u0010=\u001a\u00020\n2\b\b\u0002\u0010A\u001a\u00020\u0007H\u0002J\u0018\u0010B\u001a\u00020<2\u0006\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010C\u001a\u00020<2\u0006\u0010=\u001a\u00020\nH\u0002J\u0012\u0010D\u001a\u00020\u001c2\b\u0010E\u001a\u0004\u0018\u00010FH\u0005J\u0018\u0010G\u001a\u0004\u0018\u00010H2\u000e\b\u0002\u0010I\u001a\b\u0012\u0004\u0012\u00020<0JJ\u0011\u0010K\u001a\b\u0012\u0004\u0012\u00020+0L\u00a2\u0006\u0002\u0010MJ-\u0010N\u001a\b\u0012\u0004\u0012\u00020+0L2\u0014\b\u0004\u0010O\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0L0JH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010PJ \u0010Q\u001a\u00020<*\b\u0012\u0004\u0012\u00020?0\u00142\f\u0010R\u001a\b\u0012\u0004\u0012\u00020?0\u0014H\u0002R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R \u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0017\"\u0004\b-\u0010\u0019R\u001c\u0010.\u001a\u0004\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\n05X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006S"}, d2={"Lcom/intellij/dependencyAnalysis/core/inspection/wrapper/LicenseInspectionWrapperAbstract;", "Lcom/intellij/dependencyAnalysis/core/inspection/wrapper/LicenseInspectionWrapper;", "scope", "Lcom/intellij/analysis/AnalysisScope;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "batchMode", "", "(Lcom/intellij/analysis/AnalysisScope;Lcom/intellij/codeInspection/InspectionManager;Z)V", "ancestorDependency", "Lcom/intellij/dependencyAnalysis/core/model/Dependency;", "getAncestorDependency", "()Lcom/intellij/dependencyAnalysis/core/model/Dependency;", "setAncestorDependency", "(Lcom/intellij/dependencyAnalysis/core/model/Dependency;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "declaredDependency", "", "Lcom/intellij/dependencyAnalysis/core/model/DependencyDeclaration;", "getDeclaredDependency", "()Ljava/util/List;", "setDeclaredDependency", "(Ljava/util/List;)V", "dependencyIgnoreSet", "", "", "getDependencyIgnoreSet", "()Ljava/util/Set;", "dependencyIgnoreSet$delegate", "Lkotlin/Lazy;", "getManager", "()Lcom/intellij/codeInspection/InspectionManager;", "moduleChecking", "Lcom/intellij/openapi/module/Module;", "getModuleChecking", "()Lcom/intellij/openapi/module/Module;", "setModuleChecking", "(Lcom/intellij/openapi/module/Module;)V", "problems", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getProblems", "setProblems", "psiFile", "Lcom/intellij/psi/PsiFile;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "setPsiFile", "(Lcom/intellij/psi/PsiFile;)V", "reportedDependencies", "", "getScope", "()Lcom/intellij/analysis/AnalysisScope;", "checkDependencies", "moduleMetadata", "Lcom/intellij/dependencyAnalysis/core/model/ModuleMetadata;", "checkDependency", "", "dependency", "moduleLicense", "Lcom/jetbrains/themis/License;", "checkDetectedLicense", "generateProblem", "checkLicenseCompatibility", "checkPackageUrl", "createWrapMessage", "e", "", "getData", "Lcom/intellij/dependencyAnalysis/core/model/ProjectMetadata;", "onSuccess", "Lkotlin/Function0;", "reportWarningOfProjectConfiguration", "", "()[Lcom/intellij/codeInspection/ProblemDescriptor;", "wrapEvaluation", "evaluation", "(Lkotlin/jvm/functions/Function0;)[Lcom/intellij/codeInspection/ProblemDescriptor;", "copyTags", "licenseList", "intellij.dependencyAnalysis.core"})
@SourceDebugExtension(value={"SMAP\nLicenseInspectionWrapperAbstract.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicenseInspectionWrapperAbstract.kt\ncom/intellij/dependencyAnalysis/core/inspection/wrapper/LicenseInspectionWrapperAbstract\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n26#2:171\n1855#3,2:172\n1747#3,3:174\n1194#3,2:177\n1222#3,4:179\n1747#3,3:183\n1855#3:186\n1855#3,2:188\n1856#3:190\n1045#3:191\n1045#3:192\n1#4:187\n*S KotlinDebug\n*F\n+ 1 LicenseInspectionWrapperAbstract.kt\ncom/intellij/dependencyAnalysis/core/inspection/wrapper/LicenseInspectionWrapperAbstract\n*L\n55#1:171\n74#1:172,2\n77#1:174,3\n90#1:177,2\n90#1:179,4\n92#1:183,3\n141#1:186\n143#1:188,2\n141#1:190\n157#1:191\n162#1:192\n*E\n"})
public abstract class LicenseInspectionWrapperAbstract
implements LicenseInspectionWrapper {
    @NotNull
    private final AnalysisScope scope;
    @NotNull
    private final InspectionManager manager;
    private final boolean batchMode;
    @NotNull
    private final Lazy dependencyIgnoreSet$delegate;
    @NotNull
    private Map<String, Dependency> reportedDependencies;
    public Module moduleChecking;
    @NotNull
    private List<DependencyDeclaration> declaredDependency;
    @NotNull
    private List<ProblemDescriptor> problems;
    @Nullable
    private PsiFile psiFile;
    @Nullable
    private Dependency ancestorDependency;
    @NotNull
    private final CoroutineScope coroutineScope;

    public LicenseInspectionWrapperAbstract(@NotNull AnalysisScope scope, @NotNull InspectionManager manager, boolean batchMode) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.scope = scope;
        this.manager = manager;
        this.batchMode = batchMode;
        this.dependencyIgnoreSet$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends String>>(this){
            final /* synthetic */ LicenseInspectionWrapperAbstract this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<String> invoke() {
                Project project = this.this$0.getScope().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return DependencyAnalysis.Companion.getInstance(project).getDependencyIgnoreSet();
            }
        }));
        this.reportedDependencies = new LinkedHashMap();
        this.declaredDependency = CollectionsKt.emptyList();
        this.problems = new ArrayList();
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Static_analysis_dispatchersKt.getStaticAnalysisDispatchers().getDefault().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
    }

    @NotNull
    public AnalysisScope getScope() {
        return this.scope;
    }

    @NotNull
    public InspectionManager getManager() {
        return this.manager;
    }

    private final Set<String> getDependencyIgnoreSet() {
        Lazy lazy = this.dependencyIgnoreSet$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final Module getModuleChecking() {
        Module module = this.moduleChecking;
        if (module != null) {
            return module;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"moduleChecking");
        return null;
    }

    public final void setModuleChecking(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"<set-?>");
        this.moduleChecking = module;
    }

    @NotNull
    public final List<DependencyDeclaration> getDeclaredDependency() {
        return this.declaredDependency;
    }

    public final void setDeclaredDependency(@NotNull List<DependencyDeclaration> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.declaredDependency = list;
    }

    @NotNull
    public final List<ProblemDescriptor> getProblems() {
        return this.problems;
    }

    public final void setProblems(@NotNull List<ProblemDescriptor> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.problems = list;
    }

    @Nullable
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    public final void setPsiFile(@Nullable PsiFile psiFile) {
        this.psiFile = psiFile;
    }

    @Nullable
    public final Dependency getAncestorDependency() {
        return this.ancestorDependency;
    }

    public final void setAncestorDependency(@Nullable Dependency dependency) {
        this.ancestorDependency = dependency;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @NotNull
    public final ProblemDescriptor[] wrapEvaluation(@NotNull Function0<ProblemDescriptor[]> evaluation) {
        ProblemDescriptor[] problemDescriptorArray;
        ProblemDescriptor[] problemDescriptorArray2;
        Intrinsics.checkNotNullParameter(evaluation, (String)"evaluation");
        boolean $i$f$wrapEvaluation = false;
        try {
            boolean bl = false;
            problemDescriptorArray2 = Result.constructor-impl((Object)((ProblemDescriptor[])ArraysKt.plus((Object[])((Object[])evaluation.invoke()), (Object[])this.reportWarningOfProjectConfiguration())));
        }
        catch (Throwable throwable) {
            problemDescriptorArray2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)problemDescriptorArray2);
        if (throwable == null) {
            problemDescriptorArray = problemDescriptorArray2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            LicenseInspectionWrapperAbstractKt.getLOG().warn(it);
            problemDescriptorArray = this.reportIncorrectConfiguration(it);
        }
        return problemDescriptorArray;
    }

    @NotNull
    public final ProblemDescriptor[] reportWarningOfProjectConfiguration() {
        ProblemDescriptor[] problemDescriptorArray;
        Project project = this.getScope().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AtomicBoolean incorrectProjectConfiguration = DependencyAnalysis.Companion.getInstance(project).getIncorrectProjectConfiguration();
        ProjectMetadata pm2 = (ProjectMetadata)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ProjectMetadata>, Object>(this, null){
            int label;
            final /* synthetic */ LicenseInspectionWrapperAbstract this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Project project = this.this$0.getScope().getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        this.label = 1;
                        Object object3 = DependencyAnalysis.Companion.getInstance(project).getProjectMetadata((Continuation<? super ProjectMetadata>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ProjectMetadata> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        if (incorrectProjectConfiguration.get() && pm2 != null) {
            problemDescriptorArray = this.reportIncorrectConfiguration(null);
        } else {
            boolean $i$f$emptyArray = false;
            problemDescriptorArray = new ProblemDescriptor[]{};
        }
        return problemDescriptorArray;
    }

    @Nullable
    public final ProjectMetadata getData(@NotNull Function0<Unit> onSuccess) {
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        return (ProjectMetadata)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ProjectMetadata>, Object>(this, onSuccess, null){
            int label;
            final /* synthetic */ LicenseInspectionWrapperAbstract this$0;
            final /* synthetic */ Function0<Unit> $onSuccess;
            {
                this.this$0 = $receiver;
                this.$onSuccess = $onSuccess;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.obtainData(this.$onSuccess, (Continuation<? super ProjectMetadata>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ProjectMetadata> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static /* synthetic */ ProjectMetadata getData$default(LicenseInspectionWrapperAbstract licenseInspectionWrapperAbstract, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getData");
        }
        if ((n & 1) != 0) {
            function0 = getData.1.INSTANCE;
        }
        return licenseInspectionWrapperAbstract.getData((Function0<Unit>)function0);
    }

    @InspectionMessage
    @NotNull
    protected final String createWrapMessage(@Nullable Throwable e) {
        String message = e != null ? DependencyAnalysisBundle.INSTANCE.getMessage("message.incorrect.configuration.dependencies", new Object[0]) : DependencyAnalysisBundle.INSTANCE.getMessage("message.problem.configuration.dependencies", new Object[0]);
        return message;
    }

    private final void checkDetectedLicense(Dependency dependency, boolean generateProblem2) {
        if (!LicenseKt.areDetected(dependency.getLicenses())) {
            License it;
            Iterable $this$forEach$iv = dependency.getLicenses();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (License)element$iv;
                boolean bl = false;
                if (it.isDetected()) continue;
                it.addTag(LicenseTagType.Unknown, "");
            }
            if (generateProblem2) {
                boolean bl;
                block7: {
                    Iterable $this$any$iv = dependency.getLicenses();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (License)element$iv;
                            boolean bl2 = false;
                            if (!it.isDetected()) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    LicenseInspectionWrapper.generateProblem$default(this, ProblemType.UNKNOWN, dependency, null, null, 12, null);
                }
            }
        }
    }

    static /* synthetic */ void checkDetectedLicense$default(LicenseInspectionWrapperAbstract licenseInspectionWrapperAbstract, Dependency dependency, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkDetectedLicense");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        licenseInspectionWrapperAbstract.checkDetectedLicense(dependency, bl);
    }

    private final void checkPackageUrl(Dependency dependency) {
        if (InspectionConfig.CHECK_PACKAGE_URL_STATUS && Intrinsics.areEqual((Object)dependency.getHomepageUrl(), (Object)"")) {
            LicenseInspectionWrapper.generateProblem$default(this, ProblemType.EMPTY_PACKAGE_URL, dependency, null, null, 12, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkLicenseCompatibility(Dependency dependency, License moduleLicense) {
        boolean bl;
        Collection dependencyLicenses2;
        block6: {
            Iterator $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = dependency.getLicenses();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            Iterator iterator = $this$associateByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object element$iv$iv = iterator.next();
                License license = (License)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl2 = false;
                map.put(it.getKey(), element$iv$iv);
            }
            dependencyLicenses2 = destination$iv$iv.values();
            Iterable $this$any$iv = dependencyLicenses2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    License it = (License)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)Compatibility.INSTANCE.isCompatible(it, moduleLicense), (Object)true)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean toGenerateProblem = !bl;
        for (License dependencyLicense : dependencyLicenses2) {
            String moduleLicenseKey;
            if (!dependencyLicense.isDetected() || LicenseUtilsKt.isUnknown(moduleLicense)) continue;
            String string = moduleLicenseKey = Intrinsics.areEqual((Object)moduleLicense.getKey(), (Object)"NONE") ? "PROPRIETARY-LICENSE" : moduleLicense.getKey();
            Boolean bl4 = Compatibility.INSTANCE.isCompatible(dependencyLicense, moduleLicense);
            if (Intrinsics.areEqual((Object)bl4, (Object)true)) continue;
            if (Intrinsics.areEqual((Object)bl4, (Object)false)) {
                dependencyLicense.addTag(LicenseTagType.Prohibited, moduleLicense.getKey());
                if (!toGenerateProblem) continue;
                this.generateProblem(ProblemType.PROHIBITED, dependency, dependencyLicense.getKey(), moduleLicenseKey);
                continue;
            }
            if (bl4 != null) continue;
            dependencyLicense.addTag(LicenseTagType.Uncategorized, moduleLicense.getKey());
            if (!toGenerateProblem) continue;
            this.generateProblem(ProblemType.UNCATEGORIZED, dependency, dependencyLicense.getKey(), moduleLicenseKey);
        }
    }

    private final void checkDependency(Dependency dependency, License moduleLicense) {
        if (this.getDependencyIgnoreSet().contains(dependency.getName())) {
            return;
        }
        String idDependencyCompatibility = dependency.getIdentifier(this.psiFile, moduleLicense.getKey(), this.ancestorDependency != null);
        Dependency reported = this.reportedDependencies.get(idDependencyCompatibility);
        if (reported != null) {
            this.copyTags(dependency.getLicenses(), reported.getLicenses());
            return;
        }
        String idDependencyDetected = dependency.getIdentifier();
        Dependency dependencyWithDetectedLicense = this.reportedDependencies.get(idDependencyDetected);
        if (dependencyWithDetectedLicense != null) {
            this.checkDetectedLicense(dependency, false);
        } else {
            LicenseInspectionWrapperAbstract.checkDetectedLicense$default(this, dependency, false, 2, null);
            this.reportedDependencies.put(idDependencyDetected, dependency);
        }
        this.checkPackageUrl(dependency);
        this.checkLicenseCompatibility(dependency, moduleLicense);
        this.reportedDependencies.put(idDependencyCompatibility, dependency);
    }

    private final void copyTags(List<License> $this$copyTags, List<License> licenseList) {
        Iterable $this$forEach$iv = $this$copyTags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            License licenseWithTag;
            Object object;
            Object v0;
            Object object22;
            License license;
            block3: {
                license = (License)element$iv;
                boolean bl = false;
                Iterable iterable = licenseList;
                for (Object object22 : iterable) {
                    License it = (License)object22;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getKey(), (Object)license.getKey())) continue;
                    v0 = object22;
                    break block3;
                }
                v0 = null;
            }
            if ((object = (licenseWithTag = (License)v0)) == null || (object = ((License)object).getTags()) == null) continue;
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach2 = false;
            object22 = $this$forEach$iv2.iterator();
            while (object22.hasNext()) {
                Object element$iv2 = object22.next();
                LicenseTag it = (LicenseTag)element$iv2;
                boolean bl = false;
                license.addTag(it.getType(), it.getComment());
            }
        }
    }

    @Override
    @Nullable
    public List<ProblemDescriptor> checkDependencies(@NotNull ModuleMetadata moduleMetadata) {
        Intrinsics.checkNotNullParameter((Object)moduleMetadata, (String)"moduleMetadata");
        this.problems = new ArrayList();
        ModuleMetadata it = moduleMetadata;
        boolean bl = false;
        this.setModuleChecking(it.getModule());
        this.psiFile = this.batchMode ? it.getBuildFile() : this.psiFile;
        this.declaredDependency = it.getDeclaredDependency();
        License moduleLicenses = LicenseUtilsKt.getHighestPriorityLicense(it.getLicenses());
        Iterable $this$sortedBy$iv = it.getDependencies();
        boolean $i$f$sortedBy = false;
        List dependenciesToAnalyse = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Dependency dp = (Dependency)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)dp.getName());
                dp = (Dependency)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)dp.getName())));
            }
        });
        for (Dependency d : dependenciesToAnalyse) {
            this.ancestorDependency = null;
            this.checkDependency(d, moduleLicenses);
            this.ancestorDependency = d;
            Iterable $this$sortedBy$iv2 = d.getOnlyTransitiveDependencies();
            boolean $i$f$sortedBy2 = false;
            List transitiveDependenciesToAnalyze = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Dependency dp = (Dependency)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)dp.getName());
                    dp = (Dependency)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)dp.getName())));
                }
            });
            for (Dependency child : transitiveDependenciesToAnalyze) {
                this.checkDependency(child, moduleLicenses);
            }
        }
        return this.problems;
    }
}

