/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dependencyAnalysis.core.export;

import com.intellij.dependencyAnalysis.core.export.SbomData;
import com.intellij.dependencyAnalysis.core.export.ShortLicense;
import com.intellij.dependencyAnalysis.core.export.ThirdPartyDependencies;
import com.intellij.dependencyAnalysis.core.export.XmlCreator;
import com.intellij.dependencyAnalysis.core.model.ProjectMetadata;
import com.intellij.util.JavaXmlDocumentKt;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u001c\u0010\u001b\u001a\u00020\u00102\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00170\u001dH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/intellij/dependencyAnalysis/core/export/XmlCreator;", "Lcom/intellij/dependencyAnalysis/core/export/ThirdPartyDependencies;", "projectMetadata", "Lcom/intellij/dependencyAnalysis/core/model/ProjectMetadata;", "excludedDependencies", "", "", "(Lcom/intellij/dependencyAnalysis/core/model/ProjectMetadata;Ljava/util/Set;)V", "doc", "Lorg/w3c/dom/Document;", "projectName", "typeName", "getTypeName", "()Ljava/lang/String;", "createDocument", "createRoot", "Lorg/w3c/dom/Element;", "createTable", "fillNameOfColumns", "fillTable", "elemOfTable", "Lcom/intellij/dependencyAnalysis/core/export/SbomData;", "fillXmlFile", "", "htmlTagA", "hrefValue", "text", "htmlTagTD", "transform", "Lkotlin/Function1;", "intellij.dependencyAnalysis.core"})
public final class XmlCreator
extends ThirdPartyDependencies {
    @NotNull
    private final Document doc;
    @NotNull
    private final String projectName;

    public XmlCreator(@NotNull ProjectMetadata projectMetadata2, @NotNull Set<String> excludedDependencies) {
        Intrinsics.checkNotNullParameter((Object)projectMetadata2, (String)"projectMetadata");
        Intrinsics.checkNotNullParameter(excludedDependencies, (String)"excludedDependencies");
        super(projectMetadata2, excludedDependencies, null);
        Document document = JavaXmlDocumentKt.createDocumentBuilder$default((boolean)false, (int)1, null).newDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"newDocument(...)");
        this.doc = document;
        this.projectName = projectMetadata2.getName();
    }

    public /* synthetic */ XmlCreator(ProjectMetadata projectMetadata2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        this(projectMetadata2, set);
    }

    @Override
    @NotNull
    public String getTypeName() {
        return ".xml";
    }

    private final void fillXmlFile() {
        this.doc.setXmlStandalone(true);
        Element root = this.createRoot();
        Element p = this.doc.createElement("p");
        p.setTextContent("This page lists the third-party software dependencies used in " + this.projectName);
        root.appendChild(p);
        Element table = this.createTable();
        root.appendChild(table);
    }

    private final Element createRoot() {
        Element root = this.doc.createElement("topic");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:noNamespaceSchemaLocation", "https://resources.jetbrains.com/stardust/topic.v2.xsd");
        root.setAttribute("id", "third-party-dependencies");
        root.setAttribute("title", "Third-Party Software used in " + this.projectName);
        this.doc.appendChild(root);
        Intrinsics.checkNotNull((Object)root);
        return root;
    }

    private final Element createTable() {
        Element table = this.doc.createElement("table");
        table.appendChild(this.fillNameOfColumns());
        for (SbomData row : this.getData()) {
            table.appendChild(this.fillTable(row));
        }
        Intrinsics.checkNotNull((Object)table);
        return table;
    }

    private final Element fillNameOfColumns() {
        Element tr;
        Element columnTitle = tr = this.doc.createElement("tr");
        boolean bl = false;
        columnTitle.appendChild(this.htmlTagTD((Function1<? super Element, Unit>)((Function1)fillNameOfColumns.1.1.INSTANCE)));
        columnTitle.appendChild(this.htmlTagTD((Function1<? super Element, Unit>)((Function1)fillNameOfColumns.1.2.INSTANCE)));
        columnTitle.appendChild(this.htmlTagTD((Function1<? super Element, Unit>)((Function1)fillNameOfColumns.1.3.INSTANCE)));
        Intrinsics.checkNotNull((Object)tr);
        return tr;
    }

    private final Element htmlTagTD(Function1<? super Element, Unit> transform) {
        Element td = this.doc.createElement("td");
        Intrinsics.checkNotNull((Object)td);
        transform.invoke((Object)td);
        return td;
    }

    private final Element fillTable(SbomData elemOfTable) {
        Element tr;
        Element el = tr = this.doc.createElement("tr");
        boolean bl = false;
        el.appendChild(this.htmlTagTD((Function1<? super Element, Unit>)((Function1)new Function1<Element, Unit>(this, elemOfTable){
            final /* synthetic */ XmlCreator this$0;
            final /* synthetic */ SbomData $elemOfTable;
            {
                this.this$0 = $receiver;
                this.$elemOfTable = $elemOfTable;
                super(1);
            }

            public final void invoke(@NotNull Element td) {
                Intrinsics.checkNotNullParameter((Object)td, (String)"td");
                td.appendChild(XmlCreator.access$htmlTagA(this.this$0, this.$elemOfTable.getHomepageUrl(), this.$elemOfTable.getDependencyName()));
            }
        })));
        el.appendChild(this.htmlTagTD((Function1<? super Element, Unit>)((Function1)new Function1<Element, Unit>(elemOfTable){
            final /* synthetic */ SbomData $elemOfTable;
            {
                this.$elemOfTable = $elemOfTable;
                super(1);
            }

            public final void invoke(@NotNull Element td) {
                Intrinsics.checkNotNullParameter((Object)td, (String)"td");
                td.setTextContent(this.$elemOfTable.getVersion());
            }
        })));
        el.appendChild(this.htmlTagTD((Function1<? super Element, Unit>)((Function1)new Function1<Element, Unit>(elemOfTable, this){
            final /* synthetic */ SbomData $elemOfTable;
            final /* synthetic */ XmlCreator this$0;
            {
                this.$elemOfTable = $elemOfTable;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Element td) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)td, (String)"td");
                Iterable iterable = this.$elemOfTable.getLicenses();
                XmlCreator xmlCreator = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ShortLicense it = (ShortLicense)element$iv;
                    boolean bl = false;
                    td.appendChild(XmlCreator.access$htmlTagA(xmlCreator, it.getHomepageUrl(), it.getLicenseId()));
                }
            }
        })));
        Intrinsics.checkNotNull((Object)tr);
        return tr;
    }

    private final Element htmlTagA(String hrefValue, String text2) {
        Element elem = this.doc.createElement("a");
        elem.setAttribute("href", hrefValue);
        elem.setTextContent(text2);
        Intrinsics.checkNotNull((Object)elem);
        return elem;
    }

    @Override
    @NotNull
    public String createDocument() {
        this.fillXmlFile();
        Transformer transformer = TransformerFactory.newDefaultInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        DOMImplementation dOMImplementation = this.doc.getImplementation();
        Intrinsics.checkNotNullExpressionValue((Object)dOMImplementation, (String)"getImplementation(...)");
        DOMImplementation domImpl = dOMImplementation;
        DocumentType documentType = domImpl.createDocumentType("doctype", "", "https://resources.jetbrains.com/stardust/html-entities.dtd");
        Intrinsics.checkNotNullExpressionValue((Object)documentType, (String)"createDocumentType(...)");
        DocumentType doctype = documentType;
        transformer.setOutputProperty("doctype-system", doctype.getSystemId());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(this.doc), new StreamResult(stream));
        byte[] byArray = stream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] byArray2 = byArray;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(byArray2, charset2);
    }

    public static final /* synthetic */ Element access$htmlTagA(XmlCreator $this, String hrefValue, String text2) {
        return $this.htmlTagA(hrefValue, text2);
    }
}

