/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dependencyAnalysis.core.export;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.dependencyAnalysis.core.export.CreationInfo;
import com.intellij.dependencyAnalysis.core.export.ExtractedLicensingInfo;
import com.intellij.dependencyAnalysis.core.export.File;
import com.intellij.dependencyAnalysis.core.export.FileType;
import com.intellij.dependencyAnalysis.core.export.Package;
import com.intellij.dependencyAnalysis.core.export.PrimaryPackagePurpose;
import com.intellij.dependencyAnalysis.core.export.Relationship;
import com.intellij.dependencyAnalysis.core.export.RelationshipType;
import com.intellij.dependencyAnalysis.core.export.SPDX;
import com.intellij.dependencyAnalysis.core.export.SpdxExporter;
import com.intellij.dependencyAnalysis.core.export.SpdxExporterKt;
import com.intellij.dependencyAnalysis.core.export.ThirdPartyDependencies;
import com.intellij.dependencyAnalysis.core.model.Algorithm;
import com.intellij.dependencyAnalysis.core.model.Checksum;
import com.intellij.dependencyAnalysis.core.model.Dependency;
import com.intellij.dependencyAnalysis.core.model.ModuleMetadata;
import com.intellij.dependencyAnalysis.core.model.ProjectMetadata;
import com.intellij.dependencyAnalysis.core.model.SpdxConverter;
import com.intellij.dependencyAnalysis.core.utils.CommonUtilsKt;
import com.intellij.dependencyAnalysis.core.utils.TreeUtilsKt;
import com.jetbrains.themis.License;
import com.jetbrains.themis.LicenseKt;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 K2\u00020\u0001:\u0001KB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010(\u001a\u00020\bH\u0016J@\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00112\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00112\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u00112\f\u00101\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0002J\b\u00102\u001a\u00020\bH\u0002J\u001a\u00103\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u00110\u000bH\u0002J\u0014\u00104\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020.0\u0011H\u0002J(\u00106\u001a\b\u0012\u0004\u0012\u0002000\u00112\u0018\u00107\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u00110\u000bH\u0002J\b\u00108\u001a\u00020*H\u0002J(\u00109\u001a\b\u0012\u0004\u0012\u00020,0\u00112\u0018\u00107\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u00110\u000bH\u0002J\f\u0010:\u001a\u00020\b*\u00020;H\u0002J\u0012\u0010:\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\f\u0010<\u001a\u00020\b*\u00020\bH\u0002J\u0012\u0010=\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0018\u0010>\u001a\b\u0012\u0004\u0012\u00020\b0\u0011*\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\f\u0010?\u001a\u00020\b*\u00020;H\u0002J \u00106\u001a\b\u0012\u0004\u0012\u0002000\u0011*\b\u0012\u0004\u0012\u00020;0\u00112\u0006\u0010@\u001a\u00020\bH\u0002J\f\u0010A\u001a\u00020B*\u00020\u0012H\u0002J\f\u0010C\u001a\u00020B*\u00020\u0012H\u0002J<\u0010D\u001a\b\u0012\u0004\u0012\u00020,0\u0011*\b\u0012\u0004\u0012\u00020\u00120\u00112\n\b\u0002\u0010E\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010F\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010HH\u0002J\f\u0010I\u001a\u00020.*\u00020;H\u0002J\f\u0010I\u001a\u00020.*\u00020JH\u0002J\f\u0010I\u001a\u00020.*\u00020\u0003H\u0002R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001c\u001a\u00020\b*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0018\u0010\u001f\u001a\u00020 *\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0018\u0010#\u001a\u00020\b*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001eR\u001a\u0010%\u001a\u0004\u0018\u00010\b*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006L"}, d2={"Lcom/intellij/dependencyAnalysis/core/export/SpdxExporter;", "Lcom/intellij/dependencyAnalysis/core/export/ThirdPartyDependencies;", "projectMetadata", "Lcom/intellij/dependencyAnalysis/core/model/ProjectMetadata;", "spdxConverter", "Lcom/intellij/dependencyAnalysis/core/model/SpdxConverter;", "excludedDependencies", "", "", "(Lcom/intellij/dependencyAnalysis/core/model/ProjectMetadata;Lcom/intellij/dependencyAnalysis/core/model/SpdxConverter;Ljava/util/Set;)V", "extractedLicensingInfo", "", "Lcom/intellij/dependencyAnalysis/core/export/ExtractedLicensingInfo;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "overridedDependencies", "", "Lcom/jetbrains/themis/License;", "getProjectMetadata", "()Lcom/intellij/dependencyAnalysis/core/model/ProjectMetadata;", "getSpdxConverter", "()Lcom/intellij/dependencyAnalysis/core/model/SpdxConverter;", "spdxProjectName", "typeName", "getTypeName", "()Ljava/lang/String;", "uriName", "fileName", "getFileName", "(Ljava/lang/String;)Ljava/lang/String;", "fileType", "Lcom/intellij/dependencyAnalysis/core/export/FileType;", "getFileType", "(Ljava/lang/String;)Lcom/intellij/dependencyAnalysis/core/export/FileType;", "shortPath", "getShortPath", "spdxName", "getSpdxName", "(Lcom/jetbrains/themis/License;)Ljava/lang/String;", "createDocument", "createSpdxDocument", "Lcom/intellij/dependencyAnalysis/core/export/SPDX;", "files", "Lcom/intellij/dependencyAnalysis/core/export/File;", "packages", "Lcom/intellij/dependencyAnalysis/core/export/Package;", "relationships", "Lcom/intellij/dependencyAnalysis/core/export/Relationship;", "hasExtractedLicensingInfos", "generateDocumentNamespace", "getFilesMap", "getNonSpdxLicenses", "getPackages", "getRelationships", "fileRelationship", "getSpdxDocument", "processFiles", "getDeclaredLicenses", "Lcom/intellij/dependencyAnalysis/core/model/Dependency;", "getLicenseKey", "getLicenseNames", "getLicenseNamesDetectedLocally", "getPackageFileName", "spdxModuleName", "isDetectedLocally", "", "isSpdx", "toFiles", "dependencyName", "dependencyVersion", "packageChecksum", "Lcom/intellij/dependencyAnalysis/core/model/Checksum;", "toPackage", "Lcom/intellij/dependencyAnalysis/core/model/ModuleMetadata;", "Companion", "intellij.dependencyAnalysis.core"})
@SourceDebugExtension(value={"SMAP\nSpdxExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpdxExporter.kt\ncom/intellij/dependencyAnalysis/core/export/SpdxExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,386:1\n1360#2:387\n1446#2,5:388\n1194#2,2:399\n1222#2,4:401\n766#2:406\n857#2,2:407\n1603#2,9:409\n1855#2:418\n1856#2:420\n1612#2:421\n1360#2:422\n1446#2,5:423\n1360#2:428\n1446#2,5:429\n1045#2:434\n1179#2,2:435\n1253#2,4:437\n1360#2:441\n1446#2,5:442\n1179#2,2:447\n1253#2,4:449\n1194#2,2:453\n1222#2,4:455\n1477#2:459\n1502#2,3:460\n1505#2,3:470\n1603#2,9:474\n1855#2:483\n1856#2:485\n1612#2:486\n766#2:490\n857#2,2:491\n1603#2,9:493\n1855#2:502\n1856#2:504\n1612#2:505\n350#2,7:506\n1549#2:513\n1620#2,3:514\n1360#2:517\n1446#2,5:518\n1655#2,8:523\n1549#2:531\n1620#2,3:532\n1194#2,2:535\n1222#2,4:537\n1549#2:541\n1620#2,3:542\n1360#2:545\n1446#2,5:546\n1549#2:554\n1620#2,3:555\n1194#2,2:561\n1222#2,4:563\n1855#2,2:567\n1549#2:569\n1620#2,3:570\n1360#2:573\n1446#2,2:574\n1549#2:576\n1620#2,3:577\n1448#2,3:580\n603#3:393\n658#3:394\n739#3,4:395\n1#4:405\n1#4:419\n1#4:484\n1#4:503\n372#5,7:463\n215#6:473\n216#6:487\n215#6,2:488\n76#6:551\n96#6,2:552\n98#6,3:558\n*S KotlinDebug\n*F\n+ 1 SpdxExporter.kt\ncom/intellij/dependencyAnalysis/core/export/SpdxExporter\n*L\n43#1:387\n43#1:388,5\n54#1:399,2\n54#1:401,4\n144#1:406\n144#1:407,2\n145#1:409,9\n145#1:418\n145#1:420\n145#1:421\n160#1:422\n160#1:423,5\n161#1:428\n161#1:429,5\n162#1:434\n219#1:435,2\n219#1:437,4\n220#1:441\n220#1:442,5\n220#1:447,2\n220#1:449,4\n229#1:453,2\n229#1:455,4\n230#1:459\n230#1:460,3\n230#1:470,3\n233#1:474,9\n233#1:483\n233#1:485\n233#1:486\n245#1:490\n245#1:491,2\n246#1:493,9\n246#1:502\n246#1:504\n246#1:505\n275#1:506,7\n299#1:513\n299#1:514,3\n301#1:517\n301#1:518,5\n302#1:523,8\n303#1:531\n303#1:532,3\n304#1:535,2\n304#1:537,4\n322#1:541\n322#1:542,3\n330#1:545\n330#1:546,5\n335#1:554\n335#1:555,3\n344#1:561,2\n344#1:563,4\n346#1:567,2\n353#1:569\n353#1:570,3\n361#1:573\n361#1:574,2\n362#1:576\n362#1:577,3\n361#1:580,3\n47#1:393\n48#1:394\n48#1:395,4\n145#1:419\n233#1:484\n246#1:503\n230#1:463,7\n232#1:473\n232#1:487\n238#1:488,2\n334#1:551\n334#1:552,2\n334#1:558,3\n*E\n"})
public final class SpdxExporter
extends ThirdPartyDependencies {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectMetadata projectMetadata;
    @Nullable
    private final SpdxConverter spdxConverter;
    @NotNull
    private final String spdxProjectName;
    private final Gson gson;
    @NotNull
    private final Map<String, List<License>> overridedDependencies;
    @NotNull
    private final Map<String, ExtractedLicensingInfo> extractedLicensingInfo;
    @NotNull
    private final String uriName;
    @NotNull
    public static final String OR_SEPARATOR = " OR ";

    public SpdxExporter(@NotNull ProjectMetadata projectMetadata2, @Nullable SpdxConverter spdxConverter, @NotNull Set<String> excludedDependencies) {
        Intrinsics.checkNotNullParameter((Object)projectMetadata2, (String)"projectMetadata");
        Intrinsics.checkNotNullParameter(excludedDependencies, (String)"excludedDependencies");
        super(projectMetadata2, excludedDependencies, null);
        this.projectMetadata = projectMetadata2;
        this.spdxConverter = spdxConverter;
        this.spdxProjectName = SpdxExporterKt.adaptToSpdxId(this.projectMetadata.getName());
        this.gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        this.overridedDependencies = this.projectMetadata.getOverridedDependenciesNames();
        this.extractedLicensingInfo = this.getNonSpdxLicenses();
        this.uriName = "https://" + this.projectMetadata.getName();
    }

    public /* synthetic */ SpdxExporter(ProjectMetadata projectMetadata2, SpdxConverter spdxConverter, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            spdxConverter = null;
        }
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        this(projectMetadata2, spdxConverter, set);
    }

    @NotNull
    public final ProjectMetadata getProjectMetadata() {
        return this.projectMetadata;
    }

    @Nullable
    public final SpdxConverter getSpdxConverter() {
        return this.spdxConverter;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ExtractedLicensingInfo> getNonSpdxLicenses() {
        void $this$associateByTo$iv$iv;
        Object it;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Sequence $this$sortedBy$iv;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object object = this.spdxConverter;
        if (object == null || (object = ((SpdxConverter)object).getSpdx()) == null || (object = ((SPDX)object).getHasExtractedLicensingInfos()) == null) {
            object = CollectionsKt.emptyList();
        }
        List<ExtractedLicensingInfo> cachedNonSpdxLicenses = object;
        Sequence dependencyLicenses2 = SequencesKt.flatMapIterable((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.projectMetadata.getModules()), (Function1)getNonSpdxLicenses.dependencyLicenses.1.INSTANCE), (Function1)getNonSpdxLicenses.dependencyLicenses.2.INSTANCE);
        Iterable iterable = this.projectMetadata.getModules();
        Object object2 = this.projectMetadata.getProjectLicenses();
        boolean $i$f$flatMap22 = false;
        void var6_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ModuleMetadata it2 = (ModuleMetadata)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it2.getLicenses();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List otherLicenses = CollectionsKt.plus((Collection)object2, (Iterable)((List)destination$iv$iv));
        Sequence $i$f$flatMap22 = SequencesKt.distinctBy((Sequence)SequencesKt.filter((Sequence)SequencesKt.plus((Sequence)dependencyLicenses2, (Iterable)otherLicenses), (Function1)((Function1)new Function1<License, Boolean>(this){
            final /* synthetic */ SpdxExporter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull License it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !SpdxExporter.access$isSpdx(this.this$0, it) && !Intrinsics.areEqual((Object)it.getKey(), (Object)"NONE");
            }
        })), (Function1)getNonSpdxLicenses.pmNonSpdxLicenses.2.INSTANCE);
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                License it = (License)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getKey());
                it = (License)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getKey())));
            }
        });
        boolean $i$f$associate = false;
        destination$iv$iv = $this$associate$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl = destination$iv$iv2;
            it = (License)element$iv$iv;
            boolean bl2 = false;
            String string = ((License)it).getKey();
            String string2 = ((License)it).getText();
            if (string2 == null && (string2 = ((License)it).getName()) == null) {
                string2 = "";
            }
            String string3 = string2;
            String string4 = "LicenseRef-" + ((License)it).getKey();
            it = TuplesKt.to((Object)string, (Object)new ExtractedLicensingInfo(string4, string3, null, null, null, null, 60, null));
            bl.put(it.getFirst(), it.getSecond());
        }
        Map pmNonSpdxLicenses2 = destination$iv$iv2;
        Iterable $this$associateBy$iv = cachedNonSpdxLicenses;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            it = (ExtractedLicensingInfo)element$iv$iv;
            object2 = destination$iv$iv3;
            boolean bl = false;
            object2.put(this.getLicenseKey(((ExtractedLicensingInfo)it).getLicenseId()), element$iv$iv);
        }
        return MapsKt.plus((Map)destination$iv$iv3, (Map)pmNonSpdxLicenses2);
    }

    private final String getLicenseKey(String $this$getLicenseKey) {
        return StringsKt.substringAfter$default((String)$this$getLicenseKey, (String)"-", null, (int)2, null);
    }

    private final boolean isSpdx(License $this$isSpdx) {
        return $this$isSpdx.getSpdxUrl() != null;
    }

    private final Package toPackage(Dependency $this$toPackage) {
        String string;
        String licenseConcluded = this.getLicenseNames($this$toPackage.getLicenses());
        String licenseDeclared = this.getDeclaredLicenses($this$toPackage);
        List<String> licenseInfoFromFiles = this.getLicenseNamesDetectedLocally($this$toPackage.getLicenses());
        boolean fileAnalyzed = !licenseInfoFromFiles.contains("NOASSERTION");
        Checksum checkSum = $this$toPackage.getCheckSum();
        String string2 = Package.Companion.getSpdxId($this$toPackage.getName(), $this$toPackage.getVersion());
        String string3 = $this$toPackage.getDownloadLocation();
        if (string3 == null) {
            string3 = "NOASSERTION";
        }
        String string4 = string3;
        String it = string = $this$toPackage.getHomepageUrl();
        boolean bl = false;
        String string5 = !StringsKt.isBlank((CharSequence)it) ? string : null;
        string = $this$toPackage.getSupplier().getName();
        String string6 = $this$toPackage.getCopyrightText();
        if (string6 == null) {
            string6 = "NOASSERTION";
        }
        String string7 = string6;
        String string8 = $this$toPackage.getType().isJava() ? $this$toPackage.getId() : $this$toPackage.getName();
        Checksum checksum = checkSum;
        List list = checksum != null ? CollectionsKt.listOf((Object)checksum) : null;
        String string9 = this.getPackageFileName($this$toPackage);
        String string10 = $this$toPackage.getVersion();
        return new Package(string2, string8, string10, null, string4, fileAnalyzed, string5, licenseConcluded, licenseDeclared, licenseInfoFromFiles, null, string7, null, null, string9, string, null, list, null, null, null, null, null, null, null, null, null, null, 268252168, null);
    }

    private final Package toPackage(ProjectMetadata $this$toPackage) {
        String licenseConcluded = this.getLicenseNames($this$toPackage.getProjectLicenses());
        String licenseDeclared = this.getDeclaredLicenses($this$toPackage.getProjectLicenses());
        List<String> licenseInfoFromFiles = this.getLicenseNamesDetectedLocally($this$toPackage.getProjectLicenses());
        boolean fileAnalyzed = !licenseInfoFromFiles.contains("NOASSERTION");
        Checksum pChecksum = $this$toPackage.getCheckSum();
        String string = this.spdxProjectName;
        String string2 = $this$toPackage.getDownloadLocation();
        if (string2 == null) {
            string2 = "NOASSERTION";
        }
        String string3 = string2;
        PrimaryPackagePurpose primaryPackagePurpose = PrimaryPackagePurpose.SOURCE;
        String string4 = $this$toPackage.getSupplier().getName();
        Checksum checksum = pChecksum;
        List list = checksum != null ? CollectionsKt.listOf((Object)checksum) : null;
        String string5 = $this$toPackage.getName();
        return new Package(string, string5, null, null, string3, fileAnalyzed, null, licenseConcluded, licenseDeclared, licenseInfoFromFiles, null, null, null, null, null, string4, null, list, null, primaryPackagePurpose, null, null, null, null, null, null, null, null, 267746380, null);
    }

    private final Package toPackage(ModuleMetadata $this$toPackage) {
        String licenseConcluded = this.getLicenseNames($this$toPackage.getLicenses());
        String licenseDeclared = this.getDeclaredLicenses($this$toPackage.getLicenses());
        List<String> licenseInfoFromFiles = this.getLicenseNamesDetectedLocally($this$toPackage.getLicenses());
        boolean fileAnalyzed = !licenseInfoFromFiles.contains("NOASSERTION");
        Checksum checkSum = $this$toPackage.getCheckSum();
        String string = SpdxExporterKt.adaptToSpdxId($this$toPackage.getName());
        String string2 = $this$toPackage.getDownloadLocation();
        if (string2 == null) {
            string2 = "NOASSERTION";
        }
        String string3 = string2;
        List<String> list = this.getLicenseNamesDetectedLocally($this$toPackage.getLicenses());
        String string4 = $this$toPackage.getSupplier().getName();
        PrimaryPackagePurpose primaryPackagePurpose = PrimaryPackagePurpose.SOURCE;
        String string5 = $this$toPackage.getName();
        String string6 = $this$toPackage.getVersion();
        Checksum checksum = checkSum;
        List list2 = checksum != null ? CollectionsKt.listOf((Object)checksum) : null;
        String string7 = $this$toPackage.getHomepageUrl();
        return new Package(string, string5, string6, null, string3, fileAnalyzed, string7, licenseConcluded, licenseDeclared, list, null, null, null, null, null, string4, null, list2, null, primaryPackagePurpose, null, null, null, null, null, null, null, null, 267746312, null);
    }

    private final String getDeclaredLicenses(List<License> $this$getDeclaredLicenses) {
        return com.intellij.dependencyAnalysis.core.export.SpdxExporter$Companion.joinToStringLicenses$default(Companion, this.getLicenseNamesDetectedLocally($this$getDeclaredLicenses), null, 1, null);
    }

    private final String getDeclaredLicenses(Dependency $this$getDeclaredLicenses) {
        List<License> list = this.overridedDependencies.get($this$getDeclaredLicenses.getIdentifier());
        if (list == null) {
            list = $this$getDeclaredLicenses.getLicenses();
        }
        List<License> l = list;
        return com.intellij.dependencyAnalysis.core.export.SpdxExporter$Companion.joinToStringLicenses$default(Companion, this.getLicenseNamesDetectedLocally(l), null, 1, null);
    }

    private final String getLicenseNames(List<License> $this$getLicenseNames) {
        return LicenseKt.areDetected($this$getLicenseNames) ? Companion.joinToStringLicenses($this$getLicenseNames, (Function1)new Function1<License, CharSequence>(this){
            final /* synthetic */ SpdxExporter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull License l) {
                Intrinsics.checkNotNullParameter((Object)l, (String)"l");
                String string = SpdxExporter.access$getSpdxName(this.this$0, l);
                Intrinsics.checkNotNull((Object)string);
                return string;
            }
        }) : "NOASSERTION";
    }

    private final boolean isDetectedLocally(License $this$isDetectedLocally) {
        return $this$isDetectedLocally.getPath() != null && $this$isDetectedLocally.isDetected();
    }

    private final String getSpdxName(License $this$spdxName) {
        String string;
        String it = string = $this$spdxName.getKey();
        boolean bl = false;
        String string2 = this.isSpdx($this$spdxName) ? string : null;
        if (string2 == null) {
            ExtractedLicensingInfo extractedLicensingInfo = this.extractedLicensingInfo.get($this$spdxName.getKey());
            string2 = extractedLicensingInfo != null ? extractedLicensingInfo.getLicenseId() : null;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getLicenseNamesDetectedLocally(List<License> $this$getLicenseNamesDetectedLocally) {
        Collection collection;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$getLicenseNamesDetectedLocally;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            License it = (License)element$iv$iv;
            boolean bl = false;
            if (!this.isDetectedLocally(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            License l = (License)element$iv$iv;
            boolean bl2 = false;
            if (this.getSpdxName(l) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection collection2 = (List)destination$iv$iv;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = CollectionsKt.listOf((Object)"NOASSERTION");
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    private final String getPackageFileName(Dependency $this$getPackageFileName) {
        String string = (String)CollectionsKt.getOrNull($this$getPackageFileName.getPaths(), (int)0);
        if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null)) == null) {
            string = $this$getPackageFileName.getName();
        }
        return string;
    }

    private final String generateDocumentNamespace() {
        Iterable list$iv$iv;
        Object it;
        Object element$iv$iv;
        Object $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Iterable iterable = this.projectMetadata.getModules();
        String string = this.projectMetadata.getName();
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (ModuleMetadata)element$iv$iv;
            boolean bl = false;
            list$iv$iv = TreeUtilsKt.getFlatUniqueDependencies(((ModuleMetadata)it).getDependencies());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (Dependency)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((Dependency)it).getLicenses();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        String combinedString2 = string + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                License it = (License)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getKey());
                it = (License)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getKey())));
            }
        }), null, null, null, (int)0, null, (Function1)generateDocumentNamespace.combinedString.4.INSTANCE, (int)31, null);
        MessageDigest hasher = MessageDigest.getInstance("SHA-1");
        $this$flatMapTo$iv$iv = combinedString2;
        byte[] byArray = ((String)$this$flatMapTo$iv$iv).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = hasher.digest(byArray);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long highBits = buffer.getLong();
        long lowBits = buffer.getLong();
        String string2 = new UUID(highBits, lowBits).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String hash = string2;
        return this.uriName + "-" + hash;
    }

    private final SPDX getSpdxDocument() {
        Map<String, List<File>> filesMap = this.getFilesMap();
        List hasExtractedLicensingInfos = CollectionsKt.toList((Iterable)this.extractedLicensingInfo.values());
        List<Package> packages = this.getPackages();
        List<Relationship> relationships = this.getRelationships(filesMap);
        List<File> files2 = this.processFiles(filesMap);
        return this.createSpdxDocument(files2, packages, relationships, hasExtractedLicensingInfos);
    }

    private final List<File> processFiles(Map<String, ? extends List<File>> fileRelationship) {
        List list;
        Sequence files2 = SequencesKt.distinctBy((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)fileRelationship.values())), (Function1)processFiles.files.1.INSTANCE);
        Object object = this.spdxConverter;
        if (object == null || (object = ((SpdxConverter)object).getSpdx()) == null || (object = ((SPDX)object).getFiles()) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
            return SequencesKt.toList((Sequence)files2);
        }
        Collection<File> cachedFiles = object;
        Set filesNotInList = SetsKt.minus(cachedFiles, (Sequence)files2);
        List it = list = SequencesKt.toMutableList((Sequence)files2);
        boolean bl = false;
        it.addAll(filesNotInList);
        return list;
    }

    private final SPDX createSpdxDocument(List<File> files2, List<Package> packages, List<Relationship> relationships, List<ExtractedLicensingInfo> hasExtractedLicensingInfos) {
        Object object;
        Object spdxCreationInfo;
        Object object2;
        Object documentNamespace;
        Object object3 = this.spdxConverter;
        if (object3 == null || (object3 = ((SpdxConverter)object3).getSpdx()) == null || (object3 = ((SPDX)object3).getDocumentNamespace()) == null) {
            object3 = documentNamespace = this.generateDocumentNamespace();
        }
        if ((object2 = this.spdxConverter) == null || (object2 = ((SpdxConverter)object2).getSpdx()) == null || (object2 = ((SPDX)object2).getCreationInfo()) == null) {
            object2 = spdxCreationInfo = new CreationInfo(null, null, null, null, 15, null);
        }
        if ((object = this.spdxConverter) == null || (object = ((SpdxConverter)object).getSpdx()) == null || (object = SPDX.copy$default((SPDX)object, null, null, null, null, (String)documentNamespace, null, (CreationInfo)spdxCreationInfo, packages, files2, null, relationships, null, null, null, hasExtractedLicensingInfos, null, 47663, null)) == null) {
            String string = this.spdxProjectName;
            object = new SPDX(null, string, null, null, (String)documentNamespace, null, (CreationInfo)spdxCreationInfo, packages, files2, null, relationships, null, null, null, hasExtractedLicensingInfos, null, 47661, null);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<File>> getFilesMap() {
        Map map;
        List<Relationship> list;
        Map cachedFilesMap;
        Relationship it;
        Object element$iv$iv;
        Object object;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$associateTo$iv$iv2;
        Map projectLicense = MapsKt.mapOf((Pair)TuplesKt.to((Object)this.spdxProjectName, (Object)SpdxExporter.toFiles$default(this, this.projectMetadata.getProjectLicenses(), null, null, null, 7, null)));
        Iterable $this$associate$iv2 = this.projectMetadata.getModules();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv2;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv2 : $this$associateTo$iv$iv2) {
            Map map2 = destination$iv$iv;
            ModuleMetadata it2 = (ModuleMetadata)element$iv$iv2;
            boolean bl = false;
            it2 = TuplesKt.to((Object)SpdxExporterKt.adaptToSpdxId(it2.getName()), (Object)SpdxExporter.toFiles$default(this, it2.getLicenses(), null, null, null, 7, null));
            map2.put(it2.getFirst(), it2.getSecond());
        }
        Map moduleLicenses = destination$iv$iv;
        Iterable $this$flatMap$iv = this.projectMetadata.getModules();
        boolean $i$f$flatMap = false;
        $this$associateTo$iv$iv2 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            ModuleMetadata it3 = (ModuleMetadata)element$iv$iv2;
            boolean bl = false;
            Iterable list$iv$iv = TreeUtilsKt.getFlatUniqueDependencies(it3.getDependencies());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$associate2 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateTo2 = false;
        for (Object element$iv$iv3 : $this$associateTo$iv$iv) {
            Map bl = destination$iv$iv2;
            Dependency it4 = (Dependency)element$iv$iv3;
            boolean bl2 = false;
            it4 = TuplesKt.to((Object)Package.Companion.getSpdxId(it4.getName(), it4.getVersion()), (Object)(it4.getType().isJava() ? this.toFiles(it4.getLicenses(), it4.getName(), it4.getVersion(), it4.getCheckSum()) : SpdxExporter.toFiles$default(this, it4.getLicenses(), it4.getName(), it4.getVersion(), null, 4, null)));
            bl.put(it4.getFirst(), it4.getSecond());
        }
        Map dependencyLicenses2 = destination$iv$iv2;
        Object object2 = this.spdxConverter;
        if (object2 != null && (object2 = ((SpdxConverter)object2).getSpdx()) != null && (object2 = ((SPDX)object2).getFiles()) != null) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = (Iterable)object2;
            boolean $i$f$associateBy = false;
            int capacity$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable bl = $this$associateBy$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv3);
            boolean $i$f$associateByTo = false;
            object = $this$associateByTo$iv$iv.iterator();
            while (object.hasNext()) {
                element$iv$iv = object.next();
                File file = (File)element$iv$iv;
                Map map3 = destination$iv$iv3;
                boolean bl3 = false;
                map3.put(((File)((Object)it)).getSPDXID(), element$iv$iv);
            }
            v1 = destination$iv$iv3;
        } else {
            v1 = cachedFilesMap = MapsKt.emptyMap();
        }
        if ((list = this.spdxConverter) != null && (list = ((SpdxConverter)((Object)list)).getSpdx()) != null && (list = ((SPDX)((Object)list)).getRelationships()) != null) {
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = list;
            boolean $i$f$groupBy = false;
            Iterable $this$associateByTo$iv$iv = $this$groupBy$iv;
            Map destination$iv$iv4 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            object = $this$groupByTo$iv$iv.iterator();
            while (object.hasNext()) {
                Object object3;
                element$iv$iv = object.next();
                it = (Relationship)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = it.getSpdxElementId();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv4;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            map = destination$iv$iv4;
        } else {
            map = MapsKt.emptyMap();
        }
        Map cachedRelationship = map;
        Map allFiles = new LinkedHashMap();
        Map $this$forEach$iv = cachedRelationship;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            Map.Entry element$iv;
            Map.Entry $i$f$groupBy = element$iv = iterator.next();
            boolean bl = false;
            String k = (String)$i$f$groupBy.getKey();
            List v = (List)$i$f$groupBy.getValue();
            Iterable $this$mapNotNull$iv = v;
            boolean $i$f$mapNotNull = false;
            Iterable list$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv5 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                File it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv4 = element$iv$iv$iv = iterator2.next();
                boolean bl5 = false;
                Relationship it5 = (Relationship)element$iv$iv4;
                boolean bl6 = false;
                if ((File)cachedFilesMap.get(it5.getRelatedSpdxElement()) == null) continue;
                boolean bl7 = false;
                destination$iv$iv5.add(it$iv$iv);
            }
            Object it6 = object = (List)destination$iv$iv5;
            boolean bl8 = false;
            Object files2 = !((Collection)it6).isEmpty() ? object : null;
            if (files2 == null) continue;
            allFiles.putIfAbsent(k, files2);
        }
        $this$forEach$iv = MapsKt.plus((Map)MapsKt.plus((Map)projectLicense, (Map)moduleLicenses), (Map)dependencyLicenses2);
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it7 = element$iv = iterator.next();
            boolean bl = false;
            allFiles.putIfAbsent(it7.getKey(), it7.getValue());
        }
        return allFiles;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> toFiles(List<License> $this$toFiles, String dependencyName, String dependencyVersion, Checksum packageChecksum) {
        void $this$mapNotNullTo$iv$iv;
        Iterable licenses2;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$toFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            License it = (License)element$iv$iv;
            boolean bl = false;
            if (!this.isDetectedLocally(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable it = $this$filter$iv = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable2 = !((Collection)it).isEmpty() ? $this$filter$iv : null;
        if (iterable2 == null) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = licenses2 = iterable2;
        boolean $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File file;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            License l = (License)element$iv$iv;
            boolean bl3 = false;
            String string = l.getPath();
            if (string == null || (string = this.getFileName(string)) == null) {
                file = null;
            } else {
                String fileName = string;
                String string2 = l.getPath();
                if (string2 == null || (string2 = this.getShortPath(string2)) == null) {
                    file = null;
                } else {
                    String shortPath = string2;
                    FileType typeFile = this.getFileType(shortPath);
                    if (this.getSpdxName(l) == null) {
                        file = null;
                    } else {
                        String spdxName;
                        String spdxId = dependencyName != null && dependencyVersion != null ? SpdxExporterKt.adaptToSpdxId(dependencyName + "-" + dependencyVersion + "-" + spdxName) : SpdxExporterKt.adaptToSpdxId(fileName + "-" + spdxName);
                        String hash = CommonUtilsKt.calculateSha256(l.getPath());
                        Checksum checksum = hash == null ? null : new Checksum(Algorithm.SHA256, hash);
                        if (checksum == null) {
                            checksum = packageChecksum;
                        }
                        Checksum checksum2 = checksum;
                        List licenseInfoFromFiles = CollectionsKt.listOf((Object)spdxName);
                        Checksum checksum3 = checksum2;
                        List list = checksum3 == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)checksum3);
                        List list2 = CollectionsKt.listOf((Object)((Object)typeFile));
                        String string3 = l.getText();
                        file = new File(spdxId, shortPath, list, list2, spdxName, licenseInfoFromFiles, null, null, string3, null, null, null, null, null, null, 32448, null);
                    }
                }
            }
            if (file == null) continue;
            File it$iv$iv = file;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    static /* synthetic */ List toFiles$default(SpdxExporter spdxExporter, List list, String string, String string2, Checksum checksum, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            checksum = null;
        }
        return spdxExporter.toFiles(list, string, string2, checksum);
    }

    private final String getShortPath(String $this$shortPath) {
        String[] stringArray = new String[]{"/"};
        List parts = StringsKt.split$default((CharSequence)$this$shortPath, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() < 2) {
            return $this$shortPath;
        }
        if (StringsKt.contains$default((CharSequence)$this$shortPath, (CharSequence)".jar", (boolean)false, (int)2, null)) {
            int n;
            block4: {
                List $this$indexOfFirst$iv = parts;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    String it = (String)item$iv;
                    boolean bl = false;
                    if (StringsKt.contains$default((CharSequence)it, (CharSequence)".jar", (boolean)false, (int)2, null)) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int indx = n;
            return "./" + parts.get(indx - 1) + "/" + parts.get(indx);
        }
        return "./" + parts.get(parts.size() - 2) + "/" + CollectionsKt.last((List)parts);
    }

    private final FileType getFileType(String $this$fileType) {
        return StringsKt.contains$default((CharSequence)$this$fileType, (CharSequence)".jar", (boolean)false, (int)2, null) ? FileType.ARCHIVE : (LicenseKt.getLicenseFileNamePattern().matches((CharSequence)this.getFileName($this$fileType)) ? FileType.TEXT : FileType.OTHER);
    }

    private final String getFileName(String $this$fileName) {
        String string;
        if (StringsKt.contains$default((CharSequence)$this$fileName, (CharSequence)".jar", (boolean)false, (int)2, null)) {
            string = StringsKt.substringAfter$default((String)StringsKt.substringBeforeLast$default((String)$this$fileName, (String)".jar", null, (int)2, null), (String)"/", null, (int)2, null);
        } else {
            String string2;
            String it = string2 = StringsKt.substringAfterLast$default((String)$this$fileName, (String)"/", null, (int)2, null);
            boolean bl = false;
            string = ((CharSequence)it).length() > 0 ? string2 : null;
            if (string == null) {
                string = StringsKt.substringAfterLast$default((String)StringsKt.substringBeforeLast$default((String)$this$fileName, (String)"/", null, (int)2, null), (String)"/", null, (int)2, null);
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Package> getPackages() {
        Map map;
        Map $this$mapTo$iv$iv;
        void $this$map$iv;
        Object e$iv2;
        Iterable $this$distinctBy$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Dependency it;
        Object object;
        void $this$mapTo$iv$iv2;
        List projectPackage = CollectionsKt.listOf((Object)this.toPackage(this.projectMetadata));
        Iterable $this$map$iv2 = this.projectMetadata.getModules();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            ModuleMetadata moduleMetadata = (ModuleMetadata)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(this.toPackage((ModuleMetadata)((Object)it)));
        }
        List modulePackages = (List)destination$iv$iv;
        Iterable $i$f$map22 = this.projectMetadata.getModules();
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ModuleMetadata it2 = (ModuleMetadata)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = TreeUtilsKt.getFlatUniqueDependencies(it2.getDependencies());
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv2 : $this$distinctBy$iv) {
            it = (Dependency)e$iv2;
            boolean bl = false;
            String key$iv = it.getIdentifier();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv2);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$map = false;
        set$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        e$iv2 = $this$mapTo$iv$iv.iterator();
        while (e$iv2.hasNext()) {
            void it3;
            Object item$iv$iv = e$iv2.next();
            Dependency bl = (Dependency)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.add(this.toPackage((Dependency)it3));
        }
        List dependencyPackages = (List)destination$iv$iv2;
        Object object2 = this.spdxConverter;
        if (object2 != null && (object2 = ((SpdxConverter)object2).getSpdx()) != null && (object2 = ((SPDX)object2).getPackages()) != null) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = (Iterable)object2;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable bl2 = $this$associateBy$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it4;
                Package package_ = (Package)element$iv$iv;
                object = destination$iv$iv3;
                boolean bl = false;
                object.put(it4.getId(), element$iv$iv);
            }
            map = destination$iv$iv3;
        } else {
            map = MapsKt.emptyMap();
        }
        Map cachedPackages = map;
        Map it5 = $this$mapTo$iv$iv = (Map)new LinkedHashMap();
        boolean bl = false;
        it5.putAll(cachedPackages);
        Map allPackages = $this$mapTo$iv$iv;
        List newPackages = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)projectPackage, (Iterable)modulePackages), (Iterable)dependencyPackages);
        for (Package pkg : newPackages) {
            allPackages.putIfAbsent(pkg.getId(), pkg);
        }
        return CollectionsKt.toList((Iterable)allPackages.values());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Relationship> getRelationships(Map<String, ? extends List<File>> fileRelationship) {
        Map map;
        Relationship $this$mapTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Object element$iv$iv2;
        void $this$flatMapTo$iv$iv2;
        Object object;
        void $this$mapTo$iv$iv2;
        List mainRelationship = CollectionsKt.listOf((Object)new Relationship("SPDXRef-DOCUMENT", RelationshipType.DESCRIBES, this.spdxProjectName, null));
        Iterable $this$map$iv = this.projectMetadata.getModules();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ModuleMetadata moduleMetadata = (ModuleMetadata)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new Relationship(this.spdxProjectName, RelationshipType.CONTAINS, SpdxExporterKt.adaptToSpdxId(it.getName()), "Module of the project"));
        }
        List modulesRelationship = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = this.projectMetadata.getModules();
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
            ModuleMetadata it = (ModuleMetadata)element$iv$iv2;
            boolean bl = false;
            Iterable list$iv$iv = this.getRelationships(it.getDependencies(), SpdxExporterKt.adaptToSpdxId(it.getName()));
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List relationDependenciesModule = (List)destination$iv$iv2;
        Map<String, ? extends List<File>> $this$flatMap$iv2 = fileRelationship;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv2 = $this$flatMap$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        element$iv$iv2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (element$iv$iv2.hasNext()) {
            Map.Entry element$iv$iv3;
            Map.Entry bl = element$iv$iv3 = (Map.Entry)element$iv$iv2.next();
            boolean bl2 = false;
            String pkg = (String)bl.getKey();
            List files2 = (List)bl.getValue();
            Iterable $this$map$iv2 = files2;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv4;
                boolean bl3 = false;
                collection.add(new Relationship(pkg, RelationshipType.CONTAINS, it.getSPDXID(), "License mention"));
            }
            Iterable list$iv$iv = (List)destination$iv$iv4;
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        List fileRelation = (List)destination$iv$iv3;
        Object object2 = this.spdxConverter;
        if (object2 != null && (object2 = ((SpdxConverter)object2).getSpdx()) != null && (object2 = ((SPDX)object2).getRelationships()) != null) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = (Iterable)object2;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable bl2 = $this$associateBy$iv;
            Map destination$iv$iv5 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv4 : $this$associateByTo$iv$iv) {
                void it;
                $this$mapTo$iv$iv = (Relationship)element$iv$iv4;
                object = destination$iv$iv5;
                boolean bl = false;
                object.put(it.getId(), element$iv$iv4);
            }
            map = destination$iv$iv5;
        } else {
            map = MapsKt.emptyMap();
        }
        Map cacheRelationship = MapsKt.toMutableMap((Map)map);
        List newRelationship = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)mainRelationship, (Iterable)modulesRelationship), (Iterable)relationDependenciesModule), (Iterable)fileRelation);
        Iterable $this$forEach$iv = newRelationship;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Relationship it = (Relationship)element$iv;
            boolean bl = false;
            cacheRelationship.putIfAbsent(it.getId(), it);
        }
        return CollectionsKt.toList((Iterable)cacheRelationship.values());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Relationship> getRelationships(List<Dependency> $this$getRelationships, String spdxModuleName) {
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$getRelationships;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Dependency dependency = (Dependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Relationship(spdxModuleName, RelationshipType.DEPENDS_ON, Package.Companion.getSpdxId(it.getName(), it.getVersion()), null));
        }
        List directDependencies = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = $this$getRelationships;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            Dependency p = (Dependency)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = p.getDependencies();
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void c;
                Dependency dependency = (Dependency)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(new Relationship(Package.Companion.getSpdxId(p.getName(), p.getVersion()), RelationshipType.DEPENDS_ON, Package.Companion.getSpdxId(c.getName(), c.getVersion()), null));
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List transitiveDependencies = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)directDependencies, (Iterable)transitiveDependencies);
    }

    @Override
    @NotNull
    public String createDocument() {
        String string = this.gson.toJson((Object)this.getSpdxDocument());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    @Override
    @NotNull
    public String getTypeName() {
        return "qodana.spdx";
    }

    public static final /* synthetic */ boolean access$isSpdx(SpdxExporter $this, License $receiver) {
        return $this.isSpdx($receiver);
    }

    public static final /* synthetic */ String access$getSpdxName(SpdxExporter $this, License $receiver) {
        return $this.getSpdxName($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0005\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\n\u0018\u00010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/dependencyAnalysis/core/export/SpdxExporter$Companion;", "", "()V", "OR_SEPARATOR", "", "joinToStringLicenses", "T", "", "transform", "Lkotlin/Function1;", "", "intellij.dependencyAnalysis.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> String joinToStringLicenses(@NotNull List<? extends T> $this$joinToStringLicenses, @Nullable Function1<? super T, ? extends CharSequence> transform) {
            Intrinsics.checkNotNullParameter($this$joinToStringLicenses, (String)"<this>");
            String joinedString = CollectionsKt.joinToString$default((Iterable)$this$joinToStringLicenses, (CharSequence)SpdxExporter.OR_SEPARATOR, null, null, (int)0, null, transform, (int)30, null);
            return $this$joinToStringLicenses.size() > 1 ? "(" + joinedString + ")" : joinedString;
        }

        public static /* synthetic */ String joinToStringLicenses$default(Companion companion, List list, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = null;
            }
            return companion.joinToStringLicenses(list, function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

