/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dependencyAnalysis.core.export;

import com.intellij.dependencyAnalysis.core.export.MarkdownCreator;
import com.intellij.dependencyAnalysis.core.export.SbomData;
import com.intellij.dependencyAnalysis.core.export.ShortLicense;
import com.intellij.dependencyAnalysis.core.export.ThirdPartyDependencies;
import com.intellij.dependencyAnalysis.core.model.ProjectMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0006H\u0016R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/dependencyAnalysis/core/export/MarkdownCreator;", "Lcom/intellij/dependencyAnalysis/core/export/ThirdPartyDependencies;", "projectMetadata", "Lcom/intellij/dependencyAnalysis/core/model/ProjectMetadata;", "excludedDependencies", "", "", "(Lcom/intellij/dependencyAnalysis/core/model/ProjectMetadata;Ljava/util/Set;)V", "subTitle", "typeName", "getTypeName", "()Ljava/lang/String;", "createDocument", "MdUtils", "intellij.dependencyAnalysis.core"})
@SourceDebugExtension(value={"SMAP\nMarkdown.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Markdown.kt\ncom/intellij/dependencyAnalysis/core/export/MarkdownCreator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1963#2,14:112\n1549#2:127\n1620#2,3:128\n1#3:126\n*S KotlinDebug\n*F\n+ 1 Markdown.kt\ncom/intellij/dependencyAnalysis/core/export/MarkdownCreator\n*L\n77#1:112,14\n101#1:127\n101#1:128,3\n*E\n"})
public final class MarkdownCreator
extends ThirdPartyDependencies {
    @NotNull
    public static final MdUtils MdUtils = new MdUtils(null);
    @NotNull
    private final String subTitle;
    @NotNull
    private static final String TITLE = "# Third-party software list";
    @NotNull
    private static final String DEPENDENCY_TOP = "Dependency";
    @NotNull
    private static final String VERSION_TOP = "Version";
    @NotNull
    private static final String COPYRIGHT_TOP = "Copyright";
    @NotNull
    private static final String LICENSES_TOP = "Licenses";
    @NotNull
    private static final String NEW_LINE_MD = "\n\n";
    @NotNull
    private static final String NEW_LINE_TABLE = " <br/> ";
    @NotNull
    private static final String NEW_LINE = "\n";
    private static final int SPACE_LEN = 2;
    private static final int FORMAT_WORD_LEN = 4;

    public MarkdownCreator(@NotNull ProjectMetadata projectMetadata2, @NotNull Set<String> excludedDependencies) {
        Intrinsics.checkNotNullParameter((Object)projectMetadata2, (String)"projectMetadata");
        Intrinsics.checkNotNullParameter(excludedDependencies, (String)"excludedDependencies");
        super(projectMetadata2, excludedDependencies, null);
        this.subTitle = "This page lists the third-party software dependencies used in " + projectMetadata2.getName();
    }

    public /* synthetic */ MarkdownCreator(ProjectMetadata projectMetadata2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        this(projectMetadata2, set);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String createDocument() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Object v0;
        Comparator nullSafeStringComparator = MarkdownCreator::createDocument$lambda$1;
        SbomData nameOfColumns = new SbomData(DEPENDENCY_TOP, VERSION_TOP, "", COPYRIGHT_TOP, CollectionsKt.listOf((Object)new ShortLicense(LICENSES_TOP, null)));
        List dataTable = CollectionsKt.plus((Collection)this.getData(), (Object)nameOfColumns);
        Iterable $this$maxByOrNull$iv = dataTable;
        boolean $i$f$maxByOrNull22 = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                SbomData it = (SbomData)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = MarkdownCreator.createDocument$getLicenses(it.getLicenses()).length();
                do {
                    Object e$iv = iterator$iv.next();
                    SbomData it2 = (SbomData)e$iv;
                    $i$a$-maxByOrNull-MarkdownCreator$createDocument$licenses$1 = false;
                    int v$iv = MarkdownCreator.createDocument$getLicenses(it2.getLicenses()).length();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        if ((object = (SbomData)v0) == null || (object = ((SbomData)object).getLicenses()) == null) {
            object = CollectionsKt.listOf((Object)new ShortLicense(LICENSES_TOP, null));
        }
        Object licenses2 = object;
        $this$maxByOrNull$iv = dataTable;
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> MarkdownCreator.createDocument$lambda$3((Function1)createDocument.maxProperties.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        Iterator $i$f$maxByOrNull22 = comparator;
        iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object p0 = (SbomData)iterator$iv.next();
        boolean bl = false;
        p0 = ((SbomData)p0).getDependencyName();
        while (iterator$iv.hasNext()) {
            Object p02 = (SbomData)iterator$iv.next();
            $i$a$-maxOfWith-MarkdownCreator$createDocument$maxProperties$2 = false;
            if ($i$f$maxByOrNull22.compare((Object)p0, (Object)(p02 = ((SbomData)p02).getDependencyName())) >= 0) continue;
            p0 = p02;
        }
        $this$maxByOrNull$iv = dataTable;
        Comparator<Object> comparator2 = Comparator.comparing(arg_0 -> MarkdownCreator.createDocument$lambda$4((Function1)createDocument.maxProperties.3.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing(...)");
        $i$f$maxByOrNull22 = comparator2;
        Object object2 = p0;
        iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        p0 = (SbomData)iterator$iv.next();
        boolean bl2 = false;
        p0 = ((SbomData)p0).getVersion();
        while (iterator$iv.hasNext()) {
            Object p03 = (SbomData)iterator$iv.next();
            $i$a$-maxOfWith-MarkdownCreator$createDocument$maxProperties$4 = false;
            if ($i$f$maxByOrNull22.compare((Object)p0, (Object)(p03 = ((SbomData)p03).getVersion())) >= 0) continue;
            p0 = p03;
        }
        $this$maxByOrNull$iv = dataTable;
        Comparator<Object> comparator3 = Comparator.comparing(arg_0 -> MarkdownCreator.createDocument$lambda$6((Function1)createDocument.maxProperties.5.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator3, (String)"comparing(...)");
        $i$f$maxByOrNull22 = comparator3;
        Object object3 = p0;
        iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        p0 = (SbomData)iterator$iv.next();
        boolean bl3 = false;
        p0 = ((SbomData)p0).getHomepageUrl();
        while (iterator$iv.hasNext()) {
            Object p04 = (SbomData)iterator$iv.next();
            $i$a$-maxOfWith-MarkdownCreator$createDocument$maxProperties$8 = false;
            if ($i$f$maxByOrNull22.compare((Object)p0, (Object)(p04 = ((SbomData)p04).getHomepageUrl())) >= 0) continue;
            p0 = p04;
        }
        Object object4 = p0;
        $this$maxByOrNull$iv = dataTable;
        $i$f$maxByOrNull22 = $this$maxByOrNull$iv.iterator();
        if (!$i$f$maxByOrNull22.hasNext()) {
            throw new NoSuchElementException();
        }
        Object[] p05 = (SbomData)$i$f$maxByOrNull22.next();
        boolean bl4 = false;
        p05 = p05.getCopyright();
        while ($i$f$maxByOrNull22.hasNext()) {
            p0 = (SbomData)$i$f$maxByOrNull22.next();
            $i$a$-maxOfWith-MarkdownCreator$createDocument$maxProperties$7 = false;
            if (nullSafeStringComparator.compare(p05, p0 = ((SbomData)p0).getCopyright()) >= 0) continue;
            p05 = p0;
        }
        Object[] objectArray = p05;
        Object object5 = licenses2;
        Object[] objectArray2 = objectArray;
        Object object6 = object4;
        Object object7 = object3;
        Object object8 = object2;
        SbomData maxProperties2 = new SbomData((String)object8, (String)object7, (String)object6, (String)objectArray2, (List<ShortLicense>)object5);
        String formatLine = "|" + StringsKt.repeat((CharSequence)"-", (int)(maxProperties2.getDependencyName().length() + maxProperties2.getHomepageUrl().length() + 2 + 4)) + "|" + StringsKt.repeat((CharSequence)"-", (int)(maxProperties2.getVersion().length() + 2)) + "|" + StringsKt.repeat((CharSequence)"-", (int)(MarkdownCreator.createDocument$getLicenses(maxProperties2.getLicenses()).length() + 2)) + "|";
        p05 = new String[]{TITLE, NEW_LINE_MD, this.subTitle, NEW_LINE_MD, MarkdownCreator.createDocument$createRow(nameOfColumns, maxProperties2), NEW_LINE, formatLine};
        String top = CollectionsKt.joinToString$default((Iterable)CollectionsKt.mutableListOf((Object[])p05), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        p0 = new String[]{top};
        Collection collection = CollectionsKt.mutableListOf((Object[])p0);
        p0 = this.getData();
        Collection collection2 = collection;
        boolean $i$f$map = false;
        void $i$a$-maxOfWith-MarkdownCreator$createDocument$maxProperties$8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SbomData sbomData = (SbomData)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl5 = false;
            collection3.add(MarkdownCreator.createDocument$createRow((SbomData)it, maxProperties2));
        }
        List document = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
        return CollectionsKt.joinToString$default((Iterable)document, (CharSequence)NEW_LINE, null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public String getTypeName() {
        return "md";
    }

    private static final String createDocument$getLicenses(List<ShortLicense> licenses2) {
        return CollectionsKt.joinToString$default((Iterable)licenses2, (CharSequence)NEW_LINE_TABLE, null, null, (int)0, null, (Function1)createDocument.getLicenses.1.INSTANCE, (int)30, null);
    }

    private static final int createDocument$numbOfSpace(int a, int b) {
        return a >= b ? 0 : b - a;
    }

    private static final String createDocument$createRow(SbomData $this$createDocument_u24createRow, SbomData maxElem) {
        String string;
        int spaceCount;
        String maxDName = maxElem.getDependencyName();
        String maxVersion = maxElem.getVersion();
        String maxUrl = maxElem.getHomepageUrl();
        String maxLicense = MarkdownCreator.createDocument$getLicenses(maxElem.getLicenses());
        SbomData it = $this$createDocument_u24createRow;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)$this$createDocument_u24createRow.getHomepageUrl(), (Object)"")) {
            spaceCount = MarkdownCreator.createDocument$numbOfSpace($this$createDocument_u24createRow.getDependencyName().length(), maxDName.length() + maxUrl.length());
            string = $this$createDocument_u24createRow.getDependencyName() + StringsKt.repeat((CharSequence)" ", (int)(spaceCount + 4));
        } else {
            spaceCount = MarkdownCreator.createDocument$numbOfSpace($this$createDocument_u24createRow.getDependencyName().length() + $this$createDocument_u24createRow.getHomepageUrl().length(), maxDName.length() + maxUrl.length());
            string = "[" + $this$createDocument_u24createRow.getDependencyName() + "](" + $this$createDocument_u24createRow.getHomepageUrl() + ")" + StringsKt.repeat((CharSequence)" ", (int)spaceCount);
        }
        String dependencyCell = string;
        spaceCount = MarkdownCreator.createDocument$numbOfSpace($this$createDocument_u24createRow.getVersion().length(), maxVersion.length());
        String versionCell = $this$createDocument_u24createRow.getVersion() + StringsKt.repeat((CharSequence)" ", (int)spaceCount);
        String license = MarkdownCreator.createDocument$getLicenses($this$createDocument_u24createRow.getLicenses());
        spaceCount = MarkdownCreator.createDocument$numbOfSpace(license.length(), maxLicense.length());
        String licenseCell = license + StringsKt.repeat((CharSequence)" ", (int)spaceCount);
        return "| " + dependencyCell + " | " + versionCell + " | " + licenseCell + " |";
    }

    private static final int createDocument$lambda$1(String a, String b) {
        return a == null && b == null ? 0 : (a == null ? -1 : (b == null ? 1 : Intrinsics.compare((int)a.length(), (int)b.length())));
    }

    private static final Integer createDocument$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer createDocument$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer createDocument$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/dependencyAnalysis/core/export/MarkdownCreator$MdUtils;", "", "()V", "COPYRIGHT_TOP", "", "DEPENDENCY_TOP", "FORMAT_WORD_LEN", "", "LICENSES_TOP", "NEW_LINE", "NEW_LINE_MD", "NEW_LINE_TABLE", "SPACE_LEN", "TITLE", "VERSION_TOP", "intellij.dependencyAnalysis.core"})
    public static final class MdUtils {
        private MdUtils() {
        }

        public /* synthetic */ MdUtils(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

